/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.solo.service.TagMgmtService;
import org.b3log.solo.service.TagQueryService;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONObject;

@RequestProcessor
public class TagConsole {
    private static final Logger LOGGER = Logger.getLogger((String)TagConsole.class.getName());
    @Inject
    private TagQueryService tagQueryService;
    @Inject
    private TagMgmtService tagMgmtService;
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private LangPropsService langPropsService;

    @RequestProcessing(value={"/console/tags"}, method={HTTPRequestMethod.GET})
    public void getTags(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws IOException {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            jsonObject.put("tags", this.tagQueryService.getTags());
            jsonObject.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets tags failed", (Throwable)e);
            jsonObject.put("sc", false);
        }
    }

    @RequestProcessing(value={"/console/tag/unused"}, method={HTTPRequestMethod.GET})
    public void getUnusedTags(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws IOException {
        if (!this.userQueryService.isLoggedIn(request, response)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        ArrayList<JSONObject> unusedTags = new ArrayList<JSONObject>();
        try {
            jsonObject.put("unusedTags", unusedTags);
            List<JSONObject> tags = this.tagQueryService.getTags();
            for (int i = 0; i < tags.size(); ++i) {
                JSONObject tag = tags.get(i);
                int tagRefCnt = tag.getInt("tagReferenceCount");
                if (0 != tagRefCnt) continue;
                unusedTags.add(tag);
            }
            jsonObject.put("sc", true);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets unused tags failed", (Throwable)e);
            jsonObject.put("sc", false);
        }
    }

    @RequestProcessing(value={"/console/tag/unused"}, method={HTTPRequestMethod.DELETE})
    public void removeUnusedTags(HttpServletRequest request, HttpServletResponse response, HTTPRequestContext context) throws IOException {
        if (!this.userQueryService.isAdminLoggedIn(request)) {
            response.sendError(403);
            return;
        }
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer((AbstractHTTPResponseRenderer)renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        try {
            this.tagMgmtService.removeUnusedTags();
            jsonObject.put("msg", (Object)this.langPropsService.get("removeSuccLabel"));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Removes unused tags failed", (Throwable)e);
            jsonObject.put("msg", (Object)this.langPropsService.get("removeFailLabel"));
        }
    }
}

