/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.processor.util;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.user.UserService;
import org.b3log.latke.user.UserServiceFactory;
import org.b3log.latke.util.Requests;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.solo.processor.renderer.ConsoleRenderer;
import org.b3log.solo.service.StatisticQueryService;
import org.b3log.solo.service.UserMgmtService;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class TopBars {
    private static final Logger LOGGER = Logger.getLogger((String)TopBars.class.getName());
    private static UserService userService = UserServiceFactory.getUserService();
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private UserMgmtService userMgmtService;
    @Inject
    private StatisticQueryService statisticQueryService;

    public String getTopBarHTML(HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        Stopwatchs.start((String)"Gens Top Bar HTML");
        try {
            Template topBarTemplate = ConsoleRenderer.TEMPLATE_CFG.getTemplate("top-bar.ftl");
            StringWriter stringWriter = new StringWriter();
            HashMap<String, Object> topBarModel = new HashMap<String, Object>();
            this.userMgmtService.tryLogInWithCookie(request, response);
            JSONObject currentUser = this.userQueryService.getCurrentUser(request);
            Keys.fillServer(topBarModel);
            topBarModel.put("isLoggedIn", false);
            topBarModel.put("isMobileRequest", Requests.mobileRequest((HttpServletRequest)request));
            topBarModel.put("mobileLabel", this.langPropsService.get("mobileLabel"));
            topBarModel.put("onlineVisitor1Label", this.langPropsService.get("onlineVisitor1Label"));
            TopBars topBars = this;
            topBarModel.put("onlineVisitorCnt", topBars.statisticQueryService.getOnlineVisitorCount());
            if (null == currentUser) {
                topBarModel.put("loginURL", userService.createLoginURL("/admin-index.do#main"));
                topBarModel.put("loginLabel", this.langPropsService.get("loginLabel"));
                topBarModel.put("registerLabel", this.langPropsService.get("registerLabel"));
                topBarTemplate.process(topBarModel, (Writer)stringWriter);
                String string = stringWriter.toString();
                return string;
            }
            topBarModel.put("isLoggedIn", true);
            topBarModel.put("logoutURL", userService.createLogoutURL("/"));
            topBarModel.put("isAdmin", "adminRole".equals(currentUser.getString("userRole")));
            topBarModel.put("isVisitor", "visitorRole".equals(currentUser.getString("userRole")));
            topBarModel.put("adminLabel", this.langPropsService.get("adminLabel"));
            topBarModel.put("logoutLabel", this.langPropsService.get("logoutLabel"));
            String userName = currentUser.getString("userName");
            topBarModel.put("userName", userName);
            topBarTemplate.process(topBarModel, (Writer)stringWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Gens top bar HTML failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.log(Level.ERROR, "Gens top bar HTML failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (TemplateException e) {
            LOGGER.log(Level.ERROR, "Gens top bar HTML failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            Stopwatchs.end();
        }
    }
}

