/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.repository.impl;

import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.repository.ArchiveDateRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Repository
public class ArchiveDateRepositoryImpl
extends AbstractRepository
implements ArchiveDateRepository {
    private static final Logger LOGGER = Logger.getLogger((String)ArchiveDateRepositoryImpl.class.getName());

    public ArchiveDateRepositoryImpl() {
        super("archiveDate");
    }

    @Override
    public JSONObject getByArchiveDate(String archiveDate) throws RepositoryException {
        long time = 0L;
        try {
            time = DateUtils.parseDate((String)archiveDate, (String[])new String[]{"yyyy/MM"}).getTime();
        }
        catch (ParseException e) {
            LOGGER.log(Level.ERROR, "Can not parse archive date [" + archiveDate + "]", (Throwable)e);
            throw new RepositoryException("Can not parse archive date [" + archiveDate + "]");
        }
        LOGGER.log(Level.TRACE, "Archive date [{0}] parsed to time [{1}]", new Object[]{archiveDate, time});
        Query query = new Query();
        query.setFilter((Filter)new PropertyFilter("archiveTime", FilterOperator.EQUAL, (Object)time)).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public List<JSONObject> getArchiveDates() throws RepositoryException {
        Query query = new Query().addSort("archiveTime", SortDirection.DESCENDING).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray archiveDates = result.optJSONArray("rslts");
        List ret = CollectionUtils.jsonArrayToList((JSONArray)archiveDates);
        this.removeForUnpublishedArticles(ret);
        return ret;
    }

    private void removeForUnpublishedArticles(List<JSONObject> archiveDates) throws RepositoryException {
        Iterator<JSONObject> iterator = archiveDates.iterator();
        while (iterator.hasNext()) {
            JSONObject archiveDate = iterator.next();
            if (0 != archiveDate.optInt("archiveDatePublishedArticleCount")) continue;
            iterator.remove();
        }
    }
}

