/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.repository.impl;

import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.solo.repository.LinkRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Repository
public class LinkRepositoryImpl
extends AbstractRepository
implements LinkRepository {
    public LinkRepositoryImpl() {
        super("link");
    }

    @Override
    public JSONObject getByAddress(String address) throws RepositoryException {
        Query query = new Query().setFilter((Filter)new PropertyFilter("linkAddress", FilterOperator.EQUAL, (Object)address)).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public int getMaxOrder() throws RepositoryException {
        Query query = new Query();
        query.addSort("linkOrder", SortDirection.DESCENDING);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return -1;
        }
        return array.optJSONObject(0).optInt("linkOrder");
    }

    @Override
    public JSONObject getByOrder(int order) throws RepositoryException {
        Query query = new Query();
        query.setFilter((Filter)new PropertyFilter("linkOrder", FilterOperator.EQUAL, (Object)order));
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public JSONObject getUpper(String id) throws RepositoryException {
        JSONObject link = this.get(id);
        if (null == link) {
            return null;
        }
        Query query = new Query();
        query.setFilter((Filter)new PropertyFilter("linkOrder", FilterOperator.LESS_THAN, (Object)link.optInt("linkOrder"))).addSort("linkOrder", SortDirection.DESCENDING);
        query.setCurrentPageNum(1);
        query.setPageSize(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (1 != array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public JSONObject getUnder(String id) throws RepositoryException {
        JSONObject link = this.get(id);
        if (null == link) {
            return null;
        }
        Query query = new Query();
        query.setFilter((Filter)new PropertyFilter("linkOrder", FilterOperator.GREATER_THAN, (Object)link.optInt("linkOrder"))).addSort("linkOrder", SortDirection.ASCENDING);
        query.setCurrentPageNum(1);
        query.setPageSize(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (1 != array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }
}

