/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.repository.impl;

import java.util.List;
import org.b3log.latke.Keys;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.repository.TagArticleRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Repository
public class TagArticleRepositoryImpl
extends AbstractRepository
implements TagArticleRepository {
    public TagArticleRepositoryImpl() {
        super("tag_article");
    }

    @Override
    public List<JSONObject> getByArticleId(String articleId) throws RepositoryException {
        Query query = new Query().setFilter((Filter)new PropertyFilter("article_" + Keys.OBJECT_ID, FilterOperator.EQUAL, (Object)articleId)).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        return CollectionUtils.jsonArrayToList((JSONArray)array);
    }

    @Override
    public JSONObject getByTagId(String tagId, int currentPageNum, int pageSize) throws RepositoryException {
        Query query = new Query().setFilter((Filter)new PropertyFilter("tag_" + Keys.OBJECT_ID, FilterOperator.EQUAL, (Object)tagId)).addSort("article_" + Keys.OBJECT_ID, SortDirection.DESCENDING).setCurrentPageNum(currentPageNum).setPageSize(pageSize).setPageCount(1);
        return this.get(query);
    }
}

