/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.repository.impl;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.solo.repository.TagArticleRepository;
import org.b3log.solo.repository.TagRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Repository
public class TagRepositoryImpl
extends AbstractRepository
implements TagRepository {
    @Inject
    private TagArticleRepository tagArticleRepository;

    public TagRepositoryImpl() {
        super("tag");
    }

    @Override
    public JSONObject getByTitle(String tagTitle) throws RepositoryException {
        Query query = new Query().setFilter((Filter)new PropertyFilter("tagTitle", FilterOperator.EQUAL, (Object)tagTitle)).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        if (0 == array.length()) {
            return null;
        }
        return array.optJSONObject(0);
    }

    @Override
    public List<JSONObject> getMostUsedTags(int num) throws RepositoryException {
        Query query = new Query().addSort("tagPublishedRefCount", SortDirection.DESCENDING).setCurrentPageNum(1).setPageSize(num).setPageCount(1);
        JSONObject result = this.get(query);
        JSONArray array = result.optJSONArray("rslts");
        return CollectionUtils.jsonArrayToList((JSONArray)array);
    }

    @Override
    public List<JSONObject> getByArticleId(String articleId) throws RepositoryException {
        ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
        List<JSONObject> tagArticleRelations = this.tagArticleRepository.getByArticleId(articleId);
        for (JSONObject tagArticleRelation : tagArticleRelations) {
            String tagId = tagArticleRelation.optString("tag_" + Keys.OBJECT_ID);
            JSONObject tag = this.get(tagId);
            ret.add(tag);
        }
        return ret;
    }

    public void setTagArticleRepository(TagArticleRepository tagArticleRepository) {
        this.tagArticleRepository = tagArticleRepository;
    }
}

