/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.solo.repository.ArchiveDateRepository;
import org.json.JSONObject;

@Service
public class ArchiveDateQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)ArchiveDateQueryService.class.getName());
    @Inject
    private ArchiveDateRepository archiveDateRepository;

    public List<JSONObject> getArchiveDates() throws ServiceException {
        try {
            return this.archiveDateRepository.getArchiveDates();
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets archive dates failed", (Throwable)e);
            throw new ServiceException("Gets archive dates failed");
        }
    }

    public JSONObject getByArchiveDateString(String archiveDateString) throws ServiceException {
        JSONObject ret = new JSONObject();
        try {
            JSONObject archiveDate = this.archiveDateRepository.getByArchiveDate(archiveDateString);
            if (null == archiveDate) {
                return null;
            }
            ret.put("archiveDate", (Object)archiveDate);
            return ret;
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets archive date[string=" + archiveDateString + "] failed", (Throwable)e);
            throw new ServiceException("Gets archive date[string=" + archiveDateString + "] failed");
        }
    }

    public void setArchiveDateRepository(ArchiveDateRepository archiveDateRepository) {
        this.archiveDateRepository = archiveDateRepository;
    }
}

