/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.b3log.latke.Keys;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.event.EventManager;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Ids;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.ArchiveDateArticleRepository;
import org.b3log.solo.repository.ArchiveDateRepository;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.CommentRepository;
import org.b3log.solo.repository.TagArticleRepository;
import org.b3log.solo.repository.TagRepository;
import org.b3log.solo.repository.UserRepository;
import org.b3log.solo.service.ArticleQueryService;
import org.b3log.solo.service.PermalinkQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.service.StatisticQueryService;
import org.b3log.solo.service.TagMgmtService;
import org.b3log.solo.util.Comments;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class ArticleMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleMgmtService.class.getName());
    @Inject
    private ArticleQueryService articleQueryService;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private TagRepository tagRepository;
    @Inject
    private ArchiveDateRepository archiveDateRepository;
    @Inject
    private ArchiveDateArticleRepository archiveDateArticleRepository;
    @Inject
    private TagArticleRepository tagArticleRepository;
    @Inject
    private CommentRepository commentRepository;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private PermalinkQueryService permalinkQueryService;
    @Inject
    private EventManager eventManager;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private StatisticMgmtService statisticMgmtService;
    @Inject
    private StatisticQueryService statisticQueryService;
    @Inject
    private TagMgmtService tagMgmtService;

    public void incArticleCommentCount(String articleId) throws JSONException, RepositoryException {
        JSONObject article = this.articleRepository.get(articleId);
        JSONObject newArticle = new JSONObject(article, JSONObject.getNames((JSONObject)article));
        int commentCnt = article.getInt("articleCommentCount");
        newArticle.put("articleCommentCount", commentCnt + 1);
        this.articleRepository.update(articleId, newArticle);
    }

    public void cancelPublishArticle(String articleId) throws ServiceException {
        Transaction transaction = this.articleRepository.beginTransaction();
        try {
            JSONObject article = this.articleRepository.get(articleId);
            article.put("articleIsPublished", false);
            this.tagMgmtService.decTagPublishedRefCount(articleId);
            this.decArchiveDatePublishedRefCount(articleId);
            this.articleRepository.update(articleId, article);
            this.statisticMgmtService.decPublishedBlogArticleCount();
            int blogCmtCnt = this.statisticQueryService.getPublishedBlogCommentCount();
            int articleCmtCnt = article.getInt("articleCommentCount");
            this.statisticMgmtService.setPublishedBlogCommentCount(blogCmtCnt - articleCmtCnt);
            JSONObject author = this.userRepository.getByEmail(article.optString("articleAuthorEmail"));
            author.put("userPublishedArticleCount", author.optInt("userPublishedArticleCount") - 1);
            this.userRepository.update(author.optString(Keys.OBJECT_ID), author);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Cancels publish article failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void topArticle(String articleId, boolean top) throws ServiceException {
        Transaction transaction = this.articleRepository.beginTransaction();
        try {
            JSONObject topArticle = this.articleRepository.get(articleId);
            topArticle.put("articlePutTop", top);
            this.articleRepository.update(articleId, topArticle);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Can't put the article[oId{0}] to top", new Object[]{articleId});
            throw new ServiceException((Throwable)e);
        }
    }

    public void updateArticle(JSONObject requestJSONObject) throws ServiceException {
        JSONObject ret = new JSONObject();
        Transaction transaction = this.articleRepository.beginTransaction();
        try {
            boolean publishNewArticle;
            JSONObject article = requestJSONObject.getJSONObject("article");
            String tagsString = article.optString("articleTags");
            article.put("articleTags", (Object)tagsString.replaceAll("\uff0c", ",").replaceAll("\u3001", ","));
            String articleId = article.getString(Keys.OBJECT_ID);
            JSONObject oldArticle = this.articleRepository.get(articleId);
            String permalink = this.getPermalinkForUpdateArticle(oldArticle, article, (Date)oldArticle.get("articleCreateDate"));
            article.put("articlePermalink", (Object)permalink);
            this.processTagsForArticleUpdate(oldArticle, article);
            if (!oldArticle.getString("articlePermalink").equals(permalink)) {
                this.processCommentsForArticleUpdate(article);
            }
            this.fillAutoProperties(oldArticle, article);
            article.put("articleUpdateDate", oldArticle.get("articleUpdateDate"));
            JSONObject preference = this.preferenceQueryService.getPreference();
            Date date = new Date();
            if (!article.has("articleSignId")) {
                article.put("articleSignId", (Object)"0");
            }
            if (article.getBoolean("articleIsPublished")) {
                if (this.articleQueryService.hadBeenPublished(oldArticle)) {
                    article.put("articleUpdateDate", (Object)date);
                } else {
                    article.put("articleCreateDate", (Object)date);
                    article.put("articleUpdateDate", (Object)date);
                    article.put("articleHadBeenPublished", true);
                }
            } else if (this.articleQueryService.hadBeenPublished(oldArticle)) {
                article.put("articleUpdateDate", (Object)date);
            } else {
                article.put("articleCreateDate", (Object)date);
                article.put("articleUpdateDate", (Object)date);
            }
            if (!article.has("articleEditorType")) {
                article.put("articleEditorType", (Object)preference.optString("editorType"));
            }
            boolean bl = publishNewArticle = !oldArticle.getBoolean("articleIsPublished") && article.getBoolean("articleIsPublished");
            if (publishNewArticle) {
                this.statisticMgmtService.incPublishedBlogArticleCount();
                int blogCmtCnt = this.statisticQueryService.getPublishedBlogCommentCount();
                int articleCmtCnt = article.getInt("articleCommentCount");
                this.statisticMgmtService.setPublishedBlogCommentCount(blogCmtCnt + articleCmtCnt);
                JSONObject author = this.userRepository.getByEmail(article.optString("articleAuthorEmail"));
                author.put("userPublishedArticleCount", author.optInt("userPublishedArticleCount") + 1);
                this.userRepository.update(author.optString(Keys.OBJECT_ID), author);
            }
            if (publishNewArticle) {
                this.incArchiveDatePublishedRefCount(articleId);
            }
            boolean postToCommunity = article.optBoolean("postToCommunity", true);
            article.remove("postToCommunity");
            this.articleRepository.update(articleId, article);
            article.put("postToCommunity", postToCommunity);
            if (publishNewArticle) {
                JSONObject eventData = new JSONObject();
                eventData.put("article", (Object)article);
                eventData.put("rslts", (Object)ret);
                try {
                    this.eventManager.fireEventSynchronously(new Event("Add Article", (Object)eventData));
                }
                catch (EventException e) {
                    LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                }
            } else {
                JSONObject eventData = new JSONObject();
                eventData.put("article", (Object)article);
                eventData.put("rslts", (Object)ret);
                try {
                    this.eventManager.fireEventSynchronously(new Event("Update Article", (Object)eventData));
                }
                catch (EventException e) {
                    LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                }
            }
            transaction.commit();
        }
        catch (ServiceException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Updates an article failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Updates an article failed", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    public String addArticle(JSONObject requestJSONObject) throws ServiceException {
        Transaction transaction = this.articleRepository.beginTransaction();
        try {
            JSONObject article = requestJSONObject.getJSONObject("article");
            String ret = this.addArticleInternal(article);
            transaction.commit();
            return ret;
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new ServiceException(e.getMessage());
        }
    }

    public String addArticleInternal(JSONObject article) throws ServiceException {
        String ret = article.optString(Keys.OBJECT_ID);
        if (Strings.isEmptyOrNull((String)ret)) {
            ret = Ids.genTimeMillisId();
            article.put(Keys.OBJECT_ID, (Object)ret);
        }
        try {
            String tagsString = article.optString("articleTags");
            tagsString = tagsString.replaceAll("\uff0c", ",").replaceAll("\u3001", ",");
            article.put("articleTags", (Object)tagsString);
            String[] tagTitles = tagsString.split(",");
            JSONArray tags = this.tag(tagTitles, article);
            article.put("articleCommentCount", 0);
            article.put("articleViewCount", 0);
            JSONObject preference = this.preferenceQueryService.getPreference();
            Date date = new Date();
            if (!article.has("articleCreateDate")) {
                article.put("articleCreateDate", (Object)date);
            }
            article.put("articleUpdateDate", article.opt("articleCreateDate"));
            article.put("articlePutTop", false);
            this.addTagArticleRelation(tags, article);
            this.statisticMgmtService.incBlogArticleCount();
            if (article.optBoolean("articleIsPublished")) {
                this.statisticMgmtService.incPublishedBlogArticleCount();
            }
            this.archiveDate(article);
            String permalink = this.getPermalinkForAddArticle(article);
            article.put("articlePermalink", (Object)permalink);
            String signId = article.optString("articleSignId", "1");
            article.put("articleSignId", (Object)signId);
            article.put("articleHadBeenPublished", false);
            if (article.optBoolean("articleIsPublished")) {
                article.put("articleHadBeenPublished", true);
            }
            article.put("articleRandomDouble", Math.random());
            boolean postToCommunity = article.optBoolean("postToCommunity", true);
            article.remove("postToCommunity");
            JSONObject author = this.userRepository.getByEmail(article.optString("articleAuthorEmail"));
            int userArticleCnt = author.optInt("userArticleCount");
            author.put("userArticleCount", userArticleCnt + 1);
            if (article.optBoolean("articleIsPublished")) {
                author.put("userPublishedArticleCount", author.optInt("userPublishedArticleCount") + 1);
            }
            this.userRepository.update(author.optString(Keys.OBJECT_ID), author);
            if (!article.has("articleEditorType")) {
                article.put("articleEditorType", (Object)preference.optString("editorType"));
            }
            this.articleRepository.add(article);
            article.put("postToCommunity", postToCommunity);
            if (article.optBoolean("articleIsPublished")) {
                JSONObject eventData = new JSONObject();
                eventData.put("article", (Object)article);
                this.eventManager.fireEventSynchronously(new Event("Add Article", (Object)eventData));
            }
            article.remove("postToCommunity");
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Adds an article failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (EventException e) {
            LOGGER.log(Level.WARN, "Adds an article event process failed", (Throwable)e);
        }
        return ret;
    }

    public void removeArticle(String articleId) throws ServiceException {
        LOGGER.log(Level.DEBUG, "Removing an article[id={0}]", new Object[]{articleId});
        Transaction transaction = this.articleRepository.beginTransaction();
        try {
            this.decTagRefCount(articleId);
            this.unArchiveDate(articleId);
            this.removeTagArticleRelations(articleId, new String[0]);
            this.removeArticleComments(articleId);
            JSONObject article = this.articleRepository.get(articleId);
            this.articleRepository.remove(articleId);
            this.statisticMgmtService.decBlogArticleCount();
            if (article.getBoolean("articleIsPublished")) {
                this.statisticMgmtService.decPublishedBlogArticleCount();
            }
            JSONObject author = this.userRepository.getByEmail(article.optString("articleAuthorEmail"));
            author.put("userPublishedArticleCount", author.optInt("userPublishedArticleCount") - 1);
            author.put("userArticleCount", author.optInt("userArticleCount") - 1);
            this.userRepository.update(author.optString(Keys.OBJECT_ID), author);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Removes an article[id=" + articleId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        LOGGER.log(Level.DEBUG, "Removed an article[id={0}]", new Object[]{articleId});
    }

    public void updateArticlesRandomValue(int updateCnt) throws ServiceException {
        Transaction transaction = this.articleRepository.beginTransaction();
        try {
            List randomArticles = this.articleRepository.getRandomly(updateCnt);
            for (JSONObject article : randomArticles) {
                article.put("articleRandomDouble", Math.random());
                this.articleRepository.update(article.getString(Keys.OBJECT_ID), article);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.WARN, "Updates article random value failed", new Object[0]);
            throw new ServiceException((Throwable)e);
        }
    }

    public void incViewCount(String articleId) throws ServiceException {
        JSONObject article;
        try {
            article = this.articleRepository.get(articleId);
            if (null == article) {
                return;
            }
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets article [id=" + articleId + "] failed", (Throwable)e);
            return;
        }
        Transaction transaction = this.articleRepository.beginTransaction();
        try {
            article.put("articleViewCount", article.getInt("articleViewCount") + 1);
            this.articleRepository.update(articleId, article);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.WARN, "Updates article view count failed", new Object[0]);
            throw new ServiceException((Throwable)e);
        }
    }

    private void decTagRefCount(String articleId) throws ServiceException {
        try {
            List<JSONObject> tags = this.tagRepository.getByArticleId(articleId);
            JSONObject article = this.articleRepository.get(articleId);
            for (JSONObject tag : tags) {
                String tagId = tag.getString(Keys.OBJECT_ID);
                int refCnt = tag.getInt("tagReferenceCount");
                tag.put("tagReferenceCount", refCnt - 1);
                int publishedRefCnt = tag.getInt("tagPublishedRefCount");
                if (article.getBoolean("articleIsPublished")) {
                    tag.put("tagPublishedRefCount", publishedRefCnt - 1);
                } else {
                    tag.put("tagPublishedRefCount", publishedRefCnt);
                }
                this.tagRepository.update(tagId, tag);
                LOGGER.log(Level.TRACE, "Deced tag[title={0}, refCnt={1}, publishedRefCnt={2}] of article[id={3}]", new Object[]{tag.getString("tagTitle"), tag.getInt("tagReferenceCount"), tag.getInt("tagPublishedRefCount"), articleId});
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Decs tag references count of article[id" + articleId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        LOGGER.log(Level.DEBUG, "Deced all tag reference count of article[id={0}]", new Object[]{articleId});
    }

    private void unArchiveDate(String articleId) throws ServiceException {
        try {
            JSONObject archiveDateArticleRelation = this.archiveDateArticleRepository.getByArticleId(articleId);
            String archiveDateId = archiveDateArticleRelation.getString("archiveDate_" + Keys.OBJECT_ID);
            JSONObject archiveDate = this.archiveDateRepository.get(archiveDateId);
            int archiveDateArticleCnt = archiveDate.getInt("archiveDateArticleCount");
            --archiveDateArticleCnt;
            int archiveDatePublishedArticleCnt = archiveDate.getInt("archiveDatePublishedArticleCount");
            JSONObject article = this.articleRepository.get(articleId);
            if (article.getBoolean("articleIsPublished")) {
                --archiveDatePublishedArticleCnt;
            }
            if (0 == archiveDateArticleCnt) {
                this.archiveDateRepository.remove(archiveDateId);
            } else {
                JSONObject newArchiveDate = new JSONObject(archiveDate, (String[])CollectionUtils.jsonArrayToArray((JSONArray)archiveDate.names(), String[].class));
                newArchiveDate.put("archiveDateArticleCount", archiveDateArticleCnt);
                newArchiveDate.put("archiveDatePublishedArticleCount", archiveDatePublishedArticleCnt);
                this.archiveDateRepository.update(archiveDateId, newArchiveDate);
            }
            this.archiveDateArticleRepository.remove(archiveDateArticleRelation.getString(Keys.OBJECT_ID));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Unarchive date for article[id=" + articleId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    private void processCommentsForArticleUpdate(JSONObject article) throws Exception {
        String articleId = article.getString(Keys.OBJECT_ID);
        List<JSONObject> comments = this.commentRepository.getComments(articleId, 1, Integer.MAX_VALUE);
        for (JSONObject comment : comments) {
            String commentId = comment.getString(Keys.OBJECT_ID);
            String sharpURL = Comments.getCommentSharpURLForArticle(article, commentId);
            comment.put("commentSharpURL", (Object)sharpURL);
            if (Strings.isEmptyOrNull((String)comment.optString("commentOriginalCommentId"))) {
                comment.put("commentOriginalCommentId", (Object)"");
            }
            if (Strings.isEmptyOrNull((String)comment.optString("commentOriginalCommentName"))) {
                comment.put("commentOriginalCommentName", (Object)"");
            }
            this.commentRepository.update(commentId, comment);
        }
    }

    private void processTagsForArticleUpdate(JSONObject oldArticle, JSONObject newArticle) throws Exception {
        String[] stringArray;
        JSONObject tag;
        int i;
        String tagId;
        String oldArticleId = oldArticle.getString(Keys.OBJECT_ID);
        List<JSONObject> oldTags = this.tagRepository.getByArticleId(oldArticleId);
        String tagsString = newArticle.getString("articleTags");
        String[] tagStrings = tagsString.split(",");
        ArrayList<JSONObject> newTags = new ArrayList<JSONObject>();
        for (int i2 = 0; i2 < tagStrings.length; ++i2) {
            String tagTitle = tagStrings[i2].trim();
            JSONObject newTag = this.tagRepository.getByTitle(tagTitle);
            if (null == newTag) {
                newTag = new JSONObject();
                newTag.put("tagTitle", (Object)tagTitle);
            }
            newTags.add(newTag);
        }
        ArrayList<JSONObject> tagsDropped = new ArrayList<JSONObject>();
        ArrayList<JSONObject> tagsNeedToAdd = new ArrayList<JSONObject>();
        ArrayList<JSONObject> tagsUnchanged = new ArrayList<JSONObject>();
        for (JSONObject newTag : newTags) {
            String newTagTitle = newTag.getString("tagTitle");
            if (!ArticleMgmtService.tagExists(newTagTitle, oldTags)) {
                LOGGER.log(Level.DEBUG, "Tag need to add[title={0}]", new Object[]{newTagTitle});
                tagsNeedToAdd.add(newTag);
                continue;
            }
            tagsUnchanged.add(newTag);
        }
        for (JSONObject oldTag : oldTags) {
            String oldTagTitle = oldTag.getString("tagTitle");
            if (!ArticleMgmtService.tagExists(oldTagTitle, newTags)) {
                LOGGER.log(Level.DEBUG, "Tag dropped[title={0}]", new Object[]{oldTag});
                tagsDropped.add(oldTag);
                continue;
            }
            tagsUnchanged.remove(oldTag);
        }
        LOGGER.log(Level.DEBUG, "Tags unchanged[{0}]", new Object[]{tagsUnchanged});
        for (JSONObject tagUnchanged : tagsUnchanged) {
            tagId = tagUnchanged.optString(Keys.OBJECT_ID);
            if (null == tagId) continue;
            int publishedRefCnt = tagUnchanged.getInt("tagPublishedRefCount");
            if (oldArticle.getBoolean("articleIsPublished")) {
                if (newArticle.getBoolean("articleIsPublished")) continue;
                tagUnchanged.put("tagPublishedRefCount", publishedRefCnt - 1);
                this.tagRepository.update(tagId, tagUnchanged);
                continue;
            }
            if (!newArticle.getBoolean("articleIsPublished")) continue;
            tagUnchanged.put("tagPublishedRefCount", publishedRefCnt + 1);
            this.tagRepository.update(tagId, tagUnchanged);
        }
        for (JSONObject tagDropped : tagsDropped) {
            tagId = tagDropped.getString(Keys.OBJECT_ID);
            int refCnt = tagDropped.getInt("tagReferenceCount");
            tagDropped.put("tagReferenceCount", refCnt - 1);
            int publishedRefCnt = tagDropped.getInt("tagPublishedRefCount");
            if (oldArticle.getBoolean("articleIsPublished")) {
                tagDropped.put("tagPublishedRefCount", publishedRefCnt - 1);
            }
            this.tagRepository.update(tagId, tagDropped);
        }
        String[] tagIdsDropped = new String[tagsDropped.size()];
        for (i = 0; i < tagIdsDropped.length; ++i) {
            String id;
            tag = (JSONObject)tagsDropped.get(i);
            tagIdsDropped[i] = id = tag.getString(Keys.OBJECT_ID);
        }
        if (0 == tagIdsDropped.length) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "l0y0l";
        } else {
            stringArray = tagIdsDropped;
        }
        this.removeTagArticleRelations(oldArticleId, stringArray);
        tagStrings = new String[tagsNeedToAdd.size()];
        for (i = 0; i < tagStrings.length; ++i) {
            String tagTitle;
            tag = (JSONObject)tagsNeedToAdd.get(i);
            tagStrings[i] = tagTitle = tag.getString("tagTitle");
        }
        JSONArray tags = this.tag(tagStrings, newArticle);
        this.addTagArticleRelation(tags, newArticle);
    }

    private void removeTagArticleRelations(String articleId, String ... tagIds) throws JSONException, RepositoryException {
        List<String> tagIdList = Arrays.asList(tagIds);
        List<JSONObject> tagArticleRelations = this.tagArticleRepository.getByArticleId(articleId);
        for (int i = 0; i < tagArticleRelations.size(); ++i) {
            String relationId;
            JSONObject tagArticleRelation = tagArticleRelations.get(i);
            if (tagIdList.isEmpty()) {
                relationId = tagArticleRelation.getString(Keys.OBJECT_ID);
                this.tagArticleRepository.remove(relationId);
                continue;
            }
            if (!tagIdList.contains(tagArticleRelation.getString("tag_" + Keys.OBJECT_ID))) continue;
            relationId = tagArticleRelation.getString(Keys.OBJECT_ID);
            this.tagArticleRepository.remove(relationId);
        }
    }

    private void addTagArticleRelation(JSONArray tags, JSONObject article) throws RepositoryException {
        for (int i = 0; i < tags.length(); ++i) {
            JSONObject tag = tags.optJSONObject(i);
            JSONObject tagArticleRelation = new JSONObject();
            tagArticleRelation.put("tag_" + Keys.OBJECT_ID, (Object)tag.optString(Keys.OBJECT_ID));
            tagArticleRelation.put("article_" + Keys.OBJECT_ID, (Object)article.optString(Keys.OBJECT_ID));
            this.tagArticleRepository.add(tagArticleRelation);
        }
    }

    private JSONArray tag(String[] tagTitles, JSONObject article) throws RepositoryException {
        JSONArray ret = new JSONArray();
        for (int i = 0; i < tagTitles.length; ++i) {
            String tagId;
            String tagTitle = tagTitles[i].trim();
            JSONObject tag = this.tagRepository.getByTitle(tagTitle);
            if (null == tag) {
                LOGGER.log(Level.TRACE, "Found a new tag[title={0}] in article[title={1}]", new Object[]{tagTitle, article.optString("articleTitle")});
                tag = new JSONObject();
                tag.put("tagTitle", (Object)tagTitle);
                tag.put("tagReferenceCount", 1);
                if (article.optBoolean("articleIsPublished")) {
                    tag.put("tagPublishedRefCount", 1);
                } else {
                    tag.put("tagPublishedRefCount", 0);
                }
                tagId = this.tagRepository.add(tag);
                tag.put(Keys.OBJECT_ID, (Object)tagId);
            } else {
                tagId = tag.optString(Keys.OBJECT_ID);
                LOGGER.log(Level.TRACE, "Found a existing tag[title={0}, id={1}] in article[title={2}]", new Object[]{tag.optString("tagTitle"), tag.optString(Keys.OBJECT_ID), article.optString("articleTitle")});
                JSONObject tagTmp = new JSONObject();
                tagTmp.put(Keys.OBJECT_ID, (Object)tagId);
                tagTmp.put("tagTitle", (Object)tagTitle);
                int refCnt = tag.optInt("tagReferenceCount");
                int publishedRefCnt = tag.optInt("tagPublishedRefCount");
                tagTmp.put("tagReferenceCount", refCnt + 1);
                if (article.optBoolean("articleIsPublished")) {
                    tagTmp.put("tagPublishedRefCount", publishedRefCnt + 1);
                } else {
                    tagTmp.put("tagPublishedRefCount", publishedRefCnt);
                }
                this.tagRepository.update(tagId, tagTmp);
            }
            ret.put((Object)tag);
        }
        return ret;
    }

    private void removeArticleComments(String articleId) throws JSONException, RepositoryException {
        int removedCnt = this.commentRepository.removeComments(articleId);
        int blogCommentCount = this.statisticQueryService.getBlogCommentCount();
        this.statisticMgmtService.setBlogCommentCount(blogCommentCount -= removedCnt);
        JSONObject article = this.articleRepository.get(articleId);
        if (article.getBoolean("articleIsPublished")) {
            int publishedBlogCommentCount = this.statisticQueryService.getPublishedBlogCommentCount();
            this.statisticMgmtService.setPublishedBlogCommentCount(publishedBlogCommentCount -= removedCnt);
        }
    }

    private static boolean tagExists(String tagTitle, List<JSONObject> tags) throws JSONException {
        for (JSONObject tag : tags) {
            if (!tag.getString("tagTitle").equals(tagTitle)) continue;
            return true;
        }
        return false;
    }

    private void archiveDate(JSONObject article) throws RepositoryException {
        Date createDate = (Date)article.opt("articleCreateDate");
        String createDateString = DateFormatUtils.format((Date)createDate, (String)"yyyy/MM");
        JSONObject archiveDate = this.archiveDateRepository.getByArchiveDate(createDateString);
        if (null == archiveDate) {
            archiveDate = new JSONObject();
            try {
                archiveDate.put("archiveTime", DateUtils.parseDate((String)createDateString, (String[])new String[]{"yyyy/MM"}).getTime());
                archiveDate.put("archiveDateArticleCount", 0);
                archiveDate.put("archiveDatePublishedArticleCount", 0);
                this.archiveDateRepository.add(archiveDate);
            }
            catch (ParseException e) {
                LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
        }
        JSONObject newArchiveDate = new JSONObject(archiveDate, (String[])CollectionUtils.jsonArrayToArray((JSONArray)archiveDate.names(), String[].class));
        newArchiveDate.put("archiveDateArticleCount", archiveDate.optInt("archiveDateArticleCount") + 1);
        if (article.optBoolean("articleIsPublished")) {
            newArchiveDate.put("archiveDatePublishedArticleCount", archiveDate.optInt("archiveDatePublishedArticleCount") + 1);
        }
        this.archiveDateRepository.update(archiveDate.optString(Keys.OBJECT_ID), newArchiveDate);
        JSONObject archiveDateArticleRelation = new JSONObject();
        archiveDateArticleRelation.put("archiveDate_" + Keys.OBJECT_ID, (Object)archiveDate.optString(Keys.OBJECT_ID));
        archiveDateArticleRelation.put("article_" + Keys.OBJECT_ID, (Object)article.optString(Keys.OBJECT_ID));
        this.archiveDateArticleRepository.add(archiveDateArticleRelation);
    }

    private void fillAutoProperties(JSONObject oldArticle, JSONObject article) throws JSONException {
        Date createDate = (Date)oldArticle.get("articleCreateDate");
        article.put("articleCreateDate", (Object)createDate);
        article.put("articleCommentCount", oldArticle.getInt("articleCommentCount"));
        article.put("articleViewCount", oldArticle.getInt("articleViewCount"));
        article.put("articlePutTop", oldArticle.getBoolean("articlePutTop"));
        article.put("articleHadBeenPublished", oldArticle.getBoolean("articleHadBeenPublished"));
        article.put("articleAuthorEmail", (Object)oldArticle.getString("articleAuthorEmail"));
        article.put("articleRandomDouble", Math.random());
    }

    private String getPermalinkForAddArticle(JSONObject article) throws ServiceException {
        Date date = (Date)article.opt("articleCreateDate");
        String ret = article.optString("articlePermalink");
        if (Strings.isEmptyOrNull((String)ret)) {
            ret = "/articles/" + DateFormatUtils.format((Date)date, (String)"yyyy/MM/dd") + "/" + article.optString(Keys.OBJECT_ID) + ".html";
        }
        if (!ret.startsWith("/")) {
            ret = "/" + ret;
        }
        if (PermalinkQueryService.invalidArticlePermalinkFormat(ret)) {
            throw new ServiceException(this.langPropsService.get("invalidPermalinkFormatLabel"));
        }
        if (this.permalinkQueryService.exist(ret)) {
            throw new ServiceException(this.langPropsService.get("duplicatedPermalinkLabel"));
        }
        return ret.replaceAll(" ", "-");
    }

    private String getPermalinkForUpdateArticle(JSONObject oldArticle, JSONObject article, Date createDate) throws ServiceException, JSONException {
        String articleId = article.getString(Keys.OBJECT_ID);
        String ret = article.optString("articlePermalink").trim();
        String oldPermalink = oldArticle.getString("articlePermalink");
        if (!oldPermalink.equals(ret)) {
            if (Strings.isEmptyOrNull((String)ret)) {
                ret = "/articles/" + DateFormatUtils.format((Date)createDate, (String)"yyyy/MM/dd") + "/" + articleId + ".html";
            }
            if (!ret.startsWith("/")) {
                ret = "/" + ret;
            }
            if (PermalinkQueryService.invalidArticlePermalinkFormat(ret)) {
                throw new ServiceException(this.langPropsService.get("invalidPermalinkFormatLabel"));
            }
            if (!oldPermalink.equals(ret) && this.permalinkQueryService.exist(ret)) {
                throw new ServiceException(this.langPropsService.get("duplicatedPermalinkLabel"));
            }
        }
        return ret.replaceAll(" ", "-");
    }

    private void decArchiveDatePublishedRefCount(String articleId) throws JSONException, RepositoryException {
        JSONObject archiveDateArticleRelation = this.archiveDateArticleRepository.getByArticleId(articleId);
        String archiveDateId = archiveDateArticleRelation.getString("archiveDate_" + Keys.OBJECT_ID);
        JSONObject archiveDate = this.archiveDateRepository.get(archiveDateId);
        archiveDate.put("archiveDatePublishedArticleCount", archiveDate.getInt("archiveDatePublishedArticleCount") - 1);
        this.archiveDateRepository.update(archiveDateId, archiveDate);
    }

    private void incArchiveDatePublishedRefCount(String articleId) throws JSONException, RepositoryException {
        JSONObject archiveDateArticleRelation = this.archiveDateArticleRepository.getByArticleId(articleId);
        String archiveDateId = archiveDateArticleRelation.getString("archiveDate_" + Keys.OBJECT_ID);
        JSONObject archiveDate = this.archiveDateRepository.get(archiveDateId);
        archiveDate.put("archiveDatePublishedArticleCount", archiveDate.getInt("archiveDatePublishedArticleCount") + 1);
        this.archiveDateRepository.update(archiveDateId, archiveDate);
    }

    public void setArchiveDateArticleRepository(ArchiveDateArticleRepository archiveDateArticleRepository) {
        this.archiveDateArticleRepository = archiveDateArticleRepository;
    }

    public void setArchiveDateRepository(ArchiveDateRepository archiveDateRepository) {
        this.archiveDateRepository = archiveDateRepository;
    }

    public void setArticleRepository(ArticleRepository articleRepository) {
        this.articleRepository = articleRepository;
    }

    public void setArticleQueryService(ArticleQueryService articleQueryService) {
        this.articleQueryService = articleQueryService;
    }

    public void setPermalinkQueryService(PermalinkQueryService permalinkQueryService) {
        this.permalinkQueryService = permalinkQueryService;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void setPreferenceQueryService(PreferenceQueryService preferenceQueryService) {
        this.preferenceQueryService = preferenceQueryService;
    }

    public void setStatisticMgmtService(StatisticMgmtService statisticMgmtService) {
        this.statisticMgmtService = statisticMgmtService;
    }

    public void setStatisticQueryService(StatisticQueryService statisticQueryService) {
        this.statisticQueryService = statisticQueryService;
    }

    public void setTagRepository(TagRepository tagRepository) {
        this.tagRepository = tagRepository;
    }

    public void setTagArticleRepository(TagArticleRepository tagArticleRepository) {
        this.tagArticleRepository = tagArticleRepository;
    }

    public void setTagMgmtService(TagMgmtService tagMgmtService) {
        this.tagMgmtService = tagMgmtService;
    }

    public void setCommentRepository(CommentRepository commentRepository) {
        this.commentRepository = commentRepository;
    }

    public void setLangPropsService(LangPropsService langPropsService) {
        this.langPropsService = langPropsService;
    }
}

