/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Paginator;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.ArchiveDateArticleRepository;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.TagArticleRepository;
import org.b3log.solo.repository.TagRepository;
import org.b3log.solo.repository.UserRepository;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticQueryService;
import org.b3log.solo.service.UserQueryService;
import org.b3log.solo.util.Markdowns;
import org.b3log.solo.util.comparator.Comparators;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class ArticleQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)ArticleQueryService.class.getName());
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private UserRepository userRepository;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private TagRepository tagRepository;
    @Inject
    private TagArticleRepository tagArticleRepository;
    @Inject
    private ArchiveDateArticleRepository archiveDateArticleRepository;
    @Inject
    private StatisticQueryService statisticQueryService;
    @Inject
    private LangPropsService langPropsService;

    public boolean canAccessArticle(String articleId, HttpServletRequest request) throws Exception {
        if (Strings.isEmptyOrNull((String)articleId)) {
            return false;
        }
        if (this.userQueryService.isAdminLoggedIn(request)) {
            return true;
        }
        JSONObject article = this.articleRepository.get(articleId);
        String currentUserEmail = this.userQueryService.getCurrentUser(request).getString("userEmail");
        return article.getString("articleAuthorEmail").equals(currentUserEmail);
    }

    public boolean needViewPwd(HttpServletRequest request, JSONObject article) {
        JSONObject currentUser;
        String articleViewPwd = article.optString("articleViewPwd");
        if (Strings.isEmptyOrNull((String)articleViewPwd)) {
            return false;
        }
        if (null == request) {
            return true;
        }
        HttpSession session = request.getSession(false);
        if (null != session) {
            HashMap viewPwds = (HashMap)session.getAttribute("articlesViewPwd");
            if (null == viewPwds) {
                viewPwds = new HashMap();
            }
            if (articleViewPwd.equals(viewPwds.get(article.optString(Keys.OBJECT_ID)))) {
                return false;
            }
        }
        return null == (currentUser = this.userQueryService.getCurrentUser(request)) || "visitorRole".equals(currentUser.optString("userRole"));
    }

    public long getRecentArticleTime() throws ServiceException {
        try {
            List<JSONObject> recentArticles = this.articleRepository.getRecentArticles(1);
            if (recentArticles.isEmpty()) {
                return 0L;
            }
            JSONObject recentArticle = recentArticles.get(0);
            return ((Date)recentArticle.get("articleUpdateDate")).getTime();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new ServiceException("Gets recent article time failed");
        }
    }

    public JSONObject getAuthor(JSONObject article) throws ServiceException {
        try {
            String email = article.getString("articleAuthorEmail");
            JSONObject ret = this.userRepository.getByEmail(email);
            if (null == ret) {
                LOGGER.log(Level.WARN, "Gets author of article failed, assumes the administrator is the author of this article[id={0}]", new Object[]{article.getString(Keys.OBJECT_ID)});
                ret = this.userRepository.getAdmin();
            }
            return ret;
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets author of article[id={0}] failed", new Object[]{article.optString(Keys.OBJECT_ID)});
            throw new ServiceException((Throwable)e);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Gets author of article[id={0}] failed", new Object[]{article.optString(Keys.OBJECT_ID)});
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getSign(String signId, JSONObject preference) throws JSONException, RepositoryException {
        JSONArray signs = new JSONArray(preference.getString("signs"));
        JSONObject defaultSign = null;
        for (int i = 0; i < signs.length(); ++i) {
            JSONObject ret = signs.getJSONObject(i);
            if (signId.equals(ret.optString(Keys.OBJECT_ID))) {
                return ret;
            }
            if (!"1".equals(ret.optString(Keys.OBJECT_ID))) continue;
            defaultSign = ret;
        }
        LOGGER.log(Level.WARN, "Can not find the sign[id={0}], returns a default sign[id=1]", new Object[]{signId});
        if (null == defaultSign) {
            throw new IllegalStateException("Can not find the default sign which id equals to 1");
        }
        return defaultSign;
    }

    public boolean hasUpdated(JSONObject article) throws JSONException {
        Date updateDate = (Date)article.get("articleUpdateDate");
        Date createDate = (Date)article.get("articleCreateDate");
        return !createDate.equals(updateDate);
    }

    public boolean hadBeenPublished(JSONObject article) throws JSONException {
        return article.getBoolean("articleHadBeenPublished");
    }

    public List<JSONObject> getUnpublishedArticles() throws RepositoryException, JSONException {
        HashMap<String, SortDirection> sorts = new HashMap<String, SortDirection>();
        sorts.put("articleCreateDate", SortDirection.DESCENDING);
        sorts.put("articlePutTop", SortDirection.DESCENDING);
        Query query = new Query().setFilter((Filter)new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)true));
        JSONObject result = this.articleRepository.get(query);
        JSONArray articles = result.getJSONArray("rslts");
        return CollectionUtils.jsonArrayToList((JSONArray)articles);
    }

    public List<JSONObject> getRecentArticles(int fetchSize) throws ServiceException {
        try {
            return this.articleRepository.getRecentArticles(fetchSize);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets recent articles failed", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public JSONObject getArticle(String articleId) throws ServiceException {
        try {
            JSONObject ret = new JSONObject();
            JSONObject article = this.articleRepository.get(articleId);
            if (null == article) {
                return null;
            }
            ret.put("article", (Object)article);
            JSONArray tags = new JSONArray();
            List<JSONObject> tagArticleRelations = this.tagArticleRepository.getByArticleId(articleId);
            for (int i = 0; i < tagArticleRelations.size(); ++i) {
                JSONObject tagArticleRelation = tagArticleRelations.get(i);
                String tagId = tagArticleRelation.getString("tag_" + Keys.OBJECT_ID);
                JSONObject tag = this.tagRepository.get(tagId);
                tags.put((Object)tag);
            }
            article.put("articleTags", (Object)tags);
            JSONObject preference = this.preferenceQueryService.getPreference();
            article.put("signs", (Object)new JSONArray(preference.getString("signs")));
            article.remove("articleAuthorEmail");
            article.remove("articleCommentCount");
            article.remove("articleIsPublished");
            article.remove("articlePutTop");
            article.remove("articleUpdateDate");
            article.remove("articleViewCount");
            article.remove("articleRandomDouble");
            LOGGER.log(Level.DEBUG, "Got an article[id={0}]", new Object[]{articleId});
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets an article failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getArticles(JSONObject requestJSONObject) throws ServiceException {
        JSONObject ret = new JSONObject();
        try {
            int currentPageNum = requestJSONObject.getInt("paginationCurrentPageNum");
            int pageSize = requestJSONObject.getInt("paginationPageSize");
            int windowSize = requestJSONObject.getInt("paginationWindowSize");
            boolean articleIsPublished = requestJSONObject.optBoolean("articleIsPublished", true);
            Query query = new Query().setCurrentPageNum(currentPageNum).setPageSize(pageSize).addSort("articlePutTop", SortDirection.DESCENDING).addSort("articleCreateDate", SortDirection.DESCENDING).setFilter((Filter)new PropertyFilter("articleIsPublished", FilterOperator.EQUAL, (Object)articleIsPublished));
            int articleCount = this.statisticQueryService.getBlogArticleCount();
            articleCount = !articleIsPublished ? (articleCount -= this.statisticQueryService.getPublishedBlogArticleCount()) : this.statisticQueryService.getPublishedBlogArticleCount();
            int pageCount = (int)Math.ceil((double)articleCount / (double)pageSize);
            query.setPageCount(pageCount);
            JSONObject result = this.articleRepository.get(query);
            JSONObject pagination = new JSONObject();
            ret.put("pagination", (Object)pagination);
            List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
            pagination.put("paginationPageCount", pageCount);
            pagination.put("paginationPageNums", (Collection)pageNums);
            JSONArray articles = result.getJSONArray("rslts");
            JSONArray excludes = requestJSONObject.optJSONArray("excludes");
            excludes = null == excludes ? new JSONArray() : excludes;
            for (int i = 0; i < articles.length(); ++i) {
                JSONObject article = articles.getJSONObject(i);
                JSONObject author = this.getAuthor(article);
                String authorName = author.getString("userName");
                article.put("authorName", (Object)authorName);
                article.put("articleCreateTime", ((Date)article.get("articleCreateDate")).getTime());
                article.put("articleUpdateTime", ((Date)article.get("articleUpdateDate")).getTime());
                this.markdown(article);
                for (int j = 0; j < excludes.length(); ++j) {
                    article.remove(excludes.optString(j));
                }
            }
            ret.put("articles", (Object)articles);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets articles failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public List<JSONObject> getArticlesByTag(String tagId, int currentPageNum, int pageSize) throws ServiceException {
        try {
            JSONObject result = this.tagArticleRepository.getByTagId(tagId, currentPageNum, pageSize);
            JSONArray tagArticleRelations = result.getJSONArray("rslts");
            if (0 == tagArticleRelations.length()) {
                return Collections.emptyList();
            }
            HashSet<String> articleIds = new HashSet<String>();
            for (int i = 0; i < tagArticleRelations.length(); ++i) {
                JSONObject tagArticleRelation = tagArticleRelations.getJSONObject(i);
                String articleId = tagArticleRelation.getString("article_" + Keys.OBJECT_ID);
                articleIds.add(articleId);
            }
            ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
            Query query = new Query().setFilter((Filter)new PropertyFilter(Keys.OBJECT_ID, FilterOperator.IN, articleIds)).setPageCount(1).index(new String[]{"articlePermalink"});
            result = this.articleRepository.get(query);
            JSONArray articles = result.getJSONArray("rslts");
            for (int i = 0; i < articles.length(); ++i) {
                JSONObject article = articles.getJSONObject(i);
                if (!article.getBoolean("articleIsPublished")) continue;
                article.put("articleCreateTime", ((Date)article.get("articleCreateDate")).getTime());
                this.markdown(article);
                ret.add(article);
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets articles by tag[id=" + tagId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public List<JSONObject> getArticlesByArchiveDate(String archiveDateId, int currentPageNum, int pageSize) throws ServiceException {
        try {
            JSONObject result = this.archiveDateArticleRepository.getByArchiveDateId(archiveDateId, currentPageNum, pageSize);
            JSONArray relations = result.getJSONArray("rslts");
            if (0 == relations.length()) {
                return Collections.emptyList();
            }
            HashSet<String> articleIds = new HashSet<String>();
            for (int i = 0; i < relations.length(); ++i) {
                JSONObject relation = relations.getJSONObject(i);
                String articleId = relation.getString("article_" + Keys.OBJECT_ID);
                articleIds.add(articleId);
            }
            ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
            Query query = new Query().setFilter((Filter)new PropertyFilter(Keys.OBJECT_ID, FilterOperator.IN, articleIds)).setPageCount(1).index(new String[]{"articlePermalink"});
            result = this.articleRepository.get(query);
            JSONArray articles = result.getJSONArray("rslts");
            for (int i = 0; i < articles.length(); ++i) {
                JSONObject article = articles.getJSONObject(i);
                if (!article.getBoolean("articleIsPublished")) continue;
                article.put("articleCreateTime", ((Date)article.get("articleCreateDate")).getTime());
                this.markdown(article);
                ret.add(article);
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets articles by archive date[id=" + archiveDateId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public List<JSONObject> getArticlesRandomly(int fetchSize) throws ServiceException {
        try {
            List ret = this.articleRepository.getRandomly(fetchSize);
            this.removeUnusedProperties(ret);
            return ret;
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets articles randomly failed[fetchSize=" + fetchSize + "]", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public List<JSONObject> getRelevantArticles(JSONObject article, JSONObject preference) throws ServiceException {
        try {
            int displayCnt = preference.getInt("relevantArticlesDisplayCount");
            String[] tagTitles = article.getString("articleTags").split(",");
            int maxTagCnt = displayCnt > tagTitles.length ? tagTitles.length : displayCnt;
            String articleId = article.getString(Keys.OBJECT_ID);
            ArrayList<JSONObject> articles = new ArrayList<JSONObject>();
            for (int i = 0; i < maxTagCnt; ++i) {
                String tagTitle = tagTitles[i];
                JSONObject tag = this.tagRepository.getByTitle(tagTitle);
                String tagId = tag.getString(Keys.OBJECT_ID);
                JSONObject result = this.tagArticleRepository.getByTagId(tagId, 1, displayCnt);
                JSONArray tagArticleRelations = result.getJSONArray("rslts");
                int relationSize = displayCnt < tagArticleRelations.length() ? displayCnt : tagArticleRelations.length();
                for (int j = 0; j < relationSize; ++j) {
                    JSONObject relevant;
                    JSONObject tagArticleRelation = tagArticleRelations.getJSONObject(j);
                    String relatedArticleId = tagArticleRelation.getString("article_" + Keys.OBJECT_ID);
                    if (articleId.equals(relatedArticleId) || !(relevant = this.articleRepository.get(relatedArticleId)).getBoolean("articleIsPublished")) continue;
                    boolean existed = false;
                    for (JSONObject relevantArticle : articles) {
                        if (!relevantArticle.getString(Keys.OBJECT_ID).equals(relevant.getString(Keys.OBJECT_ID))) continue;
                        existed = true;
                    }
                    if (existed) continue;
                    articles.add(relevant);
                }
            }
            Collections.sort(articles, Comparators.ARTICLE_UPDATE_DATE_COMPARATOR);
            this.removeUnusedProperties(articles);
            if (displayCnt > articles.size()) {
                return articles;
            }
            List randomIntegers = CollectionUtils.getRandomIntegers((int)0, (int)(articles.size() - 1), (int)displayCnt);
            ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
            Iterator i$ = randomIntegers.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                ret.add((JSONObject)articles.get(index));
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets relevant articles failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public boolean isArticlePublished(String articleId) throws ServiceException {
        try {
            return this.articleRepository.isPublished(articleId);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Determines the article publish status failed[articleId=" + articleId + "]", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getNextArticle(String articleId) throws ServiceException {
        try {
            return this.articleRepository.getNextArticle(articleId);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets the next article failed[articleId=" + articleId + "]", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getPreviousArticle(String articleId) throws ServiceException {
        try {
            return this.articleRepository.getPreviousArticle(articleId);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets the previous article failed[articleId=" + articleId + "]", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getArticleById(String articleId) throws ServiceException {
        try {
            return this.articleRepository.get(articleId);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets an article[articleId=" + articleId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getArticleByPermalink(String articlePermalink) throws ServiceException {
        try {
            return this.articleRepository.getByPermalink(articlePermalink);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets an article[articlePermalink=" + articlePermalink + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public List<JSONObject> getArticlesByAuthorEmail(String authorEmail, int currentPageNum, int pageSize) throws ServiceException {
        try {
            JSONObject result = this.articleRepository.getByAuthorEmail(authorEmail, currentPageNum, pageSize);
            JSONArray articles = result.getJSONArray("rslts");
            ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
            for (int i = 0; i < articles.length(); ++i) {
                JSONObject article = articles.getJSONObject(i);
                article.put("articleCreateTime", ((Date)article.get("articleCreateDate")).getTime());
                this.markdown(article);
                ret.add(article);
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets articles by author email failed[authorEmail=" + authorEmail + ", currentPageNum=" + currentPageNum + ", pageSize=" + pageSize + "]", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public String getArticleContent(HttpServletRequest request, String articleId) throws ServiceException {
        if (Strings.isEmptyOrNull((String)articleId)) {
            return null;
        }
        try {
            JSONObject article = this.articleRepository.get(articleId);
            if (null == article) {
                return null;
            }
            if (this.needViewPwd(request, article)) {
                String content = this.langPropsService.get("articleContentPwd");
                article.put("articleContent", (Object)content);
            } else if ("CodeMirror-Markdown".equals(article.optString("articleEditorType"))) {
                Stopwatchs.start((String)"Get Article Content [Markdown]");
                String content = article.optString("articleContent");
                article.put("articleContent", (Object)Markdowns.toHTML(content));
                Stopwatchs.end();
            }
            return article.getString("articleContent");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets article content failed[articleId=" + articleId + "]", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void markdowns(List<JSONObject> articles) throws Exception {
        for (JSONObject article : articles) {
            this.markdown(article);
        }
    }

    public void markdown(JSONObject article) throws Exception {
        if ("CodeMirror-Markdown".equals(article.optString("articleEditorType"))) {
            Stopwatchs.start((String)("Markdown Article[id=" + article.optString(Keys.OBJECT_ID) + "]"));
            Stopwatchs.start((String)"Content");
            String content = article.optString("articleContent");
            article.put("articleContent", (Object)Markdowns.toHTML(content));
            Stopwatchs.end();
            String abstractContent = article.optString("articleAbstract");
            if (!Strings.isEmptyOrNull((String)abstractContent)) {
                Stopwatchs.start((String)"Abstract");
                article.put("articleAbstract", (Object)Markdowns.toHTML(abstractContent));
                Stopwatchs.end();
            }
            Stopwatchs.end();
        }
    }

    public void removeUnusedProperties(List<JSONObject> articles) {
        for (JSONObject article : articles) {
            this.removeUnusedProperties(article);
        }
    }

    public void removeUnusedProperties(JSONObject article) {
        article.remove(Keys.OBJECT_ID);
        article.remove("articleAuthorEmail");
        article.remove("articleAbstract");
        article.remove("articleCommentCount");
        article.remove("articleContent");
        article.remove("articleCreateDate");
        article.remove("articleTags");
        article.remove("articleUpdateDate");
        article.remove("articleViewCount");
        article.remove("articleRandomDouble");
        article.remove("articleIsPublished");
        article.remove("articlePutTop");
        article.remove("articleHadBeenPublished");
    }

    public void setArchiveDateArticleRepository(ArchiveDateArticleRepository archiveDateArticleRepository) {
        this.archiveDateArticleRepository = archiveDateArticleRepository;
    }

    public void setArticleRepository(ArticleRepository articleRepository) {
        this.articleRepository = articleRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void setPreferenceQueryService(PreferenceQueryService preferenceQueryService) {
        this.preferenceQueryService = preferenceQueryService;
    }

    public void setStatisticQueryService(StatisticQueryService statisticQueryService) {
        this.statisticQueryService = statisticQueryService;
    }

    public void setTagRepository(TagRepository tagRepository) {
        this.tagRepository = tagRepository;
    }

    public void setTagArticleRepository(TagArticleRepository tagArticleRepository) {
        this.tagArticleRepository = tagArticleRepository;
    }
}

