/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Paginator;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.CommentRepository;
import org.b3log.solo.repository.PageRepository;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONArray;
import org.json.JSONObject;

@Service
public class CommentQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)CommentQueryService.class.getName());
    @Inject
    private UserQueryService userQueryService;
    @Inject
    private CommentRepository commentRepository;
    @Inject
    private ArticleRepository articleRepository;
    @Inject
    private PageRepository pageRepository;

    public boolean canAccessComment(String commentId, HttpServletRequest request) throws Exception {
        if (Strings.isEmptyOrNull((String)commentId)) {
            return false;
        }
        if (this.userQueryService.isAdminLoggedIn(request)) {
            return true;
        }
        JSONObject comment = this.commentRepository.get(commentId);
        if (null == comment) {
            return false;
        }
        String onId = comment.optString("commentOnId");
        String onType = comment.optString("commentOnType");
        if ("page".equals(onType)) {
            return false;
        }
        JSONObject article = this.articleRepository.get(onId);
        if (null == article) {
            return false;
        }
        String currentUserEmail = this.userQueryService.getCurrentUser(request).getString("userEmail");
        return article.getString("articleAuthorEmail").equals(currentUserEmail);
    }

    public JSONObject getComments(JSONObject requestJSONObject) throws ServiceException {
        try {
            JSONObject ret = new JSONObject();
            int currentPageNum = requestJSONObject.getInt("paginationCurrentPageNum");
            int pageSize = requestJSONObject.getInt("paginationPageSize");
            int windowSize = requestJSONObject.getInt("paginationWindowSize");
            Query query = new Query().setCurrentPageNum(currentPageNum).setPageSize(pageSize).addSort("commentDate", SortDirection.DESCENDING);
            JSONObject result = this.commentRepository.get(query);
            JSONArray comments = result.getJSONArray("rslts");
            for (int i = 0; i < comments.length(); ++i) {
                String title;
                JSONObject comment = comments.getJSONObject(i);
                String onType = comment.getString("commentOnType");
                String onId = comment.getString("commentOnId");
                if ("article".equals(onType)) {
                    JSONObject article = this.articleRepository.get(onId);
                    title = article.getString("articleTitle");
                    comment.put("type", (Object)"articleComment");
                } else {
                    JSONObject page = this.pageRepository.get(onId);
                    title = page.getString("pageTitle");
                    comment.put("type", (Object)"pageComment");
                }
                comment.put("commentTitle", (Object)title);
                comment.put("commentTime", ((Date)comment.get("commentDate")).getTime());
                comment.remove("commentDate");
                String content = comment.getString("commentContent").replaceAll("_esc_enter_88250_", "<br/>");
                comment.put("commentContent", (Object)content);
            }
            int pageCount = result.getJSONObject("pagination").getInt("paginationPageCount");
            JSONObject pagination = new JSONObject();
            List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
            pagination.put("paginationPageCount", pageCount);
            pagination.put("paginationPageNums", (Collection)pageNums);
            ret.put("comments", (Object)comments);
            ret.put("pagination", (Object)pagination);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets comments failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public List<JSONObject> getComments(String onId) throws ServiceException {
        try {
            ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
            List<JSONObject> comments = this.commentRepository.getComments(onId, 1, Integer.MAX_VALUE);
            for (JSONObject comment : comments) {
                String content = comment.getString("commentContent").replaceAll("_esc_enter_88250_", "<br/>");
                comment.put("commentContent", (Object)content);
                comment.put("commentTime", ((Date)comment.get("commentDate")).getTime());
                comment.put("commentName", (Object)StringEscapeUtils.escapeHtml((String)comment.getString("commentName")));
                comment.put("commentURL", (Object)StringEscapeUtils.escapeHtml((String)comment.getString("commentURL")));
                comment.put("isReply", false);
                if (!Strings.isEmptyOrNull((String)comment.optString("commentOriginalCommentId"))) {
                    comment.put("isReply", true);
                }
                ret.add(comment);
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets comments failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void setArticleRepository(ArticleRepository articleRepository) {
        this.articleRepository = articleRepository;
    }

    public void setPageRepository(PageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }

    public void setCommentRepository(CommentRepository commentRepository) {
        this.commentRepository = commentRepository;
    }
}

