/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Paginator;
import org.b3log.solo.repository.LinkRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Service
public class LinkQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)LinkQueryService.class.getName());
    @Inject
    private LinkRepository linkRepository;

    public JSONObject getLinks(JSONObject requestJSONObject) throws ServiceException {
        JSONObject ret = new JSONObject();
        try {
            int currentPageNum = requestJSONObject.getInt("paginationCurrentPageNum");
            int pageSize = requestJSONObject.getInt("paginationPageSize");
            int windowSize = requestJSONObject.getInt("paginationWindowSize");
            Query query = new Query().setCurrentPageNum(currentPageNum).setPageSize(pageSize).addSort("linkOrder", SortDirection.ASCENDING);
            JSONObject result = this.linkRepository.get(query);
            int pageCount = result.getJSONObject("pagination").getInt("paginationPageCount");
            JSONObject pagination = new JSONObject();
            List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
            pagination.put("paginationPageCount", pageCount);
            pagination.put("paginationPageNums", (Collection)pageNums);
            JSONArray links = result.getJSONArray("rslts");
            ret.put("pagination", (Object)pagination);
            ret.put("links", (Object)links);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets links failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getLink(String linkId) throws ServiceException {
        JSONObject ret = new JSONObject();
        try {
            JSONObject link = this.linkRepository.get(linkId);
            if (null == link) {
                return null;
            }
            ret.put("link", (Object)link);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets a link failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void setLinkRepository(LinkRepository linkRepository) {
        this.linkRepository = linkRepository;
    }
}

