/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Ids;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.CommentRepository;
import org.b3log.solo.repository.PageRepository;
import org.b3log.solo.service.PermalinkQueryService;
import org.b3log.solo.service.PreferenceQueryService;
import org.b3log.solo.service.StatisticMgmtService;
import org.b3log.solo.service.StatisticQueryService;
import org.b3log.solo.util.Comments;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class PageMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)PageMgmtService.class.getName());
    @Inject
    private PageRepository pageRepository;
    @Inject
    private CommentRepository commentRepository;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private PermalinkQueryService permalinkQueryService;
    @Inject
    private PreferenceQueryService preferenceQueryService;
    @Inject
    private StatisticMgmtService statisticMgmtService;
    @Inject
    private StatisticQueryService statisticQueryService;

    public void updatePage(JSONObject requestJSONObject) throws ServiceException {
        Transaction transaction = this.pageRepository.beginTransaction();
        try {
            JSONObject page = requestJSONObject.getJSONObject("page");
            String pageId = page.getString(Keys.OBJECT_ID);
            JSONObject oldPage = this.pageRepository.get(pageId);
            JSONObject newPage = new JSONObject(page, JSONObject.getNames((JSONObject)page));
            newPage.put("pageOrder", oldPage.getInt("pageOrder"));
            newPage.put("pageCommentCount", oldPage.getInt("pageCommentCount"));
            String permalink = page.optString("pagePermalink").trim();
            String oldPermalink = oldPage.getString("pagePermalink");
            if (!oldPermalink.equals(permalink)) {
                if (Strings.isEmptyOrNull((String)permalink)) {
                    permalink = "/pages/" + pageId + ".html";
                }
                if ("page".equals(page.getString("pageType"))) {
                    if (!permalink.startsWith("/")) {
                        permalink = "/" + permalink;
                    }
                    if (PermalinkQueryService.invalidPagePermalinkFormat(permalink)) {
                        if (transaction.isActive()) {
                            transaction.rollback();
                        }
                        throw new ServiceException(this.langPropsService.get("invalidPermalinkFormatLabel"));
                    }
                    if (!oldPermalink.equals(permalink) && this.permalinkQueryService.exist(permalink)) {
                        if (transaction.isActive()) {
                            transaction.rollback();
                        }
                        throw new ServiceException(this.langPropsService.get("duplicatedPermalinkLabel"));
                    }
                }
            }
            newPage.put("pagePermalink", (Object)permalink.replaceAll(" ", "-"));
            if (!oldPage.getString("pagePermalink").equals(permalink)) {
                this.processCommentsForPageUpdate(newPage);
            }
            if (!newPage.has("pageEditorType")) {
                JSONObject preference = this.preferenceQueryService.getPreference();
                newPage.put("pageEditorType", (Object)preference.optString("editorType"));
            }
            this.pageRepository.update(pageId, newPage);
            transaction.commit();
            LOGGER.log(Level.DEBUG, "Updated a page[id={0}]", new Object[]{pageId});
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new ServiceException((Throwable)e);
        }
    }

    public void removePage(String pageId) throws ServiceException {
        Transaction transaction = this.pageRepository.beginTransaction();
        try {
            LOGGER.log(Level.DEBUG, "Removing a page[id={0}]", new Object[]{pageId});
            this.removePageComments(pageId);
            this.pageRepository.remove(pageId);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Removes a page[id=" + pageId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public String addPage(JSONObject requestJSONObject) throws ServiceException {
        Transaction transaction = this.pageRepository.beginTransaction();
        try {
            JSONObject page = requestJSONObject.getJSONObject("page");
            page.put("pageCommentCount", 0);
            int maxOrder = this.pageRepository.getMaxOrder();
            page.put("pageOrder", maxOrder + 1);
            String permalink = page.optString("pagePermalink");
            if (Strings.isEmptyOrNull((String)permalink)) {
                permalink = "/pages/" + Ids.genTimeMillisId() + ".html";
            }
            if ("page".equals(page.getString("pageType"))) {
                if (!permalink.startsWith("/")) {
                    permalink = "/" + permalink;
                }
                if (PermalinkQueryService.invalidPagePermalinkFormat(permalink)) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new ServiceException(this.langPropsService.get("invalidPermalinkFormatLabel"));
                }
                if (this.permalinkQueryService.exist(permalink)) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new ServiceException(this.langPropsService.get("duplicatedPermalinkLabel"));
                }
            }
            page.put("pagePermalink", (Object)permalink.replaceAll(" ", "-"));
            if (!page.has("pageEditorType")) {
                JSONObject preference = this.preferenceQueryService.getPreference();
                page.put("pageEditorType", (Object)preference.optString("editorType"));
            }
            String ret = this.pageRepository.add(page);
            transaction.commit();
            return ret;
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new ServiceException((Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new ServiceException((Throwable)e);
        }
    }

    public void changeOrder(String pageId, String direction) throws ServiceException {
        Transaction transaction = this.pageRepository.beginTransaction();
        try {
            JSONObject srcPage = this.pageRepository.get(pageId);
            int srcPageOrder = srcPage.getInt("pageOrder");
            JSONObject targetPage = "up".equals(direction) ? this.pageRepository.getUpper(pageId) : this.pageRepository.getUnder(pageId);
            if (null == targetPage) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                LOGGER.log(Level.WARN, "Cant not find the target page of source page[order={0}]", new Object[]{srcPageOrder});
                return;
            }
            srcPage.put("pageOrder", targetPage.getInt("pageOrder"));
            targetPage.put("pageOrder", srcPageOrder);
            this.pageRepository.update(srcPage.getString(Keys.OBJECT_ID), srcPage);
            this.pageRepository.update(targetPage.getString(Keys.OBJECT_ID), targetPage);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Changes page's order failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    private void removePageComments(String pageId) throws JSONException, RepositoryException {
        int removedCnt = this.commentRepository.removeComments(pageId);
        int blogCommentCount = this.statisticQueryService.getBlogCommentCount();
        this.statisticMgmtService.setBlogCommentCount(blogCommentCount -= removedCnt);
        int publishedBlogCommentCount = this.statisticQueryService.getPublishedBlogCommentCount();
        this.statisticMgmtService.setPublishedBlogCommentCount(publishedBlogCommentCount -= removedCnt);
    }

    public void processCommentsForPageUpdate(JSONObject page) throws Exception {
        String pageId = page.getString(Keys.OBJECT_ID);
        List<JSONObject> comments = this.commentRepository.getComments(pageId, 1, Integer.MAX_VALUE);
        for (JSONObject comment : comments) {
            String commentId = comment.getString(Keys.OBJECT_ID);
            String sharpURL = Comments.getCommentSharpURLForPage(page, commentId);
            comment.put("commentSharpURL", (Object)sharpURL);
            if (Strings.isEmptyOrNull((String)comment.optString("commentOriginalCommentId"))) {
                comment.put("commentOriginalCommentId", (Object)"");
            }
            if (Strings.isEmptyOrNull((String)comment.optString("commentOriginalCommentName"))) {
                comment.put("commentOriginalCommentName", (Object)"");
            }
            this.commentRepository.update(commentId, comment);
        }
    }

    public void setPermalinkQueryService(PermalinkQueryService permalinkQueryService) {
        this.permalinkQueryService = permalinkQueryService;
    }

    public void setPageRepository(PageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }

    public void setPreferenceQueryService(PreferenceQueryService preferenceQueryService) {
        this.preferenceQueryService = preferenceQueryService;
    }

    public void setStatisticQueryService(StatisticQueryService statisticQueryService) {
        this.statisticQueryService = statisticQueryService;
    }

    public void setStatisticMgmtService(StatisticMgmtService statisticMgmtService) {
        this.statisticMgmtService = statisticMgmtService;
    }

    public void setCommentRepository(CommentRepository commentRepository) {
        this.commentRepository = commentRepository;
    }

    public void setLangPropsService(LangPropsService langPropsService) {
        this.langPropsService = langPropsService;
    }
}

