/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Paginator;
import org.b3log.solo.repository.PageRepository;
import org.json.JSONArray;
import org.json.JSONObject;

@Service
public class PageQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)PageQueryService.class.getName());
    @Inject
    private PageRepository pageRepository;

    public JSONObject getPage(String pageId) throws ServiceException {
        JSONObject ret = new JSONObject();
        try {
            JSONObject page = this.pageRepository.get(pageId);
            if (null == page) {
                return null;
            }
            ret.put("page", (Object)page);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getPages(JSONObject requestJSONObject) throws ServiceException {
        JSONObject ret = new JSONObject();
        try {
            int currentPageNum = requestJSONObject.getInt("paginationCurrentPageNum");
            int pageSize = requestJSONObject.getInt("paginationPageSize");
            int windowSize = requestJSONObject.getInt("paginationWindowSize");
            Query query = new Query().setCurrentPageNum(currentPageNum).setPageSize(pageSize).addSort("pageOrder", SortDirection.ASCENDING).setPageCount(1);
            JSONObject result = this.pageRepository.get(query);
            int pageCount = result.getJSONObject("pagination").getInt("paginationPageCount");
            JSONObject pagination = new JSONObject();
            List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
            pagination.put("paginationPageCount", pageCount);
            pagination.put("paginationPageNums", (Collection)pageNums);
            JSONArray pages = result.getJSONArray("rslts");
            for (int i = 0; i < pages.length(); ++i) {
                JSONObject page = pages.getJSONObject(i);
                page.remove("pageContent");
            }
            ret.put("pagination", (Object)pagination);
            ret.put("pages", (Object)pages);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets pages failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void setPageRepository(PageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }
}

