/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.PageRepository;

@Service
public class PermalinkQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)PermalinkQueryService.class.getName());
    @Inject
    private PageRepository pageRepository;
    @Inject
    private ArticleRepository articleRepository;
    public static final String[] RESERVED_LINKS = new String[]{"/", "/article", "/tags.html", "/tags", "/page", "/blog-articles-feed.do", "/tag-articles-feed.do", "/blog-articles-rss.do", "/tag-articles-rss.do", "/get-random-articles.do", "/article-random-double-gen.do", "/captcha.do", "/kill-browser", "/add-article-comment.do", "/add-article-from-symphony-comment.do", "/add-page-comment.do", "/get-article-content", "/sitemap.xml", "/login", "/logout", "/forgot", "/get-article-content", "/admin-index.do", "/admin-article.do", "/admin-article-list.do", "/admin-link-list.do", "/admin-preference.do", "/admin-file-list.do", "/admin-page-list.do", "/admin-others.do", "/admin-draft-list.do", "/admin-user-list.do", "/admin-plugin-list.do", "/admin-main.do", "/admin-about.do", "/admin-label", "/admin-about.do", "/rm-all-data.do", "/init", "/register.html"};

    public static boolean matchDefaultArticlePermalinkFormat(String permalink) {
        Pattern pattern = Pattern.compile("/articles/\\d{4}/\\d{2}/\\d{2}/\\d+\\.html");
        Matcher matcher = pattern.matcher(permalink);
        return matcher.matches();
    }

    public static boolean matchDefaultPagePermalinkFormat(String permalink) {
        Pattern pattern = Pattern.compile("/pages/\\d+\\.html");
        Matcher matcher = pattern.matcher(permalink);
        return matcher.matches();
    }

    public static boolean invalidPermalinkFormat(String permalink) {
        return PermalinkQueryService.invalidArticlePermalinkFormat(permalink) && PermalinkQueryService.invalidPagePermalinkFormat(permalink);
    }

    public static boolean invalidArticlePermalinkFormat(String permalink) {
        if (Strings.isEmptyOrNull((String)permalink)) {
            return true;
        }
        if (PermalinkQueryService.matchDefaultArticlePermalinkFormat(permalink)) {
            return false;
        }
        return PermalinkQueryService.invalidUserDefinedPermalinkFormat(permalink);
    }

    public static boolean invalidPagePermalinkFormat(String permalink) {
        if (Strings.isEmptyOrNull((String)permalink)) {
            return true;
        }
        if (PermalinkQueryService.matchDefaultPagePermalinkFormat(permalink)) {
            return false;
        }
        return PermalinkQueryService.invalidUserDefinedPermalinkFormat(permalink);
    }

    private static boolean invalidUserDefinedPermalinkFormat(String permalink) {
        if (Strings.isEmptyOrNull((String)permalink)) {
            return true;
        }
        if (PermalinkQueryService.isReservedLink(permalink)) {
            return true;
        }
        if (Strings.isNumeric((String)permalink.substring(1))) {
            return true;
        }
        int slashCnt = 0;
        for (int i = 0; i < permalink.length(); ++i) {
            if ('/' == permalink.charAt(i)) {
                ++slashCnt;
            }
            if (slashCnt <= 1) continue;
            return true;
        }
        return !Strings.isURL((String)(Latkes.getServer() + permalink));
    }

    private static boolean isReservedLink(String requestURI) {
        for (int i = 0; i < RESERVED_LINKS.length; ++i) {
            String reservedLink = RESERVED_LINKS[i];
            if (!reservedLink.startsWith(requestURI)) continue;
            return true;
        }
        return false;
    }

    public boolean exist(String permalink) {
        try {
            return PermalinkQueryService.isReservedLink(permalink) || null != this.articleRepository.getByPermalink(permalink) || null != this.pageRepository.getByPermalink(permalink) || permalink.endsWith(".ftl");
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Determines whether the permalink[" + permalink + "] exists failed, returns true", (Throwable)e);
            return true;
        }
    }

    public void setArticleRepository(ArticleRepository articleRepository) {
        this.articleRepository = articleRepository;
    }

    public void setPageRepository(PageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }
}

