/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Locales;
import org.b3log.latke.util.Stopwatchs;
import org.b3log.latke.util.Strings;
import org.b3log.latke.util.freemarker.Templates;
import org.b3log.solo.SoloServletListener;
import org.b3log.solo.repository.PreferenceRepository;
import org.b3log.solo.util.Skins;
import org.b3log.solo.util.TimeZones;
import org.json.JSONArray;
import org.json.JSONObject;

@Service
public class PreferenceMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)PreferenceMgmtService.class.getName());
    @Inject
    private PreferenceRepository preferenceRepository;
    @Inject
    private LangPropsService langPropsService;

    public void loadSkins(JSONObject preference) throws Exception {
        String skinsString;
        Stopwatchs.start((String)"Load Skins");
        LOGGER.info("Loading skins....");
        Set<String> skinDirNames = Skins.getSkinDirNames();
        LOGGER.log(Level.DEBUG, "Loaded skins[dirNames={0}]", new Object[]{skinDirNames});
        JSONArray skinArray = new JSONArray();
        for (String dirName : skinDirNames) {
            JSONObject skin = new JSONObject();
            String name = Latkes.getSkinName((String)dirName);
            if (null == name) {
                LOGGER.log(Level.WARN, "The directory[{0}] does not contain any skin, ignored it", new Object[]{dirName});
                continue;
            }
            skin.put("skinName", (Object)name);
            skin.put("skinDirName", (Object)dirName);
            skinArray.put((Object)skin);
        }
        String currentSkinDirName = preference.optString("skinDirName");
        String skinName = preference.optString("skinName");
        LOGGER.log(Level.INFO, "Current skin[name={0}]", new Object[]{skinName});
        if (!skinDirNames.contains(currentSkinDirName)) {
            LOGGER.log(Level.WARN, "Configred skin[dirName={0}] can not find, try to use default skin[dirName=finding] instead.", new Object[]{currentSkinDirName});
            if (!skinDirNames.contains("finding")) {
                LOGGER.log(Level.ERROR, "Can not find skin[dirName=finding]", new Object[0]);
                throw new IllegalStateException("Can not find default skin[dirName=finding], please redeploy your Solo and make sure contains this default skin!");
            }
            preference.put("skinDirName", (Object)"finding");
            preference.put("skinName", (Object)Latkes.getSkinName((String)"finding"));
            this.updatePreference(preference);
        }
        if (!(skinsString = skinArray.toString()).equals(preference.getString("skins"))) {
            LOGGER.log(Level.INFO, "The skins directory has been changed, persists the change into preference", new Object[0]);
            preference.put("skins", (Object)skinsString);
            this.updatePreference(preference);
        }
        Skins.setDirectoryForTemplateLoading(preference.getString("skinDirName"));
        String localeString = preference.getString("localeString");
        if ("zh_CN".equals(localeString)) {
            TimeZones.setTimeZone("Asia/Shanghai");
        }
        LOGGER.info("Loaded skins....");
        Stopwatchs.end();
    }

    public void updateReplyNotificationTemplate(JSONObject replyNotificationTemplate) throws ServiceException {
        Transaction transaction = this.preferenceRepository.beginTransaction();
        try {
            this.preferenceRepository.update("replyNotificationTemplate", replyNotificationTemplate);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Updates reply notification failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void updatePreference(JSONObject preference) throws ServiceException {
        Iterator keys = preference.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!preference.isNull(key)) continue;
            throw new ServiceException("A value is null of preference[key=" + key + "]");
        }
        Transaction transaction = this.preferenceRepository.beginTransaction();
        try {
            String skinDirName = preference.getString("skinDirName");
            String skinName = Latkes.getSkinName((String)skinDirName);
            preference.put("skinName", (Object)skinName);
            Set<String> skinDirNames = Skins.getSkinDirNames();
            JSONArray skinArray = new JSONArray();
            for (String dirName : skinDirNames) {
                JSONObject skin = new JSONObject();
                skinArray.put((Object)skin);
                String name = Latkes.getSkinName((String)dirName);
                skin.put("skinName", (Object)name);
                skin.put("skinDirName", (Object)dirName);
            }
            preference.put("skins", (Object)skinArray.toString());
            String timeZoneId = preference.getString("timeZoneId");
            TimeZones.setTimeZone(timeZoneId);
            preference.put("signs", (Object)preference.get("signs").toString());
            JSONObject oldPreference = this.preferenceRepository.get("preference");
            String adminEmail = oldPreference.getString("adminEmail");
            preference.put("adminEmail", (Object)adminEmail);
            String version = oldPreference.optString("version");
            if (!Strings.isEmptyOrNull((String)version)) {
                preference.put("version", (Object)version);
            }
            String localeString = preference.getString("localeString");
            LOGGER.log(Level.DEBUG, "Current locale[string={0}]", new Object[]{localeString});
            Latkes.setLocale((Locale)new Locale(Locales.getLanguage((String)localeString), Locales.getCountry((String)localeString)));
            this.preferenceRepository.update("preference", preference);
            transaction.commit();
            ServletContext servletContext = SoloServletListener.getServletContext();
            Templates.MAIN_CFG.setServletContextForTemplateLoading((Object)servletContext, "/skins/" + skinDirName);
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Updates preference failed", (Throwable)e);
            throw new ServiceException(this.langPropsService.get("updateFailLabel"));
        }
        LOGGER.log(Level.DEBUG, "Updates preference successfully", new Object[0]);
    }

    public void setPreferenceRepository(PreferenceRepository preferenceRepository) {
        this.preferenceRepository = preferenceRepository;
    }

    public void setLangPropsService(LangPropsService langPropsService) {
        this.langPropsService = langPropsService;
    }
}

