/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.Requests;
import org.b3log.solo.repository.ArticleRepository;
import org.b3log.solo.repository.StatisticRepository;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class StatisticMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)StatisticMgmtService.class.getName());
    @Inject
    private StatisticRepository statisticRepository;
    @Inject
    private LangPropsService langPropsService;
    @Inject
    private ArticleRepository articleRepository;
    public static final Map<String, Long> ONLINE_VISITORS = new HashMap<String, Long>();
    private static final int ONLINE_VISITOR_EXPIRATION = 300000;

    public void incBlogViewCount(HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        if (Requests.searchEngineBotRequest((HttpServletRequest)request)) {
            return;
        }
        if (Requests.hasBeenServed((HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        Transaction transaction = this.statisticRepository.beginTransaction();
        JSONObject statistic = null;
        try {
            statistic = this.statisticRepository.get("statistic");
            if (null == statistic) {
                return;
            }
            LOGGER.log(Level.TRACE, "Before inc blog view count[statistic={0}]", new Object[]{statistic});
            int blogViewCnt = statistic.optInt("statisticBlogViewCount");
            statistic.put("statisticBlogViewCount", ++blogViewCnt);
            this.statisticRepository.update("statistic", statistic);
            transaction.commit();
        }
        catch (RepositoryException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Updates blog view count failed", (Throwable)e);
            return;
        }
        LOGGER.log(Level.TRACE, "Inced blog view count[statistic={0}]", new Object[]{statistic});
    }

    public void incBlogArticleCount() throws RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticBlogArticleCount", statistic.optInt("statisticBlogArticleCount") + 1);
        this.statisticRepository.update("statistic", statistic);
    }

    public void incPublishedBlogArticleCount() throws RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticPublishedBlogArticleCount", statistic.optInt("statisticPublishedBlogArticleCount") + 1);
        this.statisticRepository.update("statistic", statistic);
    }

    public void decBlogArticleCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticBlogArticleCount", statistic.getInt("statisticBlogArticleCount") - 1);
        this.statisticRepository.update("statistic", statistic);
    }

    public void decPublishedBlogArticleCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticPublishedBlogArticleCount", statistic.getInt("statisticPublishedBlogArticleCount") - 1);
        this.statisticRepository.update("statistic", statistic);
    }

    public void incBlogCommentCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticBlogCommentCount", statistic.getInt("statisticBlogCommentCount") + 1);
        this.statisticRepository.update("statistic", statistic);
    }

    public void incPublishedBlogCommentCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticPublishedBlogCommentCount", statistic.getInt("statisticPublishedBlogCommentCount") + 1);
        this.statisticRepository.update("statistic", statistic);
    }

    public void decBlogCommentCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticBlogCommentCount", statistic.getInt("statisticBlogCommentCount") - 1);
        this.statisticRepository.update("statistic", statistic);
    }

    public void decPublishedBlogCommentCount() throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticPublishedBlogCommentCount", statistic.getInt("statisticPublishedBlogCommentCount") - 1);
        this.statisticRepository.update("statistic", statistic);
    }

    public void setBlogCommentCount(int count) throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticBlogCommentCount", count);
        this.statisticRepository.update("statistic", statistic);
    }

    public void setPublishedBlogCommentCount(int count) throws JSONException, RepositoryException {
        JSONObject statistic = this.statisticRepository.get("statistic");
        if (null == statistic) {
            throw new RepositoryException("Not found statistic");
        }
        statistic.put("statisticPublishedBlogCommentCount", count);
        this.statisticRepository.update("statistic", statistic);
    }

    public void onlineVisitorCount(HttpServletRequest request) {
        String remoteAddr = Requests.getRemoteAddr((HttpServletRequest)request);
        LOGGER.log(Level.DEBUG, "Current request [IP={0}]", new Object[]{remoteAddr});
        ONLINE_VISITORS.put(remoteAddr, System.currentTimeMillis());
        LOGGER.log(Level.DEBUG, "Current online visitor count [{0}]", new Object[]{ONLINE_VISITORS.size()});
    }

    public static void removeExpiredOnlineVisitor() {
        long currentTimeMillis = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> iterator = ONLINE_VISITORS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> onlineVisitor = iterator.next();
            if (currentTimeMillis <= onlineVisitor.getValue() + 300000L) continue;
            iterator.remove();
            LOGGER.log(Level.TRACE, "Removed online visitor[ip={0}]", new Object[]{onlineVisitor.getKey()});
        }
        LOGGER.log(Level.DEBUG, "Current online visitor count [{0}]", new Object[]{ONLINE_VISITORS.size()});
    }

    public void updateStatistic(JSONObject statistic) throws ServiceException {
        Transaction transaction = this.statisticRepository.beginTransaction();
        try {
            this.statisticRepository.update("statistic", statistic);
            transaction.commit();
        }
        catch (RepositoryException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Updates statistic failed", (Throwable)e);
        }
        LOGGER.log(Level.DEBUG, "Updates statistic successfully", new Object[0]);
    }

    public void setArticleRepository(ArticleRepository articleRepository) {
        this.articleRepository = articleRepository;
    }

    public void setStatisticRepository(StatisticRepository statisticRepository) {
        this.statisticRepository = statisticRepository;
    }

    public void setLangPropsService(LangPropsService langPropsService) {
        this.langPropsService = langPropsService;
    }
}

