/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.List;
import javax.inject.Inject;
import org.b3log.latke.Keys;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.solo.repository.TagRepository;
import org.b3log.solo.service.TagQueryService;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class TagMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)TagMgmtService.class.getName());
    @Inject
    private TagQueryService tagQueryService;
    @Inject
    private TagRepository tagRepository;

    public void decTagPublishedRefCount(String articleId) throws JSONException, RepositoryException {
        List<JSONObject> tags = this.tagRepository.getByArticleId(articleId);
        for (JSONObject tag : tags) {
            String tagId = tag.getString(Keys.OBJECT_ID);
            int refCnt = tag.getInt("tagReferenceCount");
            tag.put("tagReferenceCount", refCnt);
            int publishedRefCnt = tag.getInt("tagPublishedRefCount");
            tag.put("tagPublishedRefCount", publishedRefCnt - 1);
            this.tagRepository.update(tagId, tag);
        }
    }

    public void removeUnusedTags() throws ServiceException {
        Transaction transaction = this.tagRepository.beginTransaction();
        try {
            List<JSONObject> tags = this.tagQueryService.getTags();
            for (int i = 0; i < tags.size(); ++i) {
                JSONObject tag = tags.get(i);
                int tagRefCnt = tag.getInt("tagReferenceCount");
                if (0 != tagRefCnt) continue;
                String tagId = tag.getString(Keys.OBJECT_ID);
                this.tagRepository.remove(tagId);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Removes unused tags failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void setTagRepository(TagRepository tagRepository) {
        this.tagRepository = tagRepository;
    }

    public void setTagQueryService(TagQueryService tagQueryService) {
        this.tagQueryService = tagQueryService;
    }
}

