/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.util.MD5;
import org.b3log.latke.util.Sessions;
import org.b3log.latke.util.Strings;
import org.b3log.solo.repository.UserRepository;
import org.b3log.solo.service.UserQueryService;
import org.json.JSONObject;

@Service
public class UserMgmtService {
    private static final Logger LOGGER = Logger.getLogger((String)UserMgmtService.class.getName());
    @Inject
    private UserRepository userRepository;
    @Inject
    private LangPropsService langPropsService;
    private static final int HASHED_PASSWORD_LENGTH = 32;

    public void tryLogInWithCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (null == cookies || 0 == cookies.length) {
            return;
        }
        try {
            for (int i = 0; i < cookies.length; ++i) {
                LatkeBeanManager beanManager;
                UserQueryService userQueryService;
                JSONObject user;
                Cookie cookie = cookies[i];
                if (!"b3log-latke".equals(cookie.getName())) continue;
                JSONObject cookieJSONObject = new JSONObject(cookie.getValue());
                String userEmail = cookieJSONObject.optString("userEmail");
                if (!Strings.isEmptyOrNull((String)userEmail) && null != (user = (userQueryService = (UserQueryService)(beanManager = Lifecycle.getBeanManager()).getReference(UserQueryService.class)).getUserByEmail(userEmail.toLowerCase().trim()))) {
                    String hashPassword;
                    String userPassword = user.optString("userPassword");
                    if (!userPassword.equals(hashPassword = cookieJSONObject.optString("userPassword"))) continue;
                    Sessions.login((HttpServletRequest)request, (HttpServletResponse)response, (JSONObject)user);
                    LOGGER.log(Level.DEBUG, "Logged in with cookie[email={0}]", new Object[]{userEmail});
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Parses cookie failed, clears the cookie[name=b3log-latke]", (Throwable)e);
            Cookie cookie = new Cookie("b3log-latke", null);
            cookie.setMaxAge(0);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
    }

    public void updateUser(JSONObject requestJSONObject) throws ServiceException {
        Transaction transaction = this.userRepository.beginTransaction();
        try {
            String userURL;
            String userRole;
            String oldUserId = requestJSONObject.optString(Keys.OBJECT_ID);
            JSONObject oldUser = this.userRepository.get(oldUserId);
            if (null == oldUser) {
                throw new ServiceException(this.langPropsService.get("updateFailLabel"));
            }
            String userNewEmail = requestJSONObject.optString("userEmail").toLowerCase().trim();
            JSONObject mayBeAnother = this.userRepository.getByEmail(userNewEmail);
            if (null != mayBeAnother && !mayBeAnother.optString(Keys.OBJECT_ID).equals(oldUserId)) {
                throw new ServiceException(this.langPropsService.get("duplicatedEmailLabel"));
            }
            String userName = requestJSONObject.optString("userName");
            String userPassword = requestJSONObject.optString("userPassword");
            oldUser.put("userEmail", (Object)userNewEmail);
            oldUser.put("userName", (Object)userName);
            boolean mybeHashed = 32 == userPassword.length();
            String newHashedPassword = MD5.hash((String)userPassword);
            String oldHashedPassword = oldUser.optString("userPassword");
            if (!("demo.b3log.org".equals(Latkes.getServerHost()) || mybeHashed && (oldHashedPassword.equals(userPassword) || oldHashedPassword.equals(newHashedPassword)))) {
                oldUser.put("userPassword", (Object)newHashedPassword);
            }
            if (!Strings.isEmptyOrNull((String)(userRole = requestJSONObject.optString("userRole")))) {
                oldUser.put("userRole", (Object)userRole);
            }
            if (!Strings.isEmptyOrNull((String)(userURL = requestJSONObject.optString("userURL")))) {
                oldUser.put("userURL", (Object)userURL);
            }
            this.userRepository.update(oldUserId, oldUser);
            transaction.commit();
        }
        catch (RepositoryException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Updates a user failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void changeRole(String userId) throws ServiceException {
        Transaction transaction = this.userRepository.beginTransaction();
        try {
            JSONObject oldUser = this.userRepository.get(userId);
            if (null == oldUser) {
                throw new ServiceException(this.langPropsService.get("updateFailLabel"));
            }
            String role = oldUser.optString("userRole");
            if ("visitorRole".equals(role)) {
                oldUser.put("userRole", (Object)"defaultRole");
            } else if ("defaultRole".equals(role)) {
                oldUser.put("userRole", (Object)"visitorRole");
            }
            this.userRepository.update(userId, oldUser);
            transaction.commit();
        }
        catch (RepositoryException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Updates a user failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public String addUser(JSONObject requestJSONObject) throws ServiceException {
        Transaction transaction = this.userRepository.beginTransaction();
        try {
            JSONObject user = new JSONObject();
            String userEmail = requestJSONObject.optString("userEmail").trim().toLowerCase();
            JSONObject duplicatedUser = this.userRepository.getByEmail(userEmail);
            if (null != duplicatedUser) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                throw new ServiceException(this.langPropsService.get("duplicatedEmailLabel"));
            }
            user.put("userEmail", (Object)userEmail);
            String userName = requestJSONObject.optString("userName");
            user.put("userName", (Object)userName);
            String userPassword = requestJSONObject.optString("userPassword");
            user.put("userPassword", (Object)MD5.hash((String)userPassword));
            String userURL = requestJSONObject.optString("userURL");
            if (Strings.isEmptyOrNull((String)userURL)) {
                userURL = Latkes.getServePath();
            }
            if (!Strings.isURL((String)userURL)) {
                throw new ServiceException(this.langPropsService.get("urlInvalidLabel"));
            }
            user.put("userURL", (Object)userURL);
            String roleName = requestJSONObject.optString("userRole", "defaultRole");
            user.put("userRole", (Object)roleName);
            user.put("userArticleCount", 0);
            user.put("userPublishedArticleCount", 0);
            this.userRepository.add(user);
            transaction.commit();
            return user.optString(Keys.OBJECT_ID);
        }
        catch (RepositoryException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Adds a user failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void removeUser(String userId) throws ServiceException {
        Transaction transaction = this.userRepository.beginTransaction();
        try {
            this.userRepository.remove(userId);
            transaction.commit();
        }
        catch (RepositoryException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Removes a user[id=" + userId + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void setLangPropsService(LangPropsService langPropsService) {
        this.langPropsService = langPropsService;
    }
}

