/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.solo.service;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.service.ServiceException;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.user.GeneralUser;
import org.b3log.latke.user.UserService;
import org.b3log.latke.user.UserServiceFactory;
import org.b3log.latke.util.Paginator;
import org.b3log.solo.repository.UserRepository;
import org.b3log.solo.service.UserMgmtService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Service
public class UserQueryService {
    private static final Logger LOGGER = Logger.getLogger((String)UserQueryService.class.getName());
    private UserService userService = UserServiceFactory.getUserService();
    @Inject
    private UserRepository userRepository;
    @Inject
    private UserMgmtService userMgmtService;

    public boolean hasMultipleUsers() throws ServiceException {
        Query query = new Query().setPageCount(1);
        try {
            JSONArray users = this.userRepository.get(query).getJSONArray("rslts");
            return 1 != users.length();
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Determines multiple users failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, "Determines multiple users failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public boolean isLoggedIn(HttpServletRequest request, HttpServletResponse response) {
        this.userMgmtService.tryLogInWithCookie(request, response);
        GeneralUser currentUser = this.userService.getCurrentUser(request);
        return null != currentUser;
    }

    public boolean isAdminLoggedIn(HttpServletRequest request) {
        return this.userService.isUserLoggedIn(request) && this.userService.isUserAdmin(request);
    }

    public JSONObject getCurrentUser(HttpServletRequest request) {
        GeneralUser currentUser = this.userService.getCurrentUser(request);
        if (null == currentUser) {
            return null;
        }
        String email = currentUser.getEmail();
        try {
            return this.userRepository.getByEmail(email);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets current user by request failed, returns null", (Throwable)e);
            return null;
        }
    }

    public JSONObject getAdmin() throws ServiceException {
        try {
            return this.userRepository.getAdmin();
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets admin failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getUserByEmail(String email) throws ServiceException {
        try {
            return this.userRepository.getByEmail(email);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets user by email[" + email + "] failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public JSONObject getUsers(JSONObject requestJSONObject) throws ServiceException {
        JSONObject ret = new JSONObject();
        int currentPageNum = requestJSONObject.optInt("paginationCurrentPageNum");
        int pageSize = requestJSONObject.optInt("paginationPageSize");
        int windowSize = requestJSONObject.optInt("paginationWindowSize");
        Query query = new Query().setCurrentPageNum(currentPageNum).setPageSize(pageSize);
        JSONObject result = null;
        try {
            result = this.userRepository.get(query);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets users failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        int pageCount = result.optJSONObject("pagination").optInt("paginationPageCount");
        JSONObject pagination = new JSONObject();
        ret.put("pagination", (Object)pagination);
        List pageNums = Paginator.paginate((int)currentPageNum, (int)pageSize, (int)pageCount, (int)windowSize);
        pagination.put("paginationPageCount", pageCount);
        pagination.put("paginationPageNums", (Collection)pageNums);
        JSONArray users = result.optJSONArray("rslts");
        ret.put("users", (Object)users);
        return ret;
    }

    public JSONObject getUser(String userId) throws ServiceException {
        JSONObject ret = new JSONObject();
        JSONObject user = null;
        try {
            user = this.userRepository.get(userId);
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.ERROR, "Gets a user failed", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        if (null == user) {
            return null;
        }
        ret.put("user", (Object)user);
        return ret;
    }

    public String getLogoutURL() {
        return this.userService.createLogoutURL("/");
    }

    public String getLoginURL(String redirectURL) {
        return this.userService.createLoginURL(redirectURL);
    }

    public void setUserMgmtService(UserMgmtService userMgmtService) {
        this.userMgmtService = userMgmtService;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

