CREATE DATABASE /*!32312 IF NOT EXISTS*/`infocomshop` /*!40100 DEFAULT CHARACTER SET gb2312 */;

USE `infocomshop`;

/*Table structure for table `admin` */

DROP TABLE IF EXISTS `admin`;

CREATE TABLE `admin` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `adminname` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=gb2312;

/*Data for the table `admin` */

insert  into `admin`(`Id`,`adminname`,`password`) values (1,'admin','12345678');

/*Table structure for table `bigtype` */

DROP TABLE IF EXISTS `bigtype`;

CREATE TABLE `bigtype` (
  `bigtypeid` int(11) NOT NULL AUTO_INCREMENT,
  `bigtypename` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`bigtypeid`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=gb2312;

/*Data for the table `bigtype` */

insert  into `bigtype`(`bigtypeid`,`bigtypename`) values (1,'通信'),(2,'电视'),(3,'音箱'),(4,'食品'),(5,'服装'),(6,'袜子'),(7,'鞋'),(8,'皮具'),(9,'电脑'),(10,'数码'),(11,'汽车'),(12,'房地产'),(13,'家具'),(14,'书籍');

/*Table structure for table `news` */

DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `newstype` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `content` text,
  `cc` varchar(255) DEFAULT NULL,
  `publicdatetime` datetime DEFAULT NULL,
  `visit` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=gb2312;

/*Data for the table `news` */

insert  into `news`(`Id`,`title`,`author`,`newstype`,`pic`,`content`,`cc`,`publicdatetime`,`visit`) values (18,'马云：收购雅虎的200多亿美元早就做了准备','崔西 云芳','行业新闻','U5009P2T1D6189106F13DT20111017173256.jpg ','&nbsp;&nbsp;&nbsp;&nbsp; 新浪科技讯 10月17日下午消息，马云(微博)在今日举行的淘宝商城媒体恳谈会上表示，阿里巴巴(微博)早就为收购雅虎的200多亿美金做了准备。此次淘宝商城新规提高服务费并非是为了圈钱买雅虎。<BR>　　“我们是互联网公司中现金储备最多的公司，我们为200多亿美金早就做了准备。”专程从美国赶回来的马云在媒体恳谈会上在解释淘宝遭围攻事件时一并谈到了收购雅虎的传闻。<BR>　　马云表示，外界认为淘宝新规是为收购雅虎“圈钱”的说法并不确切。阿里巴巴早就开始准备收购需要的200多亿美金。随后有提问问到阿里是否确认要竞购雅虎，马云回应说：“我只能告诉你，钱我们早筹备了，其他的还真不能说。”<BR>　　面对媒体对此事的追问，马云在现场再三表示涉及雅虎的事情不好表态，希望大家理解。他表示雅虎对阿里巴巴很重要，自己对雅虎的兴趣也没有改变过。“如果能做什么，我们当然希望做，今天不能讲怎么做，以后会给大家讲讲怎么做。”<BR>　　现场的一个细节是，马云来参会前在手上写了四五个“忍”字，在回答雅虎这个问题前他看了看手上的这些“忍”字。','新浪科技','2011-10-19 13:57:09',NULL),(28,'2011年中国网购奢侈品市场规模达107亿元','','行业新闻','1323844853405.gif ','&nbsp;\r\n<P>【TechWeb报道】12月14日消息，艾瑞咨询近期推出2011年中国奢侈品网络购物行业研究报告》，针对中国奢侈品网络购物市场现状深入探讨。报告研究数据显示，中国内地2010年奢侈品网络购物交易规模（C2C部分与B2C部分合计）为63.6亿元，2011年交易规模预计将达107.3亿元，实现68.8%的年增长。艾瑞同时预计2015年中国网购奢侈品交易规模或将达到372.4亿元。</P>\r\n<P style=\"TEXT-ALIGN: center\">艾瑞还在报告中介绍道，根据我国网络购物市场交易规模核算，奢侈品品类占网络购物交易规模的比例均保持在1-2%之内，其2010年占比为1.38%，预计2011年其占比为1.41%。从奢侈品网络购物交易规模占国内奢侈品交易规模的比例来看，2010年其渗透率为3.16%，2011年渗透率将达到4.37%，预计2015年奢侈品网购占比将达到8.03%。</P>','TechWeb.com.cn ','2011-12-14 22:14:57',NULL),(29,'2011年电商行业盘点：交易规模将超7500亿元','乐天','行业新闻','img20111213236712450.jpg ','&nbsp;\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>腾讯科技讯</STRONG>（乐天）12月12日消息，艾瑞分析师丁佳琪、张晶近日发布报告，预计2011年网购市场交易规模超7500亿元。第四季度为网络购物高峰期，环比增速将超过15.0%，其中国庆节、双十一光棍节、以及圣诞节、元旦春节等节日气氛促进网络购物高速增长。</P>\r\n<P style=\"TEXT-INDENT: 2em\">2011年网络购物行业延续了2010年高速发展的势头，前三季度同比增速保持在70%以上，同时呈现多个特点。资本方面，行业经历了先热后冷的过程，从2011年下半年开始，部分B2C企业遇到资金吃紧或IPO受阻等困难；</P>\r\n<P style=\"TEXT-INDENT: 2em\">企业经营方面，各类型网购企业纷纷加速横向业务扩展和纵向供应链建设，增强核心竞争力；与此同时，传统企业开展电子商务成为大势，明确业务定位是其成败关键；各大领先电商企业纷纷推出手机客户端，布局手机购物市场；</P>\r\n<P style=\"TEXT-INDENT: 2em\">此外，网络购物跨越式发展，使得消费者权益保护成为一大问题，消费者维权成热点。展望2012年，中国网络购物行业将进一步成熟，精细化、规范化和规模化将是主要特色。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>盘点一：资本市场前热后冷，部分企业资金压力增大</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件一：上半年融资事件频发，下半年投融资笔数减少</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">2011年上半年，除京东商城外，诸多细分领域的电商企业获得融资。鞋类领域，1月份乐淘网宣布获得2亿元融资，3月份，好乐买获得6000万美元。天天网、聚美优品、米奇网等化妆品类、米兰网、聚尚网、尊库网等时尚奢侈品网站及麦包包、七格格、绿盒子、斯波帝卡等淘品牌纷纷获得注资。从7月份开始，下半年网络购物领域的融资事件，相较上半年，有所减少。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件二：海外上市遇冷，多家企业IPO计划延期</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">2011年中国企业境外IPO遭冷遇，一些综合B2C、垂直B2C和团购网站均传出海外上市的计划或意愿，但截止11月下旬仍没有一家新电商企业成功上市。典型的企业为拉手网，2010-2011年总共融资1.66亿美元，累计亏损人民币4.7亿元，今年10月底，正式启动赴美上市计划，计划通过IPO融资1亿美元，但因各种缘由，目前已停止IPO计划。同样，凡客诚品赴美上市的消息一直没有间断过，直至11月20日凡客诚品并未如期上市。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件三：电商企业倒闭，市场渐现洗牌潮</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">2011年部分电商企业因战略定位、运营不善而出现倒闭或转型。一类是传统企业，如美邦服饰剥离邦购网至其母公司上海华服投资有限公司。第二类是团购企业，后半年出现较多裁员、撤站、降薪事件，如长沙本土团购网站搜团网、厦门本土团购网站E团网等地方网站陆续关闭；全国性团购网站24券淮安站关闭，窝窝团整体裁员约500人，将目前35个5线城市由完整的10-20人团队配置，缩减至2-3人。三是部分垂直B2C，如大货栈、西米网、淘鹊网、爱挑食网、七十二变零食网等不堪高额运营成本的压力而倒闭或转型。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>艾瑞点评</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">电子商务行业融资环境的变化，主要原因有二：一是中概股企业诚信问题以及政府对VIE协议态度不明朗的影响，加大了海外风险基金投资国内电商企业的整体风险；二是过去一年中，电子商务行业融资过热，形成一定的泡沫，目前资本方面进入调整期，投资有所缩减。</P>\r\n<P style=\"TEXT-INDENT: 2em\">发展方向：考虑到行业的增长潜力，未来电子商务行业仍将是互联网领域中资本投资的重点，并且电商领域投资热点将转向创新模式、垂直品类及配套服务等细分领域，如11月刚获得融资的购物分享社区美丽说、礼品类的唯礼网等。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>盘点二：网络购物企业通过横向拓展与纵向供应链建设</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件一：巨头投资加大，电商企业横向扩展业务范围</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">一方面京东商城、亚马逊中国、当当网、苏宁易购等综合商城纷纷拓充网站商品品类。2011年京东商城新进入图书、医药、奢侈品等领域；亚马逊中国、当当网开放平台，持续推进百货化；苏宁易购也从主营家电数码向图书、百货拓展。</P>\r\n<P style=\"TEXT-INDENT: 2em\">另一方面，部分垂直B2C网站也开始加速品类扩充。2月B2C购物网站红孩子推出缤购网，专营化妆、食品、保健、家居等商品品类；8月意大利品牌Redsand（红砂）入驻好乐买，好乐买也从以运动品牌为主，向休闲、户外、女鞋、男鞋品牌的扩展；10月优购网高管先后表示，优购网定位渠道品牌，未来将引进更多商品品类和品牌。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件二：电商企业纵向加速供应链整合</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">2011年5月，<SPAN class=infoMblog>阿里巴巴集团</SPAN>与交通银行全面达成战略合作，双方将在快捷支付、手机支付、中小企业网络融资等众多方面开展合作。6月，阿里巴巴集团与广发银行签署全面战略合作协议，加强在快捷支付、联名卡、中小企业金融合作等领域的深入合作。</P>\r\n<P style=\"TEXT-INDENT: 2em\">2011年1月，阿里巴巴集团在北京发布物流战略，通过“物流宝”平台大力推进物流信息管理系统，由集团层面主导、投入100亿元的资金着手兴建全国性仓储网络平台。京东正在建设6个亚洲一号仓库，预计2012年将在350个城市实现自建物流配送，未来两年内实现35个城市“211限时达”。此外，10月当当网启动百城战略，全国普及次日达、刷卡付费；11月麦考林1000多个城市实现货到付款，上门退货退现金。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件三：网络购物领域价格战频频上演</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">2011年网络购物市场价格战不断。先是2011年初，京东商城上线图书，掀起京东商城、当当网与卓越亚马逊三方的多轮图书价格战；之后3C类购物网站又启动另一轮价格战，尤其十一期间，京东商城、当当网、苏宁易购、国美(<SPAN class=infoMblog>微博</SPAN>)库巴、亚马逊等纷纷加入其中。此外，双十一光棍节，淘宝商城、京东商城等均上演大规模促销。目前各家正为随后的圣诞节、元旦春节策划营销活动。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>艾瑞点评</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">市场格局：中国网络购物行业经过十几年的发展，尚处于战国时代，市场格局仍有很大变数。考虑到中国多数消费者仍为价格敏感型用户，价格战成为网络购物企业获取用户的重要利器。</P>\r\n<P style=\"TEXT-INDENT: 2em\">发展方向：网络购物企业若想占据市场领先地位并且培养核心竞争力，拓展产品品类、丰富产品线与加强供应链、完善物流配送体系将是企业发展的重要方向。艾瑞咨询预计，上述现象仍将是未来三年中国网络购物行业发展的重要特征。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>盘点三：传统企业进一步发力电商，明确业务定位是关键</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件一：传统企业全网分销业务发展迅猛</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">传统企业通过制定合理的全网营销战略，线上销售的水平屡创新高。来自淘宝的数据，2011年，仅在淘宝分销平台上进行分销的供应商或品牌商达8.1万家，入驻的分销商达130万家，参与分销的品牌商中传统企业占据重要份额，典型的企业有波司登、艾美特、Thinkpad、帮宝适、博洋家纺、澳优、TCL、惠氏、格兰仕等。</P>\r\n<P style=\"TEXT-INDENT: 2em\">此外，传统企业的网络旗舰店在2011年体现出极强的实力。2011年淘宝双十一光棍节促销当天，传统企业旗舰店GXG、骆驼服饰、博洋家纺三家的销量超过4000万，杰克琼斯的销量突破3000万，富安娜、真维斯、水星家纺三家突破2000万。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件二：传统企业自建网站收效甚微</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">近年来，随着苏宁易购网正式上线，银泰集团推出银泰网，国美收购库巴网（原世纪电器网）80%股份，富士康推出飞虎乐购，中国邮政推出邮乐网，中粮集团创立我买网等，百丽新推优购网，国内大型传统企业纷纷进入电子商务市场。</P>\r\n<P style=\"TEXT-INDENT: 2em\">目前，以苏宁易购为代表的传统企业发展较为平稳，连续3个季度销售额均超过10亿元，跻身中国B2C网络购物市场前五。同时，部分传统企业电商平台发展远低于预期，其中邦购网被剥离，飞虎乐购拟剥离百货业务，李宁、九阳等传统企业电子商务负责人纷纷离职，种种迹象表明传统企业涉水电商市场并非易事。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>艾瑞点评</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">发展状况：传统企业已普遍意识到电子商务的发展机遇，积极尝试线上业务；但是对于电子商务业务的定位，各家略有差异。多数企业将电子商务作为其一个新销售渠道，依靠淘宝此类平台，构建线上分销渠道。部分企业则将电子商务作为一个新机会，尝试构建自营的线上零售渠道。总结目前中国传统企业电子商务业务的发展状况，艾瑞咨询发现，依靠平台发展的模式整体发展状况好于自营线上零售渠道的模式的发展状况。</P>\r\n<P style=\"TEXT-INDENT: 2em\">发展方向：艾瑞咨询认为，传统企业开展电子商务业务已成大势。传统企业做电商核心优势在于货源，如何合理定位线上业务，并配以恰当的运营策略及时满足消费者需求，是传统企业在未来电子商务发展中首要解决的问题。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>盘点四：移动电商崭露头角</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件一：电商企业纷纷推出客户端</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">随着移动互联网用户规模的快速增长以及网民上网习惯的转变，电商企业开始布局移动互联网市场。今年2月京东商城iPhone客户端上线；2月凡客诚品全面支持手机购物，并在3月推出手机秒杀活动；4月手机淘宝开放平台，构建移动互联网盈利基础平台；5月麦考林继苹果客户端后再推安卓客户端。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件二：手机购物行业仍处于发展初期</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">各家企业推出手机购物初见成效，凡客诚品每天来自手机平台的成交量在1.5万单左右；当当网每天来自移动客户端的下单量已经超过7000单；乐淘客户端下载激活量共计160万，占比6.5%，仅次于凡客；6月京东商城手机下单日交易额已达200万；淘宝移动电商上半年收入为45亿元，而双十一当天，淘宝商城手机版交易额突破1.5亿元。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>艾瑞点评</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">发展阶段：艾瑞最新数据显示，2011Q3手机电子商务（C2C和B2C网购部分）交易规模为37.7亿元，同比增长508.1%，继续保持迅猛的发展态势。同时，2011Q3中国网络购物（不含手机端）市场规模达到1975.1亿元，相比之下，手机购物仍处于发展初期。</P>\r\n<P style=\"TEXT-INDENT: 2em\">增长原因：随着智能手机的普及，移动近程通讯技术（包括NFC、RFID等）的应用，手机上网用户规模的增加，以及各大电商企业的积极推动，中国用户的移动购物习惯正逐步养成，移动互联网、移动电商正逐步成为网络购物生态系统中的重要环节。</P>\r\n<P style=\"TEXT-INDENT: 2em\">发展瓶颈：移动电商实时性、便捷性、区域性等优势逐步显现，目前移动电商发展主要受制于手机购物用户规模较小、手机支付及网络环境（带宽、资费等）不完善。未来移动电商将逐步消除以上制约因素，保持高增长态势。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>盘点五：网上消费投诉多，消费者维权成热点 </STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>相关事件：网络购物投诉多</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">网络购物市场发展快速，尤其团购市场从去年开始到今年上半年得到了飞跃式的发展，其中也伴随不少问题。截止2011年10月初，福州市工商局已受理团购相关申诉141件，较去年同期的7件增长20倍。同时，五一、十一黄金周期间的网络消费投诉增长显著，北京市2011年十一期间共受理网上购物消费投诉1204件，占整体投诉量的40.8%。</P>\r\n<P style=\"TEXT-INDENT: 2em\"><STRONG>艾瑞点评</STRONG></P>\r\n<P style=\"TEXT-INDENT: 2em\">这些现象出现，并且维权较为困难，主要原因有如下三类：一是网上交易自身特点，消费者容易遇到钓鱼网站和个人信息泄露等情况，并且购物欺骗相关事件发生后难以追溯犯罪源；二是国内网站仍处于高速发展期，现阶段物流配送等基础服务仍有欠缺，尤其在节假日和大型促销活动时凸显；三是网购政策空白多，如打折前提价、产品与网站描述不符等问题频现，对于企业缺乏相应监管措施和能力。</P>\r\n<P style=\"TEXT-INDENT: 2em\">解决措施：第一类问题需要政府、行业协会及相关企业加大宣传力度，增强消费者网购安全意识，从用户角度进行有效规避；第二类问题需要网络购物产业链各参与者加强自身建设，提高服务能力，以此提升消费者购物满意度；第三类问题需要政府相关部门、电商行业协会和各大电商企业的共同重视和努力，从商家信誉认证和货源渠道公开等方面入手，为消费者提供一个规范、可信的网上消费环境。</P>','腾讯科技讯','2011-12-14 22:17:21',NULL);

/*Table structure for table `order` */

DROP TABLE IF EXISTS `order`;

CREATE TABLE `order` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `username` char(50) DEFAULT NULL,
  `productid` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `totalprice` decimal(10,2) DEFAULT NULL,
  `payment` varchar(255) DEFAULT NULL,
  `postway` varchar(255) DEFAULT NULL,
  `orderdatetime` datetime DEFAULT NULL,
  `ifpay` int(3) DEFAULT NULL,
  `ifsent` int(3) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=114 DEFAULT CHARSET=gb2312;

/*Data for the table `order` */

insert  into `order`(`Id`,`username`,`productid`,`quantity`,`totalprice`,`payment`,`postway`,`orderdatetime`,`ifpay`,`ifsent`) values (97,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:38',NULL,NULL),(98,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:38',NULL,NULL),(99,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:38',NULL,NULL),(100,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:38',NULL,NULL),(101,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:38',NULL,NULL),(102,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:39',NULL,NULL),(103,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:39',NULL,NULL),(104,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:39',NULL,NULL),(105,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:32:39',NULL,NULL),(106,'sglg',26,1,50.00,'银行转账','平邮','2011-06-12 01:49:11',NULL,NULL),(107,'sglg',26,1,50.00,'银行转账','平邮','2011-06-27 22:08:55',NULL,NULL),(108,'sglg',27,1,60.00,'银行转账','平邮','2011-06-27 22:09:01',NULL,NULL),(109,'sglg',26,1,50.00,'银行转账','平邮','2011-08-18 00:35:47',NULL,NULL),(110,'sglg',30,1,2.50,'银行转账','平邮','2011-12-14 10:32:10',NULL,NULL),(111,'sglg',64,1,70000.00,'网上银行','平邮','2013-06-27 06:24:50',NULL,NULL),(112,'sglg',63,1,999.00,'网上银行','平邮','2013-06-27 06:24:50',NULL,NULL),(113,'',64,1,70000.00,'网上银行','快递EMS','2013-07-13 18:13:37',NULL,NULL);

/*Table structure for table `products` */

DROP TABLE IF EXISTS `products`;

CREATE TABLE `products` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `productname` varchar(255) DEFAULT NULL,
  `bigcategory` varchar(255) DEFAULT NULL,
  `smallcategory` varchar(255) DEFAULT NULL,
  `pic` blob,
  `price` decimal(10,2) DEFAULT NULL,
  `introduce` text,
  `regdatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=gb2312;

/*Data for the table `products` */

insert  into `products`(`Id`,`productname`,`bigcategory`,`smallcategory`,`pic`,`price`,`introduce`,`regdatetime`) values (57,'夏普 LCD-40LX330A','电视','液晶电视','3.jpg',4999.00,'&nbsp;\r\n<TABLE style=\"MARGIN: auto; TABLE-LAYOUT: fixed; COLOR: #333; FONT-SIZE: 12px\" id=Jtable class=tbWrap border=0 cellSpacing=0 cellPadding=0 width=740>\r\n<THEAD>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: medium none; BORDER-LEFT: #d4eaff 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 10px; BACKGROUND: #d4eaff; VERTICAL-ALIGN: middle; BORDER-TOP: #d4eaff 1px solid; BORDER-RIGHT: #d4eaff 1px solid; PADDING-TOP: 6px\">\r\n<TABLE border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD align=left><STRONG style=\"LINE-HEIGHT: 16px; FONT-SIZE: 14px\">夏普 LCD-40LX330A 详细参数</STRONG></TD>\r\n<TD width=165>查看：<A style=\"FONT-WEIGHT: 400\" href=\"http://product.pconline.com.cn/lcd_tv/sharp/485837_detail.html\"><FONT color=#0055aa>更多信息</FONT></A> | <A style=\"FONT-WEIGHT: 400\" href=\"http://product.pconline.com.cn/pdlib/485837_picture.html\"><FONT color=#0055aa>产品图片</FONT></A></TD></TR></TBODY></TABLE></TD></TR></THEAD>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 5px; PADDING-LEFT: 10px; PADDING-RIGHT: 0px; BORDER-TOP: #9cbfe5 1px solid; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 10px\"><A title=屏幕尺寸：40 href=\"http://k.pconline.com.cn/question/2685065.html\" target=_blank><FONT color=#0055aa><IMG style=\"PADDING-BOTTOM: 4px; PADDING-LEFT: 0px; PADDING-RIGHT: 4px; PADDING-TOP: 0px\" alt=尺寸 src=\"http://img.pconline.com.cn/images/product/20112/28/12988891865635570.jpg\" width=36 height=36> </FONT></A><A title=屏幕比例：16:9 href=\"http://k.pconline.com.cn/question/1172.html\" target=_blank><FONT color=#0055aa><IMG style=\"PADDING-BOTTOM: 4px; PADDING-LEFT: 0px; PADDING-RIGHT: 4px; PADDING-TOP: 0px\" alt=屏幕 src=\"http://img.pconline.com.cn/images/product/20112/24/12985307829863250.png\" width=36 height=36> </FONT></A><A title=屏幕分辨率：1920×1080 href=\"http://k.pconline.com.cn/question/1512.html\" target=_blank><FONT color=#0055aa><IMG style=\"PADDING-BOTTOM: 4px; PADDING-LEFT: 0px; PADDING-RIGHT: 4px; PADDING-TOP: 0px\" alt=分辨率 src=\"http://img.pconline.com.cn/images/product/20112/28/12988896502723250.jpg\" width=36 height=36> </FONT></A><A title=高清格式：1080p href=\"http://k.pconline.com.cn/question/2612.html\" target=_blank><FONT color=#0055aa><IMG style=\"PADDING-BOTTOM: 4px; PADDING-LEFT: 0px; PADDING-RIGHT: 4px; PADDING-TOP: 0px\" alt=1080P src=\"http://img.pconline.com.cn/images/product/20112/24/12985303130024680.png\" width=36 height=36> </FONT></A><FONT color=#0055aa><IMG style=\"PADDING-BOTTOM: 4px; PADDING-LEFT: 0px; PADDING-RIGHT: 4px; PADDING-TOP: 0px\" alt=面板 src=\"http://img.pconline.com.cn/images/product/20112/28/12988894873421560.jpg\" width=36 height=36></FONT> <A title=背光性能：LED背光源 href=\"http://k.pconline.com.cn/question/2685459.html\" target=_blank><IMG style=\"PADDING-BOTTOM: 4px; PADDING-LEFT: 0px; PADDING-RIGHT: 4px; PADDING-TOP: 0px\" alt=背光 src=\"http://img.pconline.com.cn/images/product/20112/28/12988897597803000.jpg\" width=36 height=36><FONT color=#0055aa> </FONT></A><A title=输入端口：HDMI接口 href=\"http://k.pconline.com.cn/question/2685470.html\" target=_blank><FONT color=#0055aa><IMG style=\"PADDING-BOTTOM: 4px; PADDING-LEFT: 0px; PADDING-RIGHT: 4px; PADDING-TOP: 0px\" alt=HDMI src=\"http://img.pconline.com.cn/images/product/20112/24/12985322204140180.png\" width=36 height=36> </FONT></A></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; TEXT-ALIGN: left; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 15px; BACKGROUND: #d4eaff; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 6px\"><STRONG>基本参数</STRONG></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; BORDER-LEFT: #9cbfe5 1px solid; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid\">\r\n<TABLE style=\"BORDER-SPACING: 0\" class=param border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>型号</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">LCD-40LX330A</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>特色分类</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">LED电视,全高清电视</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>屏幕尺寸</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">40英寸</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>屏幕比例</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">16:9</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>屏幕分辨率</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">1920×1080</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>高清格式</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">1080p</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>面板类型</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">VA面板</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: medium none; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>最佳观看距离</TD>\r\n<TD style=\"BORDER-BOTTOM: medium none; PADDING-LEFT: 10px\">1.8-2.5米</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; TEXT-ALIGN: left; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 15px; BACKGROUND: #d4eaff; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 6px\"><STRONG>图像参数</STRONG></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; BORDER-LEFT: #9cbfe5 1px solid; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid\">\r\n<TABLE style=\"BORDER-SPACING: 0\" class=param border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>背光性能</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">LED背光源</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: medium none; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>USB流媒体</TD>\r\n<TD style=\"BORDER-BOTTOM: medium none; PADDING-LEFT: 10px\">支持，USB支持移动硬盘容量：可接USB支持视频格式：AVI/MPEG/MP4USB支持音频格式：MP3,USB支持图片格式：JPEG </TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; TEXT-ALIGN: left; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 15px; BACKGROUND: #d4eaff; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 6px\"><STRONG>音效性能</STRONG></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; BORDER-LEFT: #9cbfe5 1px solid; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid\">\r\n<TABLE style=\"BORDER-SPACING: 0\" class=param border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>扬声器</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">2个</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: medium none; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>声音输出功率</TD>\r\n<TD style=\"BORDER-BOTTOM: medium none; PADDING-LEFT: 10px\">10W+10W</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; TEXT-ALIGN: left; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 15px; BACKGROUND: #d4eaff; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 6px\"><STRONG>功能参数</STRONG></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; BORDER-LEFT: #9cbfe5 1px solid; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid\">\r\n<TABLE style=\"BORDER-SPACING: 0\" class=param border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; TEXT-ALIGN: left; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 15px; BACKGROUND: #d4eaff; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 6px\"><STRONG>输入输出</STRONG></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; BORDER-LEFT: #9cbfe5 1px solid; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid\">\r\n<TABLE style=\"BORDER-SPACING: 0\" class=param border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>输入端口</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">HDMI接口,分量视频接口,TV输入,USB接口</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>HDMI接口</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">1组</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>TV端子</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">1组</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>色差分量端子</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">1组</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>USB接口</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">1组</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: medium none; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>其他接口类型</TD>\r\n<TD style=\"BORDER-BOTTOM: medium none; PADDING-LEFT: 10px\">网线接口</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; TEXT-ALIGN: left; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 15px; BACKGROUND: #d4eaff; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 6px\"><STRONG>外观参数</STRONG></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; BORDER-LEFT: #9cbfe5 1px solid; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid\">\r\n<TABLE style=\"BORDER-SPACING: 0\" class=param border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>机身尺寸</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">含底座:958×637×290mm,不含底座:958×595×55mm</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: medium none; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>重量</TD>\r\n<TD style=\"BORDER-BOTTOM: medium none; PADDING-LEFT: 10px\">含底座:13.5kg,不含底座:12.5kg</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; TEXT-ALIGN: left; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 15px; BACKGROUND: #d4eaff; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 6px\"><STRONG>其他参数</STRONG></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; BORDER-LEFT: #9cbfe5 1px solid; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid\">\r\n<TABLE style=\"BORDER-SPACING: 0\" class=param border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>电源要求</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">220V</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>功耗</TD>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px dotted; PADDING-LEFT: 10px\">95W</TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: medium none; TEXT-ALIGN: center; BORDER-LEFT: medium none; PADDING-BOTTOM: 7px; ZOOM: 1.0001; BACKGROUND: #f2f9ff; COLOR: #777; VERTICAL-ALIGN: middle; BORDER-TOP: medium none; FONT-WEIGHT: 400; BORDER-RIGHT: #9cbfe5 1px dotted; PADDING-TOP: 6px\" width=110>休眠功耗</TD>\r\n<TD style=\"BORDER-BOTTOM: medium none; PADDING-LEFT: 10px\">0.5W</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD style=\"BORDER-BOTTOM: #9cbfe5 1px solid; TEXT-ALIGN: right; BORDER-LEFT: #9cbfe5 1px solid; PADDING-BOTTOM: 7px; PADDING-LEFT: 9px; PADDING-RIGHT: 9px; BACKGROUND: #f2f9ff; COLOR: #777; BORDER-TOP: medium none; BORDER-RIGHT: #9cbfe5 1px solid; PADDING-TOP: 7px\" class=btm>数据来源：<A href=\"http://www.pconline.com.cn/\" target=_blank><FONT color=#0055aa>太平洋电脑网</FONT></A>&nbsp;<A href=\"http://product.pconline.com.cn/\" target=_blank><FONT color=#0055aa>产品报价 (product.pconline.com.cn)</FONT></A></TD></TR></TBODY></TABLE>','2011-12-25 23:16:26'),(58,'2011新款冬装羽绒服 男 可脱卸帽男士保暖加厚羽绒服 正品 90%绒 黑色 XXL','服装','羽绒服','8fc325d1-1310-4572-b64d-0fe04a88266b.jpg ',399.00,'<FONT color=#000000><FONT style=\"BACKGROUND-COLOR: #ffffff\">\r\n<P><FONT color=#000000><FONT style=\"BACKGROUND-COLOR: #ffffff\">&nbsp;<SPAN style=\"FONT-SIZE: medium\"><FONT size=3><SPAN style=\"COLOR: #003366\">这是一款极品短款羽绒外套，是采用填充物为膨松度800的高压缩鸭绒，非常的轻盈，保暖性能极佳，且里面的鸭绒不是那种随便的普通的鸭毛。不好的羽绒服都用鸭背部的羽毛，加工较简单，而且背部的毛是有硬梗的，所以摸上去都会有硬刷刷的感觉，柔软度也不是特别好！因为此款羽绒服梗毛相对较少，羽翼相对细密，柔软舒适，羽绒服外表纯棉涂层材质，加上今年流行的亚光质感</SPAN><SPAN style=\"COLOR: #6600cc\">（含绒量90%）。</SPAN></FONT></SPAN></FONT></FONT></P>\r\n<P></FONT></FONT>&nbsp;</P>','2011-12-25 23:45:00'),(59,'苹果iPhone 4（8GB）','通信产品','手机','celN293jBrBiQ.jpg ',4300.00,'&nbsp;\r\n<DIV style=\"BORDER-BOTTOM: #aac4e5 1px solid; BORDER-LEFT: #aac4e5 1px solid; LINE-HEIGHT: 26px; BACKGROUND-COLOR: #aac4e5; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px auto; WIDTH: 560px; FONT-SIZE: 14px; OVERFLOW: hidden; BORDER-TOP: #aac4e5 1px solid; FONT-WEIGHT: normal; BORDER-RIGHT: #aac4e5 1px solid\" id=layoutTab>\r\n<TABLE style=\"BORDER-BOTTOM: #aac4e5 2px solid; BORDER-LEFT: #aac4e5 2px solid; COLOR: #333; FONT-SIZE: 12px; BORDER-TOP: #aac4e5 2px solid; BORDER-RIGHT: #aac4e5 2px solid\" cellSpacing=1 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD bgColor=#ffffff colSpan=2>\r\n<TABLE style=\"BORDER-COLLAPSE: collapse\" border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR style=\"PADDING-BOTTOM: 14px; PADDING-LEFT: 14px; PADDING-RIGHT: 14px; PADDING-TOP: 14px\">\r\n<TD>\r\n<H3 style=\"PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; FONT-SIZE: 14px; FONT-WEIGHT: bold; PADDING-TOP: 0px\">苹果iPhone 4（8GB）</H3>\r\n<H4 style=\"PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; COLOR: #999; FONT-SIZE: 18px; FONT-WEIGHT: bold; PADDING-TOP: 0px\">参数规格</H4></TD>\r\n<TD style=\"PADDING-BOTTOM: 10px; PADDING-LEFT: 10px; PADDING-RIGHT: 10px; FONT-SIZE: 12px; PADDING-TOP: 10px\" vAlign=bottom align=right>查看： <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"\">更多信息</A> 或 <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"\">更多图片</A> </TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>基本参数</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>上市日期</SPAN></TD>\r\n<TD>2011年</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>手机类型</SPAN></TD>\r\n<TD>3G手机，智能手机，音乐手机</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>外观设计</SPAN></TD>\r\n<TD>直板</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>主屏尺寸</SPAN></TD>\r\n<TD>3.5英寸</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>触摸屏</SPAN></TD>\r\n<TD>电容屏，多点触控</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>主屏材质</SPAN></TD>\r\n<TD>IPS</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>主屏分辨率</SPAN></TD>\r\n<TD>640x960像素</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>网络模式</SPAN></TD>\r\n<TD>GSM，WCDMA</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>数据业务</SPAN></TD>\r\n<TD>GPRS，EDGE，HSPA</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>支持频段</SPAN></TD>\r\n<TD>2G：GSM 800/850/900/1800/1900<BR>3G：WCDMA 850/900/1900/2100MHz</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>操作系统</SPAN></TD>\r\n<TD>iOS 4.0</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>CPU型号</SPAN></TD>\r\n<TD>苹果 A4</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>CPU频率</SPAN></TD>\r\n<TD>1024MHz</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>GPU型号</SPAN></TD>\r\n<TD>Imagination PowerVR SGX535</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>可用空间</SPAN></TD>\r\n<TD>8GB</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>理论通话时间</SPAN></TD>\r\n<TD>840分钟（2G），420分钟（3G）</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>理论待机时间</SPAN></TD>\r\n<TD>300小时</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>其它使用时间</SPAN></TD>\r\n<TD>3G网络时间：6小时<BR>WLAN网络时间：10小时<BR>音乐播放时间：40小时<BR>视频播放时间：10小时</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>键盘类型</SPAN></TD>\r\n<TD>虚拟QWERTY键盘</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>机身颜色</SPAN></TD>\r\n<TD>黑色，白色</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>手机尺寸</SPAN></TD>\r\n<TD>115.2x58.6x9.3mm</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>手机重量</SPAN></TD>\r\n<TD>137g</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>机身特点</SPAN></TD>\r\n<TD>屏幕采用Retina显示技术；Multi-Touch 触控宽屏幕 ，正反面采用防油渍防指纹外膜，支持多种语言文字同时显示<BR>双麦克风设计，有助于降噪；<BR>机身周边的固定框被设计为了iPhone4的天线</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>基本功能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>输入法</SPAN></TD>\r\n<TD>中文输入法，英文输入法，第三方输入法</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>输入方式</SPAN></TD>\r\n<TD>手写</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>通话记录</SPAN></TD>\r\n<TD>已接+已拨+未接电话</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px\">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>短信(SMS)</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>彩信(MMS)</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>免提通话</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>录音功能</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>情景模式</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>动画屏保</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>待机图片</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>主题菜单</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>来电铃声识别</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>来电图片识别</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>自动键盘锁</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>日历功能</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>闹钟功能</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>秒表</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>计算器</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>单位换算</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>产品特性</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>GPS导航</SPAN></TD>\r\n<TD>内置GPS</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>电子罗盘</SPAN></TD>\r\n<TD>数字指南针</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px\">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>地图软件</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>重力感应器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>加速传感器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>光线传感器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>距离传感器</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>3D加速</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>拍照功能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>摄像头</SPAN></TD>\r\n<TD>内置</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>摄像头类型</SPAN></TD>\r\n<TD>双摄像头（前后）</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>摄像头像素</SPAN></TD>\r\n<TD>前：30万像素，后：500万像素</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>闪光灯</SPAN></TD>\r\n<TD>LED补光灯</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>数码变焦</SPAN></TD>\r\n<TD>5倍数码变焦</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>自动对焦</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>拍摄场景</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>照片特效</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>图像尺寸</SPAN></TD>\r\n<TD>最大支持2592×1944像素照片拍摄</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>连拍功能</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>定时器</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>视频拍摄</SPAN></TD>\r\n<TD>720p（1280×720，30帧/秒）视频录制</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>其它功能</SPAN></TD>\r\n<TD>照片和视频地理标记功能</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>娱乐功能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>视频播放</SPAN></TD>\r\n<TD>支持MP4/3GP/AVC/AVI/MPEG-4等格式</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>音频播放</SPAN></TD>\r\n<TD>支持MP3/AAC/AAC+/AMR/WMA/WAV等格式</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>铃音描述</SPAN></TD>\r\n<TD>支持MP3/MIDI/WMA/AMR/AAC等格式</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>图形格式</SPAN></TD>\r\n<TD>支持JPEG/EXIF等格式</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>游戏</SPAN></TD>\r\n<TD>内置PZS，Real Tennis，极品飞车变速，RF10，Doodle Find，EndlessRace，Rugby，PooINinja，CC Tennis</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>SNS支持</SPAN></TD>\r\n<TD>支持Twitter，MySpace，Facebook，YouTube，Flickr，Picasa等</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>即时通讯</SPAN></TD>\r\n<TD>支持QQ，MSN，飞信等</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>服务特色</SPAN></TD>\r\n<TD>App store</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px\">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>电子书</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>Java扩展</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>应用程序</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>数据功能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>蓝牙传输</SPAN></TD>\r\n<TD>支持蓝牙2.1+EDR</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>WLAN功能</SPAN></TD>\r\n<TD>WIFI</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>数据接口</SPAN></TD>\r\n<TD>30-pin dock</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>耳机插孔</SPAN></TD>\r\n<TD>3.5mm</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px\">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>WAP浏览器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>WWW浏览器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>PC数据同步</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>商务功能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>办公工具</SPAN></TD>\r\n<TD>TXT，Quick Office，Adobe PDF，zip管理</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>SyncML功能</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px\">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>电子邮件</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>飞行模式</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>世界时间</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>备忘录</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>日程表</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width=\"100%\" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style=\"COLOR: #333; FONT-SIZE: 12px\" bgColor=#f1f7fc height=18 align=middle>记事本</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>手机附件</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>包装清单</SPAN></TD>\r\n<TD>主机&nbsp;x1<BR>数据线&nbsp;x1<BR>耳机&nbsp;x1<BR>充电器&nbsp;x1&nbsp; <BR>说明书&nbsp;x1</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>保修信息</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>保修政策</SPAN></TD>\r\n<TD>全国联保，享受三包服务</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>质保时间</SPAN></TD>\r\n<TD>1年</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>质保备注</SPAN></TD>\r\n<TD>主机1年，电池6个月，充电器1年，有线耳机3个月</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>客服电话</SPAN></TD>\r\n<TD>400-627-2273</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>电话备注</SPAN></TD>\r\n<TD>周一至周五：9:00-21:00；周六至周日：9:00-18:00</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>详细内容</SPAN></TD>\r\n<TD>自购机日起（以购机发票为准），如因质量问题或故障，凭厂商维修中心或特约维修点的质量检测证明，享受7日内退货，15日内换货，15日以上在质保期内享受免费保修等三包服务！<BR>注：单独购买手机配件产品的用户，请完好保存配件外包装以及发票原件，如无法提供上述凭证的，将无法进行正常的配件保修或更换。<A href=\"http://www.apple.com.cn/support/applecare/aasp/\" target=_blank>进入官网&gt;&gt;</A></TD></TR>\r\n<TR>\r\n<TD bgColor=#ffffff height=25 colSpan=2 align=right>数据来源： <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"http://detail.zol.com.cn/\">中关村在线 报价中心</A> (detail.zol.com.cn) </TD></TR></TBODY></TABLE></DIV>','2012-01-25 12:25:50'),(60,'苹果MacBook Air（MC966CH/A）','电脑','笔记本','ceU4kbR6Q3mr(1).jpg ',12500.00,'&nbsp; \r\n<DIV style=\"BORDER-BOTTOM: #aac4e5 1px solid; BORDER-LEFT: #aac4e5 1px solid; LINE-HEIGHT: 26px; BACKGROUND-COLOR: #aac4e5; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px auto; WIDTH: 560px; FONT-SIZE: 14px; OVERFLOW: hidden; BORDER-TOP: #aac4e5 1px solid; FONT-WEIGHT: normal; BORDER-RIGHT: #aac4e5 1px solid\" id=layoutTab>\r\n<TABLE style=\"BORDER-BOTTOM: #aac4e5 2px solid; BORDER-LEFT: #aac4e5 2px solid; COLOR: #333; FONT-SIZE: 12px; BORDER-TOP: #aac4e5 2px solid; BORDER-RIGHT: #aac4e5 2px solid\" cellSpacing=1 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD bgColor=#ffffff colSpan=2>\r\n<TABLE style=\"BORDER-COLLAPSE: collapse\" border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR style=\"PADDING-BOTTOM: 14px; PADDING-LEFT: 14px; PADDING-RIGHT: 14px; PADDING-TOP: 14px\">\r\n<TD>\r\n<H3 style=\"PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; FONT-SIZE: 14px; FONT-WEIGHT: bold; PADDING-TOP: 0px\">苹果MacBook Air（MC966CH/A）</H3>\r\n<H4 style=\"PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; COLOR: #999; FONT-SIZE: 18px; FONT-WEIGHT: bold; PADDING-TOP: 0px\">参数规格</H4></TD>\r\n<TD style=\"PADDING-BOTTOM: 10px; PADDING-LEFT: 10px; PADDING-RIGHT: 10px; FONT-SIZE: 12px; PADDING-TOP: 10px\" vAlign=bottom align=right>查看： <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"\">更多信息</A> 或 <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"\">更多图片</A> </TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>基本参数</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>上市时间</SPAN></TD>\r\n<TD>2011年08月</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>产品类型</SPAN></TD>\r\n<TD>家用</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>产品定位</SPAN></TD>\r\n<TD>轻薄便携本</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>操作系统</SPAN></TD>\r\n<TD>Mac OS X 10.7 Lion</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>处理器</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>CPU系列</SPAN></TD>\r\n<TD>英特尔 酷睿i5 2代系列（Sandy Bridge）</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>CPU型号</SPAN></TD>\r\n<TD>Intel 酷睿i5 2557M</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>CPU主频</SPAN></TD>\r\n<TD>1.7GHz</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>最高睿频</SPAN></TD>\r\n<TD>2700MHz</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>总线规格</SPAN></TD>\r\n<TD>DMI 5 GT/s</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>三级缓存</SPAN></TD>\r\n<TD>3MB</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>核心类型</SPAN></TD>\r\n<TD>Sandy Bridge</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>核心/线程数</SPAN></TD>\r\n<TD>双核心/四线程</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>制程工艺</SPAN></TD>\r\n<TD>32nm</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>指令集</SPAN></TD>\r\n<TD>AVX，64bit</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>功耗</SPAN></TD>\r\n<TD>17W</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>存储设备</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>内存容量</SPAN></TD>\r\n<TD>4GB</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>内存类型</SPAN></TD>\r\n<TD>DDR3 1333MHz</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>最大内存容量</SPAN></TD>\r\n<TD>8GB</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>硬盘容量</SPAN></TD>\r\n<TD>256GB SSD固态硬盘</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>光驱类型</SPAN></TD>\r\n<TD>无内置光驱</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>显示屏</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>屏幕尺寸</SPAN></TD>\r\n<TD>13.3英寸</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>屏幕比例</SPAN></TD>\r\n<TD>16:10</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>屏幕分辨率</SPAN></TD>\r\n<TD>1440x900</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>背光技术</SPAN></TD>\r\n<TD>LED背光</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>显卡</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>显卡类型</SPAN></TD>\r\n<TD>核芯显卡</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>显卡芯片</SPAN></TD>\r\n<TD>Intel GMA HD 3000</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>显存容量</SPAN></TD>\r\n<TD>共享内存容量</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>显存类型</SPAN></TD>\r\n<TD>无</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>DirectX</SPAN></TD>\r\n<TD>10.1</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>多媒体设备</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>摄像头</SPAN></TD>\r\n<TD>集成摄像头</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>音频系统</SPAN></TD>\r\n<TD>内置音效芯片</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>扬声器</SPAN></TD>\r\n<TD>内置扬声器</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>麦克风</SPAN></TD>\r\n<TD>内置麦克风</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>网络通信</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>无线网卡</SPAN></TD>\r\n<TD>支持802.11a/g/n无线协议</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>有线网卡</SPAN></TD>\r\n<TD>集成网卡</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>蓝牙</SPAN></TD>\r\n<TD>支持，蓝牙4.0模块</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>I/O接口</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>数据接口</SPAN></TD>\r\n<TD>2×USB2.0，Thunderbolt接口</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>音频接口</SPAN></TD>\r\n<TD>耳机输出接口</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>其它接口</SPAN></TD>\r\n<TD>电源接口</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>读卡器</SPAN></TD>\r\n<TD>SD读卡器</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>输入设备</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>指取设备</SPAN></TD>\r\n<TD>触摸板</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>键盘描述</SPAN></TD>\r\n<TD>背光键盘</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>电源描述</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>电池类型</SPAN></TD>\r\n<TD>锂电池</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>续航时间</SPAN></TD>\r\n<TD>具体时间视使用环境而定</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>外观</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>笔记本重量</SPAN></TD>\r\n<TD>1.35Kg</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>外形尺寸</SPAN></TD>\r\n<TD>325×227×3-17mm</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>外壳材质</SPAN></TD>\r\n<TD>镁铝合金</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>外壳描述</SPAN></TD>\r\n<TD>精密铝合金一体成型机身</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>其他</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>附带软件</SPAN></TD>\r\n<TD>随机软件</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>其它特点</SPAN></TD>\r\n<TD>Multi Touch 手势Mission ControlMac App StoreLaunchpad</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>笔记本附件</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>包装清单</SPAN></TD>\r\n<TD>笔记本主机&nbsp;x1<BR>电源适配器&nbsp;x1<BR>说明书&nbsp;x1<BR>保修卡&nbsp;x1</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>保修信息</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>保修政策</SPAN></TD>\r\n<TD>全国联保，享受三包服务</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>质保时间</SPAN></TD>\r\n<TD>1年</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>质保备注</SPAN></TD>\r\n<TD>1年硬件维修，90天电话支持</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>客服电话</SPAN></TD>\r\n<TD>400-627-2273</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>详细内容</SPAN></TD>\r\n<TD>凡属正常使用情况下由于产品本身质量问题引起的故障，在保修期内，苹果公司将负责给予有限保修。产品出现故障，请直接与苹果售后支持热线400-627-2273联系。用户请妥善保存本保修卡及购机时经销商开具的国家税务局标准销售凭证。在维修时将被要求出示以上凭证作为保修依据，产品的保修起始日期为有效购机凭证上的购机日期。<A href=\"http://www.apple.com.cn/store/specialdeals/salespolicies.html\" target=_blank>进入官网&gt;&gt;</A></TD></TR>\r\n<TR>\r\n<TD bgColor=#ffffff height=25 colSpan=2 align=right>数据来源： <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"http://detail.zol.com.cn/\">中关村在线 报价中心</A> (detail.zol.com.cn) </TD></TR></TBODY></TABLE></DIV>','2012-02-15 20:26:30'),(61,'纽曼A80HD（8GB）','数码','mp3/mp4','ceUmw3svJkBL.jpg ',699.00,'&nbsp;\r\n<DIV style=\"BORDER-BOTTOM: #aac4e5 1px solid; BORDER-LEFT: #aac4e5 1px solid; LINE-HEIGHT: 26px; BACKGROUND-COLOR: #aac4e5; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px auto; WIDTH: 560px; FONT-SIZE: 14px; OVERFLOW: hidden; BORDER-TOP: #aac4e5 1px solid; FONT-WEIGHT: normal; BORDER-RIGHT: #aac4e5 1px solid\" id=layoutTab>\r\n<TABLE style=\"BORDER-BOTTOM: #aac4e5 2px solid; BORDER-LEFT: #aac4e5 2px solid; COLOR: #333; FONT-SIZE: 12px; BORDER-TOP: #aac4e5 2px solid; BORDER-RIGHT: #aac4e5 2px solid\" cellSpacing=1 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR>\r\n<TD bgColor=#ffffff colSpan=2>\r\n<TABLE style=\"BORDER-COLLAPSE: collapse\" border=0 cellSpacing=0 cellPadding=0 width=\"100%\">\r\n<TBODY>\r\n<TR style=\"PADDING-BOTTOM: 14px; PADDING-LEFT: 14px; PADDING-RIGHT: 14px; PADDING-TOP: 14px\">\r\n<TD>\r\n<H3 style=\"PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; FONT-SIZE: 14px; FONT-WEIGHT: bold; PADDING-TOP: 0px\">纽曼A80HD（8GB）</H3>\r\n<H4 style=\"PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; COLOR: #999; FONT-SIZE: 18px; FONT-WEIGHT: bold; PADDING-TOP: 0px\">参数规格</H4></TD>\r\n<TD style=\"PADDING-BOTTOM: 10px; PADDING-LEFT: 10px; PADDING-RIGHT: 10px; FONT-SIZE: 12px; PADDING-TOP: 10px\" vAlign=bottom align=right>查看： <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"\">更多信息</A> 或 <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"\">更多图片</A> </TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>基本性能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>产品类型</SPAN></TD>\r\n<TD>高清视频MP4</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>存储介质</SPAN></TD>\r\n<TD>闪存</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>存储容量</SPAN></TD>\r\n<TD>8GB</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>扩展卡</SPAN></TD>\r\n<TD>支持MicroSD（TF）卡，最大32GB</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>操作方式</SPAN></TD>\r\n<TD>按键式</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>电池容量</SPAN></TD>\r\n<TD>3300mAh</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>机身特点</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>屏幕尺寸</SPAN></TD>\r\n<TD>8英寸</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>屏幕类型</SPAN></TD>\r\n<TD>宽屏（16:9）</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>屏幕分辨率</SPAN></TD>\r\n<TD>1280×800像素</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>视频性能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>视频格式</SPAN></TD>\r\n<TD>支持RM，RMVB，AVI，MOV，TP，M2TS，TS，MKV，MPG，MP4等格式</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>视频分辨率</SPAN></TD>\r\n<TD>1080P</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>视频输出</SPAN></TD>\r\n<TD>支持（TV-OUT）</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>其他视频特点</SPAN></TD>\r\n<TD>支持多格式的字幕显示</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>音频性能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>音乐格式</SPAN></TD>\r\n<TD>支持支持MP3，WMA，WAV，APE，FLAC等格式</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>歌词同步</SPAN></TD>\r\n<TD>支持歌词同步显示</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>图像文本</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>图片浏览格式</SPAN></TD>\r\n<TD>支持JPG，BMP，PNG格式</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>主要功能</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>遥控功能</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>其他描述</SPAN></TD>\r\n<TD>支持多任务操作</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>其他说明</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>机形特点</SPAN></TD>\r\n<TD>精致纤薄，容易摆放，携带方便，IML外壳工艺</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\">\r\n<TD style=\"BACKGROUND: #f2f7fd\" colSpan=2><B>保修信息</B></TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>保修政策</SPAN></TD>\r\n<TD>全国联保，享受三包服务</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>质保时间</SPAN></TD>\r\n<TD>1年</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>客服电话</SPAN></TD>\r\n<TD>400-890-9890，400-810-1989，010-8268-9216</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>电话备注</SPAN></TD>\r\n<TD>周一至周日：9:00-18:00</TD></TR>\r\n<TR style=\"PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px\" bgColor=#ffffff>\r\n<TD style=\"WIDTH: 80px\"><SPAN>详细内容</SPAN></TD>\r\n<TD>您在购买本产品之日起7日内（含），若产品主机经纽曼红色服务快车中心检测出由于本机元器件所引发之故障，您可以选择退货，更换或维修。如您选择退货，请您携带有效购机凭证和有效三包凭证与故障设备及其全部物件到销售商处，销售商将免费为您退货，并按照购买价格（以有效购机凭证价格为准）一次性退清货款。<A href=\"http://www.newsmy.com/Page/shfwcn_1.html\" target=_blank>进入官网&gt;&gt;</A></TD></TR>\r\n<TR>\r\n<TD bgColor=#ffffff height=25 colSpan=2 align=right>数据来源： <A style=\"COLOR: #0267a7; TEXT-DECORATION: none\" href=\"http://detail.zol.com.cn/\">中关村在线 报价中心</A> (detail.zol.com.cn) </TD></TR></TBODY></TABLE></DIV>','2012-02-15 20:25:59'),(63,'韩式田园 韩式田园家具-白色1.5米排骨架床 韩菲','家具','家用家具','1338853863194324533.jpg ',999.00,'&nbsp; \r\n<DT><SPAN class=\"gray goods_sn nright\">( 编号：<SPAN id=JS_attr_title_sn>HFE-A3</SPAN><SPAN id=JS_attr_title_born>| 产地：广东惠州</SPAN> )</SPAN> </DT>\r\n<DT>配&#8194;置： </DT>\r\n<DD><A onclick=\"GF.setCurrentById(\'16311\');\" id=JS_join_goods_nav_16311_16311 class=current href=\"javascript:;\">1.5*2.0米排骨架床</A><A onclick=\"GF.setCurrentById(\'16312\');\" id=JS_join_goods_nav_16311_16312 href=\"javascript:;\">1.8*2.0米排骨架床</A> </DD>\r\n<DL id=JS_panel_trans_type_16311 class=\"clearfix none\">\r\n<DT>配&#8194;送： </DT>\r\n<DD><A onclick=\"GL[\'16311\'].setTransType(0);return false;\" id=JS_panel_trans_type_16311_0 class=current href=\"javascript:;\">包物流</A><A onclick=\"GL[\'16311\'].setTransType(1);return false;\" id=JS_panel_trans_type_16311_1 href=\"javascript:;\">包快递</A> </DD></DL>\r\n<DL class=clearfix>\r\n<DT>颜&#8194;色： </DT>\r\n<DD><SPAN class=current>象牙白</SPAN> </DD></DL>\r\n<DL class=clearfix>\r\n<DT>内&#8194;径： </DT>\r\n<DD><SPAN class=current>1.5*2.0米</SPAN> </DD></DL>\r\n<DL class=clearfix>\r\n<DT>外&#8194;径： </DT>\r\n<DD><SPAN class=current>长2095*宽1650*高1160mm；125mm（床沿深）</SPAN> </DD></DL>','2013-06-27 06:22:49'),(64,'力帆620 1.6L CVT','汽车','轿车','1221788701_48d3041d059c0.jpg ',70000.00,'&nbsp; \r\n<TABLE style=\"DISPLAY: block\" cellSpacing=1 cellPadding=0 border=0 jQuery1354721409546=\"25\">\r\n<CAPTION>力帆 620 1.6L CVT配置表 </CAPTION>\r\n<TBODY>\r\n<TR>\r\n<TD rowSpan=2 align=center><STRONG>项目</STRONG></TD>\r\n<TD rowSpan=2 align=center><STRONG>配置类型</STRONG></TD>\r\n<TD align=center><STRONG>旗舰型</STRONG></TD></TR>\r\n<TR>\r\n<TD align=center><STRONG>(LX)</STRONG></TD></TR>\r\n<TR>\r\n<TD align=center></TD>\r\n<TD align=left><STRONG>价格</STRONG></TD>\r\n<TD align=center><STRONG>69900</STRONG></TD></TR>\r\n<TR>\r\n<TD rowSpan=7 align=center>尺寸</TD>\r\n<TD align=left>长X宽X高（mm）</TD>\r\n<TD align=center>4550X1705X1495</TD></TR>\r\n<TR>\r\n<TD align=left>轴距（mm）</TD>\r\n<TD align=center>2605</TD></TR>\r\n<TR>\r\n<TD align=left>轮距（前后）（mm）</TD>\r\n<TD align=center>1470/1460</TD></TR>\r\n<TR>\r\n<TD align=left>最小离地间隙（mm）</TD>\r\n<TD align=center>150</TD></TR>\r\n<TR>\r\n<TD align=left>轮胎（mm）</TD>\r\n<TD align=center>175/65R15</TD></TR>\r\n<TR>\r\n<TD align=left>油箱容积（L）</TD>\r\n<TD align=center>58</TD></TR>\r\n<TR>\r\n<TD align=left>行李箱容积（L）</TD>\r\n<TD align=center>650</TD></TR>\r\n<TR>\r\n<TD rowSpan=12 align=center>性能</TD>\r\n<TD align=left>发动机</TD>\r\n<TD align=center>LF481Q3</TD></TR>\r\n<TR>\r\n<TD align=left>发动机形式</TD>\r\n<TD align=center>L4双顶置凸轮轴，多点喷射，16气门</TD></TR>\r\n<TR>\r\n<TD align=left>排量(L)</TD>\r\n<TD align=center>1.587</TD></TR>\r\n<TR>\r\n<TD align=left>最大功率(KW/rpm)</TD>\r\n<TD align=center>78/6000</TD></TR>\r\n<TR>\r\n<TD align=left>最大扭力(Nm/rpm)</TD>\r\n<TD align=center>137/3500~5000</TD></TR>\r\n<TR>\r\n<TD align=left>变速箱</TD>\r\n<TD align=center>CVT</TD></TR>\r\n<TR>\r\n<TD align=left>驱动形式</TD>\r\n<TD align=center>前置前驱</TD></TR>\r\n<TR>\r\n<TD align=left>最高车速（km/h）</TD>\r\n<TD align=center>160</TD></TR>\r\n<TR>\r\n<TD align=left>百公里等速油耗(90Km/h)（L）</TD>\r\n<TD align=center>5.1</TD></TR>\r\n<TR>\r\n<TD align=left>前悬挂</TD>\r\n<TD align=center>麦弗逊式独立悬架</TD></TR>\r\n<TR>\r\n<TD align=left>后悬挂</TD>\r\n<TD align=center>拖曳臂式非独立悬架</TD></TR>\r\n<TR>\r\n<TD align=left>制动系统</TD>\r\n<TD align=center>前盘后盘</TD></TR>\r\n<TR>\r\n<TD rowSpan=13 align=center>安全性</TD>\r\n<TD align=left>ABS</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>EBD</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>后车门儿童锁</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>可溃缩式转向柱</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>高位刹车灯</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>速度感应型自动车门锁止系统</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>冲撞力感应自动车门开启系统</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>双安全气囊</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>后泊车雷达</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>底盘保护</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>倒车影象系统</TD>\r\n<TD align=center>○</TD></TR>\r\n<TR>\r\n<TD align=left>前雾灯</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>车门未关警告</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD rowSpan=6 align=center>外饰</TD>\r\n<TD align=left>后视镜电动调节</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>铝合金轮毂</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>钢制轮毂</TD>\r\n<TD align=center>?</TD></TR>\r\n<TR>\r\n<TD align=left>电动天窗</TD>\r\n<TD align=center>?</TD></TR>\r\n<TR>\r\n<TD align=left>镀铬水箱格栅</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>挡泥板</TD>\r\n<TD align=center>?</TD></TR>\r\n<TR>\r\n<TD rowSpan=8 align=center>内饰</TD>\r\n<TD align=left>皮质座椅</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>驾驶座手动腰部支撑</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>后排座椅4/6分</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>后排中央扶手</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>后排中央扶手带杯托</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>发动机装饰盖</TD>\r\n<TD align=center>○</TD></TR>\r\n<TR>\r\n<TD align=left>休息踏板</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>高度可调</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD rowSpan=5 align=center>舒适性</TD>\r\n<TD align=left>自动点亮前大灯</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>一体式遥控钥匙</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>前后电动车窗</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>遥控门锁</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>机械内部开启油箱盖锁</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD rowSpan=5 align=center>娱乐性</TD>\r\n<TD align=left>方向盘音响控制</TD>\r\n<TD align=center>?</TD></TR>\r\n<TR>\r\n<TD align=left>扬声器数量</TD>\r\n<TD align=center>6</TD></TR>\r\n<TR>\r\n<TD align=left>单碟CD</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>外接MP3</TD>\r\n<TD align=center>●</TD></TR>\r\n<TR>\r\n<TD align=left>GPS+USB+AUX</TD>\r\n<TD align=center>○</TD></TR></TBODY></TABLE>','2013-06-27 06:21:43');

/*Table structure for table `smalltype` */

DROP TABLE IF EXISTS `smalltype`;

CREATE TABLE `smalltype` (
  `smalltypeid` int(11) NOT NULL AUTO_INCREMENT,
  `bigtypeid` int(11) DEFAULT NULL,
  `smalltypename` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`smalltypeid`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=gb2312;

/*Data for the table `smalltype` */

insert  into `smalltype`(`smalltypeid`,`bigtypeid`,`smalltypename`) values (2,2,'液晶电视'),(3,3,'家庭音箱'),(4,8,'皮包'),(5,8,'钱包'),(6,8,'男士皮包'),(7,8,'女士皮包'),(8,5,'上衣'),(9,5,'长裤'),(10,5,'西服'),(11,5,'休闲服'),(12,6,'长袜'),(13,6,'短袜'),(14,7,'皮鞋'),(15,7,'波鞋'),(16,7,'凉鞋'),(17,1,'手机'),(18,1,'电话'),(19,4,'大米'),(20,4,'蔬菜'),(21,4,'肉类'),(22,4,'副食品'),(23,4,'酒'),(26,4,'海鲜'),(27,4,'早点'),(28,5,'羽绒服'),(30,5,'皮衣'),(31,9,'笔记本'),(32,10,'数码相机'),(33,10,'mp3/mp4'),(34,12,'商品房'),(35,12,'别墅'),(36,11,'轿车'),(37,11,'商务车'),(38,13,'酒店家具'),(39,13,'家用家具'),(40,14,'小学'),(41,14,'初中'),(42,14,'高中'),(43,14,'大学'),(44,14,'成人'),(45,14,'自考'),(46,14,'考研'),(47,14,'英语'),(48,14,'技术');

/*Table structure for table `user` */

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) DEFAULT NULL,
  `password` varchar(20) DEFAULT NULL,
  `sex` int(10) DEFAULT NULL,
  `friends` varchar(50) DEFAULT NULL,
  `picture` varchar(200) DEFAULT NULL,
  `message` text,
  `hobby` varchar(255) DEFAULT NULL,
  `regdatetime` datetime DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `post` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=gb2312;

/*Data for the table `user` */

insert  into `user`(`Id`,`username`,`password`,`sex`,`friends`,`picture`,`message`,`hobby`,`regdatetime`,`address`,`post`) values (149,'sglg','19830522',1,'小明','images\\photo_person.jpg','恭喜发财！','足球','2011-06-12 00:55:34',NULL,NULL);

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
