﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.IO;
using System.Web.Script.Serialization;
// 下载于www.51aspx.com
namespace TuLingRobot
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private static string APIKEY = "d91b25b8866fef13f82cd28c0d523c8a";
        private static string INFO = Encoding.UTF8.GetString(Encoding.UTF8.GetBytes("你好"));
        private static string getURl = "http://www.tuling123.com/openapi/api?key=" + APIKEY + "&info=" + INFO;
        private string code = "";
        private string text = "";
        private string url = "";
        private string list = "";

        public string article = "";
        public string source = "";
        public string detailurl = "";
        public string trainnum = "";
        public string start = "";
        public string terminal = "";
        public string flight = "";
        public string route = "";
        public string starttime = "";
        public string endtime = "";
        public string icon = "";
        public string name = "";
        public string info = "";
        
        private ToJoson DoAPI(string Msg)
        {
            INFO = Encoding.UTF8.GetString(Encoding.UTF8.GetBytes(Msg));
            getURl = "http://www.tuling123.com/openapi/api?key=" + APIKEY + "&info=" + INFO;
            Uri uri = new Uri(getURl);
            HttpWebRequest getUrl = WebRequest.Create(uri) as HttpWebRequest;
            getUrl.Method = "GET";
            HttpWebResponse response = getUrl.GetResponse() as HttpWebResponse;
            Stream respStream = response.GetResponseStream();
            StreamReader stream = new StreamReader(respStream,Encoding.UTF8);
            string respStr = stream.ReadToEnd();
            stream.Close();
            JavaScriptSerializer js = new JavaScriptSerializer();
            ToJoson joson = js.Deserialize<ToJoson>(respStr);
            code = joson.code;
            text = joson.text;
            url = joson.url;
            List<list> list = joson.list;
            return joson;
        }
        private void Clear()
        {
            txtSendMsg.Text = "";
        }

        private void btnSend_Click(object sender, EventArgs e)
        {
            StringBuilder receiveMsg = new StringBuilder();
            string msg = txtSendMsg.Text.Trim();
            txtRecMsg.AppendText("我：" + DateTime.Now+Environment.NewLine);
            txtRecMsg.AppendText(msg + "\r\n");
            ToJoson joson = DoAPI(msg);
            List<list> list = joson.list;
            switch (joson.code)
            {
                //文本类
                case "100000":
                    receiveMsg.Append(joson.text+Environment.NewLine);
                    break;
                //列车
                case "305000":
                    receiveMsg.Append(joson.text + Environment.NewLine)
                              .Append("起始站【" + list[0].start + "】，到达站【" + list[0].terminal + "】" + Environment.NewLine);
                    receiveMsg.Append("车次\t\t\t\t\t开车时间\t\t到达时间" + Environment.NewLine);
                    foreach (list listDetail in list)
                    {
                        receiveMsg.Append(listDetail.trainnum.PadRight(30, ' ') + "\t" + listDetail.starttime + "\t\t\t" + listDetail.endtime + Environment.NewLine);
                    }
                    receiveMsg.Append("详情地址:" + list[0].detailurl + Environment.NewLine);
                    break;
                //航班
                case "306000":
                     receiveMsg.Append(joson.text + Environment.NewLine) ;
                     receiveMsg.Append("航班\t\t\t\t\t起飞时间\t到达时间" + Environment.NewLine);
                    foreach (list listDetail in list)
                    {
                        receiveMsg.Append(listDetail.flight.PadRight(50, ' ') + listDetail.starttime+ "\t\t" + listDetail.endtime + Environment.NewLine);
                    }
                    break;
                //网址类数据 
                case "200000":
                    receiveMsg.Append(joson.text + Environment.NewLine)
                               .Append(joson.url);
                    break;
                //新闻 
                case "302000":
                    receiveMsg.Append(joson.text + Environment.NewLine)
                              .Append(joson.url);
                    foreach (list listDetail in list)
                    {
                        receiveMsg.Append(listDetail.source +"   "+listDetail.article + Environment.NewLine)
                            .Append(listDetail.detailurl + Environment.NewLine);
                    }
                    break;
                //菜谱、视频、小说 
                case "308000":
                     receiveMsg.Append(joson.text + Environment.NewLine)
                              .Append(joson.url);
                    foreach (list listDetail in list)
                    {
                        receiveMsg.Append(listDetail.name + "   " + listDetail.info + Environment.NewLine)
                            .Append(listDetail.detailurl + Environment.NewLine);
                    }
                    break;
                //key的长度错误（32位）
                case "40001":
                    receiveMsg.Append("key的长度错误（32位）" + Environment.NewLine);
                    break;
                //请求内容为空
                case "40002":
                    receiveMsg.Append("请求内容为空" + Environment.NewLine);
                    break;
                //Key错误或帐号未激活
                case "40003":
                    receiveMsg.Append("Key错误或帐号未激活" + Environment.NewLine);
                    break;
                //当天请求次数已用完
                case "40004":
                    receiveMsg.Append("当天请求次数已用完" + Environment.NewLine);
                    break;
                //暂不支持该功能
                case "40005":
                    receiveMsg.Append("暂不支持该功能" + Environment.NewLine);
                    break;
                //服务器升级中
                case "40006":
                    receiveMsg.Append("服务器升级中" + Environment.NewLine);
                    break;
                //服务器数据格式异常
                case "40007":
                    receiveMsg.Append("服务器数据格式异常" + Environment.NewLine);
                    break;
                default:
                    break;
            }
            //txtRecMsg.Select(0, 3);
            //txtRecMsg.SelectionFont = new Font("宋体", 13, FontStyle.Bold); ;
            //txtRecMsg.SelectionColor = Color.Green;
            txtRecMsg.AppendText("机器人：" +DateTime.Now+Environment.NewLine);
            txtRecMsg.AppendText(receiveMsg.ToString() +  "\r\n");
            txtRecMsg.Select(txtRecMsg.TextLength, 0);
            Clear();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //StringBuilder receiveMsg = new StringBuilder();
            //receiveMsg.Append("航班\t\t\t\t\t起飞时间\t到达时间" + Environment.NewLine);
            //receiveMsg.Append("CZ8102 南方航空 CA3964 中国国航 共享".PadRight(50, ' ') + "07:15" + "\t\t" + "08:27" + Environment.NewLine);
            //receiveMsg.Append("CA3916 中国国航 共享".PadRight(50, ' ') + "07:15" + "\t\t" + "08:27" + Environment.NewLine);
           
            //txtRecMsg.AppendText(receiveMsg.ToString());

            //txtRecMsg.AppendText("我：" +"1211");
            //txtRecMsg.Select(0, 1);
            //txtRecMsg.SelectionFont =  new Font("宋体", 13 , FontStyle.Bold);;
            //txtRecMsg.SelectionColor = Color.Green;
        }

        private void txtSendMsg_KeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyCode == Keys.Enter)
            {
                btnSend_Click(sender, e);
            }
        }

        private void txtRecMsg_LinkClicked(object sender, LinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start(e.LinkText);
        }
    }
}
