/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.io.Repeatable;
import org.zkoss.io.RepeatableInputStream;
import org.zkoss.io.RepeatableReader;
import org.zkoss.lang.Strings;
import org.zkoss.lang.SystemException;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.Media;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.PartialByteStream;
import org.zkoss.web.util.resource.ExtendletContext;

public class Https
extends Servlets {
    private static final Log log = Log.lookup(Https.class);
    private static final String[] _dfs = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEEEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMMM d HH:mm:ss yyyy"};

    public static final byte[] gzip(HttpServletRequest request, HttpServletResponse response, InputStream content1, byte[] content2) throws IOException {
        String ae = request.getHeader("accept-encoding");
        if (ae != null && !response.containsHeader("Content-Encoding") && ae.indexOf("gzip") >= 0) {
            response.addHeader("Content-Encoding", "gzip");
            ByteArrayOutputStream boas = new ByteArrayOutputStream(8192);
            GZIPOutputStream gzs = new GZIPOutputStream(boas);
            if (content1 != null) {
                Files.copy((OutputStream)gzs, (InputStream)content1);
            }
            if (content2 != null) {
                gzs.write(content2);
            }
            gzs.finish();
            return boas.toByteArray();
        }
        return null;
    }

    public static final String getCompleteServerName(HttpServletRequest hreq) {
        String ctx;
        StringBuffer sb = hreq.getRequestURL();
        int j = sb.indexOf(ctx = hreq.getContextPath());
        if (j < 0) {
            throw new SystemException("Unknown request: url=" + sb + ", ctx=" + ctx);
        }
        return sb.delete(j, sb.length()).toString();
    }

    public static final String getCompleteContext(HttpServletRequest hreq) {
        String ctx;
        StringBuffer sb = hreq.getRequestURL();
        int j = sb.indexOf(ctx = hreq.getContextPath());
        if (j < 0) {
            throw new SystemException("Unknown request: url=" + sb + ", ctx=" + ctx);
        }
        return sb.delete(j + ctx.length(), sb.length()).toString();
    }

    public static final String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int j = cookies.length;
            while (--j >= 0) {
                if (!cookies[j].getName().equals(name)) continue;
                return cookies[j].getValue();
            }
        }
        return null;
    }

    public static final String getServletURI(HttpServletRequest request) {
        String sp = request.getServletPath();
        String pi = request.getPathInfo();
        if (pi == null || pi.length() == 0) {
            return sp;
        }
        if (sp.length() == 0) {
            return pi;
        }
        return sp + pi;
    }

    public static final String getThisContextPath(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.context_path");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getContextPath() : "");
    }

    public static final String getThisServletPath(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getServletPath() : "/");
    }

    public static final String getThisRequestURI(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.request_uri");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getRequestURI() : "/");
    }

    public static final String getThisQueryString(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.query_string");
        return path != null || Https.isIncluded(request) || !(request instanceof HttpServletRequest) ? path : ((HttpServletRequest)request).getQueryString();
    }

    public static final String getThisPathInfo(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.path_info");
        return path != null || Https.isIncluded(request) || !(request instanceof HttpServletRequest) ? path : ((HttpServletRequest)request).getPathInfo();
    }

    public static final String getOriginContextPath(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.context_path");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getContextPath() : "");
    }

    public static final String getOriginServletPath(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getServletPath() : "/");
    }

    public static final String getOriginRequestURI(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.request_uri");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getRequestURI() : "/");
    }

    public static final String getOriginPathInfo(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.path_info");
        return path != null ? path : (Https.isForwarded(request) ? null : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getPathInfo() : null));
    }

    public static final String getOriginQueryString(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.query_string");
        return path != null ? path : (Https.isForwarded(request) ? null : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getQueryString() : null));
    }

    public static final String getOriginFullServlet(ServletRequest request) {
        String qstr = Https.getOriginQueryString(request);
        String pi = Https.getOriginPathInfo(request);
        if (qstr == null && pi == null) {
            return Https.getOriginServletPath(request);
        }
        StringBuffer sb = new StringBuffer(80).append(Https.getOriginServletPath(request));
        if (pi != null) {
            sb.append(pi);
        }
        if (qstr != null) {
            sb.append('?').append(qstr);
        }
        return sb.toString();
    }

    public static final String getOriginFullRequest(ServletRequest request) {
        String qstr = Https.getOriginQueryString(request);
        return qstr != null ? Https.getOriginRequestURI(request) + '?' + qstr : Https.getOriginRequestURI(request);
    }

    public static final void sendRedirect(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String uri, Map params, int mode) throws IOException, ServletException {
        uri = Https.locate(ctx, (ServletRequest)request, uri, null);
        String encodedUrl = Https.encodeRedirectURL(ctx, request, response, uri, params, mode);
        response.sendRedirect(encodedUrl);
    }

    public static final String encodeRedirectURL(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String uri, Map params, int mode) {
        if (uri == null) {
            uri = request.getContextPath() + Https.getOriginFullServlet((ServletRequest)request);
        } else {
            int len = uri.length();
            if (len == 0 || uri.charAt(0) == '/') {
                uri = request.getContextPath() + uri;
            } else if (uri.charAt(0) == '~') {
                int j = uri.indexOf(47, 1);
                String ctxroot = j >= 0 ? "/" + uri.substring(1, j) : "/" + uri.substring(1);
                ExtendletContext extctx = Servlets.getExtendletContext(ctx, ctxroot.substring(1));
                if (extctx != null) {
                    uri = j >= 0 ? uri.substring(j) : "/";
                    return extctx.encodeRedirectURL(request, response, uri, params, mode);
                }
                uri = len >= 2 && uri.charAt(1) == '/' ? uri.substring(1) : '/' + uri.substring(1);
            }
        }
        return response.encodeRedirectURL(Https.generateURI(uri, params, mode));
    }

    public static final Date toDate(String sdate) throws ParseException {
        ParseException ex = null;
        for (int j = 0; j < _dfs.length; ++j) {
            try {
                return new SimpleDateFormat(_dfs[j], Locale.US).parse(sdate);
            }
            catch (ParseException t) {
                if (ex != null) continue;
                ex = t;
                continue;
            }
        }
        throw ex;
    }

    public static final String toString(Date date) {
        return new SimpleDateFormat(_dfs[0], Locale.US).format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletRequest request, HttpServletResponse response, Media media, boolean download, boolean repeatable) throws IOException {
        byte[] data;
        if (!Servlets.isBrowser((ServletRequest)request, "ie")) {
            response.setHeader("Accept-Ranges", "bytes");
        }
        boolean headOnly = "HEAD".equalsIgnoreCase(request.getMethod());
        int from = -1;
        int to = -1;
        Media media2 = media;
        synchronized (media2) {
            int[] range;
            String rs;
            String ctype = media.getContentType();
            if (ctype != null) {
                response.setContentType(ctype);
            }
            if (download) {
                String value = "attachment";
                String flnm = media.getName();
                if (flnm != null && flnm.length() > 0) {
                    value = value + ";filename=" + Https.encodeFilename(flnm);
                }
                response.setHeader("Content-Disposition", value);
            }
            if ((rs = request.getHeader("Range")) != null && rs.length() > 0 && (range = Https.parseRange(rs)) != null) {
                from = range[0];
                to = range[1];
            }
            if (!media.inMemory()) {
                ServletOutputStream out = response.getOutputStream();
                if (media.isBinary()) {
                    InputStream in = media.getStreamData();
                    if (repeatable) {
                        in = RepeatableInputStream.getInstance((InputStream)in);
                    }
                    try {
                        if (headOnly) {
                            int v;
                            int cnt = 0;
                            byte[] buf = new byte[512];
                            while ((v = in.read(buf)) >= 0) {
                                cnt += v;
                            }
                            response.setContentLength(cnt);
                            return;
                        }
                        if (from >= 0) {
                            PartialByteStream pbs = new PartialByteStream(from, to);
                            Files.copy((OutputStream)pbs, (InputStream)in);
                            pbs.responseTo(response);
                        }
                        Files.copy((OutputStream)out, (InputStream)in);
                    }
                    catch (IOException ex) {
                        if (in instanceof Repeatable) {
                            try {
                                int v;
                                byte[] buf = new byte[8192];
                                while ((v = in.read(buf)) >= 0) {
                                }
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                    finally {
                        in.close();
                    }
                } else {
                    String charset = Https.getCharset(ctype);
                    Reader in = media.getReaderData();
                    if (repeatable) {
                        in = RepeatableReader.getInstance((Reader)in);
                    }
                    try {
                        if (headOnly) {
                            int v;
                            int cnt = 0;
                            char[] buf = new char[256];
                            while ((v = in.read(buf)) >= 0) {
                                cnt += new String(buf, 0, v).getBytes(charset).length;
                            }
                            response.setContentLength(cnt);
                            return;
                        }
                        if (from >= 0) {
                            PartialByteStream pbs = new PartialByteStream(from, to);
                            OutputStreamWriter wt = new OutputStreamWriter((OutputStream)pbs, charset);
                            Files.copy((Writer)wt, (Reader)in);
                            wt.close();
                            pbs.responseTo(response);
                        } else {
                            OutputStreamWriter wt = new OutputStreamWriter((OutputStream)out, charset);
                            Files.copy((Writer)wt, (Reader)in);
                            wt.close();
                        }
                    }
                    catch (IOException ex) {
                        if (in instanceof Repeatable) {
                            try {
                                int v;
                                char[] buf = new char[4096];
                                while ((v = in.read(buf)) >= 0) {
                                }
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                    finally {
                        in.close();
                    }
                }
                out.flush();
                return;
            }
            data = media.isBinary() ? media.getByteData() : media.getStringData().getBytes(Https.getCharset(ctype));
        }
        if (headOnly) {
            response.setContentLength(data.length);
        } else {
            ServletOutputStream out = response.getOutputStream();
            if (from >= 0) {
                response.setStatus(206);
                int f = from <= data.length ? from : data.length;
                int t = to >= 0 && to < data.length ? to : data.length;
                int cnt = t - f + 1;
                response.setContentLength(cnt);
                response.setHeader("Content-Range", "bytes " + f + "-" + t + "/" + data.length);
                out.write(data, f, cnt);
            } else {
                response.setContentLength(data.length);
                out.write(data);
            }
            out.flush();
        }
    }

    private static String encodeFilename(String flnm) {
        return '\"' + Strings.escape((String)flnm, (String)"\"") + '\"';
    }

    private static String getCharset(String contentType) {
        String cs;
        int j;
        if (contentType != null && (j = contentType.indexOf("charset=")) >= 0 && (cs = contentType.substring(j + 8).trim()).length() > 0) {
            return cs;
        }
        return "UTF-8";
    }

    private static int[] parseRange(String range) {
        int k;
        range = range.toLowerCase();
        int j = 0;
        int len = range.length();
        while ((k = range.indexOf("bytes", j)) >= 0) {
            k += 5;
            while (k < len) {
                char cc;
                if ((cc = range.charAt(k++)) == ' ' || cc == '\t' || cc != '=') continue;
                j = range.indexOf(45, k);
                try {
                    int from = Integer.parseInt((j >= 0 ? range.substring(k, j) : range.substring(k)).trim());
                    if (from >= 0) {
                        int to;
                        String s;
                        if (j >= 0 && (s = range.substring(j + 1).trim()).length() > 0 && (to = Integer.parseInt(s)) >= from) {
                            return new int[]{from, to};
                        }
                        return new int[]{from, -1};
                    }
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (log.debugable()) {
                    log.debug("Failed to parse Range: " + range);
                }
                return null;
            }
            j = k;
        }
        return null;
    }
}

