/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.ckez;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.zkforge.ckez.CKeditor;
import org.zkforge.ckez.FilebrowserController;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.au.http.AuExtension;
import org.zkoss.zk.au.http.DHtmlUpdateServlet;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class CkezUploadExtension
implements AuExtension {
    private static final Log log = Log.lookup((Class)CkezUploadExtension.class);
    private ServletContext _ctx;

    public void init(DHtmlUpdateServlet servlet) throws ServletException {
        this._ctx = servlet.getServletContext();
    }

    public void destroy() {
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        Session sess = Sessions.getCurrent((boolean)false);
        if (sess == null) {
            response.setIntHeader("ZK-Error", 410);
            return;
        }
        String type = request.getParameter("type");
        String dtid = request.getParameter("dtid");
        String uuid = request.getParameter("uuid");
        String url = request.getParameter("url");
        try {
            FileItem item = this.parseFileItem(request);
            url = FilebrowserController.getFolderUrl(url);
            String path = request.getContextPath() + url;
            if (item != null) {
                Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktopIfAny(dtid);
                CKeditor ckez = (CKeditor)desktop.getComponentByUuidIfAny(uuid);
                String nextURI = "~./ckez/html/fileupload-done.html.dsp";
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("CKEditorFuncNum", request.getParameter("CKEditorFuncNum"));
                attrs.put("path", ckez.writeFileItem(path, desktop.getWebApp().getRealPath(url), item, type));
                Servlets.forward((ServletContext)this._ctx, (ServletRequest)request, (ServletResponse)response, (String)nextURI, attrs, (int)3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FileItem parseFileItem(HttpServletRequest request) throws Exception {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)factory);
            servletFileUpload.setHeaderEncoding("UTF-8");
            List fileItemsList = servletFileUpload.parseRequest(request);
            Iterator it = fileItemsList.iterator();
            while (it.hasNext()) {
                FileItem item = (FileItem)it.next();
                if (item.isFormField()) continue;
                return item;
            }
        }
        return null;
    }
}

