/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.ckez;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.GenericForwardComposer;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Div;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;

public class FilebrowserController
extends GenericForwardComposer {
    private static final String[] EXCLUDE_FOLDERS = new String[]{"WEB-INF", "META-INF"};
    private static final String[] EXCLUDE_FILES = new String[0];
    private static final String[] IMAGES = new String[]{"gif", "jpg", "jpeg", "png"};
    private static final String[] FILES = new String[]{"htm", "html", "php", "php3", "php5", "phtml", "asp", "aspx", "ascx", "jsp", "cfm", "cfc", "pl", "bat", "exe", "dll", "reg", "cgi", "asmx"};
    private static final String[] FLASH = new String[]{"swf"};
    private static final String[] MEDIA = new String[]{"swf", "fla", "jpg", "gif", "jpeg", "png", "avi", "mpg", "mpeg"};
    private String type = "";
    private Map fileFilterMap;
    private Tree tree;
    private Div cntDiv;
    private Toolbarbutton selBtn;

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this.type = ((String[])this.param.get("Type"))[0];
        this.fileFilterMap = this.initFileFilterMap();
        String url = ((String[])this.param.get("url"))[0];
        if (Strings.isBlank((String)url)) {
            return;
        }
        if (this.application.getResourcePaths(url = FilebrowserController.getFolderUrl(url)) == null) {
            throw new UiException("Folder not found: " + url);
        }
        TreeMap rootFolderMap = new TreeMap();
        TreeMap map = new TreeMap();
        rootFolderMap.put(url, map);
        this.parseFolders(url, map);
        this.tree.setItemRenderer((TreeitemRenderer)new ExplorerTreeitemRenderer());
        this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)new DefaultTreeNode((Object)"ROOT", (Collection)this.initTreeModel(rootFolderMap, new ArrayList()))));
        this.showImages(map);
    }

    static String getFolderUrl(String url) {
        if (url.startsWith("./")) {
            url = url.substring(1);
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return url;
    }

    private List initTreeModel(Map parentFolderMap, List list) {
        Iterator it = parentFolderMap.entrySet().iterator();
        while (it.hasNext()) {
            Map map;
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (!(value instanceof Map) || (map = (Map)value).size() == 0) continue;
            ArrayList al = new ArrayList();
            list.add(new DefaultTreeNode(entry, al));
            this.initTreeModel(map, al);
        }
        return list;
    }

    private Map parseFolders(String path, Map parentFolderMap) {
        Iterator it = this.application.getResourcePaths(path).iterator();
        while (it.hasNext()) {
            String pagePath = String.valueOf(it.next());
            if (pagePath.endsWith("/")) {
                String folderName = pagePath.substring(0, pagePath.length() - 1);
                if (!this.shallShowFile(folderName = folderName.substring(folderName.lastIndexOf("/") + 1))) continue;
                parentFolderMap.put(folderName, this.parseFolders(pagePath, new TreeMap()));
                continue;
            }
            String fileName = pagePath.substring(pagePath.lastIndexOf("/") + 1);
            String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            if (!this.shallShowFile(fileName) && !this.shallShowFile(extension)) continue;
            parentFolderMap.put(fileName, pagePath);
        }
        return parentFolderMap;
    }

    private boolean shallShowFile(String folderName) {
        return new Boolean((String)this.fileFilterMap.get(folderName));
    }

    private Map initFileFilterMap() {
        HashMap<String, String> fileFilterMap;
        block8: {
            int i;
            int j;
            block9: {
                block7: {
                    fileFilterMap = new HashMap<String, String>();
                    j = EXCLUDE_FOLDERS.length;
                    for (i = 0; i < j; ++i) {
                        fileFilterMap.put(EXCLUDE_FOLDERS[i], "false");
                    }
                    j = EXCLUDE_FILES.length;
                    for (i = 0; i < j; ++i) {
                        fileFilterMap.put(EXCLUDE_FILES[i], "false");
                    }
                    if (!this.type.equals("Flash")) break block7;
                    j = FLASH.length;
                    for (i = 0; i < j; ++i) {
                        fileFilterMap.put(FLASH[i], "true");
                    }
                    break block8;
                }
                if (!this.type.equals("Images")) break block9;
                j = IMAGES.length;
                for (i = 0; i < j; ++i) {
                    fileFilterMap.put(IMAGES[i], "true");
                }
                break block8;
            }
            if (!this.type.equals("Files")) break block8;
            j = FLASH.length;
            for (i = 0; i < j; ++i) {
                fileFilterMap.put(FLASH[i], "true");
            }
            j = IMAGES.length;
            for (i = 0; i < j; ++i) {
                fileFilterMap.put(IMAGES[i], "true");
            }
            j = FILES.length;
            for (i = 0; i < j; ++i) {
                fileFilterMap.put(FILES[i], "true");
            }
        }
        return fileFilterMap;
    }

    public void onSelect$tree() {
        this.cntDiv.getChildren().clear();
        Treeitem item = this.tree.getSelectedItem();
        Map map = (Map)item.getValue();
        this.showImages(map);
    }

    private void showImages(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Object value = me.getValue();
            if (value instanceof Map) continue;
            String path = String.valueOf(value);
            String swfPath = "";
            if (path.endsWith("swf")) {
                swfPath = "~./ckez/img/flashIcon.jpg";
            }
            Toolbarbutton tb = new Toolbarbutton(String.valueOf(me.getKey()), "".equals(swfPath) ? path : swfPath);
            tb.addEventListener("onClick", new EventListener(){

                public void onEvent(Event event) throws Exception {
                    if (FilebrowserController.this.selBtn != null) {
                        FilebrowserController.this.selBtn.setSclass(null);
                    }
                    FilebrowserController.this.selBtn = (Toolbarbutton)event.getTarget();
                    FilebrowserController.this.selBtn.setSclass("sel");
                }
            });
            int CKEditorFuncNum = 1;
            CKEditorFuncNum = new Integer(((String[])this.param.get("CKEditorFuncNum"))[0]);
            String script = "window.opener.CKEDITOR.tools.callFunction(" + CKEditorFuncNum + ", '" + this.execution.encodeURL(path) + "'); window.close(); ";
            tb.setWidgetListener("onDoubleClick", script);
            this.cntDiv.appendChild((Component)tb);
        }
    }

    private class ExplorerTreeitemRenderer
    implements TreeitemRenderer {
        private ExplorerTreeitemRenderer() {
        }

        public void render(Treeitem item, Object data) throws Exception {
            Map.Entry entry = (Map.Entry)((DefaultTreeNode)data).getData();
            item.setLabel(String.valueOf(entry.getKey()));
            Object value = entry.getValue();
            item.setValue(value);
            item.setOpen(true);
            if (item.getParentItem() == null) {
                item.setSelected(true);
            }
        }

        public void render(Treeitem item, Object data, int index) throws Exception {
            this.render(item, data);
        }
    }
}

