/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.zkoss.util.CollectionsX;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeNode<E>
implements TreeNode<E>,
Comparable<DefaultTreeNode<E>>,
Cloneable,
Serializable {
    private DefaultTreeModel<E> _model;
    private DefaultTreeNode<E> _parent;
    private List<TreeNode<E>> _children;
    private E _data;
    private boolean _maxnull;

    public DefaultTreeNode(E data, Collection<? extends TreeNode<E>> children) {
        this(data, children, false);
    }

    public DefaultTreeNode(E data, Collection<? extends TreeNode<E>> children, boolean nullAsMax) {
        this._data = data;
        this._children = new TreeNodeChildrenList();
        if (children != null) {
            for (TreeNode<E> node : children) {
                this.add(node);
            }
        }
        this._maxnull = nullAsMax;
    }

    public DefaultTreeNode(E data, TreeNode<E>[] children) {
        this(data, (Collection<TreeNode<E>>)new CollectionsX.ArrayCollection((Object[])children));
    }

    public DefaultTreeNode(E data) {
        this(data, false);
    }

    public DefaultTreeNode(E data, boolean nullAsMax) {
        this._data = data;
        this._children = null;
        this._maxnull = nullAsMax;
    }

    public void removeFromParent() {
        if (this._parent != null) {
            this._parent.remove(this);
        }
    }

    @Override
    public DefaultTreeModel<E> getModel() {
        return this._parent != null ? this._parent.getModel() : this._model;
    }

    @Override
    public void setModel(DefaultTreeModel<E> model) {
        if (model != null && this._parent != null) {
            throw new IllegalStateException("Only root allowed, " + this);
        }
        this._model = model;
    }

    @Override
    public E getData() {
        return this._data;
    }

    @Override
    public void setData(E data) {
        this._data = data;
        DefaultTreeModel<E> model = this.getModel();
        TreeNode<E> parent = this.getParent();
        if (model != null && parent != null) {
            int index = parent.getIndex(this);
            model.fireEvent(0, model.getPath(parent), index, index);
        }
    }

    @Override
    public List<TreeNode<E>> getChildren() {
        return this.isLeaf() ? null : this._children;
    }

    @Override
    public TreeNode<E> getChildAt(int childIndex) {
        return childIndex >= 0 && childIndex < this.getChildCount() ? this._children.get(childIndex) : null;
    }

    @Override
    public int getChildCount() {
        return this.isLeaf() ? 0 : this._children.size();
    }

    @Override
    public TreeNode<E> getParent() {
        return this._parent;
    }

    protected void setParent(DefaultTreeNode<E> parent) {
        this._parent = parent;
    }

    @Override
    public int getIndex(TreeNode<E> node) {
        return this.isLeaf() ? -1 : this._children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this._children == null;
    }

    @Override
    public void insert(TreeNode<E> child, int index) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        this._children.add(index, child);
    }

    @Override
    public void add(TreeNode<E> child) {
        this.insert(child, this.getChildCount());
    }

    private static boolean isAncestor(TreeNode p, TreeNode c) {
        do {
            if (p != c) continue;
            return true;
        } while ((c = c.getParent()) != null);
        return false;
    }

    @Override
    public void remove(int index) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        this._children.remove(index);
    }

    @Override
    public void remove(TreeNode<E> child) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        if (!this._children.remove(child)) {
            throw new IllegalArgumentException("not a child of this node");
        }
    }

    @Override
    public int compareTo(DefaultTreeNode<E> node) {
        if (this._data == null) {
            return node == null ? 0 : (node.getData() == null ? 0 : (this._maxnull ? 1 : -1));
        }
        if (node == null) {
            return this._maxnull ? -1 : 1;
        }
        return ((Comparable)this._data).compareTo(node.getData());
    }

    @Override
    public Object clone() {
        DefaultTreeNode clone;
        try {
            clone = (DefaultTreeNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._parent = null;
        if (this._children != null) {
            TreeNodeChildrenList newkids;
            clone._children = newkids = clone.new TreeNodeChildrenList();
            for (TreeNode<E> node : this._children) {
                DefaultTreeNode child = (DefaultTreeNode)node.clone();
                child._parent = clone;
                newkids._list.add(child);
            }
        }
        return clone;
    }

    public String toString() {
        return this._data == null ? "(null)" : this._data.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TreeNodeChildrenList
    extends AbstractList<TreeNode<E>>
    implements Serializable {
        protected final ArrayList<TreeNode<E>> _list = new ArrayList();

        protected TreeNodeChildrenList() {
        }

        @Override
        public TreeNode<E> get(int index) {
            return this._list.get(index);
        }

        @Override
        public int size() {
            return this._list.size();
        }

        @Override
        public void add(int index, TreeNode<E> child) {
            DefaultTreeModel model;
            if (DefaultTreeNode.isAncestor(child, DefaultTreeNode.this)) {
                throw new IllegalArgumentException("New child is an ancestor");
            }
            TreeNode oldp = child.getParent();
            if (oldp != null) {
                oldp.remove(child);
            }
            this._list.add(index, child);
            if (child instanceof DefaultTreeNode) {
                ((DefaultTreeNode)child).setParent(DefaultTreeNode.this);
            }
            if ((model = DefaultTreeNode.this.getModel()) != null) {
                model.fireEvent(1, model.getPath(DefaultTreeNode.this), index, index);
            }
        }

        @Override
        public TreeNode<E> remove(int index) {
            DefaultTreeModel model = DefaultTreeNode.this.getModel();
            TreeNode child = this._list.get(index);
            int[] path = null;
            if (model != null) {
                path = model.getPath(child);
                model.removeSelectionPath(path);
                model.removeOpenPath(path);
            }
            this._list.remove(index);
            if (child instanceof DefaultTreeNode) {
                ((DefaultTreeNode)child).setParent(null);
            }
            if (model != null) {
                model.fireEvent(2, model.getPath(DefaultTreeNode.this), index, index);
            }
            return child;
        }

        @Override
        public boolean remove(Object child) {
            int index = this._list.indexOf(child);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            return true;
        }

        @Override
        void sort(Comparator cmpr) {
            Collections.sort(this._list, cmpr);
        }
    }
}

