/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.SimpleDoubleSpinnerConstraint;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Doublespinner
extends NumberInputElement {
    private double _step = 1.0;
    private boolean _btnVisible = true;

    public Doublespinner() {
        this.setCols(11);
    }

    public Doublespinner(double value) throws WrongValueException {
        this();
        this.setValue(new Double(value));
    }

    public Double getValue() throws WrongValueException {
        return (Double)this.getTargetValue();
    }

    public double doubleValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (Double)val : 0.0;
    }

    public void setValue(Double value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public double getStep() {
        return this._step;
    }

    public void setStep(double step) {
        if (Double.compare(this._step, step) != 0) {
            this._step = step;
            this.smartUpdate("step", this._step);
        }
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-doublespinner" : this._zclass;
    }

    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? new SimpleDoubleSpinnerConstraint(constr) : null);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            double v;
            double divscale;
            double d = divscale = vals[1] != null ? (double)((Integer)vals[1]).intValue() : 0.0;
            for (v = Double.parseDouble(val); v != 0.0; v /= 10.0) {
                double d2;
                divscale -= 1.0;
                if (!(d2 >= 0.0)) break;
            }
            return new Double(v);
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? (value instanceof Double ? Doublebox.toLocaleString((Double)value, this.getDefaultLocale()) : value.toString()) : this.formatNumber(value, null);
    }

    protected Object unmarshall(Object value) {
        if (value instanceof Integer) {
            return new Double(((Integer)value).doubleValue());
        }
        return value;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (Double.compare(this._step, 1.0) != 0) {
            renderer.render("step", this._step);
        }
        if (!this._btnVisible) {
            renderer.render("buttonVisible", this._btnVisible);
        }
    }
}

