/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.io.Files;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zk.ui.ext.Includer;
import org.zkoss.zk.ui.sys.ComponentRedraws;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Include
extends XulElement
implements Includer,
DynamicPropertied,
AfterCompose,
IdSpace {
    private static final Log log = Log.lookup(Include.class);
    private static final String ATTR_RENDERED = "org.zkoss.zul.Include.rendered";
    private String _src;
    private Map<String, Object> _dynams;
    private transient Page _childpg;
    private String _mode = Include.getDefaultMode();
    private String _renderResult;
    private boolean _localized;
    private boolean _progressing;
    private boolean _afterComposed;
    private boolean _instantMode;
    private boolean _comment;
    private byte _progressStatus;
    private static String _defMode;

    public Include() {
        this.setAttribute("z$is", Boolean.TRUE);
    }

    public Include(String src) {
        this();
        this.setSrc(src);
    }

    public void setProgressing(boolean progressing) {
        if (this._progressing != progressing) {
            if (progressing && "instant".equals(this._mode)) {
                throw new UnsupportedOperationException("progressing not allowed in instant mode");
            }
            this._progressing = progressing;
            this.fixMode();
            this.checkProgressing();
            if (!this._instantMode) {
                this.getChildren().clear();
                this.invalidate();
            } else {
                super.invalidate();
            }
        }
    }

    public boolean getProgressing() {
        return this._progressing;
    }

    public void onEchoInclude() {
        Clients.clearBusy();
        super.invalidate();
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.fixMode();
            if (!this._instantMode) {
                this.invalidate();
            } else {
                super.invalidate();
            }
        }
    }

    public void detach() {
        if (this._childpg != null) {
            this._childpg.removeComponents();
            this._childpg = null;
        }
        super.detach();
    }

    public String getMode() {
        return this._mode;
    }

    public void setMode(String mode) throws WrongValueException {
        if (!this._mode.equals(mode)) {
            if (!("auto".equals(mode) || "instant".equals(mode) || "defer".equals(mode))) {
                throw new WrongValueException("Unknown mode: " + mode);
            }
            if ((this._localized || this._progressing) && "instant".equals(mode)) {
                throw new UnsupportedOperationException("localized/progressing not allowed in the instant mode");
            }
            this._mode = mode;
            this.fixMode();
            if (!this._instantMode) {
                this.invalidate();
            } else {
                super.invalidate();
            }
        }
    }

    private void fixMode() {
        this.fixModeOnly();
        this.applyChangesToContent();
    }

    private void fixModeOnly() {
        this._instantMode = "auto".equals(this._mode) ? (this._src != null && !this._progressing && !this._localized ? this._src.endsWith(".zul") || this._src.endsWith(".zhtml") : false) : "instant".equals(this._mode);
    }

    private void applyChangesToContent() {
        if (this._instantMode && this._afterComposed) {
            this.afterCompose();
        } else if (this._src == null && !this.getChildren().isEmpty()) {
            this.getChildren().clear();
        }
    }

    public boolean isLocalized() {
        return this._localized;
    }

    public void setLocalized(boolean localized) {
        if (this._localized != localized) {
            if (localized && "instant".equals(this._mode)) {
                throw new UnsupportedOperationException("localized not supported in instant mode yet");
            }
            this._localized = localized;
            if (this._localized) {
                this.fixMode();
            }
            if (!this._instantMode) {
                this.invalidate();
            } else {
                super.invalidate();
            }
        }
    }

    public boolean isComment() {
        return this._comment;
    }

    public void setComment(boolean comment) {
        this._comment = comment;
    }

    public Page getChildPage() {
        return this._childpg;
    }

    public void setChildPage(Page page) {
        Desktop desktop;
        if (this._childpg != null && page == null && (desktop = this.getDesktop()) != null) {
            ((DesktopCtrl)desktop).removePage(this._childpg);
        }
        this._childpg = page;
    }

    public void setRenderingResult(String result) {
        this._renderResult = result;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        if (newpage != null) {
            Events.postEvent((String)"onAfterCompose", (Component)this, null);
        }
        super.onPageAttached(newpage, oldpage);
    }

    public void onAfterCompose() {
        if (!this._afterComposed) {
            this.afterCompose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompose() {
        this._afterComposed = true;
        this.fixModeOnly();
        if (this._instantMode) {
            Execution exec = this.getExecution();
            Map<String, Object> old = this.setupDynams(exec);
            String attrRenderedKey = "org.zkoss.zul.Include.rendered$" + this.getUuid();
            String oldSrc = (String)exec.getAttribute(attrRenderedKey);
            if (!Objects.equals((Object)oldSrc, (Object)this._src)) {
                try {
                    this.getChildren().clear();
                    int j = this._src.indexOf(63);
                    exec.createComponents(j >= 0 ? this._src.substring(0, j) : this._src, (Component)this, this._dynams);
                    exec.setAttribute(attrRenderedKey, (Object)this._src);
                }
                finally {
                    Include.restoreDynams(exec, old);
                }
            }
        } else {
            this.getChildren().clear();
        }
    }

    private Execution getExecution() {
        Desktop desktop = this.getDesktop();
        return desktop != null ? desktop.getExecution() : Executions.getCurrent();
    }

    public boolean hasDynamicProperty(String name) {
        return this._dynams != null && this._dynams.containsKey(name);
    }

    public Object getDynamicProperty(String name) {
        return this._dynams != null ? this._dynams.get(name) : null;
    }

    public void setDynamicProperty(String name, Object value) {
        if (this._dynams == null) {
            this._dynams = new HashMap<String, Object>();
        }
        this._dynams.put(name, value);
    }

    public void clearDynamicProperties() {
        this._dynams = null;
    }

    public void invalidate() {
        super.invalidate();
        this.applyChangesToContent();
        if (this._progressStatus >= 2) {
            this._progressStatus = 0;
        }
        this.checkProgressing();
    }

    private void checkProgressing() {
        if (this._progressing && this._progressStatus == 0) {
            this._progressStatus = 1;
            Clients.showBusy((String)Messages.get((int)MZul.PLEASE_WAIT));
            Events.echoEvent((String)"onEchoInclude", (Component)this, null);
        }
    }

    protected boolean isChildable() {
        return this._instantMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.setChildPage(null);
        this.render(renderer, "comment", this._comment);
        if (this._instantMode && this._afterComposed) {
            return;
        }
        UiEngine ueng = ((WebAppCtrl)this.getDesktop().getWebApp()).getUiEngine();
        Component old = ueng.setOwner((Component)this);
        try {
            if (this._progressStatus == 1) {
                this._progressStatus = (byte)2;
            } else if (this._src != null && this._src.length() > 0) {
                HtmlPageRenders.RenderContext rc;
                StringWriter sw = new StringWriter();
                this.include(sw);
                StringBuffer incsb = sw.getBuffer();
                if (this.getChildPage() == null && !Utils.testAttribute((Component)this, "org.zkoss.zul.include.html.defer", false, true) && (rc = HtmlPageRenders.getRenderContext(null)) != null && !rc.included) {
                    Writer cwout = rc.temp;
                    cwout.write("<div id=\"");
                    cwout.write(this.getUuid());
                    cwout.write("\" style=\"display:none\">");
                    if (this._comment) {
                        cwout.write("\n<!--\n");
                    }
                    Files.write((Writer)cwout, (StringBuffer)incsb);
                    if (this._comment) {
                        cwout.write("\n-->\n");
                    }
                    cwout.write("</div>");
                    renderer.render("_xcnt", (Object)new JavaScriptValue("zk('" + this.getUuid() + "').detachChildren()"));
                    return;
                }
                renderer.render("_xcnt", incsb.toString());
                if (this._renderResult != null && this._renderResult.length() > 0) {
                    renderer.renderDirectly("_childjs", (Object)("function(){" + this._renderResult + '}'));
                }
            }
        }
        finally {
            this._renderResult = null;
            ueng.setOwner(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void include(Writer out) throws IOException {
        desktop = this.getDesktop();
        exec = this.getExecution();
        src = exec.toAbsoluteURI(this._src, false);
        old = this.setupDynams(exec);
        ComponentRedraws.beforeRedraw((boolean)true);
        try {
            exec.include(out, src, null, 0);
        }
        catch (Throwable err) {
            this.setChildPage(null);
            errpg = desktop.getWebApp().getConfiguration().getErrorPage(desktop.getDeviceType(), err);
            if (errpg == null) ** GOTO lbl-1000
            try {
                exec.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                exec.setAttribute("javax.servlet.error.exception", (Object)err);
                exec.setAttribute("javax.servlet.error.exception_type", err.getClass());
                exec.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                exec.include(out, errpg, null, 0);
                return;
            }
            catch (IOException ex) {
            }
            catch (Throwable ex) {
                Include.log.warning("Failed to load the error page: " + errpg, ex);
            }
lbl-1000:
            // 3 sources

            {
                msg = Messages.get((int)MZk.PAGE_FAILED, (Object[])new Object[]{src, Exceptions.getMessage((Throwable)err), Exceptions.formatStackTrace(null, (Throwable)err, null, (int)6)});
                attrs = new HashMap<String, String>();
                attrs.put("px_alert_type", "error");
                attrs.put("px_alert", msg);
                exec.include(out, "~./html/alert.dsp", attrs, 3);
            }
        }
        finally {
            ComponentRedraws.afterRedraw();
            Include.restoreDynams(exec, old);
        }
    }

    private Map<String, Object> setupDynams(Execution exec) {
        if (this._dynams == null || this._dynams.isEmpty()) {
            return null;
        }
        HashMap<String, Object> old = new HashMap<String, Object>();
        for (Map.Entry<String, Object> me : this._dynams.entrySet()) {
            String nm = me.getKey();
            Object val = me.getValue();
            old.put(nm, exec.getAttribute(nm));
            if (val != null) {
                exec.setAttribute(nm, val);
                continue;
            }
            exec.removeAttribute(nm);
        }
        return old;
    }

    private static void restoreDynams(Execution exec, Map<String, Object> old) {
        if (old != null) {
            for (Map.Entry<String, Object> me : old.entrySet()) {
                String nm = me.getKey();
                Object val = me.getValue();
                if (val != null) {
                    exec.setAttribute(nm, val);
                    continue;
                }
                exec.removeAttribute(nm);
            }
        }
    }

    private static String getDefaultMode() {
        if (_defMode == null) {
            _defMode = Library.getProperty((String)"org.zkoss.zul.include.mode", (String)"auto");
        }
        return _defMode;
    }
}

