/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ext.Sortable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListModelList<E>
extends AbstractListModel<E>
implements Sortable<E>,
List<E>,
Serializable {
    private static final long serialVersionUID = 20120206122641L;
    protected List<E> _list;
    private Comparator<E> _sorting;
    private boolean _sortDir;

    public ListModelList(List<E> list, boolean live) {
        this._list = live ? list : new ArrayList(list);
    }

    public ListModelList() {
        this._list = new ArrayList();
    }

    public ListModelList(Collection<? extends E> c) {
        this._list = new ArrayList<E>(c);
    }

    public ListModelList(E[] array) {
        this._list = new ArrayList(array.length);
        for (int j = 0; j < array.length; ++j) {
            this._list.add(array[j]);
        }
    }

    public ListModelList(int initialCapacity) {
        this._list = new ArrayList(initialCapacity);
    }

    public void removeRange(int fromIndex, int toIndex) {
        int index;
        if (fromIndex > toIndex) {
            throw new UiException("fromIndex must less than toIndex: fromIndex: " + fromIndex + ", toIndex: " + toIndex);
        }
        if (fromIndex == toIndex) {
            return;
        }
        int sz = this._list.size();
        if (sz == fromIndex) {
            return;
        }
        ListIterator<E> it = this._list.listIterator(fromIndex);
        for (index = fromIndex; it.hasNext() && index < toIndex; ++index) {
            Object obj = it.next();
            this.removeFromSelection(obj);
            it.remove();
        }
        this.fireEvent(2, fromIndex, index - 1);
    }

    public List<E> getInnerList() {
        return this._list;
    }

    @Override
    public int getSize() {
        return this._list.size();
    }

    @Override
    public E getElementAt(int j) {
        return this._list.get(j);
    }

    @Override
    public void add(int index, E element) {
        this._list.add(index, element);
        this.fireEvent(1, index, index);
    }

    @Override
    public boolean add(E o) {
        int i1 = this._list.size();
        boolean ret = this._list.add(o);
        this.fireEvent(1, i1, i1);
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int sz = c.size();
        if (sz <= 0) {
            return false;
        }
        int i1 = this._list.size();
        int i2 = i1 + sz - 1;
        boolean ret = this._list.addAll(c);
        this.fireEvent(1, i1, i2);
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int sz = c.size();
        if (sz <= 0) {
            return false;
        }
        int i2 = index + sz - 1;
        boolean ret = this._list.addAll(index, c);
        this.fireEvent(1, index, i2);
        return ret;
    }

    @Override
    public void clear() {
        int i2 = this._list.size() - 1;
        if (i2 < 0) {
            return;
        }
        this.clearSelection();
        this._list.clear();
        this.fireEvent(2, 0, i2);
    }

    @Override
    public boolean contains(Object elem) {
        boolean ret = this._list.contains(elem);
        return ret;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return ((Object)this._list).equals(o instanceof ListModelList ? ((ListModelList)o)._list : o);
    }

    @Override
    public E get(int index) {
        return this._list.get(index);
    }

    @Override
    public int hashCode() {
        return ((Object)this._list).hashCode();
    }

    public String toString() {
        return this._list.toString();
    }

    @Override
    public int indexOf(Object elem) {
        return this._list.indexOf(elem);
    }

    @Override
    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Iterator<E> _it;
            private E _current;
            private int _nextIndex;
            {
                this._it = ListModelList.this._list.iterator();
                this._current = null;
            }

            @Override
            public boolean hasNext() {
                return this._it.hasNext();
            }

            @Override
            public E next() {
                this._current = this._it.next();
                ++this._nextIndex;
                return this._current;
            }

            @Override
            public void remove() {
                this._it.remove();
                ListModelList.this.removeFromSelection(this._current);
                --this._nextIndex;
                ListModelList.this.fireEvent(2, this._nextIndex, this._nextIndex);
            }
        };
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this._list.lastIndexOf(elem);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            private ListIterator<E> _it;
            private E _current;
            {
                this._it = ListModelList.this._list.listIterator(index);
                this._current = null;
            }

            @Override
            public boolean hasNext() {
                return this._it.hasNext();
            }

            @Override
            public E next() {
                this._current = this._it.next();
                return this._current;
            }

            @Override
            public void remove() {
                this._it.remove();
                ListModelList.this.removeFromSelection(this._current);
                int index2 = this._it.nextIndex();
                ListModelList.this.fireEvent(2, index2, index2);
            }

            @Override
            public void add(E arg0) {
                int index2 = this._it.nextIndex();
                this._it.add(arg0);
                ListModelList.this.fireEvent(1, index2, index2);
            }

            @Override
            public boolean hasPrevious() {
                return this._it.hasPrevious();
            }

            @Override
            public int nextIndex() {
                return this._it.nextIndex();
            }

            @Override
            public E previous() {
                this._current = this._it.previous();
                return this._current;
            }

            @Override
            public int previousIndex() {
                return this._it.previousIndex();
            }

            @Override
            public void set(E arg0) {
                this._it.set(arg0);
                int index2 = this._it.nextIndex() - 1;
                ListModelList.this.fireEvent(0, index2, index2);
            }
        };
    }

    @Override
    public E remove(int index) {
        E ret = this._list.remove(index);
        this.removeFromSelection(ret);
        this.fireEvent(2, index, index);
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this._list == c || this == c) {
            this.clearSelection();
            this.clear();
            return true;
        }
        return this.removePartial(c, true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this._list == c || this == c) {
            return false;
        }
        return this.removePartial(c, false);
    }

    private boolean removePartial(Collection<?> c, boolean exclude) {
        boolean removed = false;
        int index = 0;
        int begin = -1;
        ArrayList<E> selected = new ArrayList<E>();
        Iterator<E> it = this._list.iterator();
        while (it.hasNext()) {
            E item = it.next();
            if (c.contains(item) == exclude) {
                if (begin < 0) {
                    begin = index;
                }
                removed = true;
                it.remove();
                if (this._selection.contains(item)) {
                    selected.add(item);
                }
            } else if (begin >= 0) {
                this.fireEvent(2, begin, index - 1);
                index = begin;
                begin = -1;
            }
            ++index;
        }
        if (!selected.isEmpty()) {
            this.removeAllSelection(selected);
        }
        if (begin >= 0) {
            this.fireEvent(2, begin, index - 1);
        }
        return removed;
    }

    @Override
    public E set(int index, E element) {
        E ret = this._list.set(index, element);
        this.fireEvent(0, index, index);
        return ret;
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List<E> list = this._list.subList(fromIndex, toIndex);
        return new ListModelList<E>(list, true);
    }

    @Override
    public Object[] toArray() {
        return this._list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._list.toArray(a);
    }

    @Override
    public void sort(Comparator<E> cmpr, boolean ascending) {
        this._sorting = cmpr;
        this._sortDir = ascending;
        Collections.sort(this._list, cmpr);
        this.fireEvent(3, -1, -1);
    }

    @Override
    public String getSortDirection(Comparator<E> cmpr) {
        if (Objects.equals(this._sorting, cmpr)) {
            return this._sortDir ? "ascending" : "descending";
        }
        return "natural";
    }

    @Override
    public Object clone() {
        ListModelList clone = (ListModelList)super.clone();
        if (this._list != null) {
            clone._list = new ArrayList<E>(this._list);
        }
        return clone;
    }

    @Override
    protected void fireSelectionEvent(E e) {
        this.fireEvent(4, this.indexOf(e), -1);
    }

    public void addSelection(E obj) {
        this.addToSelection(obj);
    }

    public void removeSelection(Object obj) {
        this.removeFromSelection(obj);
    }
}

