/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel.impl.lang;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import org.zkoss.zel.ELException;
import org.zkoss.zel.impl.lang.ELArithmetic;
import org.zkoss.zel.impl.util.MessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELSupport {
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    protected static final boolean COERCE_NULL_TO_NULL = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.valueOf(System.getProperty("org.zkoss.zel.impl.parser.COERCE_NULL_TO_NULL", "true"));
        }
    }).booleanValue() : Boolean.valueOf(System.getProperty("org.zkoss.zel.impl.parser.COERCE_NULL_TO_NULL", "true")).booleanValue();
    private static final Long ZERO = 0L;

    public static final int compare(Object obj0, Object obj1) throws ELException {
        if (obj0 == obj1 || ELSupport.equals(obj0, obj1)) {
            return 0;
        }
        if (ELSupport.isBigDecimalOp(obj0, obj1)) {
            BigDecimal bd0 = (BigDecimal)ELSupport.coerceToNumber(obj0, BigDecimal.class);
            BigDecimal bd1 = (BigDecimal)ELSupport.coerceToNumber(obj1, BigDecimal.class);
            return bd0.compareTo(bd1);
        }
        if (ELSupport.isDoubleOp(obj0, obj1)) {
            Double d0 = (Double)ELSupport.coerceToNumber(obj0, Double.class);
            Double d1 = (Double)ELSupport.coerceToNumber(obj1, Double.class);
            return d0.compareTo(d1);
        }
        if (ELSupport.isBigIntegerOp(obj0, obj1)) {
            BigInteger bi0 = (BigInteger)ELSupport.coerceToNumber(obj0, BigInteger.class);
            BigInteger bi1 = (BigInteger)ELSupport.coerceToNumber(obj1, BigInteger.class);
            return bi0.compareTo(bi1);
        }
        if (ELSupport.isLongOp(obj0, obj1)) {
            Long l0 = (Long)ELSupport.coerceToNumber(obj0, Long.class);
            Long l1 = (Long)ELSupport.coerceToNumber(obj1, Long.class);
            return l0.compareTo(l1);
        }
        if (obj0 instanceof String || obj1 instanceof String) {
            return ELSupport.coerceToString(obj0).compareTo(ELSupport.coerceToString(obj1));
        }
        if (obj0 instanceof Comparable) {
            Comparable comparable = (Comparable)obj0;
            return obj1 != null ? comparable.compareTo(obj1) : 1;
        }
        if (obj1 instanceof Comparable) {
            Comparable comparable = (Comparable)obj1;
            return obj0 != null ? -comparable.compareTo(obj0) : -1;
        }
        throw new ELException(MessageFactory.get("error.compare", obj0, obj1));
    }

    public static final boolean equals(Object obj0, Object obj1) throws ELException {
        if (obj0 == obj1) {
            return true;
        }
        if (obj0 == null || obj1 == null) {
            return false;
        }
        if (obj0 instanceof Boolean || obj1 instanceof Boolean) {
            return ELSupport.coerceToBoolean(obj0).equals(ELSupport.coerceToBoolean(obj1));
        }
        if (obj0.getClass().isEnum()) {
            return obj0.equals(ELSupport.coerceToEnum(obj1, obj0.getClass()));
        }
        if (obj1.getClass().isEnum()) {
            return obj1.equals(ELSupport.coerceToEnum(obj0, obj1.getClass()));
        }
        if (obj0 instanceof String || obj1 instanceof String) {
            int lexCompare = ELSupport.coerceToString(obj0).compareTo(ELSupport.coerceToString(obj1));
            return lexCompare == 0;
        }
        if (ELSupport.isBigDecimalOp(obj0, obj1)) {
            BigDecimal bd0 = (BigDecimal)ELSupport.coerceToNumber(obj0, BigDecimal.class);
            BigDecimal bd1 = (BigDecimal)ELSupport.coerceToNumber(obj1, BigDecimal.class);
            return bd0.equals(bd1);
        }
        if (ELSupport.isDoubleOp(obj0, obj1)) {
            Double d0 = (Double)ELSupport.coerceToNumber(obj0, Double.class);
            Double d1 = (Double)ELSupport.coerceToNumber(obj1, Double.class);
            return d0.equals(d1);
        }
        if (ELSupport.isBigIntegerOp(obj0, obj1)) {
            BigInteger bi0 = (BigInteger)ELSupport.coerceToNumber(obj0, BigInteger.class);
            BigInteger bi1 = (BigInteger)ELSupport.coerceToNumber(obj1, BigInteger.class);
            return bi0.equals(bi1);
        }
        if (ELSupport.isLongOp(obj0, obj1)) {
            Long l0 = (Long)ELSupport.coerceToNumber(obj0, Long.class);
            Long l1 = (Long)ELSupport.coerceToNumber(obj1, Long.class);
            return l0.equals(l1);
        }
        return obj0.equals(obj1);
    }

    public static final Enum<?> coerceToEnum(Object obj, Class type) {
        Object result;
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (type.isAssignableFrom(obj.getClass())) {
            return (Enum)obj;
        }
        if (!(obj instanceof String)) {
            throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
        }
        try {
            result = Enum.valueOf(type, (String)obj);
        }
        catch (IllegalArgumentException iae) {
            throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type), iae);
        }
        return result;
    }

    public static final Boolean coerceToBoolean(Object obj) throws ELException {
        if (obj == null || "".equals(obj)) {
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), Boolean.class));
    }

    public static final Character coerceToCharacter(Object obj) throws ELException {
        if (obj == null || "".equals(obj)) {
            return Character.valueOf('\u0000');
        }
        if (obj instanceof String) {
            return Character.valueOf(((String)obj).charAt(0));
        }
        if (ELArithmetic.isNumber(obj)) {
            return Character.valueOf((char)((Number)obj).shortValue());
        }
        Class<?> objType = obj.getClass();
        if (obj instanceof Character) {
            return (Character)obj;
        }
        throw new ELException(MessageFactory.get("error.convert", obj, objType, Character.class));
    }

    protected static final Number coerceToNumber(Number number, Class<?> type) throws ELException {
        if (Long.TYPE == type || Long.class.equals(type)) {
            return number.longValue();
        }
        if (Double.TYPE == type || Double.class.equals(type)) {
            return new Double(number.doubleValue());
        }
        if (Integer.TYPE == type || Integer.class.equals(type)) {
            return number.intValue();
        }
        if (BigInteger.class.equals(type)) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            if (number instanceof BigInteger) {
                return number;
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (BigDecimal.class.equals(type)) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        if (Byte.TYPE == type || Byte.class.equals(type)) {
            return number.byteValue();
        }
        if (Short.TYPE == type || Short.class.equals(type)) {
            return number.shortValue();
        }
        if (Float.TYPE == type || Float.class.equals(type)) {
            return new Float(number.floatValue());
        }
        if (Number.class.equals(type)) {
            return number;
        }
        throw new ELException(MessageFactory.get("error.convert", number, number.getClass(), type));
    }

    public static final Number coerceToNumber(Object obj, Class<?> type) throws ELException {
        if (obj == null || "".equals(obj)) {
            return ELSupport.coerceToNumber(ZERO, type);
        }
        if (obj instanceof String) {
            return ELSupport.coerceToNumber((String)obj, type);
        }
        if (ELArithmetic.isNumber(obj)) {
            return ELSupport.coerceToNumber((Number)obj, type);
        }
        if (obj instanceof Character) {
            return ELSupport.coerceToNumber((short)((Character)obj).charValue(), type);
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
    }

    protected static final Number coerceToNumber(String val, Class<?> type) throws ELException {
        if (Long.TYPE == type || Long.class.equals(type)) {
            try {
                return Long.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type), nfe);
            }
        }
        if (Integer.TYPE == type || Integer.class.equals(type)) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type), nfe);
            }
        }
        if (Double.TYPE == type || Double.class.equals(type)) {
            try {
                return Double.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type), nfe);
            }
        }
        if (BigInteger.class.equals(type)) {
            try {
                return new BigInteger(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type), nfe);
            }
        }
        if (BigDecimal.class.equals(type)) {
            try {
                return new BigDecimal(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type), nfe);
            }
        }
        if (Byte.TYPE == type || Byte.class.equals(type)) {
            try {
                return Byte.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type), nfe);
            }
        }
        if (Short.TYPE == type || Short.class.equals(type)) {
            try {
                return Short.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type), nfe);
            }
        }
        if (Float.TYPE == type || Float.class.equals(type)) {
            try {
                return Float.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type), nfe);
            }
        }
        throw new ELException(MessageFactory.get("error.convert", val, String.class, type), new NumberFormatException());
    }

    public static final String coerceToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        return obj.toString();
    }

    protected static final Object coerceToTypeForSetValue(Object obj, Class<?> type) throws ELException {
        if (type == null || Object.class.equals(type) || obj != null && type.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (String.class.equals(type)) {
            return obj == null && COERCE_NULL_TO_NULL ? null : ELSupport.coerceToString(obj);
        }
        if (ELArithmetic.isNumberType(type)) {
            return (obj == null || "".equals(obj)) && !type.isPrimitive() && COERCE_NULL_TO_NULL ? (Number)null : (Number)ELSupport.coerceToNumber(obj, type);
        }
        if (Character.class.equals(type) || Character.TYPE == type) {
            return (obj == null || "".equals(obj)) && !type.isPrimitive() && COERCE_NULL_TO_NULL ? null : ELSupport.coerceToCharacter(obj);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE == type) {
            return (obj == null || "".equals(obj)) && COERCE_NULL_TO_NULL ? null : ELSupport.coerceToBoolean(obj);
        }
        if (type.isEnum()) {
            return ELSupport.coerceToEnum(obj, type);
        }
        if (ELSupport.isDateTimeType(type)) {
            return ELSupport.coerceToDateTime(obj, type);
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            if ("".equals(obj)) {
                return null;
            }
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor != null) {
                editor.setAsText((String)obj);
                return editor.getValue();
            }
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
    }

    public static final Object coerceToType(Object obj, Class<?> type) throws ELException {
        if (type == null || Object.class.equals(type) || obj != null && type.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (String.class.equals(type)) {
            return ELSupport.coerceToString(obj);
        }
        if (ELArithmetic.isNumberType(type)) {
            return ELSupport.coerceToNumber(obj, type);
        }
        if (Character.class.equals(type) || Character.TYPE == type) {
            return ELSupport.coerceToCharacter(obj);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE == type) {
            return ELSupport.coerceToBoolean(obj);
        }
        if (type.isEnum()) {
            return ELSupport.coerceToEnum(obj, type);
        }
        if (ELSupport.isDateTimeType(type)) {
            return ELSupport.coerceToDateTime(obj, type);
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            if ("".equals(obj)) {
                return null;
            }
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor != null) {
                editor.setAsText((String)obj);
                return editor.getValue();
            }
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
    }

    public static final boolean isBigDecimalOp(Object obj0, Object obj1) {
        return obj0 instanceof BigDecimal || obj1 instanceof BigDecimal;
    }

    public static final boolean isBigIntegerOp(Object obj0, Object obj1) {
        return obj0 instanceof BigInteger || obj1 instanceof BigInteger;
    }

    public static final boolean isDoubleOp(Object obj0, Object obj1) {
        return obj0 instanceof Double || obj1 instanceof Double || obj0 instanceof Float || obj1 instanceof Float;
    }

    public static final boolean isLongOp(Object obj0, Object obj1) {
        return obj0 instanceof Long || obj1 instanceof Long || obj0 instanceof Integer || obj1 instanceof Integer || obj0 instanceof Character || obj1 instanceof Character || obj0 instanceof Short || obj1 instanceof Short || obj0 instanceof Byte || obj1 instanceof Byte;
    }

    public static final boolean isStringFloat(String str) {
        int len = str.length();
        if (len > 1) {
            for (int i = 0; i < len; ++i) {
                switch (str.charAt(i)) {
                    case 'E': {
                        return true;
                    }
                    case 'e': {
                        return true;
                    }
                    case '.': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static final boolean isDateTimeType(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    public static final Date coerceToDateTime(Object obj, Class type) throws ELException {
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (type.isAssignableFrom(obj.getClass())) {
            return (Date)obj;
        }
        try {
            if (obj instanceof Date) {
                return ELSupport.newDateInstance(((Date)obj).getTime(), type);
            }
            if (obj instanceof Number) {
                return ELSupport.newDateInstance(((Number)obj).longValue(), type);
            }
        }
        catch (Exception e) {
            throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type), e);
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
    }

    private static Date newDateInstance(long time, Class type) throws Exception {
        Constructor ctr = type.getConstructor(Long.TYPE);
        return (Date)ctr.newInstance(time);
    }
}

