/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class FormatedNumberConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        String formatPtn = (String)ctx.getConverterArg("format");
        if (formatPtn == null) {
            throw new NullPointerException("format attribute not found");
        }
        return val == null ? null : FormatedNumberConverter.getLocalizedDecimalFormat(formatPtn).format((Number)val);
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        String format = (String)ctx.getConverterArg("format");
        if (format == null) {
            throw new NullPointerException("format attribute not found");
        }
        try {
            return val == null ? (Number)null : (Number)FormatedNumberConverter.getLocalizedDecimalFormat(format).parse((String)val);
        }
        catch (ParseException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    private static DecimalFormat getLocalizedDecimalFormat(String pattern) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locales.getCurrent());
        df.applyLocalizedPattern(pattern);
        return df;
    }
}

