/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.ext.Selectable;

public class RadiogroupSelectedItemConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 200808191534L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        Radiogroup radiogroup = (Radiogroup)comp;
        ListModel model = radiogroup.getModel();
        if (model != null && !(model instanceof Selectable)) {
            throw new UiException("model doesn't implement Selectable");
        }
        if (val != null) {
            if (model != null) {
                ((Selectable)model).addToSelection(val);
                return IGNORED_VALUE;
            }
            for (Radio radio : radiogroup.getItems()) {
                String value = (String)radio.getValue();
                if (!val.equals(value)) continue;
                return radio;
            }
        }
        if (model != null) {
            Set sels = ((Selectable)model).getSelection();
            if (sels != null && sels.size() > 0) {
                ((Selectable)model).clearSelection();
            }
            return IGNORED_VALUE;
        }
        return null;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        if (val != null) {
            ListModel model = ((Radio)val).getRadiogroup().getModel();
            if (model != null && !(model instanceof Selectable)) {
                throw new UiException("model doesn't implement Selectable");
            }
            if (model != null) {
                Set selection = ((Selectable)model).getSelection();
                if (selection == null || selection.size() == 0) {
                    return null;
                }
                return selection.iterator().next();
            }
            return ((Radio)val).getValue();
        }
        return null;
    }
}

