/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.lang.Classes;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.ext.TreeSelectableModel;

public class TreeSelectedItemsConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 201108171811L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        Set vals;
        Tree tree = (Tree)comp;
        TreeModel model = tree.getModel();
        if (model != null && !(model instanceof TreeSelectableModel)) {
            throw new UiException("model doesn't implement " + TreeSelectableModel.class);
        }
        TreeSelectableModel smodel = (TreeSelectableModel)model;
        HashSet<Treeitem> items = new HashSet<Treeitem>();
        Set set = vals = val == null ? null : (Set)Classes.coerce(HashSet.class, (Object)val);
        if (smodel != null && !smodel.isSelectionEmpty()) {
            smodel.clearSelection();
        }
        if (vals != null && vals.size() > 0) {
            if (model != null) {
                for (Object v : vals) {
                    int[] path = model.getPath(v);
                    if (!(path != null & smodel != null)) continue;
                    smodel.addSelectionPath(path);
                }
                return IGNORED_VALUE;
            }
            for (Treeitem ti : tree.getItems()) {
                Object bean = ti.getValue();
                if (!vals.contains(bean)) continue;
                items.add(ti);
                vals.remove(bean);
                if (!vals.isEmpty()) continue;
                break;
            }
        }
        return smodel == null ? items : IGNORED_VALUE;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        HashSet<Object> vals;
        block3: {
            block4: {
                vals = new HashSet<Object>();
                if (val == null) break block3;
                Tree tree = (Tree)comp;
                TreeModel model = tree.getModel();
                if (model != null && !(model instanceof TreeSelectableModel)) {
                    throw new UiException("model doesn't implement TreeSelectableModel");
                }
                if (model == null) break block4;
                int[][] paths = ((TreeSelectableModel)model).getSelectionPaths();
                if (paths == null || paths.length <= 0) break block3;
                for (int[] path : paths) {
                    vals.add(model.getChild(path));
                }
                break block3;
            }
            Set items = (Set)Classes.coerce(HashSet.class, (Object)val);
            for (Treeitem item : items) {
                vals.add(item.getValue());
            }
        }
        return vals;
    }
}

