/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Property;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindingImpl;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.zk.ui.Component;

public class ReferenceBindingImpl
extends BindingImpl
implements ReferenceBinding {
    private static final long serialVersionUID = 20120204122151L;
    private static final Object NULL_VALUE = new Object();
    private final ExpressionX _exprX;
    private transient Object _cacheValue;

    public ReferenceBindingImpl(Binder binder, String expression, Component comp) {
        super(binder, comp, null);
        BindContext ctx = this.newBindContext();
        this._exprX = binder.getEvaluatorX().parseExpressionX(ctx, expression, Object.class);
    }

    public Object getValue(BindELContext ctx) {
        this.load(null);
        return this._cacheValue == NULL_VALUE ? null : this._cacheValue;
    }

    public void setValue(BindELContext ctx, Object val) {
        this.invalidateCache();
        BindContext bctx = this.newBindContext();
        this.getBinder().getEvaluatorX().setValue(bctx, this.getComponent(), this._exprX, val);
        Set<Property> notifies = BindELContext.getNotifys(bctx);
        if (notifies != null) {
            BindELContext.addNotifys(notifies, ctx.getBindContext());
        }
    }

    private BindContext newBindContext() {
        return BindContextUtil.newBindContext(this.getBinder(), this, false, null, this.getComponent(), null);
    }

    public void load(BindContext ctx) {
        if (this._cacheValue == null) {
            BindContext bctx = this.newBindContext();
            Object val = this.getBinder().getEvaluatorX().getValue(bctx, this.getComponent(), this._exprX);
            this._cacheValue = val == null ? NULL_VALUE : val;
        }
    }

    public String getPropertyString() {
        return this.getPureExpressionString(this._exprX);
    }

    public void invalidateCache() {
        this._cacheValue = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ",component:" + this.getComponent();
    }

    ValueReference getValueReference() {
        BindContext bctx = this.newBindContext();
        return this.getBinder().getEvaluatorX().getValueReference(bctx, this.getComponent(), this._exprX);
    }
}

