/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Generics;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectEvent<T extends Component, E>
extends Event {
    private final Set<T> _selectedItems;
    private final Set<E> _selectedObjects;
    private final T _ref;
    private final int _keys;
    public static final int ALT_KEY = 1;
    public static final int CTRL_KEY = 2;
    public static final int SHIFT_KEY = 4;

    public static final <T extends Component, E> SelectEvent<T, E> getSelectEvent(AuRequest request) {
        return SelectEvent.getSelectEvent(request, null);
    }

    public static final <T extends Component, E> SelectEvent<T, E> getSelectEvent(AuRequest request, SelectedObjectHandler<T> handler) {
        Map<String, Object> data = request.getData();
        Desktop desktop = request.getDesktop();
        List sitems = Generics.cast((List)((List)data.get("items")));
        Set items = AuRequests.convertToItems(desktop, sitems);
        Set<Object> objs = handler == null ? null : handler.getObjects(items);
        return new SelectEvent<Component, Object>(request.getCommand(), request.getComponent(), items, objs, desktop.getComponentByUuidIfAny((String)data.get("reference")), null, AuRequests.parseKeys(data));
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems) {
        this(name, target, selectedItems, null, 0);
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems, T ref) {
        this(name, target, selectedItems, ref, 0);
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems, T ref, int keys) {
        this(name, target, selectedItems, null, ref, null, keys);
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems, Set<E> selectedObjects, T ref, Object data, int keys) {
        super(name, target, data);
        this._selectedItems = selectedItems != null ? selectedItems : Collections.emptySet();
        this._selectedObjects = selectedObjects != null ? selectedObjects : Collections.emptySet();
        this._ref = ref;
        this._keys = keys;
    }

    public final Set<T> getSelectedItems() {
        return this._selectedItems;
    }

    public final Set<E> getSelectedObjects() {
        return this._selectedObjects;
    }

    public T getReference() {
        return this._ref;
    }

    public final int getKeys() {
        return this._keys;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SelectedObjectHandler<T extends Component> {
        public Set<Object> getObjects(Set<T> var1);
    }
}

