/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.ext;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.impl.SimpleScope;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

public class Scopes {
    private static final Log log = Log.lookup(Scopes.class);
    private static final ThreadLocal<List<Implicit>> _implicits = new ThreadLocal();
    private static final ThreadLocal<List<Scope>> _scopes = new ThreadLocal();

    public static final Scope beforeInterpret(Scope scope) {
        if (scope == null) {
            scope = new SimpleScope(null);
        }
        Implicit impl = Scopes.beforeInterpret0(scope);
        impl.setImplicit("self", scope);
        if (scope instanceof Component) {
            impl.setImplicit("componentScope", new DeferredAttributes(scope));
        }
        return scope;
    }

    private static Implicit beforeInterpret0(Scope scope) {
        List<Implicit> impls = _implicits.get();
        if (impls == null) {
            impls = new LinkedList<Implicit>();
            _implicits.set(impls);
        }
        Implicit impl = new Implicit();
        impls.add(0, impl);
        Execution exec = Executions.getCurrent();
        impl.setImplicit("arg", exec != null ? exec.getArg() : null);
        Scopes.push(scope);
        return impl;
    }

    public static final void afterInterpret() {
        _implicits.get().remove(0);
        Scopes.pop();
    }

    public static void setImplicit(String name, Object value) {
        Scopes._implicits.get().get(0).setImplicit(name, value);
    }

    public static Object getImplicit(String name, Object defValue) {
        List<Implicit> implicits = _implicits.get();
        if (implicits != null && !implicits.isEmpty()) {
            return implicits.get(0).getImplicit(name, defValue);
        }
        Object val = Scopes.getSysImplicit(name);
        return val != null ? val : defValue;
    }

    private static Object getSysImplicit(String name) {
        Scope val = Scopes.getCurrent(null);
        return val instanceof Component ? Components.getImplicit((Component)val, name) : (val instanceof Page ? Components.getImplicit((Page)val, name) : null);
    }

    public static final Scope getCurrent(Page page) {
        Execution exec;
        Scope scope;
        List<Scope> nss = _scopes.get();
        Scope scope2 = scope = nss != null && !nss.isEmpty() ? nss.get(0) : null;
        if (scope != null) {
            return scope;
        }
        if (page == null && (exec = Executions.getCurrent()) != null) {
            page = ((ExecutionCtrl)((Object)exec)).getCurrentPage();
        }
        return page;
    }

    private static final void push(Scope scope) {
        List<Scope> nss = _scopes.get();
        if (nss == null) {
            nss = new LinkedList<Scope>();
            _scopes.set(nss);
        }
        nss.add(0, scope);
    }

    private static final void pop() {
        _scopes.get().remove(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeferredAttributes
    implements Map<String, Object> {
        private final Scope _scope;

        private DeferredAttributes(Scope scope) {
            this._scope = scope;
        }

        @Override
        public void clear() {
            this._scope.getAttributes().clear();
        }

        @Override
        public boolean containsKey(Object arg0) {
            return this._scope.getAttributes().containsKey(arg0);
        }

        @Override
        public boolean containsValue(Object arg0) {
            return this._scope.getAttributes().containsValue(arg0);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this._scope.getAttributes().entrySet();
        }

        @Override
        public Object get(Object arg0) {
            return this._scope.getAttributes().get(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this._scope.getAttributes().isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this._scope.getAttributes().keySet();
        }

        @Override
        public Object put(String arg0, Object arg1) {
            return this._scope.getAttributes().put(arg0, arg1);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> arg0) {
            this._scope.getAttributes().putAll(arg0);
        }

        @Override
        public Object remove(Object arg0) {
            return this._scope.getAttributes().remove(arg0);
        }

        @Override
        public int size() {
            return this._scope.getAttributes().size();
        }

        @Override
        public Collection<Object> values() {
            return this._scope.getAttributes().values();
        }

        @Override
        public int hashCode() {
            return ((Object)this._scope.getAttributes()).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return ((Object)this._scope.getAttributes()).equals(o instanceof DeferredAttributes ? ((DeferredAttributes)o)._scope.getAttributes() : o);
        }

        public String toString() {
            return this._scope.getAttributes().toString();
        }
    }

    private static interface Deferred {
        public Object getValue();
    }

    private static class Implicit {
        private final Map<String, Object> _vars = new HashMap<String, Object>();

        private Implicit() {
        }

        private void setImplicit(String name, Object value) {
            this._vars.put(name, value);
        }

        private Object getImplicit(String name, Object defValue) {
            Object val = this._vars.get(name);
            if (val != null || this._vars.containsKey(name)) {
                if (val instanceof Deferred) {
                    val = ((Deferred)val).getValue();
                    this._vars.put(name, val);
                }
                return val;
            }
            val = Scopes.getSysImplicit(name);
            return val != null ? val : defValue;
        }
    }
}

