/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Exceptions;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.DesktopRecycles;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DesktopRecycle;

public class DHtmlLayoutServlet
extends HttpServlet {
    private static final Log log = Log.lookup(DHtmlLayoutServlet.class);
    private WebManager _webman;
    private boolean _webmanCreated;
    private boolean _compress = true;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        String param = config.getInitParameter("log-level");
        if (param != null && param.length() > 0) {
            Level level = Log.getLevel((String)param);
            if (level != null) {
                Log.lookup((String)"org.zkoss").setLevel(level);
            } else {
                log.error("Unknown log-level: " + param);
            }
        }
        this._compress = (param = config.getInitParameter("compress")) == null || param.length() == 0 || "true".equals(param);
        ServletContext ctx = this.getServletContext();
        this._webman = WebManager.getWebManagerIfAny(ctx);
        String updateURI = Utils.checkUpdateURI(config.getInitParameter("update-uri"), "The update-uri parameter");
        if (this._webman == null) {
            log.warning("WebManager not initialized. Please check if HttpSessionListener is configured properly.");
            this._webman = new WebManager(ctx, updateURI);
            this._webmanCreated = true;
        } else {
            this._webman.setUpdateUri(updateURI);
        }
    }

    public void destroy() {
        if (this._webman != null) {
            if (this._webmanCreated) {
                this._webman.destroy();
            }
            this._webman = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            Session sess;
            boolean bRichlet;
            String path = Https.getThisPathInfo((ServletRequest)request);
            boolean bl = bRichlet = path != null && path.length() > 0;
            if (!bRichlet) {
                path = Https.getThisServletPath((ServletRequest)request);
            }
            if (!SessionsCtrl.requestEnter(sess = WebManager.getSession(this.getServletContext(), request))) {
                response.sendError(503, Messages.get((int)MZk.TOO_MANY_REQUESTS));
                return;
            }
            try {
                Object old;
                block10: {
                    old = I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, sess.getWebApp().getConfiguration().getResponseCharset());
                    try {
                        if (this.process(sess, request, response, path, bRichlet)) break block10;
                        this.handleError(sess, request, response, path, null);
                    }
                    catch (Throwable ex) {
                        try {
                            this.handleError(sess, request, response, path, ex);
                            break block11;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            I18Ns.cleanup((ServletRequest)request, old);
                        }
                    }
                }
                I18Ns.cleanup((ServletRequest)request, old);
            }
            finally {
                SessionsCtrl.requestExit(sess);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(Session sess, HttpServletRequest request, HttpServletResponse response, String path, boolean bRichlet) throws ServletException, IOException {
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Configuration config = wapp.getConfiguration();
        boolean bInclude = Servlets.isIncluded((ServletRequest)request);
        boolean compress = this._compress && !bInclude;
        Writer out = compress ? new StringWriter() : response.getWriter();
        DesktopRecycle dtrc = bInclude ? null : config.getDesktopRecycle();
        ServletContext ctx = this.getServletContext();
        Desktop desktop = dtrc != null ? DesktopRecycles.beforeService(dtrc, ctx, sess, request, response, path) : null;
        try {
            if (desktop != null) {
                Page page2 = Utils.getMainPage(desktop);
                if (page2 != null) {
                    ExecutionImpl exec = new ExecutionImpl(ctx, request, response, desktop, page2);
                    WebManager.setDesktop(request, desktop);
                    wappc.getUiEngine().recycleDesktop(exec, page2, out);
                } else {
                    desktop = null;
                }
            }
            if (desktop == null) {
                Page page3;
                desktop = this._webman.getDesktop(sess, (ServletRequest)request, (ServletResponse)response, path, true);
                if (desktop == null) {
                    boolean page2 = true;
                    return page2;
                }
                RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, request, PageDefinitions.getLocator(wapp, path));
                sess.setAttribute("org.zkoss.zk.gae.fix", new Integer(0));
                ((SessionCtrl)((Object)sess)).notifyClientRequest(true);
                UiFactory uf = wappc.getUiFactory();
                if (uf.isRichlet(ri, bRichlet)) {
                    Richlet richlet = uf.getRichlet(ri, path);
                    if (richlet == null) {
                        boolean bl = false;
                        return bl;
                    }
                    page3 = WebManager.newPage(uf, (RequestInfo)ri, richlet, (ServletResponse)response, path);
                    ExecutionImpl exec = new ExecutionImpl(ctx, request, response, desktop, page3);
                    wappc.getUiEngine().execNewPage((Execution)exec, richlet, page3, out);
                } else {
                    PageDefinition pagedef = uf.getPageDefinition(ri, path);
                    if (pagedef == null) {
                        boolean page3 = false;
                        return page3;
                    }
                    page3 = WebManager.newPage(uf, (RequestInfo)ri, pagedef, (ServletResponse)response, path);
                    ExecutionImpl exec = new ExecutionImpl(ctx, request, response, desktop, page3);
                    wappc.getUiEngine().execNewPage((Execution)exec, pagedef, page3, out);
                }
            }
            if (compress) {
                String result = ((StringWriter)out).toString();
                try {
                    byte[] bs;
                    ServletOutputStream os = response.getOutputStream();
                    byte[] data = result.getBytes(config.getResponseCharset());
                    if (data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
                        data = bs;
                    }
                    response.setContentLength(data.length);
                    os.write(data);
                    response.flushBuffer();
                }
                catch (IllegalStateException ex) {
                    response.getWriter().write(result);
                }
            }
        }
        finally {
            if (dtrc != null) {
                DesktopRecycles.afterService(dtrc, desktop);
            }
        }
        return true;
    }

    private void handleError(Session sess, HttpServletRequest request, HttpServletResponse response, String path, Throwable err) throws ServletException, IOException {
        String errpg;
        Utils.resetOwner();
        if (err != null && Servlets.isIncluded((ServletRequest)request) && (errpg = sess.getWebApp().getConfiguration().getErrorPage(sess.getDeviceType(), err)) != null) {
            try {
                request.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                request.setAttribute("javax.servlet.error.exception", (Object)err);
                request.setAttribute("javax.servlet.error.exception_type", err.getClass());
                request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                if (this.process(sess, request, response, errpg, false)) {
                    return;
                }
                log.warning("The error page not found: " + errpg);
            }
            catch (IOException ex) {
            }
            catch (Throwable ex) {
                log.warning("Failed to load the error page: " + errpg, ex);
            }
        }
        Utils.handleError(this.getServletContext(), request, response, path, err);
    }
}

