/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.SimpleSession;
import org.zkoss.zk.ui.http.SimpleWebApp;
import org.zkoss.zk.ui.http.WebManager;

public class HttpSessionListener23
implements HttpSessionListener,
HttpSessionAttributeListener,
ServletContextAttributeListener,
ServletContextListener {
    private WebManager _webman;
    private boolean _webmanCreated;

    public void sessionCreated(HttpSessionEvent evt) {
    }

    public void sessionDestroyed(HttpSessionEvent evt) {
        HttpSession hsess = evt.getSession();
        if (hsess.getAttribute("org.zkoss.zk.ui.renewNativeSession") == null) {
            WebManager.sessionDestroyed(hsess);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent evt) {
        Session sess;
        String name = evt.getName();
        if (!HttpSessionListener23.shallIgnore(name) && (sess = Sessions.getCurrent()) instanceof SimpleSession && evt.getSession().equals(sess.getNativeSession())) {
            ((SimpleSession)sess).getScopeListeners().notifyAdded(name, evt.getValue());
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent evt) {
        Session sess;
        String name = evt.getName();
        if (!HttpSessionListener23.shallIgnore(name) && (sess = Sessions.getCurrent()) instanceof SimpleSession && evt.getSession().equals(sess.getNativeSession())) {
            ((SimpleSession)sess).getScopeListeners().notifyRemoved(name);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent evt) {
        Session sess;
        String name = evt.getName();
        if (!HttpSessionListener23.shallIgnore(name) && (sess = Sessions.getCurrent()) instanceof SimpleSession && evt.getSession().equals(sess.getNativeSession())) {
            ((SimpleSession)sess).getScopeListeners().notifyReplaced(name, evt.getValue());
        }
    }

    public void attributeAdded(ServletContextAttributeEvent evt) {
        WebApp wapp;
        String name = evt.getName();
        if (!HttpSessionListener23.shallIgnore(name) && (wapp = WebManager.getWebAppIfAny(evt.getServletContext())) instanceof SimpleWebApp) {
            ((SimpleWebApp)wapp).getScopeListeners().notifyAdded(name, evt.getValue());
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent evt) {
        WebApp wapp;
        String name = evt.getName();
        if (!HttpSessionListener23.shallIgnore(name) && (wapp = WebManager.getWebAppIfAny(evt.getServletContext())) instanceof SimpleWebApp) {
            ((SimpleWebApp)wapp).getScopeListeners().notifyRemoved(name);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent evt) {
        WebApp wapp;
        String name = evt.getName();
        if (!HttpSessionListener23.shallIgnore(name) && (wapp = WebManager.getWebAppIfAny(evt.getServletContext())) instanceof SimpleWebApp) {
            ((SimpleWebApp)wapp).getScopeListeners().notifyReplaced(name, evt.getValue());
        }
    }

    static boolean shallIgnore(String name) {
        return name.startsWith("javax.zkoss") || name.startsWith("org.zkoss");
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        if (this._webman != null) {
            if (this._webmanCreated) {
                this._webman.destroy();
            }
            this._webman = null;
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        if (WebManager.getWebManagerIfAny(ctx) == null) {
            this._webman = new WebManager(ctx, "/zkau");
            this._webmanCreated = true;
        }
    }
}

