/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.zkoss.lang.Library;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.logging.Log;

class LogConfigurer {
    private static final Log log = Log.lookup(LogConfigurer.class);

    LogConfigurer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void configure() {
        String LIBPROP = "org.zkoss.util.logging.config.file";
        String path = Library.getProperty((String)"org.zkoss.util.logging.config.file");
        if (path == null || path.length() == 0) {
            return;
        }
        InputStream is = LogConfigurer.class.getResourceAsStream(path);
        try {
            if (is == null) {
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = new File(System.getProperty("user.dir", "."), path);
                }
                if (file.exists()) {
                    try {
                        is = new FileInputStream(file);
                    }
                    catch (FileNotFoundException ex) {
                        // empty catch block
                    }
                }
                if (is == null) {
                    log.error(MCommon.FILE_NOT_FOUND, (Object)path);
                    return;
                }
            }
            log.info(MCommon.FILE_OPENING, (Object)path);
            Properties props = new Properties();
            props.load(is);
            Log.configure((Properties)props);
        }
        catch (Throwable ex) {
            log.realCauseBriefly("Failed to load " + path, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable ex) {}
            }
        }
    }
}

