/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Library;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.HttpBufferedResponse;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ExtendletLoader;
import org.zkoss.zk.fn.JspFns;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.http.AbstractExtendlet;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.WcsInfo;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.util.ThemeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WcsExtendlet
extends AbstractExtendlet<WcsInfo> {
    public void init(ExtendletConfig config) {
        this.init(config, new WcsLoader());
        config.addCompressExtension("wcs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        byte[] bs;
        WcsInfo wi;
        String resourceCache = Library.getProperty((String)"org.zkoss.zk.WCS.cache");
        if (resourceCache != null && "false".equalsIgnoreCase(resourceCache)) {
            this._cache.clear();
        }
        if ((wi = (WcsInfo)this._cache.get((Object)path)) == null) {
            if (Servlets.isIncluded((ServletRequest)request)) {
                log.error("Failed to load the resource: " + path);
                throw new FileNotFoundException("Failed to load the resource: " + path);
            }
            response.sendError(404, path);
            return;
        }
        StringWriter sw = new StringWriter();
        ExecutionImpl exec = new ExecutionImpl(this.getServletContext(), request, response, null, null);
        Execution olde = Executions.getCurrent();
        ExecutionsCtrl.setCurrent(exec);
        ((ExecutionCtrl)exec).onActivate();
        try {
            int hours = 8760;
            ThemeProvider tp = this.getWebApp().getConfiguration().getThemeProvider();
            if (tp != null) {
                String p = "~." + path;
                if (tp.beforeWCS(exec, p) == null) {
                    response.setContentType("text/css;charset=UTF-8");
                    return;
                }
                hours = tp.getWCSCacheControl(exec, p);
            }
            if (hours > 0) {
                JspFns.setCacheControl(this.getServletContext(), request, response, "org.zkoss.web.classWebResource.cache", hours);
            }
            for (int j = 0; j < wi.items.length; ++j) {
                Object o = wi.items[j];
                if (o instanceof String) {
                    String uri = (String)o;
                    if (tp != null && (uri = tp.beforeWidgetCSS(exec, uri)) == null) continue;
                    try {
                        this._webctx.include(request, HttpBufferedResponse.getInstance((HttpServletResponse)response, (Writer)sw), uri, null);
                    }
                    catch (Throwable ex) {
                        log.realCauseBriefly("Unable to load " + wi.items[j], ex);
                    }
                } else {
                    sw.write(this.invoke(new AbstractExtendlet.RequestContext(this, request, response), (AbstractExtendlet.MethodInfo)o));
                }
                sw.write(10);
            }
            for (String uri : wi.langdef.getCSSURIs()) {
                if (tp != null && (uri = tp.beforeWidgetCSS(exec, uri)) == null) continue;
                try {
                    this._webctx.include(request, HttpBufferedResponse.getInstance((HttpServletResponse)response, (Writer)sw), uri, null);
                }
                catch (Throwable ex) {
                    log.realCauseBriefly("Unable to load " + uri, ex);
                }
            }
        }
        finally {
            ((ExecutionCtrl)exec).onDeactivate();
            ExecutionsCtrl.setCurrent(olde);
        }
        response.setContentType("text/css;charset=UTF-8");
        byte[] data = sw.getBuffer().toString().getBytes("UTF-8");
        if (this._webctx.shallCompress((ServletRequest)request, "wcs") && data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
            data = bs;
        }
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
        response.flushBuffer();
    }

    private WcsInfo parse(InputStream is, String path) throws Exception {
        Element root = new SAXBuilder(true, false, true).build(is).getRootElement();
        String lang = IDOMs.getRequiredAttributeValue((Element)root, (String)"language");
        if (lang.length() == 0) {
            throw new UiException("The language attribute must be specified, " + root.getLocator() + ", " + path);
        }
        LinkedList<Object> items = new LinkedList<Object>();
        for (Element el : root.getElements()) {
            String elnm = el.getName();
            if ("stylesheet".equals(elnm)) {
                String href = IDOMs.getRequiredAttributeValue((Element)el, (String)"href");
                if (href.length() != 0) {
                    items.add(href);
                    continue;
                }
                log.warning("Ingored stylesheet: href required, " + el.getLocator() + ", " + path);
                continue;
            }
            if ("function".equals(elnm)) {
                AbstractExtendlet.MethodInfo mtd = WcsExtendlet.getMethodInfo(el);
                if (mtd == null) continue;
                items.add(mtd);
                continue;
            }
            log.warning("Ignored unknown element, " + el.getLocator() + ", " + path);
        }
        return new WcsInfo(lang, items);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WcsLoader
    extends ExtendletLoader<WcsInfo> {
        private WcsLoader() {
        }

        protected WcsInfo parse(InputStream is, String path, String orgpath) throws Exception {
            return WcsExtendlet.this.parse(is, path);
        }

        protected ExtendletContext getExtendletContext() {
            return WcsExtendlet.this._webctx;
        }

        protected String getRealPath(String path) {
            int j;
            if (path.length() > 1 && path.substring(1).startsWith("_zkiju-") && (j = path.indexOf(47, "_zkiju-".length() + 1)) > 0) {
                return path.substring(j);
            }
            return path;
        }
    }
}

