/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.DesktopRecycle;

public class DesktopRecycles {
    private static final Log log = Log.lookup(DesktopRecycles.class);

    public static boolean removeDesktop(Execution exec) {
        Desktop dt = exec.getDesktop();
        WebApp wapp = dt.getWebApp();
        DesktopRecycle dtrc = wapp.getConfiguration().getDesktopRecycle();
        if (dtrc != null) {
            try {
                if (dtrc.beforeRemove(exec, dt, 0)) {
                    ((DesktopCtrl)((Object)dt)).recycle();
                    return false;
                }
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
        ((WebAppCtrl)((Object)wapp)).getDesktopCache(dt.getSession()).removeDesktop(dt);
        return true;
    }
}

