/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Generics;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.resource.Location;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.DynamicTag;
import org.zkoss.zk.ui.impl.MultiComposer;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.EventHandler;
import org.zkoss.zk.ui.metainfo.EventHandlerMap;
import org.zkoss.zk.ui.metainfo.ForEachBranchInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.Parser;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.WidgetAttribute;
import org.zkoss.zk.ui.metainfo.WidgetListener;
import org.zkoss.zk.ui.metainfo.WidgetOverride;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ConditionImpl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.EvaluatorRef;
import org.zkoss.zk.xel.ExValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentInfo
extends ForEachBranchInfo {
    private transient ComponentDefinition _compdef;
    private ExValue _impl;
    private List<Property> _props;
    private EventHandlerMap _evthds;
    private List<WidgetListener> _wgtlsns;
    private List<WidgetOverride> _wgtovds;
    private List<WidgetAttribute> _wgtattrs;
    private AnnotationMap _annots;
    private String _tag;
    private String _fulfill;
    private ExValue[] _apply;
    private String _forward;
    private ExValue _wgtcls;
    private String _replaceableText;

    public ComponentInfo(NodeInfo parent, ComponentDefinition compdef, String tag) {
        super(parent, null);
        if (compdef == null) {
            throw new IllegalArgumentException();
        }
        this._compdef = compdef;
        this._tag = tag;
    }

    ComponentInfo(EvaluatorRef evalr, ComponentDefinition compdef, String tag) {
        if (compdef == null || evalr == null) {
            throw new IllegalArgumentException();
        }
        this._evalr = evalr;
        this._compdef = compdef;
        this._tag = tag;
    }

    private ComponentInfo(ComponentInfo compInfo) {
        super(compInfo);
        this._compdef = compInfo._compdef;
        this._impl = compInfo._impl;
        this._tag = compInfo._tag;
        this._fulfill = compInfo._fulfill;
        this._apply = compInfo._apply;
        this._forward = compInfo._forward;
        this._replaceableText = compInfo._replaceableText;
        this.dupProps(compInfo);
    }

    private void dupProps(ComponentInfo compInfo) {
        if (compInfo._annots != null) {
            this._annots = (AnnotationMap)compInfo._annots.clone();
        }
        if (compInfo._props != null) {
            this._props = new LinkedList<Property>(compInfo._props);
        }
        if (compInfo._evthds != null) {
            this._evthds = (EventHandlerMap)compInfo._evthds.clone();
        }
        if (compInfo._wgtlsns != null) {
            this._wgtlsns = new LinkedList<WidgetListener>(compInfo._wgtlsns);
        }
        if (compInfo._wgtovds != null) {
            this._wgtovds = new LinkedList<WidgetOverride>(compInfo._wgtovds);
        }
        if (compInfo._wgtattrs != null) {
            this._wgtattrs = new LinkedList<WidgetAttribute>(compInfo._wgtattrs);
        }
    }

    public LanguageDefinition getLanguageDefinition() {
        return this._compdef.getLanguageDefinition();
    }

    public ComponentDefinition getComponentDefinition() {
        return this._compdef;
    }

    @Override
    public void appendChild(NodeInfo child) {
        if (child instanceof TextInfo && !Parser.isNativeText(this)) {
            throw new IllegalStateException("TextInfo cannot be a child of " + this);
        }
        super.appendChild(child);
    }

    public String getTag() {
        return this._tag;
    }

    public String getTextAs() {
        return this._compdef.getTextAs();
    }

    public boolean isChildAllowedInTextAs() {
        return this._compdef.isChildAllowedInTextAs();
    }

    public boolean isBlankPreserved() {
        return this._compdef.isBlankPreserved();
    }

    public String getReplaceableText() {
        return this._replaceableText;
    }

    public void setReplaceableText(String text) {
        this._replaceableText = text;
    }

    public String getFulfill() {
        return this._fulfill;
    }

    public void setFulfill(String fulfill) {
        this._fulfill = fulfill != null && fulfill.length() > 0 ? fulfill : null;
    }

    public Composer resolveComposer(Page page, Component comp) {
        ExValue[] defapply = this._compdef.getParsedApply();
        if (this._apply == null && defapply == null) {
            return null;
        }
        try {
            LinkedList<Composer> composers = new LinkedList<Composer>();
            Evaluator eval = this.getEvaluator();
            ComponentInfo.toComposers(composers, defapply, eval, page, comp);
            ComponentInfo.toComposers(composers, this._apply, eval, page, comp);
            return MultiComposer.getComposer(page, composers.toArray(new Composer[composers.size()]));
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    private static void toComposers(List<Composer> composers, ExValue[] apply, Evaluator eval, Page page, Component comp) throws Exception {
        if (apply != null) {
            for (int j = 0; j < apply.length; ++j) {
                ComponentInfo.toComposer(composers, page, comp != null ? apply[j].getValue(eval, comp) : apply[j].getValue(eval, page));
            }
        }
    }

    private static void toComposer(List<Composer> composers, Page page, Object o) throws Exception {
        String s;
        if (o instanceof String && (s = (String)o).indexOf(44) >= 0) {
            o = CollectionsX.parse(null, (String)s, (char)',');
        }
        if (o instanceof Collection) {
            Iterator it = ((Collection)o).iterator();
            while (it.hasNext()) {
                Composer cp = Utils.newComposer(page, it.next());
                if (cp == null) continue;
                composers.add(cp);
            }
            return;
        }
        if (o instanceof Object[]) {
            Object[] ary = (Object[])o;
            for (int j = 0; j < ary.length; ++j) {
                Composer cp = Utils.newComposer(page, ary[j]);
                if (cp == null) continue;
                composers.add(cp);
            }
            return;
        }
        Composer cp = Utils.newComposer(page, o);
        if (cp != null) {
            composers.add(cp);
        }
    }

    public String getApply() {
        if (this._apply == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < this._apply.length; ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(this._apply[j].getRawValue());
        }
        return sb.toString();
    }

    public void setApply(String apply) {
        this._apply = org.zkoss.zk.xel.impl.Utils.parseList(apply, Object.class, true);
    }

    public String getForward() {
        return this._forward;
    }

    public void setForward(String forward) {
        this._forward = forward != null && forward.length() > 0 ? forward : null;
    }

    public List<Property> getProperties() {
        if (this._props != null) {
            return this._props;
        }
        return Collections.emptyList();
    }

    public void addProperty(String name, String value, ConditionImpl cond) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        this._props.add(new Property(this._evalr, name, value, cond));
    }

    public void addProperty(String name, NativeInfo value, ConditionImpl cond) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        this._props.add(new Property(this._evalr, name, value, cond));
    }

    public void addEventHandler(String name, ZScript zscript, ConditionImpl cond) {
        if (name == null || zscript == null) {
            throw new IllegalArgumentException("name and zscript cannot be null");
        }
        EventHandler evthd = new EventHandler(this._evalr, zscript, cond);
        if (this._evthds == null) {
            this._evthds = new EventHandlerMap();
        }
        this._evthds.add(name, evthd);
    }

    public Set<String> getEventHandlerNames() {
        if (this._evthds != null) {
            return this._evthds.getEventNames();
        }
        return Collections.emptySet();
    }

    public void addWidgetListener(String name, String script, ConditionImpl cond) {
        WidgetListener listener = new WidgetListener(this._evalr, name, script, cond);
        if (this._wgtlsns == null) {
            this._wgtlsns = new LinkedList<WidgetListener>();
        }
        this._wgtlsns.add(listener);
    }

    public void addWidgetOverride(String name, String script, ConditionImpl cond) {
        WidgetOverride mtd = new WidgetOverride(this._evalr, name, script, cond);
        if (this._wgtovds == null) {
            this._wgtovds = new LinkedList<WidgetOverride>();
        }
        this._wgtovds.add(mtd);
    }

    public void addWidgetAttribute(String name, String value, ConditionImpl cond) {
        WidgetAttribute attr = new WidgetAttribute(this._evalr, name, value, cond);
        if (this._wgtattrs == null) {
            this._wgtattrs = new LinkedList<WidgetAttribute>();
        }
        this._wgtattrs.add(attr);
    }

    public void setWidgetClass(String wgtcls) {
        this._wgtcls = wgtcls != null && wgtcls.length() > 0 ? new ExValue(wgtcls, String.class) : null;
    }

    public String getWidgetClass() {
        return this._wgtcls != null ? this._wgtcls.getRawValue() : null;
    }

    public String resolveWidgetClass(Component comp) {
        return this._wgtcls != null ? (String)this._wgtcls.getValue(this.getEvaluator(), comp) : null;
    }

    public String getImplementation() {
        return this._impl != null ? this._impl.getRawValue() : null;
    }

    public void setImplementation(String expr) {
        this._impl = expr != null && expr.length() > 0 ? new ExValue(expr, Object.class) : null;
    }

    public Component newInstance(Page page, Component parent) {
        Component comp;
        Object impl = this.evalImpl(page, parent);
        ComponentsCtrl.setCurrentInfo(this);
        try {
            block6: {
                try {
                    if (impl instanceof Class) {
                        Class cls = Generics.cast((Class)((Class)impl));
                        comp = this._compdef.newInstance(cls);
                        break block6;
                    }
                    comp = impl instanceof Component ? (Component)impl : this._compdef.newInstance(page, (String)impl);
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ComponentsCtrl.setCurrentInfo((ComponentInfo)null);
            throw throwable;
        }
        ComponentsCtrl.setCurrentInfo((ComponentInfo)null);
        if (comp instanceof DynamicTag && this._tag != null) {
            ((DynamicTag)((Object)comp)).setTag(this._tag);
        }
        return comp;
    }

    private Object evalImpl(Page page, Component parent) {
        return this._impl == null ? null : (parent != null ? this._impl.getValue(this.getEvaluator(), parent) : (page != null ? this._impl.getValue(this.getEvaluator(), page) : (this._impl.isExpression() ? null : this._impl.getRawValue())));
    }

    public Component newInstance(Page page) {
        return this.newInstance(page, null);
    }

    public Class resolveImplementationClass(Page page, Component parent) throws ClassNotFoundException {
        Object impl = this.evalImpl(page, parent);
        return impl instanceof Class ? (Class<?>)impl : (impl instanceof Component ? impl.getClass() : this._compdef.resolveImplementationClass(page, (String)impl));
    }

    public Class resolveImplementationClass(Page page) throws ClassNotFoundException {
        return this.resolveImplementationClass(page, null);
    }

    public AnnotationMap getAnnotationMap() {
        return this._annots;
    }

    public void applyProperties(Component comp) {
        this._compdef.applyProperties(comp);
        if (this._evthds != null) {
            ((ComponentCtrl)((Object)comp)).addSharedEventHandlerMap(this._evthds);
        }
        if (this._props != null) {
            for (Property prop : this._props) {
                prop.assign(comp);
            }
        }
        if (this._wgtlsns != null) {
            for (WidgetListener wl : this._wgtlsns) {
                wl.assign(comp);
            }
        }
        if (this._wgtovds != null) {
            for (WidgetOverride wo : this._wgtovds) {
                wo.assign(comp);
            }
        }
        if (this._wgtattrs != null) {
            for (WidgetAttribute wa : this._wgtattrs) {
                wa.assign(comp);
            }
        }
        comp.setWidgetClass(this.resolveWidgetClass(comp));
    }

    public Map<String, Object> evalProperties(Map<String, Object> propmap, Page owner, Component parent, boolean defIncluded) {
        if (defIncluded) {
            propmap = this._compdef.evalProperties(propmap, owner, parent);
        } else if (propmap == null) {
            propmap = new HashMap<String, Object>();
        }
        if (this._props != null) {
            for (Property prop : this._props) {
                if (parent != null) {
                    if (!prop.isEffective(parent)) continue;
                    propmap.put(prop.getName(), prop.getValue(parent));
                    continue;
                }
                if (!prop.isEffective(owner)) continue;
                propmap.put(prop.getName(), prop.getValue(owner));
            }
        }
        return propmap;
    }

    public void addAnnotation(String propName, String annotName, Map<String, String[]> annotAttrs, Location loc) {
        if (this._annots == null) {
            this._annots = new AnnotationMap();
        }
        this._annots.addAnnotation(propName, annotName, annotAttrs, loc);
    }

    public ComponentInfo duplicate() {
        return new DupComponentInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64).append('[').append(this instanceof NativeInfo ? "NativeInfo" : "ComponentInfo");
        if (this._compdef != null) {
            sb.append(": ").append(this._compdef.getName());
        }
        if (this._tag != null) {
            sb.append(" <").append(this._tag).append('>');
        }
        return sb.append(']').toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        LanguageDefinition langdef = this._compdef.getLanguageDefinition();
        if (langdef != null) {
            s.writeObject(langdef.getName());
            s.writeObject(this._compdef.getName());
        } else {
            s.writeObject(this._compdef);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object v = s.readObject();
        if (v instanceof String) {
            LanguageDefinition langdef = LanguageDefinition.lookup((String)v);
            this._compdef = langdef.getComponentDefinition((String)s.readObject());
        } else {
            this._compdef = (ComponentDefinition)v;
        }
    }

    private static class DupComponentInfo
    extends ComponentInfo {
        private DupComponentInfo(ComponentInfo compInfo) {
            super(compInfo);
        }

        public void appendChild(NodeInfo child) {
            throw new UnsupportedOperationException();
        }

        public boolean removeChild(NodeInfo child) {
            throw new UnsupportedOperationException();
        }
    }
}

