/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.ConventionWires;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorComposer<T extends Component>
implements Composer<T>,
ComposerExt<T>,
ComponentCloneListener,
ComponentActivationListener,
Serializable {
    private static final long serialVersionUID = 5022810317492589463L;
    private static final String ON_WIRE_CLONE = "onWireCloneSelectorComposer";
    private T _self;
    protected final List<VariableResolver> _resolvers = Selectors.newVariableResolvers(this.getClass(), SelectorComposer.class);
    private static Method _alert;
    private static final String UTILITY_HANDLER_KEY = "org.zkoss.zk.ui.select.SelectorComposer.UtilityHandler.class";
    private static UtilityHandler _handler;

    @Override
    public ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo) {
        Selectors.wireVariables(page, (Object)this, this._resolvers);
        this.getUtilityHandler().subscribeEventQueues(this);
        return compInfo;
    }

    @Override
    public void doBeforeComposeChildren(T comp) throws Exception {
        this._self = comp;
        ConventionWires.wireController(comp, this);
    }

    @Override
    public void doAfterCompose(T comp) throws Exception {
        this._self = comp;
        Selectors.wireComponents(comp, (Object)this, false);
        Selectors.wireEventListeners(comp, this);
        comp.addEventListener(1000, "onCreate", new BeforeCreateWireListener());
        comp.addEventListener("onCreate", new AfterCreateWireListener());
    }

    protected T getSelf() {
        return this._self;
    }

    protected Page getPage() {
        Page page;
        if (this._self != null && (page = this._self.getPage()) != null) {
            return page;
        }
        Execution exec = Executions.getCurrent();
        return exec != null ? ((ExecutionCtrl)((Object)exec)).getCurrentPage() : null;
    }

    protected void alert(String m) {
        try {
            if (_alert == null) {
                Class mboxcls = Classes.forNameByThread((String)"org.zkoss.zul.Messagebox");
                _alert = mboxcls.getMethod("show", String.class);
            }
            _alert.invoke(null, m);
        }
        catch (InvocationTargetException e) {
            throw UiException.Aide.wrap(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object willClone(Component comp) {
        try {
            Composer composerClone = (Composer)this.getClass().newInstance();
            comp.addEventListener(ON_WIRE_CLONE, new CloneDoAfterCompose());
            Events.postEvent(new Event(ON_WIRE_CLONE, comp, composerClone));
            return composerClone;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    @Override
    public void didActivate(Component comp) {
        Selectors.rewireComponentsOnActivate(comp, this);
        Selectors.rewireVariablesOnActivate(comp, this, this._resolvers);
        Selectors.rewireEventListeners(comp, this);
        this.getUtilityHandler().resubscribeEventQueues(this);
    }

    @Override
    public void willPassivate(Component comp) {
    }

    @Override
    public boolean doCatch(Throwable ex) throws Exception {
        return false;
    }

    @Override
    public void doFinally() throws Exception {
    }

    protected UtilityHandler getUtilityHandler() {
        this.loadUtilityHandler();
        return _handler;
    }

    private final void loadUtilityHandler() {
        if (_handler != null) {
            return;
        }
        String clsName = Library.getProperty((String)UTILITY_HANDLER_KEY);
        if (clsName != null) {
            try {
                Object o = Classes.newInstanceByThread((String)clsName);
                if (!(o instanceof UtilityHandler)) {
                    _handler = new UtilityHandlerImpl();
                    throw new UiException(o.getClass().getName() + " must implement " + UtilityHandler.class.getName());
                }
                _handler = (UtilityHandler)o;
            }
            catch (Exception ex) {
                _handler = new UtilityHandlerImpl();
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + clsName);
            }
        } else {
            _handler = new UtilityHandlerImpl();
        }
    }

    public static class UtilityHandlerImpl
    implements UtilityHandler {
        private static final long serialVersionUID = 1L;

        public void subscribeEventQueues(Object controller) {
        }

        public void resubscribeEventQueues(Object controller) {
        }
    }

    public static interface UtilityHandler {
        public void subscribeEventQueues(Object var1);

        public void resubscribeEventQueues(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloneDoAfterCompose
    implements SerializableEventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CloneDoAfterCompose() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Component clone = event.getTarget();
            SelectorComposer composerClone = (SelectorComposer)event.getData();
            ConventionWires.wireController(clone, composerClone);
            Selectors.wireVariables(clone.getPage(), (Object)this, composerClone._resolvers);
            Selectors.wireComponents(clone, (Object)this, false);
            Selectors.wireEventListeners(clone, this);
            composerClone.getUtilityHandler().subscribeEventQueues(this);
            clone.removeEventListener(SelectorComposer.ON_WIRE_CLONE, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AfterCreateWireListener
    implements SerializableEventListener<Event> {
        private static final long serialVersionUID = 1L;

        private AfterCreateWireListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Selectors.wireEventListeners(SelectorComposer.this._self, SelectorComposer.this);
            SelectorComposer.this._self.removeEventListener("onCreate", this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeforeCreateWireListener
    implements SerializableEventListener<Event> {
        private static final long serialVersionUID = 1L;

        private BeforeCreateWireListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Selectors.wireComponents(event.getTarget(), (Object)SelectorComposer.this, true);
            SelectorComposer.this._self.removeEventListener("onCreate", this);
        }
    }
}

