/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.html.HTMLs;
import org.zkoss.html.JavaScript;
import org.zkoss.html.StyleSheet;
import org.zkoss.io.Files;
import org.zkoss.json.JSONArray;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.ext.Includer;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentRedraws;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.SEORenderer;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.ThemeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPageRenders {
    private static final String ATTR_LANG_CSS_GENED = "javax.zkoss.zk.lang.css.generated";
    private static final String ATTR_LANG_JS_GENED = "javax.zkoss.zk.lang.js.generated";
    private static final String ATTR_UNAVAILABLE_GENED = "javax.zkoss.zk.unavail.generated";
    private static final String ATTR_DESKTOP_JS_GENED = "javax.zkoss.zk.dtjs.generated";
    private static final String DOCTYPE_GENED = "javax.zkoss.zk.doctype.generated";
    private static final String FIRST_LINE_GENED = "javax.zkoss.zk.firstline.generated";
    private static final String ATTR_RENDER_CONTEXT = "org.zkoss.zk.ui.renderContext";
    private static final String ATTR_DIRECT_CONTENT = "org.zkoss.zk.ui.directContent";
    private static final String ATTR_APPNM = "org.zkoss.zk.appnm";
    private static final String ATTR_PI = "org.zkoss.zk.pi";
    private static Boolean _crod;
    private static Boolean _groupingAllowed;
    private static final String ATTR_ZK_TAGS_GENERATED = "zkHtmlTagsGened";

    public static final void setContentType(Execution exec, Page page) {
        String cs;
        int j;
        String contentType = ((PageCtrl)((Object)page)).getContentType();
        if (contentType == null && (contentType = page.getDesktop().getDevice().getContentType()) == null) {
            contentType = "";
        }
        if ((j = contentType.indexOf(59)) < 0 && (cs = page.getDesktop().getWebApp().getConfiguration().getResponseCharset()) != null && cs.length() > 0) {
            contentType = contentType + ";charset=" + cs;
        }
        ((ExecutionCtrl)((Object)exec)).setContentType(contentType);
    }

    public static final String outDocType(Execution exec, Page page) {
        if (exec.getAttribute(DOCTYPE_GENED) == null && !exec.isAsyncUpdate(null)) {
            exec.setAttribute(DOCTYPE_GENED, Boolean.TRUE);
            String docType = ((PageCtrl)((Object)page)).getDocType();
            return HtmlPageRenders.trimAndLF(docType != null ? docType : page.getDesktop().getDevice().getDocType());
        }
        return "";
    }

    private static final String trimAndLF(String s) {
        int len;
        if (s != null && (len = (s = s.trim()).length()) > 0 && s.charAt(len - 1) != '\n') {
            s = s + '\n';
        }
        return s;
    }

    public static String outUnavailable(Execution exec) {
        if (exec.getAttribute(ATTR_UNAVAILABLE_GENED) == null && !exec.isAsyncUpdate(null)) {
            exec.setAttribute(ATTR_UNAVAILABLE_GENED, Boolean.TRUE);
            Device device = exec.getDesktop().getDevice();
            String s = device.getUnavailableMessage();
            return s != null ? "<noscript>\n" + s + "\n</noscript>" : "";
        }
        return "";
    }

    public static final String outFirstLine(Execution exec, Page page) {
        if (exec.getAttribute(FIRST_LINE_GENED) == null && !exec.isAsyncUpdate(null)) {
            exec.setAttribute(FIRST_LINE_GENED, Boolean.TRUE);
            return HtmlPageRenders.trimAndLF(((PageCtrl)((Object)page)).getFirstLine());
        }
        return "";
    }

    public static final String outResponseJavaScripts(Execution exec) {
        return HtmlPageRenders.outResponseJavaScripts(exec, false);
    }

    public static final String outResponseJavaScripts(Execution exec, boolean directJS) {
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        Collection<AuResponse> responses = execCtrl.getResponses();
        if (responses == null || responses.isEmpty()) {
            return "";
        }
        execCtrl.setResponses(null);
        StringBuffer sb = new StringBuffer(256);
        if (!directJS) {
            sb.append("<script class=\"z-runonce\" type=\"text/javascript\">\nzkac(");
        }
        Iterator<AuResponse> it = responses.iterator();
        while (it.hasNext()) {
            AuResponse response = it.next();
            sb.append('\'').append(response.getCommand()).append("',");
            List<Object> encdata = response.getEncodedData();
            if (encdata != null) {
                sb.append('\'').append(Strings.escape((String)JSONArray.toJSONString(encdata), (String)"'\n\r\t\f\\/!")).append('\'');
            } else {
                sb.append((String)null);
            }
            if (!it.hasNext()) continue;
            sb.append(",\n");
        }
        if (!directJS) {
            sb.append(");\n</script>");
        }
        return sb.toString();
    }

    public static final String outLangJavaScripts(Execution exec, WebApp wapp, String deviceType) {
        Device device;
        String s;
        if (exec.isAsyncUpdate(null) || exec.getAttribute(ATTR_LANG_JS_GENED) != null) {
            return "";
        }
        exec.setAttribute(ATTR_LANG_JS_GENED, Boolean.TRUE);
        Desktop desktop = exec.getDesktop();
        if (wapp == null) {
            wapp = desktop.getWebApp();
        }
        if (deviceType == null) {
            deviceType = desktop != null ? desktop.getDeviceType() : "ajax";
        }
        StringBuffer sb = new StringBuffer(1536);
        LinkedHashSet<JavaScript> jses = new LinkedHashSet<JavaScript>(32);
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(deviceType)) {
            jses.addAll(langdef.getJavaScripts());
        }
        for (JavaScript js : jses) {
            HtmlPageRenders.append(sb, js);
        }
        sb.append("\n<!-- ZK ").append(wapp.getVersion());
        if (WebApps.getFeature("ee")) {
            sb.append(" EE");
        } else if (WebApps.getFeature("pe")) {
            sb.append(" PE");
        }
        sb.append(' ').append(wapp.getBuild());
        Object o = wapp.getAttribute("org.zkoss.zk.ui.notice");
        if (o != null) {
            sb.append(o);
        }
        sb.append(" -->\n");
        int tmout = 0;
        Boolean autoTimeout = HtmlPageRenders.getAutomaticTimeout(desktop);
        if (autoTimeout != null ? autoTimeout != false : wapp.getConfiguration().isAutomaticTimeout(deviceType)) {
            if (desktop != null) {
                tmout = desktop.getSession().getMaxInactiveInterval();
            } else {
                Object req = exec.getNativeRequest();
                if (req instanceof HttpServletRequest) {
                    HttpSession hsess = ((HttpServletRequest)req).getSession(false);
                    if (hsess != null) {
                        Session sess = SessionsCtrl.getSession(wapp, hsess);
                        if (sess != null) {
                            tmout = sess.getMaxInactiveInterval();
                        } else {
                            tmout = wapp.getConfiguration().getSessionMaxInactiveInterval();
                            if (tmout <= 0) {
                                tmout = hsess.getMaxInactiveInterval();
                            }
                        }
                    } else {
                        tmout = wapp.getConfiguration().getSessionMaxInactiveInterval();
                    }
                }
            }
            if (tmout > 0) {
                int extra;
                tmout += (extra = tmout / 8) > 60 ? 60 : (extra < 5 ? 5 : extra);
            }
        }
        boolean keepDesktop = exec.getAttribute("org.zkoss.zk.desktop.nocache") == null && !"page".equals(ExecutionsCtrl.getPageRedrawControl(exec));
        boolean groupingAllowed = HtmlPageRenders.isGroupingAllowed(desktop);
        String progressboxPos = Library.getProperty((String)"org.zkoss.zul.progressbox.position", (String)"");
        if (tmout > 0 || keepDesktop || progressboxPos.length() > 0 || !groupingAllowed) {
            sb.append("<script class=\"z-runonce\" type=\"text/javascript\">zkopt({");
            if (keepDesktop) {
                sb.append("kd:1,");
            }
            if (!groupingAllowed) {
                sb.append("gd:1,");
            }
            if (tmout > 0) {
                sb.append("to:").append(tmout).append(',');
            }
            if (progressboxPos.length() > 0) {
                sb.append("ppos:'").append(progressboxPos).append('\'');
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.setLength(sb.length() - 1);
            }
            sb.append("});</script>");
        }
        if ((s = (device = Devices.getDevice(deviceType)).getEmbedded()) != null) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    private static Boolean getAutomaticTimeout(Desktop desktop) {
        if (desktop != null) {
            for (Page page : desktop.getPages()) {
                Boolean b = ((PageCtrl)((Object)page)).getAutomaticTimeout();
                if (b == null) continue;
                return b;
            }
        }
        return null;
    }

    public static final String outLangStyleSheets(Execution exec, WebApp wapp, String deviceType) {
        if (exec.isAsyncUpdate(null) || exec.getAttribute(ATTR_LANG_CSS_GENED) != null) {
            return "";
        }
        exec.setAttribute(ATTR_LANG_CSS_GENED, Boolean.TRUE);
        StringBuffer sb = new StringBuffer(512);
        for (StyleSheet ss : HtmlPageRenders.getStyleSheets(exec, wapp, deviceType)) {
            HtmlPageRenders.append(sb, ss, exec, null);
        }
        if (sb.length() > 0) {
            sb.append('\n');
        }
        return sb.toString();
    }

    public static final List<StyleSheet> getStyleSheets(Execution exec, WebApp wapp, String deviceType) {
        LinkedList<StyleSheet> sses;
        block9: {
            Configuration config;
            block8: {
                if (wapp == null) {
                    wapp = exec.getDesktop().getWebApp();
                }
                if (deviceType == null) {
                    deviceType = exec.getDesktop().getDeviceType();
                }
                config = wapp.getConfiguration();
                Set<String> disabled = config.getDisabledThemeURIs();
                sses = new LinkedList<StyleSheet>();
                for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(deviceType)) {
                    for (StyleSheet ss : langdef.getStyleSheets()) {
                        if (disabled.contains(ss.getHref())) continue;
                        sses.add(ss);
                    }
                }
                ThemeProvider themeProvider = config.getThemeProvider();
                if (themeProvider == null) break block8;
                LinkedList<Object> orgss = new LinkedList<Object>();
                for (StyleSheet ss : sses) {
                    String href = ss.getHref();
                    if (href == null || href.length() <= 0) continue;
                    orgss.add(ss.getMedia() != null ? ss : href);
                }
                String[] hrefs = config.getThemeURIs();
                for (int j = 0; j < hrefs.length; ++j) {
                    orgss.add(hrefs[j]);
                }
                sses.clear();
                Collection<Object> res = themeProvider.getThemeURIs(exec, orgss);
                if (res == null) break block9;
                for (Object re : res) {
                    sses.add(re instanceof StyleSheet ? (StyleSheet)re : new StyleSheet((String)re, "text/css"));
                }
                break block9;
            }
            String[] hrefs = config.getThemeURIs();
            for (int j = 0; j < hrefs.length; ++j) {
                sses.add(new StyleSheet(hrefs[j], "text/css"));
            }
        }
        return sses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void append(StringBuffer sb, StyleSheet ss, Execution exec, Page page) {
        String href = ss.getHref();
        String media = ss.getMedia();
        if (href != null) {
            try {
                if (exec != null) {
                    href = (String)exec.evaluate(page, href, String.class);
                }
                if (href == null || href.length() <= 0) return;
                sb.append("\n<link rel=\"stylesheet\" type=\"").append(ss.getType()).append("\" href=\"").append(ServletFns.encodeURL((String)href));
                if (media != null) {
                    sb.append("\" media=\"").append(media);
                }
                sb.append("\"/>");
                return;
            }
            catch (ServletException ex) {
                throw new UiException(ex);
            }
        } else {
            sb.append("\n<style");
            if (ss.getType() != null) {
                sb.append(" type=\"").append(ss.getType()).append('\"');
            }
            sb.append(">\n").append(ss.getContent()).append("\n</style>");
        }
    }

    private static void append(StringBuffer sb, JavaScript js) {
        sb.append("\n<script type=\"text/javascript\"");
        if (js.getSrc() != null) {
            String url;
            try {
                url = ServletFns.encodeURL((String)js.getSrc());
            }
            catch (ServletException ex) {
                throw new UiException(ex);
            }
            sb.append(" src=\"").append(url).append('\"');
            String charset = js.getCharset();
            if (charset != null) {
                sb.append(" charset=\"").append(charset).append('\"');
            }
            sb.append('>');
        } else {
            sb.append(" class=\"z-runonce\">\n").append(js.getContent());
        }
        sb.append("\n</script>");
    }

    public static final RenderContext getRenderContext(Execution exec) {
        if (exec == null) {
            exec = Executions.getCurrent();
        }
        return exec != null ? (RenderContext)exec.getAttribute(ATTR_RENDER_CONTEXT) : null;
    }

    private static final void setRenderContext(Execution exec, RenderContext rc) {
        exec.setAttribute(ATTR_RENDER_CONTEXT, rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void outPageContent(Execution exec, Page page, Writer out, boolean au) throws IOException {
        boolean standalone;
        Desktop desktop = page.getDesktop();
        PageCtrl pageCtrl = (PageCtrl)((Object)page);
        Component owner = pageCtrl.getOwner();
        boolean contained = owner == null && exec.isIncluded();
        String style = page.getStyle();
        if (style == null || style.length() == 0) {
            style = null;
            String wd = null;
            String hgh = null;
            if (owner instanceof HtmlBasedComponent) {
                HtmlBasedComponent hbc = (HtmlBasedComponent)owner;
                wd = hbc.getWidth();
                hgh = hbc.getHeight();
            }
            if (wd != null || hgh != null || contained) {
                StringBuffer sb = new StringBuffer(32);
                HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)(wd != null ? wd : "100%"));
                HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)(hgh != null ? hgh : (contained ? null : "100%")));
                style = sb.toString();
            }
        }
        RenderContext rc = null;
        RenderContext old = null;
        boolean aupg = exec.isAsyncUpdate(page);
        boolean includedAndPart = owner != null && !aupg;
        boolean divRequired = !au || includedAndPart;
        boolean bl = standalone = !au && owner == null;
        if (standalone) {
            rc = new RenderContext(out, new StringWriter(), desktop.getWebApp().getConfiguration().isCrawlable(), false);
            HtmlPageRenders.setRenderContext(exec, rc);
        } else if (owner != null) {
            old = HtmlPageRenders.getRenderContext(exec);
            boolean crawlable = old != null && old.temp != null && desktop.getWebApp().getConfiguration().isCrawlable();
            HtmlPageRenders.setRenderContext(exec, crawlable ? new RenderContext(old.temp, null, true, true) : null);
        }
        if (divRequired) {
            HtmlPageRenders.outDivTemplateBegin(out, page.getUuid());
        }
        if (standalone) {
            out = new StringWriter();
        } else if (divRequired) {
            HtmlPageRenders.outDivTemplateEnd(page, out);
        }
        if (includedAndPart) {
            out = new StringWriter();
        } else if (divRequired) {
            out.write("\n<script class=\"z-runonce\" type=\"text/javascript\">");
        }
        exec.setAttribute(ATTR_DESKTOP_JS_GENED, Boolean.TRUE);
        int order = ComponentRedraws.beforeRedraw(false);
        try {
            if (order < 0) {
                if (aupg) {
                    out.write(91);
                } else {
                    out.write(HtmlPageRenders.outSpecialJS(desktop));
                    out.write(divRequired ? "zkmx(" : "zkx(");
                }
            } else if (order > 0) {
                out.write(44);
            }
            out.write("\n[0,'");
            out.write(page.getUuid());
            out.write("',{");
            StringBuffer props = new StringBuffer(128);
            String pgid = page.getId();
            if (pgid.length() > 0) {
                HtmlPageRenders.appendProp(props, "id", pgid);
            }
            if (owner != null) {
                HtmlPageRenders.appendProp(props, "ow", owner.getUuid());
            } else {
                HtmlPageRenders.appendProp(props, "dt", desktop.getId());
                HtmlPageRenders.appendProp(props, "cu", HtmlPageRenders.getContextURI(exec));
                HtmlPageRenders.appendProp(props, "uu", desktop.getUpdateURI(null));
                HtmlPageRenders.appendProp(props, "ru", desktop.getRequestPath());
            }
            String pageWgtCls = pageCtrl.getWidgetClass();
            if (pageWgtCls != null) {
                HtmlPageRenders.appendProp(props, "wc", pageWgtCls);
            }
            if (style != null) {
                HtmlPageRenders.appendProp(props, "style", style);
            }
            if (!HtmlPageRenders.isClientROD(page)) {
                HtmlPageRenders.appendProp(props, "z$rod", Boolean.FALSE);
            }
            if (contained) {
                HtmlPageRenders.appendProp(props, "ct", Boolean.TRUE);
            }
            out.write(props.toString());
            out.write("},[");
            for (Component root = page.getFirstRoot(); root != null; root = root.getNextSibling()) {
                ((ComponentCtrl)((Object)root)).redraw(out);
            }
            out.write("]]");
            Object var22_21 = null;
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            String extra = ComponentRedraws.afterRedraw();
            throw throwable;
        }
        String extra = ComponentRedraws.afterRedraw();
        if (order < 0) {
            void var16_23;
            HtmlPageRenders.outEndJavaScriptFunc(exec, out, (String)var16_23, aupg);
        }
        if (standalone) {
            HtmlPageRenders.setRenderContext(exec, null);
            StringBuffer sw = ((StringWriter)out).getBuffer();
            out = rc.temp;
            if (divRequired) {
                HtmlPageRenders.outDivTemplateEnd(page, out);
            }
            Files.write((Writer)out, (StringBuffer)((StringWriter)rc.perm).getBuffer());
            Files.write((Writer)out, (StringBuffer)sw);
        } else if (owner != null) {
            HtmlPageRenders.setRenderContext(exec, old);
        }
        if (includedAndPart) {
            ((Includer)((Object)owner)).setRenderingResult(((StringWriter)out).toString());
        } else if (divRequired) {
            out.write("</script>\n");
        }
    }

    private static void outDivTemplateBegin(Writer out, String uuid) throws IOException {
        out.write("<div");
        HtmlPageRenders.writeAttr(out, "id", uuid);
        out.write(" class=\"z-temp\">");
    }

    private static void outDivTemplateEnd(Page page, Writer out) throws IOException {
        HtmlPageRenders.outSEOContent(page, out);
        out.write("</div>");
    }

    public static void outSEOContent(Page page, Writer out) throws IOException {
        if (page != null && ((PageCtrl)((Object)page)).getOwner() == null) {
            SEORenderer[] sds = page.getDesktop().getWebApp().getConfiguration().getSEORenderers();
            for (int j = 0; j < sds.length; ++j) {
                sds[j].render(page, out);
            }
        }
    }

    private static void outEndJavaScriptFunc(Execution exec, Writer out, String extra, boolean aupg) throws IOException {
        String ac = HtmlPageRenders.outResponseJavaScripts(exec, true);
        if (aupg) {
            if (extra.length() > 0 || ac.length() > 0) {
                out.write(",0,");
                if (ac.length() > 0) {
                    out.write("\n[");
                    out.write(ac);
                    out.write(93);
                } else {
                    out.write("null");
                }
                if (extra.length() > 0) {
                    out.write(",'");
                    out.write(Strings.escape((String)extra, (String)"'\n\r\t\f\\/!"));
                    out.write(39);
                }
            }
            out.write(93);
        } else {
            if (extra.length() > 0 || ac.length() > 0) {
                out.write(44);
                out.write(extra.length() > 0 ? 57 : 48);
                if (ac.length() > 0) {
                    out.write(",\n[");
                    out.write(ac);
                    out.write(93);
                }
            }
            out.write(");\n");
            out.write(extra);
        }
    }

    private static void appendProp(StringBuffer sb, String name, Object value) {
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(name).append(':');
        boolean quote = value instanceof String;
        if (quote) {
            sb.append('\'');
        }
        sb.append(value);
        if (quote) {
            sb.append('\'');
        }
    }

    public static final String outSpecialJS(Desktop desktop) {
        WebApp wapp;
        Session sess;
        String appnm;
        StringBuffer sb = new StringBuffer();
        String oldnm = (String)desktop.getAttribute(ATTR_APPNM);
        if (oldnm == null) {
            oldnm = "ZK";
        }
        if (!oldnm.equals(appnm = desktop.getWebApp().getAppName())) {
            sb.append("zk.appName='");
            Strings.escape((StringBuffer)sb, (CharSequence)appnm, (String)"'\n\r\t\f\\/!").append("';");
            desktop.setAttribute(ATTR_APPNM, appnm);
        }
        if ((sess = Sessions.getCurrent()) != null && ((wapp = desktop.getWebApp()) == null || "CE".equals(WebApps.getEdition()) || wapp.getAttribute("org.zkoss.zk.ui.notice") != null)) {
            boolean show;
            PI pi = (PI)sess.getAttribute(ATTR_PI);
            boolean bl = show = pi == null;
            if (show) {
                sess.setAttribute(ATTR_PI, new PI());
            } else {
                show = pi.show();
            }
            if (show) {
                sb.append("zk.pi=1;");
            }
        }
        return sb.toString();
    }

    private static final boolean isClientROD(Page page) {
        Object o = page.getAttribute("org.zkoss.zul.client.rod");
        if (o != null) {
            return o instanceof Boolean && (Boolean)o != false || !"false".equals(o);
        }
        if (_crod == null) {
            String s = Library.getProperty((String)"org.zkoss.zul.client.rod");
            _crod = s == null || !"false".equals(s);
        }
        return _crod;
    }

    private static final boolean isGroupingAllowed(Desktop desktop) {
        Page page;
        Object o;
        Collection<Page> pages;
        String name = "org.zkoss.zk.ui.input.grouping.allowed";
        if (desktop != null && !(pages = desktop.getPages()).isEmpty() && (o = (page = pages.iterator().next()).getAttribute("org.zkoss.zk.ui.input.grouping.allowed")) != null) {
            return o instanceof Boolean && (Boolean)o != false || !"false".equals(o);
        }
        if (_groupingAllowed == null) {
            String s = Library.getProperty((String)"org.zkoss.zk.ui.input.grouping.allowed");
            _groupingAllowed = s == null || !"false".equals(s);
        }
        return _groupingAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void outStandalone(Execution exec, Component comp, Writer out) throws IOException {
        void var3_5;
        if (ComponentRedraws.beforeRedraw(false) >= 0) {
            throw new InternalError("Not possible: " + comp);
        }
        try {
            if (comp != null) {
                HtmlPageRenders.outDivTemplateBegin(out, comp.getUuid());
                HtmlPageRenders.outDivTemplateEnd(comp.getPage(), out);
            }
            out.write("<script class=\"z-runonce\" type=\"text/javascript\">\nzkmx(");
            if (comp != null) {
                ((ComponentCtrl)((Object)comp)).redraw(out);
            } else {
                out.write("null");
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            String extra = ComponentRedraws.afterRedraw();
            throw throwable;
        }
        String extra = ComponentRedraws.afterRedraw();
        HtmlPageRenders.outEndJavaScriptFunc(exec, out, (String)var3_5, false);
        out.write("\n</script>\n");
    }

    private static final void writeAttr(Writer out, String name, String value) throws IOException {
        out.write(32);
        out.write(name);
        out.write("=\"");
        out.write(XMLs.encodeAttribute((String)value));
        out.write(34);
    }

    public static final String outHeaders(Execution exec, Page page, boolean before) {
        if (page == null) {
            return "";
        }
        String attr = "zkHeaderGened" + page.getUuid();
        if (before) {
            attr = attr + "Bf";
        }
        if (exec.getAttribute(attr) != null) {
            return null;
        }
        exec.setAttribute(attr, Boolean.TRUE);
        return before ? ((PageCtrl)((Object)page)).getBeforeHeadTags() : ((PageCtrl)((Object)page)).getAfterHeadTags();
    }

    public static String outHeaderZkTags(Execution exec, Page page) {
        String s1 = HtmlPageRenders.outHeaders(exec, page, true);
        String s2 = HtmlPageRenders.outZkTags(exec, null, null);
        String s3 = HtmlPageRenders.outHeaders(exec, page, false);
        return s1 != null ? (s2 != null ? (s3 != null ? s1 + s2 + s3 : s1 + s2) : (s3 != null ? s1 + s3 : s1)) : (s2 != null ? (s3 != null ? s2 + s3 : s2) : (s3 != null ? s3 : null));
    }

    public static String outZkTags(Execution exec, WebApp wapp, String deviceType) {
        if (exec.getAttribute(ATTR_ZK_TAGS_GENERATED) != null) {
            return null;
        }
        exec.setAttribute(ATTR_ZK_TAGS_GENERATED, Boolean.TRUE);
        StringBuffer sb = new StringBuffer(512).append('\n').append(HtmlPageRenders.outLangStyleSheets(exec, wapp, deviceType)).append(HtmlPageRenders.outLangJavaScripts(exec, wapp, deviceType));
        Desktop desktop = exec.getDesktop();
        if (desktop != null && exec.getAttribute(ATTR_DESKTOP_JS_GENED) == null) {
            sb.append("<script class=\"z-runonce\" type=\"text/javascript\">zkdt('").append(desktop.getId()).append("','").append(HtmlPageRenders.getContextURI(exec)).append("','").append(desktop.getUpdateURI(null)).append("','").append(desktop.getRequestPath()).append("');").append(HtmlPageRenders.outSpecialJS(desktop)).append("</script>\n");
        }
        return sb.toString();
    }

    public static boolean isZkTagsGenerated(Execution exec) {
        return exec.getAttribute(ATTR_ZK_TAGS_GENERATED) != null;
    }

    private static String getContextURI(Execution exec) {
        if (exec != null) {
            String s = exec.encodeURL("/");
            int j = s.lastIndexOf(47);
            return j >= 0 ? s.substring(0, j) + s.substring(j + 1) : s;
        }
        return "";
    }

    public static boolean setDirectContent(Execution exec, boolean direct) {
        return (direct ? exec.setAttribute(ATTR_DIRECT_CONTENT, Boolean.TRUE) : exec.removeAttribute(ATTR_DIRECT_CONTENT)) != null;
    }

    public static boolean isDirectContent(Execution exec) {
        if (exec == null) {
            exec = Executions.getCurrent();
        }
        return exec != null && exec.getAttribute(ATTR_DIRECT_CONTENT) != null;
    }

    public static class RenderContext {
        public final Writer temp;
        public final Writer perm;
        public final boolean crawlable;
        public final boolean included;

        private RenderContext(Writer temp, Writer perm, boolean crawlable, boolean included) {
            this.temp = temp;
            this.perm = perm;
            this.crawlable = crawlable;
            this.included = included;
        }
    }

    private static class PI
    implements Serializable {
        long _t = System.currentTimeMillis();

        private PI() {
        }

        private boolean show() {
            long now = System.currentTimeMillis();
            if (now - this._t > 600000L) {
                this._t = now;
                return true;
            }
            return false;
        }
    }
}

