/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.ui.util.InitiatorExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Composition
implements Initiator,
InitiatorExt {
    private static final String RESOLVE_COMPOSITION = "zk.ui.util.RESOLVE_COMPOSITION";
    public static final String PARENT = "zk.ui.util.PARENT";

    @Override
    public boolean doCatch(Throwable ex) throws Exception {
        return false;
    }

    @Override
    public void doFinally() throws Exception {
    }

    @Override
    public void doInit(Page page, Map<String, Object> args) throws Exception {
        Execution exec = Executions.getCurrent();
        if (exec.getAttribute(RESOLVE_COMPOSITION) == null) {
            exec.setAttribute(RESOLVE_COMPOSITION, this);
        }
        Component parent = (Component)exec.getAttribute(PARENT);
        for (Object arg : args.values()) {
            exec.createComponents((String)arg, parent, null);
        }
    }

    @Override
    public void doAfterCompose(Page page, Component[] comps) throws Exception {
        Execution exec = Executions.getCurrent();
        if (exec.getAttribute(RESOLVE_COMPOSITION) != this) {
            return;
        }
        exec.removeAttribute(RESOLVE_COMPOSITION);
        HashMap<String, Component> insertMap = new HashMap<String, Component>();
        Component parent = (Component)exec.getAttribute(PARENT);
        Collection<Component> roots = parent == null ? page.getRoots() : parent.getChildren();
        this.resolveInsertComponents(roots, insertMap);
        if (!roots.isEmpty()) {
            Component nextRoot;
            Component comp = roots.iterator().next();
            do {
                nextRoot = comp.getNextSibling();
                Annotation annt = ((ComponentCtrl)((Object)comp)).getAnnotation(null, "define");
                if (annt == null) continue;
                String joinId = annt.getAttribute("value");
                Component insertComp = (Component)insertMap.get(joinId);
                if (insertComp != null) {
                    comp.setParent(insertComp);
                    continue;
                }
                comp.detach();
            } while ((comp = nextRoot) != null);
        }
    }

    private void resolveInsertComponents(Collection<Component> comps, Map<String, Component> map) {
        for (Component comp : comps) {
            Annotation annt = ((ComponentCtrl)((Object)comp)).getAnnotation(null, "insert");
            if (annt != null) {
                String insertName = annt.getAttribute("value");
                if (map.containsKey(insertName)) {
                    throw new UiException("Duplicate insert name: " + insertName + " at Component " + comp);
                }
                map.put(insertName, comp);
            }
            this.resolveInsertComponents(comp.getChildren(), map);
        }
    }
}

