/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.jndi;

import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.zkoss.lang.Objects;
import org.zkoss.util.Maps;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;

public class JndiVariableResolver
implements VariableResolver {
    private static final Log log = Log.lookup(JndiVariableResolver.class);
    private String _jndiPrepend = null;
    private Map<String, Object> _jndiMapping = new HashMap<String, Object>();

    public JndiVariableResolver(String prepend, String mapping) {
        this._jndiMapping = new HashMap<String, Object>();
        Maps.parse(this._jndiMapping, (String)mapping, (char)',', (char)'=');
        this._jndiPrepend = prepend;
    }

    public JndiVariableResolver() {
    }

    public Object resolveVariable(String var) throws XelException {
        Object jndiPattern;
        Object variable = null;
        variable = this.jndiLookup("java:comp/env/" + var);
        if (variable == null) {
            variable = this.jndiLookup("java:comp/" + var);
        }
        if (variable == null) {
            variable = this.jndiLookup("java:/" + var);
        }
        if (variable == null) {
            variable = this.defaultBean(var);
        }
        if (!this._jndiMapping.isEmpty() && variable == null && (jndiPattern = this._jndiMapping.get(var)) != null) {
            variable = this.jndiLookup(jndiPattern.toString());
        }
        return variable;
    }

    private Object defaultBean(String name) {
        Object variable = null;
        variable = this.jndiLookup(this._jndiPrepend + "/" + name + "/local");
        if (variable == null) {
            variable = this.jndiLookup(this._jndiPrepend + "/" + name + "/remote");
        }
        return variable;
    }

    private Object jndiLookup(String jndiPattern) {
        Object obj;
        block2: {
            obj = null;
            try {
                InitialContext ctx = new InitialContext();
                obj = ctx.lookup(jndiPattern);
            }
            catch (NamingException ex) {
                if (!log.debugable()) break block2;
                log.debug("JNDI binding not found: " + ex);
            }
        }
        return obj;
    }

    public int hashCode() {
        return Objects.hashCode(this._jndiMapping) + Objects.hashCode((Object)this._jndiPrepend);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JndiVariableResolver && Objects.equals(this._jndiMapping, ((JndiVariableResolver)obj)._jndiMapping) && Objects.equals((Object)this._jndiPrepend, (Object)((JndiVariableResolver)obj)._jndiPrepend);
    }
}

