
(zk = function (sel) {
	return jq(sel, zk).zk;
}).copy = function (dst, src, bu) {
	dst = dst || {};
	for (var p in src) {
		if (bu) bu[p] = dst[p];
		dst[p] = src[p];
	}
	return dst;
};

(function () {
	var _oid = 0,
		_statelesscnt = 0,
		_logmsg,
		_stamps = [],
		_t0 = jq.now();

	function newClass() {
		return function () {
			this.$oid = ++_oid;
			this.$init.apply(this, arguments);

			var ais = this._$ais;
			if (ais) {
				delete this._$ais;
				for (var j = ais.length; j--;)
					ais[j].call(this);
			}
		};
	}
	function regClass(jclass, superclass) {
		var oid = jclass.$oid = ++_oid;
		zk.classes[oid] = jclass;
		jclass.prototype.$class = jclass;
		jclass.$class = zk.Class;
		(jclass._$extds = (jclass.superclass = superclass) ?
			zk.copy({}, superclass._$extds): {})[oid] = jclass;
			
		return jclass;
	}

	function defGet(nm) {
		return new Function('return this.' + nm + ';');
	}
	function defSet00(nm) {
		return function (v) {
			this[nm] = v;
			return this;
		};
	}
	function defSet01(nm, after) {
		return function (v, opts) {
			var o = this[nm];
			this[nm] = v;
			if (o !== v || (opts && opts.force))
				after.apply(this, arguments);
			return this;
		};
	}
	function defSet10(nm, before) {
		return function () {
			this[nm] = before.apply(this, arguments);
			return this;
		};
	}
	function defSet11(nm, before, after) {
		return function (v, opts) {
			var o = this[nm];
			this[nm] = v = before.apply(this, arguments);;
			if (o !== v || (opts && opts.force))
				after.apply(this, arguments);
			return this;
		};
	}

	function showprgbInit() {
		
		if (jq.isReady||zk.Page.contained.length)
			_showprgb(true, zk.pi ? 'z-initing': null);
		else
			setTimeout(showprgbInit, 10);
	}
	function showprgb() { 
		_showprgb();
	}
	function _showprgb(mask, icon) {
		if (zk.processing
		&& !jq("#zk_proc").length && !jq("#zk_showBusy").length)
			zUtl.progressbox("zk_proc", window.msgzk?msgzk.PLEASE_WAIT:'Processing...', mask, icon);
	}
	function wgt2s(w) {
		var s = w.widgetName;
		return s + (w.id ? '$' + w.id: '') + '#' + w.uuid + '$' + w.$oid;
	}
	function toLogMsg(ars, detailed) {
		var msg = [], Widget = zk.Widget;
		for (var j = 0, len = ars.length; j < len; j++) {
			if (msg.length) msg.push(", ");
			var ar = ars[j];
			if (ar && (jq.isArray(ar) || ar.zk)) 
				msg.push('[' + toLogMsg(ar, detailed) + ']');
			else if (Widget && Widget.isInstance(ar))
				msg.push(wgt2s(ar));
			else if (ar && ar.nodeType) {
				var w = Widget && Widget.$(ar);
				if (w) msg.push(jq.nodeName(ar), (ar != w.$n() ? '#'+ar.id+'.'+ar.className:''), ':', wgt2s(w));
				else msg.push(jq.nodeName(ar), '#', ar.id);
			} else if (detailed && ar && (typeof ar == 'object') && !ar.nodeType) {
				var s = ['{\n'];
				for (var v in ar)
					s.push(v, ':', ar[v], ',\n');
				if (s[s.length - 1] == ',\n')
					s.pop();
				s.push('\n}');
				msg.push(s.join(''));
			} else if (typeof ar == 'function') {
				var s = '' + ar,
					m = s.indexOf('{'),
					k = m < 0 ? s.indexOf('\n'): -1;
				msg.push(s.substring(0, m > 0 ? m: k > 0 ? k: s.length));
			} else
				msg.push('' + ar);
		}
		return msg.join('');
	}
	function doLog() {
		if (_logmsg) {
			var console = jq("#zk_log");
			if (!console.length) {
				jq(document.body).append(
	'<div id="zk_logbox" class="z-log">'
	+'<button onclick="jq(\'#zk_logbox\').remove()">X</button><br/>'
	+'<textarea id="zk_log" rows="10"></textarea></div>');
				console = jq("#zk_log");
			}
			console = console[0];
			console.value += _logmsg;
			console.scrollTop = console.scrollHeight;
			_logmsg = null;
		}
	}

	function _stampout() {
		if (zk.mounting)
			return zk.afterMount(_stampout);
		zk.stamp('ending');
		zk.stamp();
	}

	
	function _overrideSub(dstpt, nm, oldfn, newfn, tobak) {
		for (var sub = dstpt._$subs, j = sub ? sub.length: 0; --j >= 0;) {
			var subpt = sub[j];
			if (subpt[nm] === oldfn) {
				if (tobak)
					subpt['$'+nm] = oldfn; 
				subpt[nm] = newfn;
				_overrideSub(subpt, nm, oldfn, newfn, tobak); 
			}
		}
	}
	

zk.copy(zk, {
	
	classes: {},
	
	isClass: function (cls) {
		return cls && cls.$class == zk.Class;
	},
	
	isObject: function (o) {
		return o && o.$supers != null;
	},
	
	procDelay: 900,
	
	tipDelay: 800,
	
	clickPointer: [0, 0],
	
	currentPointer: [0, 0],
	
	
	
	

	
	loading: 0,
	
	
	
	
	
	
	
	
	
	busy: 0,
	
	appName: "ZK",

	
	
	
	

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

	
	
	
	
	
	
	
	
	
	

	
	
	
	

	
	
	
	

	
	
	

	
	cut: function (props, nm) {
		var v;
		if (props) {
			v = props[nm];
			delete props[nm];
		}
		return v;
	},

	
	$package: function (name, end, wv) { 
		for (var j = 0, ref = window;;) {
			var k = name.indexOf('.', j),
				nm = k >= 0 ? name.substring(j, k): name.substring(j);
			var nxt = ref[nm], newpkg;
			if (newpkg = !nxt) nxt = ref[nm] = {};
			if (k < 0) {
				if (newpkg && end !== false) zk.setLoaded(name);
					
					
				if (wv) nxt.$wv = true; 
				return nxt;
			}
			ref = nxt;
			j = k + 1;
		}
	},
	
	
	$import: function (name, fn) {
		for (var j = 0, ref = window;;) {
			var k = name.indexOf('.', j),
				nm = k >= 0 ? name.substring(j, k): name.substring(j);
			var nxt = ref[nm];
			if (k < 0 || !nxt) {
				if (fn)
					if (nxt) fn(nxt);
					else
						zk.load(name.substring(0, name.lastIndexOf('.')),
							function () {fn(zk.$import(name));});
				return nxt;
			}
			ref = nxt;
			j = k + 1;
		}
	},

	
	$extends: function (superclass, members, staticMembers) {
		if (!superclass)
			throw 'unknown superclass';

		var jclass = newClass(),
			thispt = jclass.prototype,
			superpt = superclass.prototype,
			define = members['$define'];
		delete members['$define'];
		zk.copy(thispt, superpt); 
		zk.define(jclass, define);
		zk.copy(thispt, members);

		for (var p in superclass) 
			if (p != 'prototype')
				jclass[p] = superclass[p];

		zk.copy(jclass, staticMembers);

		thispt._$super = superpt;
		thispt._$subs = [];
		superpt._$subs.push(thispt);
			
		return regClass(jclass, superclass);
	},

	
	$default: function (opts, defaults) {
		opts = opts || {};
		for (var p in defaults)
			if (opts[p] === undefined)
				opts[p] = defaults[p];
		return opts;
	},

	
	
	
	override: function (dst, backup, src) {
		switch (typeof backup) {
		case "function":
			var old = dst;
			dst = backup;
			return old;
		case "string":
			
			_overrideSub(dst, backup, dst['$'+backup] = dst[backup], dst[backup] = src, true);
			return dst;
		}

		for (var nm in src)
			_overrideSub(dst, nm, backup[nm] = dst[nm], dst[nm] = src[nm]);
		return dst;
	},

	
	define: function (klass, props) {
		for (var nm in props) {
			var nm1 = '_' + nm,
				nm2 = nm.charAt(0).toUpperCase() + nm.substring(1),
				pt = klass.prototype,
				after = props[nm], before = null;
			if (jq.isArray(after)) {
				before = after.length ? after[0]: null;
				after = after.length > 1 ? after[1]: null;
			}
			pt['set' + nm2] = before ?
				after ? defSet11(nm1, before, after): defSet10(nm1, before):
				after ? defSet01(nm1, after): defSet00(nm1);
			pt['get' + nm2] = pt['is' + nm2] = defGet(nm1);
		}
		return klass;
	},

	
	$void: function () {return false;},

	
	parseInt: function (v, b) {
		return v && !isNaN(v = parseInt(v, b || 10)) ? v: 0;
	},
	
	parseFloat: function (v) {
		return v && !isNaN(v = parseFloat(v)) ? v: 0;
	},

	
	
	set: function (o, name, value, extra) {
		if (typeof name == "string") {
			zk._set(o, name, value, extra);
		} else 
			for (var j = 0, len = value.length, m, n, v; j < len;) {
				n = value[j++];
				m = name['get' + n.charAt(0).toUpperCase() + n.substring(1)];
				if (!extra || m || name[n] !== undefined) 
					zk._set(o, n, m ? m.call(name): name[n]);
			}
		return o;
	},
	_set: function (o, name, value, extra) { 
		zk._set2(o,
			o['set' + name.charAt(0).toUpperCase() + name.substring(1)],
			name, value, extra);
	},
	_set2: function (o, mtd, name, value, extra) { 
		if (mtd) {
			if (extra !== undefined)
				mtd.call(o, value, extra);
			else
				mtd.call(o, value);
		} else
			o[name] = value;
	},
	
	get: function (o, name) {
		var nm = name.charAt(0).toUpperCase() + name.substring(1),
			m = o['get' + nm];
		if (m) return m.call(o);
		m = o['is' + nm];
		if (m) return m.call(o);
		return o[name];
	},

	
	
	startProcessing: function (timeout) {
		zk.processing = true;
		setTimeout(jq.isReady ? showprgb: showprgbInit, timeout > 0 ? timeout: 0);
	},
	
	endProcessing: function () {
		zk.processing = false;
		zUtl.destroyProgressbox("zk_proc");
	},

	
	disableESC: function () {
		++zk._noESC;
	},
	
	enableESC: function () {
		--zk._noESC;
	},
	_noESC: 0, 

	
	
	error: function (msg) {
		zAu.send(new zk.Event(null, "error", {message: msg}, {ignorable: true}), 800);
		zk._Erbx.push(msg);
	},
	
	errorDismiss: function () {
		zk._Erbx.remove();
	},
	
	log: function (detailed) {
		var msg = toLogMsg(
			(detailed !== zk) ? arguments :
				(function (args) {
					var a = [];
					for (var j = args.length; --j > 0;)
						a.unshift(args[j]);
					return a;
				})(arguments)
			, (detailed === zk)
		);
		_logmsg = (_logmsg ? _logmsg + msg: msg) + '\n';
		if (zk.mobile) {
			console.log(_logmsg);
			_logmsg = null;
		} else setTimeout(function(){jq(doLog);}, 300);
	},
	
	
	stamp: function (nm, noAutoLog) {
		if (nm) {
			if (!noAutoLog && !_stamps.length)
				setTimeout(_stampout, 0);
			_stamps.push({n: nm, t: jq.now()});
		} else if (_stamps.length) {
			var t0 = _t0;
			for (var inf; (inf = _stamps.shift());) {
				zk.log(inf.n + ': ' + (inf.t - _t0));
				_t0 = inf.t;
			}
			zk.log("total: " + (_t0 - t0));
		}
	},

	
	ajaxURI: function (uri, opts) {
		var ctx = zk.Desktop.$(opts?opts.desktop:null),
			au = opts && opts.au;
		ctx = (ctx ? ctx: zk)[au ? 'updateURI': 'contextURI'];
		uri = uri || '';

		var abs = uri.charAt(0) == '/';
		if (au && !abs) {
			abs = true;
			if (uri)
				uri = '/' + uri; 
		}

		var j = ctx.lastIndexOf(';'), k = ctx.lastIndexOf('?');
		if (j < 0 && k < 0) return abs ? ctx + uri: uri;

		if (k >= 0 && (j < 0 || k < j)) j = k;
		var prefix = abs ? ctx.substring(0, j): '';

		if (opts && opts.ignoreSession)
			return prefix + uri;

		var suffix = ctx.substring(j),
			l = uri.indexOf('?');
		return l >= 0 ?
			k >= 0 ?
			  prefix + uri.substring(0, l) + suffix + '&' + uri.substring(l+1):
			  prefix + uri.substring(0, l) + suffix + uri.substring(l):
			prefix + uri + suffix;
	},
	
	stateless: function (dtid, contextURI, updateURI, reqURI) {
		var Desktop = zk.Desktop, dt;
		dtid = dtid || ('z_auto' + _statelesscnt++);
		dt = Desktop.all[dtid];
		if (dt && !dt.stateless) throw "Desktop conflict";
		if (zk.updateURI == null)
			zk.updateURI = updateURI;
		if (zk.contextURI == null) 
			zk.contextURI = contextURI;
		return dt || new Desktop(dtid, contextURI, updateURI, reqURI, true);
	}
});


(function () {
	function _ver(ver) {
		return parseFloat(ver) || ver;
	}
	var browser = jq.browser,
		agent = zk.agent = navigator.userAgent.toLowerCase();
	zk.safari = browser.safari && _ver(browser.version);
	zk.opera = browser.opera && _ver(browser.version);
	zk.ff = zk.gecko = browser.mozilla && _ver(browser.version);
	zk.ios = zk.safari && /iphone|ipad|ipod/.test(agent);
	zk.android = zk.safari && (agent.indexOf('android') >= 0);
	zk.mobile = zk.ios || zk.android;
	zk.linux = agent.indexOf('linux') >= 0;
	zk.mac = !zk.ios && agent.indexOf('mac') >= 0;
	zk.chrome = zk.safari && agent.indexOf('chrome') >= 0;
	zk.safari_ = zk.safari && !zk.chrome; 
	zk.css3 = true;
	
	zk.vendor = zk.safari ? 'webkit' : '';

	var bodycls;
	if (zk.ff) {
		if (zk.ff < 5 
		&& (bodycls = agent.indexOf("firefox/")) > 0)
			zk.ff = zk.gecko = _ver(agent.substring(bodycls + 8));
		bodycls = 'gecko gecko' + Math.floor(zk.ff);
		zk.vendor = 'Moz';
	} else if (zk.opera) { 
		bodycls = 'opera';
		zk.vendor = 'O';
	} else {
		zk.iex = browser.msie && _ver(browser.version); 
			
			
		if (zk.iex) {
			if ((zk.ie = document.documentMode||zk.iex) < 6) 
				zk.ie = 6; 
			zk.ie7 = zk.ie >= 7; 
			zk.ie8 = zk.ie >= 8; 
			zk.css3 = zk.ie9 = zk.ie >= 9; 
			zk.ie6_ = zk.ie < 7;
			zk.ie7_ = zk.ie == 7;
			zk.ie8_ = zk.ie == 8;
			bodycls = 'ie ie' + Math.floor(zk.ie);
			zk.vendor = 'ms';
		} else {
			if (zk.safari)
				bodycls = 'safari safari' + Math.floor(zk.safari);
			if (zk.mobile) {
				bodycls = (bodycls || '') + ' mobile';
				if (zk.ios)
					bodycls = (bodycls || '') + ' ios';
				else
					bodycls = (bodycls || '') + ' android';
			}
		}
	}
	if ((zk.air = agent.indexOf("adobeair") >= 0) && zk.safari)
		bodycls = (bodycls || '') + ' air';

	if (bodycls)
		jq(function () {
			jq(document.body).addClass(bodycls);
		});
	
	zk.vendor_ = zk.vendor.toLowerCase();
})();


	function getProxy(o, f) { 
		return function () {
				return f.apply(o, arguments);
			};
	}
zk.Class = function () {}; 
regClass(zk.Object = newClass());

zk.Object.prototype = {
	
	$init: zk.$void,
	
	afterInit: function (f) {
		(this._$ais = this._$ais || []).unshift(f); 
	},
	
	
	
	
	
	$instanceof: function () {
		if (this.$class)
			for (var extds = this.$class._$extds, args = arguments,
					j = args.length, cls; j--;)
				if ((cls = args[j]) && extds[cls.$oid])
					return true; 
		return false;
	},
	
	
	$super: function (arg0, arg1) {
		var args = [], bCls = typeof arg0 != "string";
		for (var j = arguments.length, end = bCls ? 1: 0; --j > end;)
			args.unshift(arguments[j]);
		return bCls ? this.$supers(arg0, arg1, args): this.$supers(arg0, args);
	},
	
	
	$supers: function (nm, args, argx) {
		var supers = this._$supers;
		if (!supers) supers = this._$supers = {};

		if (typeof nm != "string") { 
			var old = supers[args], p; 
			if (!(p = nm.prototype._$super) || !(nm = p[args])) 
				throw args + " not in superclass"; 

			supers[args] = p;
			try {
				return nm.apply(this, argx);
			} finally {
				supers[args] = old; 
			}
		}

		
		var old = supers[nm], m, p, oldmtd;
		if (old) {
			oldmtd = old[nm];
			p = old;
		} else {
			oldmtd = this[nm];
			p = this;
		}
		while (p = p._$super)
			if (oldmtd != p[nm]) {
				m = p[nm];
				if (m) supers[nm] = p;
				break;
			}

		if (!m)
			throw nm + " not in superclass";

		try {
			return m.apply(this, args);
		} finally {
			supers[nm] = old; 
		}
	},
	
	_$subs: [],

	
	proxy: function (f) {
		var fps = this._$proxies, fp;
		if (!fps) this._$proxies = fps = {};
		else if (fp = fps[f]) return fp;
		return fps[f] = getProxy(this, f);
	}
};


_zkf = {
	
	isInstance: function (o) {
		return o && o.$instanceof && o.$instanceof(this);
	},
	
	isAssignableFrom: function (cls) {
		return cls && (cls = cls._$extds) && cls[this.$oid] != null;
	}
};
zk.copy(zk.Object, _zkf);
zk.copy(regClass(zk.Class, zk.Object), _zkf);


var _erbx, _errcnt = 0;

zk._Erbx = zk.$extends(zk.Object, { 
	$init: function (msg) {
		var id = "zk_err",
			$id = "#" + id,
			
 			html = '<div class="z-error" id="' + id + '"><table cellpadding="2" cellspacing="2" width="100%">'
 					+ '<tr valign="top"><td class="msgcnt" colspan="3"><div class="msgs">'+ zUtl.encodeXML(msg, {multiline : true}) + '</div></td></tr>'
 					+ '<tr id="'+ id + '-p"><td class="errnum" align="left">'+ ++_errcnt+ ' Errors</td><td align="right"><div >'
					+ '<div class="btn redraw" onclick="zk._Erbx.redraw()"' + (zk.mobile ? ' ontouchstart="zk._Erbx.redraw()"' : '') + '></div>'
					+ '<div class="btn close" onclick="zk._Erbx.remove()"' + (zk.mobile ? ' ontouchstart="zk._Erbx.remove()"' : '')	+ '></div>'
					+ '</div></td></tr></table></div>';

		jq(document.body).append(html);
		_erbx = this;
		this.id = id;
		try {
			var n;
			this.dg = new zk.Draggable(null, n = jq($id)[0], {
				handle: jq($id + '-p')[0], zIndex: n.style.zIndex,
				starteffect: zk.$void, starteffect: zk.$void,
				endeffect: zk.$void});
		} catch (e) {
		}
		jq("#" + id).slideDown(1000);
	},
	destroy: function () {
		_erbx = null;
		_errcnt = 0;
		if (this.dg) this.dg.destroy();
		jq('#' + this.id).remove();
	}
},{
	redraw: function () {
		zk.errorDismiss();
		zAu.send(new zk.Event(null, 'redraw'));
	},
	push: function (msg) {
		if (!_erbx)
			return new zk._Erbx(msg);

		var id = _erbx.id;
		jq("#" + id + " .errnum").html(++_errcnt + " Errors");
		jq("#" + id + " .msgs").prepend('<div class="newmsg">' + msg + "</hr></div>");
		jq("#" + id + " .newmsg")
			.removeClass("newmsg").addClass("msg").slideDown(600)
	},
	remove: function () {
		if (_erbx) _erbx.destroy();
	}
});
})();
