﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Collections;
using System.Net;
using System.Web;
using System.IO;
using System.Threading;
using mshtml;

using System.Diagnostics;
using System.Drawing.Drawing2D;
using System.Collections.Specialized;
using System.Data.OleDb;

using System.Text.RegularExpressions;

using System.Runtime.InteropServices;
using System.Security.Cryptography; //MD5模块

using System.Net.Sockets; //端口扫描

//主程序模块
namespace Php
{
    public partial class Form1 : Form
    {
        Http http = new Http();//单个网站http对象
        public int n = 0;//当前多个网站http对象,线程个数
        public int m = 0;
        public static int N = 1024;
        Http[] https = new Http[N]; //多个网站的http对象数组    
        Thread[] threads = new Thread[N];//多个网站开辟的线程数组
        public Boolean IsWebsiteScan = true;
        public String TimeUsedStr = "";
        public int L = 0;
        //以下是ＤＮＳ反查定义开始
        string ss = null;
        string ssport = null;
        int ip1, ip2, ip3, ip4;
        string[] t = new string[5];
        //以上是ＤＮＳ反查定义结束
        public Boolean Locked = true;

        public Form1()
        {
            InitializeComponent();
            CheckForIllegalCrossThreadCalls = false; //设置WEB服务器安全模块
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            try
            {
                this.textBox_WebsitesAdd.Text = Application.StartupPath + "\\" + "urls.txt";
                //以下为获取本机IP地址开始
                string myname = Dns.GetHostName();
                IPHostEntry mys = Dns.GetHostEntry(myname);
                toolStripStatusLabel1.Text = mys.AddressList[1].ToString();
                //以上为获取本机IP地址结束
            }
            catch (System.Exception ex)
            {

            }

        }
        #region //sql漏洞扫描事件


        private void radioButton＿WebsiteAdd_CheckedChanged(object sender, EventArgs e)
        {
            textBox_WebsiteAdd.Enabled = true;
            textBox_WebsitesAdd.Enabled = false;
            button_file.Enabled = false;
        }

        private void radioButton＿WebsitesAdd_CheckedChanged(object sender, EventArgs e)
        {
            textBox_WebsiteAdd.Enabled = false;
            textBox_WebsitesAdd.Enabled = true;
            button_file.Enabled = true;
        }

        private void button_Exit_Click(object sender, EventArgs e)
        {
            this.Dispose();
            this.Close();
        }

        public void ThreadProc_WebsiteAdd()
        {
            if (http != null)
            {
                http.Scan();
            }
        }
        public void ThreadProc_WebsitesAdd()
        {
            int n1 = n;
            Locked = false;
            if (https[n1 % N] != null)
            {
                https[n1 % N].Scan();
            }
        }





        Thread linkceshith;
        private void toolStripButton2_Click(object sender, EventArgs e) //开始按钮
        {


            try
            {
                Navigate(toolStripComboBox1.Text);
                listBox1.Items.Clear(); //清空
                this.textCookie.Text = this.webBrowser1.Document.Cookie.ToString(); //取得cookies

                StreamReader sr = new StreamReader(webBrowser1.DocumentStream, Encoding.GetEncoding("gb2312"));
                richTextBox1.Text = sr.ReadToEnd();

                linkceshith = new Thread(new ThreadStart(googlelinkceshi));
                linkceshith.Start();
            }
            catch
            {

            }

        }

        //测试
        public void googlelinkceshi()
        {


            System.Text.RegularExpressions.Regex R = new System.Text.RegularExpressions.Regex("http://\\w+([-.]\\w+)*.\\w+([-.]\\w+)*(:\\d+)*(/[-\\w%?&=]*)*");
            //System.Text.RegularExpressions.Regex R = new System.Text.RegularExpressions.Regex("http://[\\w-]+.google[\\w-]*(\\.\\w(2,4))(1,2)/");
            Match M = R.Match(richTextBox1.Text);
            //R.Replace("google", "");
            while (M.Success)
            {
                listBox1.Items.Add(M.Value);

                M = M.NextMatch();
            }
        }


        //测试

        // 给URL指定的导航.
        private void Navigate(String address)
        {
            if (String.IsNullOrEmpty(address)) return;
            if (address.Equals("about:blank")) return;
            if (!address.StartsWith("http://") &&
                !address.StartsWith("https://"))
            {
                address = "http://" + address;
            }
            try
            {
                webBrowser1.Navigate(new Uri(address));
            }
            catch (System.UriFormatException)
            {
                return;
            }
        }


        private void webBrowser1_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            try
            {
                this.toolStripComboBox1.Text = webBrowser1.Url.ToString();
                //this.toolStripButton4.Enabled = webBrowser1.CanGoForward; //判断及设定 前进按钮是否可用
                //this.toolStripButton1.Enabled = webBrowser1.CanGoBack; //判断及设定 后退按钮是否可用


            }
            catch (Exception ex)
            { }

        }
        Thread sqlshaoth;
        private void button_StartScan_Click_1(object sender, EventArgs e)
        {
            sqlshaoth = new Thread(new ThreadStart(sqlshaomiao));
            try
            {
                sqlshaoth.Start();

            }
            catch
            {

            }

        }

        public void sqlshaomiao()
        {
            if (radioButton＿WebsiteAdd.Checked)
            {//单个网站扫描 
                this.IsWebsiteScan = true;
                //开启程序执行时间统计
                Stopwatch sw1 = new Stopwatch();
                Stopwatch sw2 = Stopwatch.StartNew();
                //---------------------------------------------------------------
                sw1.Start();
                listView_InjectionPoints.Clear();
                listView_InjectionPoints.GridLines = true;//显示各个记录的分隔线 
                listView_InjectionPoints.View = View.Details;//定义列表显示的方式 
                listView_InjectionPoints.Scrollable = true; //需要时候显示滚动条
                if (listView_InjectionPoints.Columns.Count == 0)
                {
                    listView_InjectionPoints.Columns.Add("可能的注入点", 490);
                    listView_InjectionPoints.Columns.Add("是否泄漏敏感信息", 90);
                    listView_InjectionPoints.Columns.Add("可否注入", 90);
                }
                //开一个线程
                String website = textBox_WebsiteAdd.Text;
                if (website == null || website == "")
                {
                    MessageBox.Show("请输入ＵＲＬ地址!");
                    return;
                }
                http = new Http(website);
                if (checkBox_ScanAlonePoint.Checked)
                {
                    if (textBox_AlonePoints.Text.Substring(textBox_AlonePoints.Text.LastIndexOf('.')) == ".mdb")
                    {
                        string strConnection = "Provider=Microsoft.Jet.OleDb.4.0;";
                        strConnection += @"Data Source=" + textBox_AlonePoints.Text;//这里用的是绝对路径
                        try
                        {
                            OleDbConnection objConnection = new OleDbConnection(strConnection);
                            //objConnection.Open();
                            //OleDbDataAdapter da = new OleDbDataAdapter("select * from xjtu_website", objConnection);
                            OleDbCommand objCommand = new OleDbCommand("select * from Scan_AlonePoints", objConnection);
                            objConnection.Open();
                            OleDbDataReader objDataReader = objCommand.ExecuteReader();
                            while (objDataReader.Read())
                            {
                                Uri urlNew = new Uri(new Uri(http.RootUrl), Convert.ToString(objDataReader["AlonePoint"]));
                                string strNew = urlNew.AbsoluteUri.ToString();
                                InjectionPoint IPnew = new InjectionPoint(strNew, false, false, false);
                                http.alPossibleInjectionPoints.Add(IPnew);
                            }
                            objConnection.Close();
                        }
                        catch
                        {
                            MessageBox.Show("读取或连接错误!");
                            return;
                        }
                    }
                }
                progressBar_Scanner.Minimum = 0;
                progressBar_Scanner.Maximum = 100;
                progressBar_Scanner.Value = 10;
                Thread t = new Thread(ThreadProc_WebsiteAdd);
                t.Start();
                Boolean wait = true;
                DateTime dt = DateTime.Now;
                while (wait)
                {
                    if (http.floor == 1)
                        progressBar_Scanner.Value = 30;
                    else if (http.floor == 2)
                        progressBar_Scanner.Value = 50;
                    else if (http.floor == 3)
                        progressBar_Scanner.Value = 70;
                    //查看是否扫描结束
                    if (http.floor_threads_num[http.floor] == -1)
                    {
                        wait = false;
                        break;
                    }
                    if (progressBar_Scanner.Value >= 70)
                    {
                        wait = false;
                        break;
                    }
                    DateTime dt1 = DateTime.Now;
                    TimeSpan dt_diff = dt1 - dt;
                    if (dt_diff.Seconds >= 25)
                    {
                        wait = false;
                        break;
                    }
                }

                t.Join(25 * 1000);
                progressBar_Scanner.Value = 100;
                //显示scan返回结果
                ArrayList alLinks = http.alPossibleInjectionPoints;
                Array aLinks = alLinks.ToArray();
                for (int i = 0; i < aLinks.GetLength(0); i++)
                {
                    ListViewItem lt = new ListViewItem();
                    lt.SubItems[0].Text = ((InjectionPoint)aLinks.GetValue(i)).Url;
                    lt.SubItems.Add(((InjectionPoint)aLinks.GetValue(i)).IsSensitive.ToString());
                    lt.SubItems.Add(((InjectionPoint)aLinks.GetValue(i)).CanInject.ToString());
                    listView_InjectionPoints.Items.Add(lt);
                }
                ListViewItem lvt = new ListViewItem();
                http.N_Pages = http.alPossibleInjectionPoints.Count;
                http.N_Pages_secure = http.N_Pages - http.N_Pages_secure;
                int j = 0; String state = "[";
                while (http.floor_threads_num[j] != -1 && http.floor_threads_num[j] != 0)
                {
                    state += http.floor_threads_num[j++];
                    state += " ";
                }
                state += "]";
                lvt.SubItems[0].Text = "扫描完毕![" + http.RootUrl + "]" + "[" + http.DBType + "]" + state;
                lvt.SubItems.Add(http.IsSensitive.ToString() + " " + http.N_Pages_sensitive + "/" + http.N_Pages);
                lvt.SubItems.Add(http.IsInjectable.ToString() + " " + http.N_Pages_injectable + "/" + http.N_Pages);
                listView_InjectionPoints.Items.Add(lvt);
                sw2.Stop();
                long elaspsedMilliseconds = sw1.ElapsedMilliseconds;
                TimeUsedStr = elaspsedMilliseconds.ToString();
                label_timeused.Text = "TimeUsed:" + TimeUsedStr + " Milliseconds";
                label_state.Text = "State:" + "扫描完毕!";
                MessageBox.Show("扫描完成!请查看HTML扫描报告！");
                //this.button_htmlreport_Click_1(sender, e);
            }
            else//多个网站扫描
            {
                this.IsWebsiteScan = false;
                //开启程序执行时间统计
                Stopwatch sw1 = new Stopwatch();
                Stopwatch sw2 = Stopwatch.StartNew();
                sw1.Start();
                //-----------------------------------------------
                if (textBox_WebsitesAdd.Text == "")
                {
                    MessageBox.Show("请输入一个文件!");
                    return;
                }
                label_state.Text = "State:" + "正在读取文件 " + textBox_WebsitesAdd.Text + " .......";
                ArrayList alUrls = new ArrayList();
                if (textBox_WebsitesAdd.Text.Substring(textBox_WebsitesAdd.Text.LastIndexOf('.')) == ".txt")
                {
                    StreamReader reader = new StreamReader(textBox_WebsitesAdd.Text);
                    try
                    {
                        while (reader.Peek() != -1)
                        {
                            alUrls.Add(new Website(reader.ReadLine(), ""));
                        }
                    }
                    catch
                    {
                        MessageBox.Show("文件是空的");
                        return;
                    }
                    finally
                    {
                        reader.Close();
                    }
                    if (alUrls.Count == 0)
                    {
                        MessageBox.Show("文件是空的");
                        return;
                    }
                    label_state.Text = "State:" + "文件已读取,开始准备多线程执行程序......";
                    //以上对输入的txt文件检验是否存在及内容是否为空
                }
                if (textBox_WebsitesAdd.Text.Substring(textBox_WebsitesAdd.Text.LastIndexOf('.')) == ".mdb")
                {
                    string strConnection = "Provider=Microsoft.Jet.OleDb.4.0;";
                    strConnection += @"Data Source=" + textBox_WebsitesAdd.Text;//这里用的是绝对路径
                    try
                    {
                        OleDbConnection objConnection = new OleDbConnection(strConnection);
                        //objConnection.Open();
                        //OleDbDataAdapter da = new OleDbDataAdapter("select * from xjtu_website", objConnection);
                        OleDbCommand objCommand = new OleDbCommand("select * from xjtu_website", objConnection);
                        objConnection.Open();
                        OleDbDataReader objDataReader = objCommand.ExecuteReader();
                        while (objDataReader.Read())
                        {
                            alUrls.Add(new Website(Convert.ToString(objDataReader["w_url"]), Convert.ToString(objDataReader["w_info"])));
                        }
                        objDataReader.Close();
                        objConnection.Close();
                    }
                    catch
                    {
                        MessageBox.Show("读取或连接错误!");
                        return;
                    }
                    if (alUrls.Count == 0)
                    {
                        MessageBox.Show("文件是空的");
                        return;
                    }
                }
                //清空listview 
                listView_InjectionPoints.Clear();
                listView_InjectionPoints.GridLines = true;//显示各个记录的分隔线 
                listView_InjectionPoints.View = View.Details;//定义列表显示的方式 
                listView_InjectionPoints.Scrollable = true; //需要时候显示滚动条
                listView_InjectionPoints.Sorting = SortOrder.None;
                if (listView_InjectionPoints.Columns.Count == 0)
                {
                    listView_InjectionPoints.Columns.Add("可能的注入点", 490);
                    listView_InjectionPoints.Columns.Add("是否泄漏敏感信息", 90);
                    listView_InjectionPoints.Columns.Add("可否注入", 90);
                }
                progressBar_Scanner.Minimum = 0;
                progressBar_Scanner.Maximum = 100;
                progressBar_Scanner.Value = 2;
                n = 0;
                //ArrayList alPIP=new ArrayList();//可能的注入点

                foreach (Website ws in alUrls)
                {
                    if (ws.strurl == null || ws.strurl == "" || ws.strurl.Trim() == "") continue;
                    https[n] = new Http(ws.strurl, ws.strinfo);
                    if (checkBox_ScanAlonePoint.Checked)
                    {
                        if (textBox_AlonePoints.Text.Substring(textBox_AlonePoints.Text.LastIndexOf('.')) == ".mdb")
                        {
                            string strConnection = "Provider=Microsoft.Jet.OleDb.4.0;";
                            strConnection += @"Data Source=" + textBox_AlonePoints.Text;//这里用的是绝对路径
                            try
                            {
                                OleDbConnection objConnection = new OleDbConnection(strConnection);
                                //objConnection.Open();
                                //OleDbDataAdapter da = new OleDbDataAdapter("select * from xjtu_website", objConnection);
                                OleDbCommand objCommand = new OleDbCommand("select * from Scan_AlonePoints", objConnection);
                                objConnection.Open();
                                OleDbDataReader objDataReader = objCommand.ExecuteReader();
                                while (objDataReader.Read())
                                {
                                    Uri urlNew = new Uri(new Uri(https[n].RootUrl), Convert.ToString(objDataReader["AlonePoint"]));
                                    string strNew = urlNew.AbsoluteUri.ToString();
                                    InjectionPoint IPnew = new InjectionPoint(strNew, false, false, false);
                                    https[n].alPossibleInjectionPoints.Add(IPnew);
                                }
                                objConnection.Close();
                            }
                            catch
                            {
                                MessageBox.Show("[" + textBox_AlonePoints.Text + "]Connecting to Access or Reading data error!");
                                return;
                            }
                        }
                    }
                    threads[n] = new Thread(ThreadProc_WebsitesAdd);
                    threads[n].Start();
                    while (Locked) ;
                    n++;
                    Locked = true;
                }
                L = ((n > N) ? N : n);
                //label_state.Text = "State:" + L +"个多线程已创建,主控程序开始监控多线程的执行进度......";
                progressBar_Scanner.Value = 5;
                Boolean wait = true;
                DateTime dt = DateTime.Now;
                while (wait)
                {
                    int value = 0;
                    for (int l = 0; l < L; l++)
                    {
                        if (https[l].floor_threads_num[https[l].floor] == -1)
                            value += (95 / L);
                    }
                    label_state.Text = "State:" + L + "个多线程正在执行,目前进度:" + (5 + value) + "%";
                    progressBar_Scanner.Value = 5 + value;
                    //停止进度准确滚动
                    if (progressBar_Scanner.Value > 50)
                    {
                        wait = false;
                    }
                    DateTime dt1 = DateTime.Now;
                    TimeSpan dt_diff = dt1 - dt;
                    if (dt_diff.Seconds >= 30)
                    {
                        wait = false;
                    }

                    Thread.Sleep(2 * 1000);
                }
                label_state.Text = "State:" + "开始发出的" + L + "个多线程.......";
                //等待发出的(n > 100) ? 100 : n个线程是否返回 
                for (int i = 0; i < ((n > N) ? N : n); i++)
                {
                    if (threads[i] != null)
                    {
                        threads[i].Join(30 * 1000);
                        label_state.Text = "State:" + "开始发出的" + L + "个多线程, 线程" + i + "已完成!";
                    }
                }
                label_state.Text = "State:" + "多线程执行完毕,正在显示扫描结果........";
                progressBar_Scanner.Value = 100;
                for (int j = 0; j < n; j++)
                {
                    ArrayList alLinks = https[j].alPossibleInjectionPoints;
                    Array aLinks = alLinks.ToArray();
                    for (int i = 0; i < aLinks.GetLength(0); i++)
                    {
                        ListViewItem lt = new ListViewItem();
                        lt.SubItems[0].Text = ((InjectionPoint)aLinks.GetValue(i)).Url;
                        lt.SubItems.Add(((InjectionPoint)aLinks.GetValue(i)).IsSensitive.ToString());
                        lt.SubItems.Add(((InjectionPoint)aLinks.GetValue(i)).CanInject.ToString());
                        listView_InjectionPoints.Items.Add(lt);
                    }
                    ListViewItem lvt = new ListViewItem();
                    https[j].N_Pages = https[j].alPossibleInjectionPoints.Count;
                    https[j].N_Pages_secure = https[j].N_Pages - https[j].N_Pages_secure;
                    int k = 0; String state = "[";
                    while (https[j].floor_threads_num[k] != -1 && https[j].floor_threads_num[k] != 0)
                    {
                        state += https[j].floor_threads_num[k++];
                        state += " ";
                    }
                    state += "]";
                    lvt.SubItems[0].Text = "扫描完毕![" + https[j].RootUrl + "]" + "[" + https[j].DBType + "]" + state;
                    lvt.SubItems.Add(https[j].IsSensitive.ToString() + " " + https[j].N_Pages_sensitive + "/" + https[j].N_Pages);
                    lvt.SubItems.Add(https[j].IsInjectable.ToString() + " " + https[j].N_Pages_injectable + "/" + https[j].N_Pages);
                    listView_InjectionPoints.Items.Add(lvt);
                }
                sw2.Stop();

                long elaspsedMilliseconds = sw1.ElapsedMilliseconds;
                TimeUsedStr = elaspsedMilliseconds.ToString();
                label_timeused.Text = "TimeUsed:" + TimeUsedStr + " Milliseconds";
                label_state.Text = "State:" + "扫描完毕!";
                MessageBox.Show("扫描完成!请查看HTML扫描报告！");
                //this.button_htmlreport_Click_1(sender, e);
            }
        }

        private void button_htmlreport_Click_1(object sender, EventArgs e)
        {
            if (this.IsWebsiteScan && http != null && http.RootUrl != null)
            {
                StreamReader sr = new StreamReader("./" + "tmpl.html", System.Text.Encoding.GetEncoding("GB2312"));
                String htmlcode = sr.ReadToEnd();
                htmlcode = htmlcode.Replace("HTMLReport_timeused", TimeUsedStr);
                htmlcode = htmlcode.Replace("HTMLReport_timegen", DateTime.Now.ToString());
                htmlcode = htmlcode.Replace("HTMLReport_N_sites_all", "1");

                if (http.SecurityLevel == 0)
                {
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_cannot_connect", "1");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_secure", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_notinjectable", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_notsensitive_injectable", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_injectable", "0");
                }
                if (!http.IsSensitive && !http.IsInjectable)
                {
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_cannot_connect", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_secure", "1");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_notinjectable", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_notsensitive_injectable", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_injectable", "0");
                }
                if (http.IsSensitive && !http.IsInjectable)
                {
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_cannot_connect", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_secure", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_notinjectable", "1");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_notsensitive_injectable", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_injectable", "0");
                }
                if (!http.IsSensitive && http.IsInjectable)
                {
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_cannot_connect", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_secure", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_notinjectable", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_notsensitive_injectable", "1");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_injectable", "0");
                }
                if (http.IsSensitive && http.IsInjectable)
                {
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_cannot_connect", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_secure", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_notinjectable", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_notsensitive_injectable", "0");
                    htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_injectable", "1");
                }
                //write the detail info
                String DetailInfo = "<table width=100% border=0 cellpadding=0 cellspacing=0 align=center>";
                DetailInfo += "<tr align=left>";
                DetailInfo += "<td width=40%>站点URL</td>";
                DetailInfo += "<td><a href='" + http.RootUrl + "'>" + http.RootUrl + "</a></td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td>站点说明</td>";
                DetailInfo += "<td>" + http.Info + "</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td>数据库类型</td>";
                DetailInfo += "<td>" + http.DBType + "</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td>扫描页面总数</td>";
                DetailInfo += "<td>" + http.N_Pages + "</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td>安全页面数</td>";
                DetailInfo += "<td>" + http.N_Pages_secure + "</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td>泄漏敏感信息页面数</td>";
                DetailInfo += "<td>" + http.N_Pages_sensitive + "(" + http.N_Pages_sensitive + "/" + http.N_Pages + ")" + "</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td>可注入页面数</td>";
                DetailInfo += "<td>" + http.N_Pages_injectable + "(" + http.N_Pages_injectable + "/" + http.N_Pages + ")" + "</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td colspan=2>泄漏敏感信息的页面列表</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td colspan=2>";
                foreach (InjectionPoint IP in http.alPossibleInjectionPoints)
                {
                    if (IP.IsSensitive)
                        DetailInfo += "<a href=" + IP.Url + "'>" + IP.Url + "'</a>" + "<br/>";
                }
                DetailInfo += "</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td colspan=2>可实施SQL注入的页面列表</td>";
                DetailInfo += "</tr>";
                DetailInfo += "<tr>";
                DetailInfo += "<td colspan=2>";
                foreach (InjectionPoint IP in http.alPossibleInjectionPoints)
                {
                    if (IP.CanInject)
                        DetailInfo += "<a href='" + IP.Url + "'>" + IP.Url + "</a>" + "<br/>";
                }
                DetailInfo += "</td></tr></table>";
                htmlcode = htmlcode.Replace("HTMLReport_detail", DetailInfo);
                string htmlfilename = "[Rep]" + http.RootUrl.Replace("/", "_").Replace(":", "_") + DateTime.Now.ToString("yyyyMMddHHmmss") + ".html";
                String HtmlPath = "./" + htmlfilename;
                StreamWriter sw = new StreamWriter(HtmlPath, false, System.Text.Encoding.GetEncoding("GB2312"));
                sw.Write(htmlcode);
                sw.Flush();
                sw.Close();
                new FormViewReport(Path.GetFullPath(htmlfilename)).Show();
                return;
            }
            if (!this.IsWebsiteScan && n != 0)
            {
                StreamReader sr = new StreamReader("./" + "tmpl.html", System.Text.Encoding.GetEncoding("GB2312"));
                String htmlcode = sr.ReadToEnd();
                htmlcode = htmlcode.Replace("HTMLReport_timeused", TimeUsedStr);
                htmlcode = htmlcode.Replace("HTMLReport_timegen", DateTime.Now.ToString());
                htmlcode = htmlcode.Replace("HTMLReport_N_sites_all", n.ToString());
                int N_sites_cannot_connect = 0;
                int N_sites_secure = L;
                int N_sites_sensitive_notinjectable = 0;
                int N_sites_notsensitive_injectable = 0;
                int N_sites_sensitive_injectable = 0;

                String DetailInfo = "";
                for (int i = 0; i < L; i++)
                {
                    if (https[i].SecurityLevel == 0)
                    {
                        N_sites_cannot_connect++;
                    }
                    if (https[i].IsSensitive && https[i].IsInjectable)
                    {
                        N_sites_sensitive_injectable++;
                    }
                    if (https[i].IsSensitive && !https[i].IsInjectable)
                    {
                        N_sites_sensitive_notinjectable++;
                    }
                    if (!https[i].IsSensitive && https[i].IsInjectable)
                    {
                        N_sites_notsensitive_injectable++;
                    }
                    //write the detail info
                    DetailInfo += "<table width=100% border=0 cellpadding=0 cellspacing=0 align=center>";
                    DetailInfo += "<tr align=left>";
                    DetailInfo += "<td width=40%>站点URL</td>";
                    DetailInfo += "<td><a href='" + https[i].RootUrl + "'>" + https[i].RootUrl + "</a></td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td>站点说明</td>";
                    DetailInfo += "<td>" + https[i].Info + "</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td>数据库类型</td>";
                    DetailInfo += "<td>" + https[i].DBType + "</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td>扫描页面总数</td>";
                    DetailInfo += "<td>" + https[i].N_Pages + "</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td>安全页面数</td>";
                    DetailInfo += "<td>" + https[i].N_Pages_secure + "</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td>泄漏敏感信息页面数</td>";
                    DetailInfo += "<td>" + https[i].N_Pages_sensitive + "(" + https[i].N_Pages_sensitive + "/" + https[i].N_Pages + ")" + "</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td>可注入页面数</td>";
                    DetailInfo += "<td>" + https[i].N_Pages_injectable + "(" + https[i].N_Pages_injectable + "/" + https[i].N_Pages + ")" + "</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td colspan=2>泄漏敏感信息的页面列表</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td colspan=2>";
                    foreach (InjectionPoint IP in https[i].alPossibleInjectionPoints)
                    {
                        if (IP.IsSensitive)
                            DetailInfo += "<a href=" + IP.Url + "'>" + IP.Url + "'</a>" + "<br/>";
                    }
                    DetailInfo += "</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td colspan=2>注入点列表</td>";
                    DetailInfo += "</tr>";
                    DetailInfo += "<tr>";
                    DetailInfo += "<td colspan=2>";
                    foreach (InjectionPoint IP in https[i].alPossibleInjectionPoints)
                    {
                        if (IP.CanInject)
                            DetailInfo += "<a href='" + IP.Url + "'>" + IP.Url + "</a>" + "<br/>";
                    }
                    DetailInfo += "</td></tr></table><hr/>";
                }
                N_sites_secure = N_sites_secure - N_sites_cannot_connect - N_sites_sensitive_injectable - N_sites_sensitive_notinjectable - N_sites_notsensitive_injectable;

                htmlcode = htmlcode.Replace("HTMLReport_N_sites_cannot_connect", N_sites_cannot_connect.ToString());
                htmlcode = htmlcode.Replace("HTMLReport_N_sites_secure", N_sites_secure.ToString());
                htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_notinjectable", N_sites_sensitive_notinjectable.ToString());
                htmlcode = htmlcode.Replace("HTMLReport_N_sites_notsensitive_injectable", N_sites_notsensitive_injectable.ToString());
                htmlcode = htmlcode.Replace("HTMLReport_N_sites_sensitive_injectable", N_sites_sensitive_injectable.ToString());

                htmlcode = htmlcode.Replace("HTMLReport_detail", DetailInfo);

                string htmlfilename = "[Rep]" + "ALL" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".html";
                String HtmlPath = "./" + htmlfilename;
                StreamWriter sw = new StreamWriter(HtmlPath, false, System.Text.Encoding.GetEncoding("GB2312"));
                sw.Write(htmlcode);
                sw.Flush();
                sw.Close();
                new FormViewReport(Path.GetFullPath(htmlfilename)).Show();
                return;
            }
        }

        private void button_Exit_Click_1(object sender, EventArgs e)
        {

        }

        private void button_file_Click_1(object sender, EventArgs e)
        {
            OpenFileDialog fdlg = new OpenFileDialog();
            fdlg.Title = "Open File Dialog";
            fdlg.InitialDirectory = Path.GetFullPath("./");//@"c:\";
            fdlg.Filter = "txt files (*.txt)|*.txt|Access files (*.mdb)|*.mdb|All files (*.*)|*.*";
            fdlg.FilterIndex = 1;
            fdlg.RestoreDirectory = true;
            if (fdlg.ShowDialog() == DialogResult.OK)
            {
                textBox_WebsitesAdd.Text = fdlg.FileName;
            }
        }

        private void button_AlonePointsFile_Click_1(object sender, EventArgs e)
        {
            OpenFileDialog fdlg = new OpenFileDialog();
            fdlg.Title = "Open File Dialog";
            fdlg.InitialDirectory = Path.GetFullPath("./");//@"c:\";
            fdlg.Filter = "Access files (*.mdb)|*.mdb|All files (*.*)|*.*";
            fdlg.FilterIndex = 1;
            fdlg.RestoreDirectory = true;
            if (fdlg.ShowDialog() == DialogResult.OK)
            {
                textBox_AlonePoints.Text = fdlg.FileName;
            }
        }
        #endregion

        #region //判断在线离线事件
        private void timer1_Tick(object sender, EventArgs e)
        {
            try
            {
                if (cTool.IsLinkInternet() == false)
                {
                    this.staIsInternet.Image = Bitmap.FromFile(Program.getPrjPath() + "img\\a08.gif");

                    this.staIsInternet.Text = "离线";
                }
                else
                {
                    this.staIsInternet.Image = Bitmap.FromFile(Program.getPrjPath() + "img\\a07.gif");

                    this.staIsInternet.Text = "在线";
                }
            }
            catch (Exception ex)

            { }
        }


        private void textBox_WebsiteAdd_TextChanged(object sender, EventArgs e)
        {
            //if (radioButton＿WebsiteAdd.Checked == false)
            //{
            //    radioButton＿WebsiteAdd.Checked = true;
            //}
            //else
            //{
            //    radioButton＿WebsiteAdd.Checked = false;
            //}
        }

        private void textBox_WebsitesAdd_TextChanged(object sender, EventArgs e)
        {
            if (radioButton＿WebsitesAdd.Checked == false)
            {
                radioButton＿WebsitesAdd.Checked = true;
            }
            else
            {
                radioButton＿WebsitesAdd.Checked = false;
            }
        }
        #endregion


        #region//web服务器安全检测事件
        private int a = 0;
        private int b = 0;
        private int c = 0;
        private bool stop = false;
        private void btSelect_Click(object sender, EventArgs e)
        {
            if (folder1.ShowDialog() == DialogResult.OK)
            {
                txtList.Text = folder1.SelectedPath;
            }
        }

        private void btKill_Click(object sender, EventArgs e)
        {
            try
            {
                if (btKill.Text == "开始查杀")
                {
                    a = 0;
                    b = 0;
                    btend();
                    btSelect.Enabled = false;
                    listView1.Items.Clear();
                    stop = false;
                    btKill.Text = "停止查杀";
                    Thread.Sleep(22);
                    Thread T = new Thread(new ThreadStart(Dr));
                    T.Start();
                }
                else
                {
                    stop = true;
                    btKill.Text = "开始查杀";

                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "错误提示！", MessageBoxButtons.OK, MessageBoxIcon.Error);
                btstart();
            }
        }
        public delegate void setListView(string filename, string aaa, string filedir, string filetime, string filesize);//更新listview的委托
        public delegate void setbtkill(string text);//更新btkill按钮的委托
        //更新按钮的方法
        private void addbtkill(string text)
        {
            btKill.Text = text;

        }
        //更新listview方法
        private void addlist(string filename, string aaa, string filedir, string filetime, string filesize)
        {
            ListViewItem item = new ListViewItem();
            item = listView1.Items.Add(filename);
            item.SubItems.Add(aaa);
            item.SubItems.Add(filedir);
            item.SubItems.Add(filetime);
            item.SubItems.Add(filesize);
            c = c + 1;
        }
        private void Dr()
        {
            DirectoryItem(txtList.Text);
            if (btKill.InvokeRequired)
            {
                setbtkill ss = new setbtkill(addbtkill);
                this.BeginInvoke(ss, new object[] { "开始查杀" });
            }
            else
            {
                btKill.Text = "开始查杀";
            }
            btstart();
            footlabel1.Text = "  总共检测了" + a.ToString() + "个文件夹和" + b.ToString() + "个文件！有" + c.ToString() + "个可疑文件！";
        }
        private void DirectoryItem(string dir)
        {
            try
            {
                DirectoryInfo di = new DirectoryInfo(dir);
                DirectoryInfo[] dis = di.GetDirectories();
                FileInfoItem(di.GetFiles(), dir);
                foreach (DirectoryInfo d in dis)
                {
                    if (stop)
                    {
                        break;
                    }
                    else
                    {
                        a = a + 1;
                        DirectoryItem(d.FullName);
                    }
                }
            }
            catch (Exception ex)
            {
                footlabel1.Text = ex.Message;
                btstart();
            }

        }
        private void FileInfoItem(FileInfo[] filelist, string dir)
        {
            try
            {
                string strdir = "";
                foreach (FileInfo f in filelist)
                {
                    if (stop)
                    {
                        break;
                    }
                    else
                    {
                        string ext = f.Extension.ToLower();
                        if (f.Length < 502400 && ext != ".rar" && (ext == ".asp" || ext == ".asa" || ext == ".cdx" || ext == ".cer"))
                        {
                            b = b + 1;
                            strdir = dir + "\\" + f.Name;
                            duoekill.CheckVirus cv = new duoekill.CheckVirus();
                            using (StreamReader sr = new StreamReader(f.FullName, Encoding.Default))
                            {
                                string s = sr.ReadToEnd();
                                footlabel1.Text = "正在扫描分析文件：" + strdir;
                                string cvs = cv.CheckString(s);
                                if (cvs != "")
                                {
                                    setListView slv = new setListView(addlist);
                                    listView1.Invoke(slv, new object[] { f.Name, cvs, strdir, f.LastAccessTime.ToString(), (f.Length / 1024).ToString() });
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                footlabel1.Text = ex.Message;
                btstart();
            }
        }

        private void listView1_SelectedIndexChanged(object sender, EventArgs e)
        {
            string str = listView1.SelectedItems[0].SubItems[2].Text;
            System.Diagnostics.Process.Start(str.Substring(0, str.LastIndexOf("\\") + 1));
        }



        private void btend()
        {
            btSelect.Enabled = false;
            btSeleltALL.Enabled = false;
            btzseleall.Enabled = false;
            btdelete.Enabled = false;
            btsethtml.Enabled = false;
            btselect2.Enabled = false;
            btZall2.Enabled = false;
            btClear.Enabled = false;
            btselectAll2.Enabled = false;
        }
        private void btstart()
        {
            btSelect.Enabled = true;
            btSeleltALL.Enabled = true;
            btzseleall.Enabled = true;
            btdelete.Enabled = true;
            btsethtml.Enabled = true;
            btselect2.Enabled = true;
            btZall2.Enabled = true;
            btClear.Enabled = true;
            btselectAll2.Enabled = true;
        }

        private void btSeleltALL_Click(object sender, EventArgs e)
        {
            selectlistview(true);
        }

        private void btzseleall_Click(object sender, EventArgs e)
        {
            selectlistview(false);
        }
        private void selectlistview(bool b)
        {
            foreach (ListViewItem item in listView1.Items)
            {
                item.Checked = b;
            }
        }

        private void btdelete_Click(object sender, EventArgs e)
        {
            DialogResult result = MessageBox.Show("确认要删除选定的吗？查杀的文件并不一定都是木马，又可能是网站所需的文件！\r\n如果你选择【备份删除文件】文件删除后将将在原目录做备份，原文件名后面加.bak！", "友情提示", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (result == DialogResult.Yes)
            {
                a = 0;
                string str = "";
                foreach (ListViewItem item in listView1.CheckedItems)
                {
                    str = item.SubItems[2].Text;
                    if (cbbak.Checked)
                    {
                        File.Copy(str, str + ".bak");
                    }
                    File.Delete(str);
                    listView1.Items.Remove(item);
                    a = a + 1;
                }
                if (cbbak.Checked)
                {
                    footlabel1.Text = "  总共删除了" + a.ToString() + "个文件!并在原目录做了相应备份，可去除.bak恢复";
                }
                else
                {
                    footlabel1.Text = "  总共删除了" + a.ToString() + "个文件!没有备份！将无法恢复！";
                }
            }
            else
            {
                return;
            }
        }

        private void btselect2_Click(object sender, EventArgs e)
        {
            if (folder1.ShowDialog() == DialogResult.OK)
            {
                txtlist2.Text = folder1.SelectedPath;
            }
        }

        private void btkill2_Click(object sender, EventArgs e)
        {
            try
            {
                if (btkill2.Text == "开始查杀")
                {
                    a = 0;
                    b = 0;
                    c = 0;
                    btend();
                    listView2.Items.Clear();
                    btkill2.Text = "停止";
                    stop = false;
                    Thread t = new Thread(new ThreadStart(killmuma));
                    t.Start();
                }
                else
                {
                    stop = true;
                    btkill2.Text = "开始查杀";
                    btstart();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "错误提示！", MessageBoxButtons.OK, MessageBoxIcon.Error);
                btstart();
            }
        }
        /// <summary>
        ///清楚木马
        /// </summary>
        private void killmuma()
        {
            killmumas(txtlist2.Text);
            btkill2.Text = "开始查杀";
            footlabel1.Text = "  总共检测了" + a.ToString() + "个文件夹和" + b.ToString() + "个文件！有" + c.ToString() + "个可疑文件！";
            btstart();
        }
        private void killmumas(string txt)//搜索所以文件夹
        {
            try
            {
                DirectoryInfo di = new DirectoryInfo(txt);
                DirectoryInfo[] dis = di.GetDirectories();
                killmumafile(di.GetFiles());
                foreach (DirectoryInfo d in dis)
                {
                    a += 1;
                    if (stop)
                    {
                        break;
                    }
                    else
                    {
                        killmumas(d.FullName);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "错误提示！", MessageBoxButtons.OK, MessageBoxIcon.Error);
                btstart();
            }

        }
        private void killmumafile(FileInfo[] file)//搜索所有文件
        {
            try
            {
                foreach (FileInfo f in file)
                {
                    if (stop)
                    {
                        break;
                    }
                    else
                    {
                        string filelist = f.FullName;
                        bool extt = false;
                        string[] exts = txtType.Text.Split(new char[] { '|' });
                        foreach (string ext in exts)
                        {
                            if (f.Extension.ToLower() == ext)
                            {
                                extt = true;
                                break;
                            }
                        }
                        if (extt)
                        {
                            duoekill.command cmd = new duoekill.command();
                            b += 1;
                            int filesize = 500;
                            if (cbsize.Checked)
                            {
                                filesize = 200;
                            }
                            if ((f.Length / 1024) < filesize)
                            {
                                string s = cmd.ReadContent(f.FullName);
                                string[] texts = cmd.RexStr(s, txtiframe.Text).Split(new char[] { '|' });
                                foreach (string text in texts)
                                {
                                    if (text.Length > 1)
                                    {
                                        if (cbdi.Checked)
                                        {
                                            if (cmd.RexStr(text))
                                            {
                                                c += 1;
                                                ListViewItem item = listView2.Items.Add(f.Name);
                                                item.SubItems.Add(text);
                                                item.SubItems.Add(f.FullName);
                                                item.SubItems.Add("危险文件");
                                            }
                                        }
                                        else
                                        {
                                            c += 1;
                                            ListViewItem item = listView2.Items.Add(f.Name);
                                            item.SubItems.Add(text);
                                            item.SubItems.Add(f.FullName);
                                            if (cmd.RexStr(text))
                                            {
                                                item.SubItems.Add("危险文件");
                                            }
                                            else
                                            {
                                                item.SubItems.Add("低危险文件");
                                            }
                                        }
                                    }
                                }
                                footlabel1.Text = "正在扫描分析文件：" + filelist;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "错误提示！", MessageBoxButtons.OK, MessageBoxIcon.Error);
                btstart();
            }
        }

        private void btselectAll2_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem item in listView2.Items)
            {
                item.Checked = true;
            }
        }

        private void btZall2_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem item in listView2.Items)
            {
                item.Checked = false;
            }
        }

        private void btClear_Click(object sender, EventArgs e)
        {
            Thread t = new Thread(new ThreadStart(ReplaceFile));
            t.Start();
        }

        private void ReplaceFile()
        {
            try
            {
                c = 0;
                duoekill.command cmd = new duoekill.command();
                string str = "";
                foreach (ListViewItem item in listView2.CheckedItems)
                {

                    c += 1;
                    str = cmd.ReadContent(item.SubItems[2].Text);
                    str = str.Replace(item.SubItems[1].Text, "");
                    cmd.WriteContent(item.SubItems[2].Text, str);
                    listView2.Items.Remove(item);
                }
                footlabel1.Text = "已经清除了" + c + "个挂马内容！";
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "错误提示！", MessageBoxButtons.OK, MessageBoxIcon.Error);
                btstart();
            }
        }
        private void listView1_ColumnClick(object sender, ColumnClickEventArgs e)
        {
            this.listView1.ListViewItemSorter = new duoekill.ListViewItemComparer(e.Column, SortOrder.Descending);
            listView1.Sorting = SortOrder.Descending;
            listView1.Sort();
        }

        private void btupdate2_Click(object sender, EventArgs e)
        {
            设置SToolStripMenuItem_Click(sender, e);
        }

        private void btupdate_Click(object sender, EventArgs e)
        {
            设置SToolStripMenuItem_Click(sender, e);
        }
        #endregion

        private void 退出XToolStripMenuItem_Click(object sender, EventArgs e) //退出事件
        {
            try
            {
                this.Dispose();
                Application.ExitThread();
                isurlth.Abort(); //停止扫描
                isUrl404th.Abort(); //停止扫描
                sqlshaoth.Abort();
                threads[0].Abort();
            }
            catch (System.Exception ex)
            {
                this.Close();
                Application.ExitThread();
                Application.Exit();

            }

        }

        private void 关于AboutAToolStripMenuItem_Click(object sender, EventArgs e) //关于事件
        {
            FormAbout fabout = new FormAbout();
            fabout.Show();
        }

        private void 设置SToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FormConfig fconfig = new FormConfig();
            fconfig.Show();
        }

        private void 软件注册RToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FormReg freg = new FormReg();
            freg.Show();
        }

        #region //密码探测模块
        String Speacl = "";  //用来保存特殊特征码字符串
        Thread thmima;
        private void button1_Click(object sender, EventArgs e)
        {
            if (textBoxUrl.Text == "")
            {
                MessageBox.Show("请输入您的提交网址 (请带上 http:// ) ： ");
                textBoxUrl.Focus();
                return;
            }
            if (textBoxUse.Text == "")
            {
                MessageBox.Show("请输入您的用户名： ");
                textBoxUse.Focus();
                return;
            }

            thmima = new Thread(new ThreadStart(mimatance));

            try
            {
                thmima.Start();
            }
            catch { }


        }
        //以下为向listBox1的垂直滚动条发送滚动的消息开始
        [DllImport("User32.dll")]
        private static extern Int32 SendMessage(IntPtr hWnd, int Msg, int wParam, int lParam);
        public const int WM_VSCROLL = 0x0115;//垂直滚动条消息
        public const int SB_LINEDOWN = 1;//向下滚动一行
        public const int SB_PAGEDOWN = 3;//向下滚动一页
        public const int SB_BOTTOM = 7;//滚动到最底部
        //以上为向listBox1的垂直滚动条发送滚动的消息结束
        public void mimatance() //密码探测试委托事件
        {
            WebClient web = new WebClient();
            NameValueCollection vc = new NameValueCollection();
            StreamReader Reader = new StreamReader("dic.txt");
            String Content = "";
            while ((Content = Reader.ReadLine()) != null)
            {
                vc.Add("username", this.textBoxUse.Text);
                vc.Add("pwd", Content);
                String ReturnMess = "";
                int j = 0;
                try
                {
                    byte[] byRemoteInfo = web.UploadValues(this.textBoxUrl.Text, vc);
                    ReturnMess = Encoding.Default.GetString(byRemoteInfo);
                    listBox2.Items.Add("正在校验 帐号：" + this.textBoxUse.Text + " 密码：" + Content);
                    Thread.Sleep(50);
                    SendMessage(listBox2.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox1的垂直滚动条发送滚动的消息
                    if (ReturnMess.IndexOf(this.Speacl) > 0)
                    {

                        listBox3.Items.Add("密码找到了! 帐号：" + this.textBoxUse.Text + " 密码：" + Content);
                        break;
                    }
                    //Length += 9;
                }
                catch (Exception ex)
                {

                    //MessageBox.Show("出现错误 ： 请检查您所输入的信息是否正确......");
                    thmima.Abort();
                }
                web.Dispose();
                vc.Clear();
            }
        }

        private void button2_Click(object sender, EventArgs e) //密码探测停止线程事件
        {
            thmima.Abort();
        }
        #endregion

        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            FormAccess faccess = new FormAccess();
            faccess.Show();
        }
        #region //后台扫描事件开始
        Thread isurlth;
        Thread isUrl404th;
        private void button3_Click(object sender, EventArgs e)
        {
            if (textBoxhuotaiscan.Text == "")
            {
                MessageBox.Show("后台URL不能为空！", "Tips");
                return;
            }

            isurlth = new Thread(new ThreadStart(txtlistbox));
            try
            {
                isurlth.Start();//开始扫描
                button4.Enabled = true;
                button3.Enabled = false;
                listBox4.Items.Clear();
            }
            catch
            { }

            isUrl404th = new Thread(new ThreadStart(isUrl404));
            try
            {
                isUrl404th.Start();//开始扫描

                listBox5.Items.Clear();
            }
            catch
            { }

        }





        public void isUrl404() //判断网址是否有效委托
        {



            for (int i = 0; i < listBox4.Items.Count; i++)
            {


                System.Net.WebResponse myRepTest;
                System.Net.WebRequest myTest = System.Net.WebRequest.Create(listBox4.Items[i].ToString());

                myTest.Timeout = 5000;
                groupBox8.Text = "正在扫描：" + listBox4.Items[i].ToString();
                bool link = true;

                try
                {
                    myRepTest = myTest.GetResponse();
                    listBox5.Items.Add(listBox4.Items[i].ToString());
                }
                catch (Exception e)
                {
                    link = false;
                }


            }

        }
        

        public void txtlistbox() //将dict_manager.txt填充到listbox4委托事件
        {
            string path = @"Dict_Manager.txt";
            StreamReader sr = new StreamReader(path, Encoding.GetEncoding("gb2312"));//读取文件

            string str = null;
            while ((str = sr.ReadLine()) != null)//判断行
            {
                listBox4.Items.Add(textBoxhuotaiscan.Text + str);
                //Thread.Sleep(20);
                SendMessage(listBox4.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox4的垂直滚动条发送滚动的消息
            }


        }

        private void button4_Click(object sender, EventArgs e) //后台停止扫描事件
        {
            isurlth.Abort(); //停止扫描
            isUrl404th.Abort(); //停止扫描
            button3.Enabled = true;
            button4.Enabled = false;
        }
        #endregion

        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            this.webBrowser1.GoBack();
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            this.webBrowser1.GoForward();

        }

        private void toolStripButton3_Click(object sender, EventArgs e)
        {

            Navigate("http://www.google.com.hk/");
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            textBox_WebsiteAdd.Text = listBox1.SelectedItem.ToString(); //传值到textbox
            textBoxhuotaiscan.Text = listBox1.SelectedItem.ToString(); //传值到textbox
            textBoxUrl.Text = listBox1.SelectedItem.ToString(); //传值到textbox
            tabControl1.SelectedIndex = 1;
            radioButton＿WebsiteAdd.Checked = true; //为可选
        }

        private void button5_Click(object sender, EventArgs e) //sql停止扫描事件
        {
            sqlshaoth.Abort();

            button_StartScan.Enabled = true;
            button5.Enabled = false;
        }

        private void 自动升级ToolStripMenuItem_Click(object sender, EventArgs e) //自动升级事件
        {
            FrmUpdate fupdate = new FrmUpdate();
            fupdate.Show();
        }


        private void listView_InjectionPoints_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                textBoxSQLin.Text = listView_InjectionPoints.SelectedItems[0].SubItems[0].Text; //传值到textbox
                this.tabControl1.SelectedIndex = 2;
            }
            catch (System.Exception ex)
            {

            }

        }

        private void checkBox3_CheckedChanged(object sender, EventArgs e) //从主机位置扫描判断事件
        {
            if (checkBox3.Checked == true)
            {
                checkBox2.Checked = false;
                textBoxhuotaiscan.Text = Regex.Match(textBoxhuotaiscan.Text, "http://" + @"(?<=://)[a-zA-Z\.0-9]+(?=\/)").Value.ToString(); //正则表达式
            }
            else
            {
                //checkBox2.Checked = true;
                checkBox3.Checked = false;
            }
            //textBoxhuotaiscan.Text = Regex.Match(textBoxhuotaiscan.Text, "http://" + @"(?<=://)[a-zA-Z\.0-9]+(?=\/)").Value.ToString(); //备份
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e) ///从当前位置扫描判断事件
        {
            if (checkBox2.Checked == true)
            {
                checkBox3.Checked = false;

            }
            else
            {
                checkBox2.Checked = false;
                //checkBox3.Checked = false;
            }
        }

        private void radioButton＿WebsiteAdd_CheckedChanged_1(object sender, EventArgs e)
        {
            if (radioButton＿WebsiteAdd.Checked == true)
            {
                radioButton＿WebsitesAdd.Checked = false;
            }
            else
            {
                radioButton＿WebsiteAdd.Checked = false;
            }
        }

        private void radioButton＿WebsitesAdd_CheckedChanged_1(object sender, EventArgs e)
        {
            if (radioButton＿WebsitesAdd.Checked == true)
            {
                radioButton＿WebsiteAdd.Checked = false;
            }
            else
            {
                radioButton＿WebsitesAdd.Checked = false;
            }
        }

        #region //MD5模块事件

        private void button12_Click(object sender, EventArgs e) //加密按钮
        {
            textBox2.Text = "";
            byte[] bt = UTF8Encoding.UTF8.GetBytes(textBox1.Text);//UTF8需要对Text的引用
            MD5CryptoServiceProvider objMD5;
            objMD5 = new MD5CryptoServiceProvider();
            byte[] output = objMD5.ComputeHash(bt);
            string str = BitConverter.ToString(output);
            string[] str1 = str.Split('-');
            foreach (string a in str1)
            {
                textBox2.Text = textBox2.Text + a;
            }
        }

        private void button13_Click(object sender, EventArgs e) //传值按钮
        {
            textBox3.Text = textBox2.Text;
        }
        Thread thmd5;
        private void button14_Click(object sender, EventArgs e) //反向破解按钮
        {
            this.listView3.Visible = true;
            button14.Enabled = false;
            button15.Enabled = true;
            listBox3.Items.Clear();
            thmd5 = new Thread(new ThreadStart(abc));
            thmd5.Start();
        }
        void abc()
        {
            for (int i = 1; i < 1000000; i++)
            {
                string x = "";
                x = "";
                textBox4.Text = "";
                byte[] bt = UTF8Encoding.UTF8.GetBytes(i.ToString());//UTF8需要对Text的引用
                MD5CryptoServiceProvider objMD5;
                objMD5 = new MD5CryptoServiceProvider();
                byte[] output = objMD5.ComputeHash(bt);
                string str = BitConverter.ToString(output);
                string[] str1 = str.Split('-');

                foreach (string a in str1)
                {
                    x = x + a;
                }
                listView3.Items.Add(x);
                SendMessage(listView3.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox4的垂直滚动条发送滚动的消息
                if (textBox3.Text == x)
                {
                    textBox4.Text = i.ToString();
                    Thread.Sleep(800);
                    // listView3.Visible = false;
                    button14.Enabled = true;
                    button15.Enabled = false;
                    thmd5.Abort();


                }
            }
        }
        private void button15_Click(object sender, EventArgs e) //停止按钮
        {
            try
            {
                thmd5.Abort();
                //this.listView3.Visible = false;
                button14.Enabled = true;
                button15.Enabled = false;
            }
            catch
            {
                MessageBox.Show("线程未开始");
            }
        }

        private void button16_Click(object sender, EventArgs e) //导入字典按钮
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox5.Text = openFileDialog1.FileName;
            }
        }
        void abcd()
        {
            string path = textBox5.Text;
            StreamReader s = new StreamReader(@path);
            while (!s.EndOfStream)
            {
                string z = s.ReadLine();
                string y = "";
                textBox7.Text = "";
                byte[] bt = UTF8Encoding.UTF8.GetBytes(z.ToString());//UTF8需要对Text的引用
                MD5CryptoServiceProvider objMD5;
                objMD5 = new MD5CryptoServiceProvider();
                byte[] output = objMD5.ComputeHash(bt);
                string str = BitConverter.ToString(output);
                string[] str1 = str.Split('-');
                foreach (string a in str1)
                {
                    y = y + a;
                }
                listView3.Items.Add(y);
                SendMessage(listView3.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox4的垂直滚动条发送滚动的消息
                if (textBox6.Text == y)
                {
                    textBox7.Text = z.ToString();
                    Thread.Sleep(800);
                    //listView3.Visible = false;
                    button17.Enabled = false;
                    button18.Enabled = true;
                    thmd51.Abort();
                }
            }
        }
        Thread thmd51;
        private void button17_Click(object sender, EventArgs e) //字典破解按钮
        {
            if (textBox5.Text.Trim() == "")
            {
                MessageBox.Show("请导入字典文件");
            }
            else
            {
                try
                {
                    this.listView3.Visible = true;
                    listBox3.Items.Clear();
                    thmd51 = new Thread(new ThreadStart(abcd));
                    thmd51.Start();
                    button17.Enabled = false;
                    button18.Enabled = true;
                }
                catch
                {
                    MessageBox.Show("请导入正确的字典文件");
                }
            }
        }

        private void button18_Click(object sender, EventArgs e) //停止按钮
        {
            try
            {
                thmd51.Abort();
                button17.Enabled = true;
                button18.Enabled = false;
                //this.listView3.Visible = false;
            }
            catch
            {
                MessageBox.Show("线程未开始");
            }
        }

        private void listBox5_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.webBrowser1.Url = new Uri(listBox5.Text.ToString());
            this.tabControl1.SelectedIndex = 0;
        }
        #endregion

        private void 导出列表OToolStripMenuItem_Click(object sender, EventArgs e) //导出列表事件
        {
            string result = listBox1.Text;
            #region 文本写入
            try
            {
                StringBuilder sb = new StringBuilder();

                for (int i = 0; i < listBox1.Items.Count; i++)
                {
                    sb.Append(listBox1.Items[i].ToString() + "\r\n");
                }
                string content = sb.ToString().Trim();
                if (content.Length > 0)
                {
                    using (StreamWriter sw = new StreamWriter(Application.StartupPath + "\\urls.txt", false))
                    {
                        sw.Write(content);

                    }
                }
                MessageBox.Show("列表导出成功！", "Tips");
            }
            catch (System.Exception ex)
            {
                MessageBox.Show(ex.Message);
            }



            #endregion

        }

        private void 导入列表DToolStripMenuItem_Click(object sender, EventArgs e) //导入列表事件
        {
            try
            {
                listBox1.Items.Clear(); //先清除
                string path = Application.StartupPath + "\\urls.txt";
                StreamReader sr = new StreamReader(path, Encoding.GetEncoding("gb2312"));//读取文件

                string str = null;
                while ((str = sr.ReadLine()) != null)//判断行
                {
                    listBox1.Items.Add(str);
                }
                MessageBox.Show("列表导入成功！", "Tips");

            }
            catch (System.Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void timer2_Tick(object sender, EventArgs e)
        {
            try
            {
                this.toolStripProgressBar1.Value = (int)(performanceCounter1.NextValue());
            }
            catch (System.Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

        }

        private void textBox8_TextChanged(object sender, EventArgs e)
        {
            textBox12.Text = textBox8.Text;
        }

        private void textBox9_TextChanged(object sender, EventArgs e)
        {
            textBox13.Text = textBox9.Text;
        }

        private void textBox14_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox10_TextChanged(object sender, EventArgs e)
        {
            textBox14.Text = textBox10.Text;
        }
        #region //DNS反查域名事件
        Thread thdns; //定义多线程
        private void button20_Click(object sender, EventArgs e) //ＤＮＳ反查域名开始按钮事件
        {
            thdns = new Thread(new ThreadStart(thdnswt));
            thdns.Start();
            button19.Enabled = true;
            button20.Enabled = false;
            tabControl3.SelectedIndex = 1;
        }
        public void thdnswt() //委托事件
        {
            ss = textBox8.Text.ToString() + "." + textBox9.Text.ToString() + "." + textBox10.Text.ToString();
            listBox11.Items.Clear(); //先清空
            //给端口扫描赋值开始
            textBox17.Text = textBox8.Text.ToString() + "." + textBox9.Text.ToString() + "." + textBox10.Text.ToString() + "." + textBox11.Text.ToString();
            textBox16.Text = textBox8.Text.ToString() + "." + textBox9.Text.ToString() + "." + textBox10.Text.ToString() + "." + textBox15.Text.ToString();
            //给端口扫描赋值结束
            for (int i = int.Parse(textBox10.Text); i <= int.Parse(textBox15.Text); i++)
            {
                Thread.Sleep(50);
                listBox11.Items.Add(ss + "." + i);
                SendMessage(listBox11.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox11的垂直滚动条发送滚动的消息
            }
            button19.Enabled = false;
            button20.Enabled = true;
            thdns.Abort(); //停止线程

        }

        private void button19_Click(object sender, EventArgs e)
        {
            button19.Enabled = false;
            button20.Enabled = true;
            thdns.Abort(); //停止线程
        }
        #endregion
        #region //端口扫描事件

        Thread fThread;
        private void button21_Click(object sender, EventArgs e)
        {
            this.richTextBox2.Text = null;
            ssport = this.textBox17.Text;

            //this.timer1.Enabled = true;
            this.richTextBox2.Text = "正在进行扫描，请稍候......\n";
            fThread = new Thread(new ThreadStart(runs));

            fThread.Start();
            button21.Enabled = false;
            button22.Enabled = true;
        }
        public void runs()
        {
            while (true) //这个是死循环  循环计算出 IP
            {

                if (!ssport.Equals(this.textBox16.Text))//当初始地址 不等于结束地址的时候  继续操作  如果相等  就结束循环
                {
                    Startscan(ssport);
                    ipstart_get(ssport);
                    IPAdd();
                    ssport = ip1.ToString() + "." + ip2.ToString() + "." + ip3.ToString() + "." + ip4.ToString();

                }
                else
                {
                    Startscan(ssport);
                    break;
                }


            }
        }
        public void Startscan(string yy)
        {
            Int32 port = Convert.ToInt32(comboBox1.Text.Trim());
            try
            {
                TcpClient tcp = new TcpClient(); //去连接指定IP的指定端口  如果成功  就显示 端口开放  不成功就抛出异常 端口未开放
                tcp.Connect(this.textBox17.Text, port);
                this.richTextBox2.AppendText(ssport + "   端口：" + port.ToString() + "开放\n");

            }
            catch
            {
                this.richTextBox2.AppendText(ssport + "  端口：" + port.ToString() + "未开放\n");

            }


        }
        public void ipstart_get(string ff)
        {
            t = ff.Split('.');
            ip1 = Convert.ToInt16(t[0].ToString().Trim());
            ip2 = Convert.ToInt16(t[1].ToString().Trim());
            ip3 = Convert.ToInt16(t[2].ToString().Trim());
            ip4 = Convert.ToInt16(t[3].ToString().Trim());


        }

        public void IPAdd()   //这个算法的用处是：将你的IP 增加1  如果你将此方法用 for循环的话，你可以循环出指定IP段的所有IP地址
        {
            if (++ip4 > 255)
            {
                ip3++;
                ip4 = 1;
            }

            if (ip3 > 255)
            {
                ip2++;
                ip3 = 1;
            }

            if (ip2 > 255)
            {
                ip1++;
                ip2 = 1;
            }

            if (ip1 > 255)
            {
                ip1 = 1;
            }
        }

        private void button22_Click(object sender, EventArgs e)
        {
            button22.Enabled = false;
            button21.Enabled = true;
            fThread.Abort(); //停止线程

        }
        #endregion

        public bool GetPage(string url)
        {

            try
            {

                // 值临时变量 r。

                bool r = false;

                // 对指定的 URL 创建 HttpWebRequest 对象。

                HttpWebRequest myHttpWebRequest = (HttpWebRequest)WebRequest.Create(url);

                // 发送 HttpWebRequest 并等待回应。

                HttpWebResponse myHttpWebResponse = (HttpWebResponse)myHttpWebRequest.GetResponse();

                // 检测 HttpWebRequest 当为 HttpStatusCode.OK 时，设置临时变量为 true。

                if (myHttpWebResponse.StatusCode == HttpStatusCode.OK)

                    r = true;

                // 释放 HttpWebRequest 使用的资源。

                myHttpWebResponse.Close();

                // 函数返回临时变量 r。

                return r;

            }

            catch (WebException ex)
            {

                //捕捉到 WebException 时函数返回 false。

                return false;
                MessageBox.Show(ex.Message);
            }

            catch (Exception ex)
            {

                //捕捉到 Exception 时函数返回 false。

                return false;
                MessageBox.Show(ex.Message);
            }

        }

        private void button6_Click(object sender, EventArgs e) //开始扫描 
        {
            if (this.GetPage(textBoxSQLin.Text + "%20and%201=1"))
            {
                listBox8.Items.Clear();
                listBox8.Items.Add("该页面可能存在 SQL 注入漏洞，可尝试扫描！正在自动猜解.....");
            }
            else
            {
                listBox8.Items.Clear();
                listBox8.Items.Add("该页面不存在 SQL 注入漏洞，无法扫描！");
            }
            


        }
        Thread sqltxtlistboxsqlinij;
        Thread sqlinijth;
        private void button8_Click(object sender, EventArgs e)
        {
            //this.GetPage(textBoxSQLin.Text + "%20and%201=(select%20id%20from%20" + table + "%20where%20len(" + field + "));
            if (textBoxSQLin.Text == "")
            {
                MessageBox.Show("注入点不能为空，请输入网址！");
                return;

            }

            sqltxtlistboxsqlinij = new Thread(new ThreadStart(txtlistboxsqlinij));
            
            try
            {
                sqltxtlistboxsqlinij.Start(); //线程启动
                listBox6.Items.Clear();
                listBox8.Items.Clear();
                button9.Enabled = true;
                button8.Enabled = false;
            }
            catch (System.Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            
        }

        

        public void txtlistboxsqlinij() //将Dict_Table.txt填充到listbox6委托事件
        {
            string path = @"Dict_Table.txt";
            StreamReader sr = new StreamReader(path, Encoding.GetEncoding("gb2312"));//读取文件

            string strDict_Table = null;
            while ((strDict_Table = sr.ReadLine()) != null)//判断行
            {
                listBox6.Items.Add(strDict_Table);
                listBox8.Items.Add(textBoxSQLin.Text + strDict_Table);
                Thread.Sleep(100);
                SendMessage(listBox6.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox6的垂直滚动条发送滚动的消息
                SendMessage(listBox8.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox6的垂直滚动条发送滚动的消息
            }
            button9.Enabled = false;
            button8.Enabled = true;
            sqltxtlistboxsqlinij.Abort();

        }
        Thread sqlinijthdenglu;
        private void button11_Click(object sender, EventArgs e)
        {
            if (textBoxSQLin.Text == "")
            {
                MessageBox.Show("注入点不能为空，请输入网址！");
                return;

            }
            sqlinijthdenglu = new Thread(new ThreadStart(txtlistboxsqlinijdenglu));
            try
            {
                
                sqlinijthdenglu.Start(); //线程启动
                listBox7.Items.Clear();
                listBox8.Items.Clear(); //扫描结果清空
                button10.Enabled = true;
                button11.Enabled = false;
            }
            catch (System.Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
        public void txtlistboxsqlinijdenglu() //将Dict_Field.txt填充到listbox7委托事件
        {
            string path = @"Dict_Field.txt";
            StreamReader sr = new StreamReader(path, Encoding.GetEncoding("gb2312"));//读取文件

            string strDict_Field = null;
            while ((strDict_Field = sr.ReadLine()) != null)//判断行
            {
                listBox7.Items.Add(strDict_Field);
                listBox8.Items.Add(textBoxSQLin.Text + strDict_Field);
                Thread.Sleep(100);
                SendMessage(listBox7.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox7的垂直滚动条发送滚动的消息
                SendMessage(listBox8.Handle, WM_VSCROLL, SB_LINEDOWN, 0); //向listBox6的垂直滚动条发送滚动的消息
            }

            button10.Enabled = false;
            button11.Enabled = true;
            sqlinijthdenglu.Abort();
        }

        private void button9_Click(object sender, EventArgs e)
        {
            button9.Enabled = false;
            button8.Enabled = true;
            sqltxtlistboxsqlinij.Abort();
        }

        private void button10_Click(object sender, EventArgs e)
        {
            button10.Enabled = false;
            button11.Enabled = true;
            sqlinijthdenglu.Abort();
        }

    }
}
