/*!
 * Copyright (c) 2010 WangYang
 * Registration Forms Authentication.
 * Date: 2010-09-14 20:42:16
 */
var myreg = /^([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+\.[a-zA-Z]{2,3}$/;
var passwdtest = /^[a-zA-Z0-9_]{6,16}$/;
var nametest = /[a-zA-Z][a-zA-Z0-9|_]{2,19}$/;

function trim(val){
	return val.replace(/(\s*$)/g, "");
}


function Check_User_Login(){

	if(!checkEmail()) return false;
    if(!checkPasswd1()) return false;
    if(!checkPasswd2()) return false;
    if(!checkUser_name()) return false;
    if(!checkUserrand()) return false;

	return true;

}

function checkEmail(){

	var email = trim($("#email").attr("value"));
	var checkEmail = "";
	if( email == '' ){
		$("#p_email").attr("className","new");
		$("#p_email").html("请输入Email地址!");
		return false;
	}else if(!myreg.test(email)){
		$("#p_email").attr("className","new");
		$("#p_email").html("请输入有效的Email地址!");
		return false;
	}else{
		return checkemail(email);
	}
	return true;
}

function checkemail(email){

	var bool = true;
	$.ajax({
		type: "POST",
		cache:false,
        async:false,
		url: "/program/inc/checkPersonalEmail.jsp",
		data: "user_email="+email,
		success: function(data){
			 if(data!=null && data!=""){
				if( data == 1 ){
					$("#p_email").attr("className","new");
					$("#p_email").html("该Email已被占用!");
					bool = false;
				} else{
					$("#p_email").attr("className","green");
					$("#p_email").html("该Email可以使用!");
				}
			 }
		}

	});

	return bool;
}
function checkPasswd1(){

	var passwd1 = trim($("#passwd1").attr("value"));
	if( passwd1 == '' ){
		$("#p_passwd").attr("className","new");
		$("#p_passwd").html("请输入密码!");
		return false;
	}else if(passwd1.length < 6) {
		$("#p_passwd").attr("className","new");
		$("#p_passwd").html("密码必须大于6位，请重新输入!");
		return false;
	}else if(!passwdtest.test(passwd1)) {
		$("#p_passwd").attr("className","new");
		$("#p_passwd").html("密码只能为字母或数字，请重新输入!");
		return false;
	}else{
		$("#p_passwd").attr("className","green");
		$("#p_passwd").html("密码输入正确!");
	}
	return true;
}

function checkPasswd2(){

	var passwd1 = trim($("#passwd1").attr("value"));
	var passwd2 = trim($("#passwd2").attr("value"));
	if( passwd2 == '' ){
		$("#p_passwd1").attr("className","new");
		$("#p_passwd1").html("请输入确认密码!");
		return false;
	}else if(passwd2.length < 6) {
		$("#p_passwd1").attr("className","new");
		$("#p_passwd1").html("密码必须大于6位，请重新输入!");
		return false;
	}else if(!passwdtest.test(passwd2)) {
		$("#p_passwd1").attr("className","new");
		$("#p_passwd1").html("密码只能为字母或数字，请重新输入!");
		return false;
	}if( passwd1 != passwd2 ){
		$("#p_passwd1").attr("className","new");
		$("#p_passwd1").html("两次密码不一致，请重新输入!");
		return false;
	}else{
		$("#p_passwd1").attr("className","green");
		$("#p_passwd1").html("确认密码输入正确!");
	}
	return true;
}

function checkUser_name(){

	var user_name1 = trim($("#user_name1").attr("value"));
	if( user_name1 == '' ){
		$("#p_user_name").attr("className","new");
		$("#p_user_name").html("请输入用户名!");
		return false;
	}else if( !nametest.test(user_name1) ){
		$("#p_user_name").attr("className","new");
		$("#p_user_name").html("用户名格式不正确!");
		return false;
	}else{
		return checkname(user_name1);
	}
	return true;
}

function checkname(user_name1){

	var bool = true;
	$.ajax({
		type: "POST",
		cache:false,
        async:false,
		url: "/templets/jsp/checkUserName.jsp",
		data:"user_name=" + user_name1,
		success: function(data){
			 if(data!=null && data!=""){
				if( data == 1 ){
					$("#p_user_name").attr("className","new");
					$("#p_user_name").html("用户名已经存在!");
					bool = false;
				} else{
					$("#p_user_name").attr("className","green");
					$("#p_user_name").html("用户名输入正确!");
				}
			 }
		}
	});
	return bool;
}

function checkUserrand(){

	var userrand1 = trim($("#userrand1").attr("value"));
	if( userrand1 == ''){
		$("#p_userrand").attr("className","new");
		$("#p_userrand").html("请输入验证码!");
		return false;
	}else if( $('#userrand1').val().length != 4){
		$("#p_userrand").attr("className","new");
		$("#p_userrand").html("请输入正确的验证码!");
		return false;
	}
	/*else{
		$("#p_userrand").attr("className","green");
		$("#p_userrand").html("验证码输入正确!");
	}*/
	return true;
}




function login_user_name(){

	if(trim($("#user_name").attr("value")) == ''){
		$("#L_user_name").show();
		$("#L_user_name").html("请输入用户名!");
		return false;
	}else if( !nametest.test(trim($("#user_name").attr("value"))) ){
		$("#L_user_name").show();
		$("#L_user_name").html("用户名格式不正确!");
		return false;
	}else{
		$("#L_user_name").hide();
		return true;
	}
}

function login_passwd(){

	if(trim($("#passwd").attr("value")) == ''){
		$("#L_password").show();
		$("#L_password").html("请输入密码!");
		return false;
	}else if(!passwdtest.test(trim($("#passwd").attr("value")))) {
		$("#L_password").show();
		$("#L_password").html("密码必须大于6位!");
		return false;
	}else{
		$("#L_password").hide();
		return true;
	}
}

function formSub(){

	if(!login_user_name()) return false;
    if(!login_passwd()) return false;

	var rdata = Math.round(Math.random()* 10000);
    var udata ='iframe_user_name='+$.trim($("#user_name").val())+'&iframe_passwd='+$.trim($("#passwd").val())+'&rdata='+rdata;
	$.ajax({
		type: 'POST',
		url: '/templets/html/jsp/ajaxLogSubCheck.jsp',
		data: udata,
		async:false,
		success: function(msg){
			msg = $.trim(msg);
			$("#L_password").hide();
			if(msg=='1') {
				$("#L_password").show();
				$("#L_password").html("用户名或密码不正确！");
				return false;
			}
			$("#L_password").hide();
			if(msg=='2'){
				$("#L_password").show();
				$("#L_password").html("用户当前状态不允许登录！");
				return false;
			}
			$("#L_password").hide();
			if(msg=='3'){
			  $("#L_password").show();
			  var appvar = "/program/admin/images/wait.gif";
			  $("#L_password").html("<span><img src='" +appvar+"' />正在登录....请稍后</span>");
			  document.loginForm.submit();
			}

		}
       });
}

function LoginKeyDown(event) {
	if (event.keyCode == 13) { formSub() }
}




$(document).ready(function(){
	$("#user_name").focus();
});