/*
 * Decompiled with CFR 0.152.
 */
package tot.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.db.DBConnectionManager;
import tot.global.Sysconfig;

public final class DBUtils {
    private static Log log = LogFactory.getLog(DBUtils.class);
    public static final int DATABASE_UNKNOWN = 0;
    public static final int DATABASE_GENERAL = 1;
    public static final int DATABASE_NOSCROLL = 2;
    public static final int DATABASE_ORACLE = 10;
    public static final int DATABASE_SQLSERVER = 11;
    public static final int DATABASE_DB2 = 12;
    public static final int DATABASE_SYBASE = 13;
    public static final int DATABASE_IMFORMIX = 14;
    public static final int DATABASE_MYSQL = 15;
    public static final int DATABASE_POSTGRESQL = 16;
    public static final int DATABASE_HSQLDB = 17;
    public static final int DATABASE_ACCESS = 18;
    public static final int DATABASE_SAPDB = 19;
    public static final int DATABASE_INTERBASE = 20;
    public static final int DATABASE_FIREBIRD = 21;
    private static int databaseType = 0;
    private static boolean useDatasource = false;
    private static int maxTimeToWait = 2000;
    private static int minutesBetweenRefresh = 30;
    private static DBConnectionManager connectionManager = null;
    private static DataSource dataSource = null;
    private static long lastGetConnectionTime = 0L;
    private static long lastCloseAllConnectionsTime = 0L;

    private DBUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDatabaseType() {
        if (databaseType == 0) {
            Connection connection = null;
            try {
                connection = DBUtils.getConnection();
                DatabaseMetaData dbmd = connection.getMetaData();
                String databaseName = dbmd.getDatabaseProductName().toLowerCase();
                databaseType = databaseName.indexOf("oracle") != -1 ? 10 : (databaseName.indexOf("sql server") != -1 ? 11 : (databaseName.indexOf("db2") != -1 ? 12 : (databaseName.indexOf("sybase") != -1 ? 13 : (databaseName.indexOf("imformix") != -1 ? 14 : (databaseName.indexOf("mysql") != -1 ? 15 : (databaseName.indexOf("postgresql") != -1 ? 16 : (databaseName.indexOf("hsql") != -1 ? 17 : (databaseName.indexOf("sap") != -1 ? 19 : (databaseName.indexOf("firebird") != -1 ? 21 : 1)))))))));
                log.info((Object)("Auto detect DATABASE_TYPE = " + databaseType + " (" + DBUtils.getDatabaseTypeName(databaseType) + ")"));
            }
            catch (Exception ex) {
                log.error((Object)"Error when running getDatabaseType", (Throwable)ex);
            }
            finally {
                DBUtils.closeConnection(connection);
            }
        }
        return databaseType;
    }

    public static String getDatabaseTypeName(int databaseType) {
        String databaseTypeName = "Cannot find databaseType = " + databaseType;
        switch (databaseType) {
            case 0: {
                databaseTypeName = "DATABASE_UNKNOWN";
                break;
            }
            case 1: {
                databaseTypeName = "DATABASE_GENERAL";
                break;
            }
            case 2: {
                databaseTypeName = "DATABASE_NOSCROLL";
                break;
            }
            case 10: {
                databaseTypeName = "DATABASE_ORACLE";
                break;
            }
            case 11: {
                databaseTypeName = "DATABASE_SQLSERVER";
                break;
            }
            case 12: {
                databaseTypeName = "DATABASE_DB2";
                break;
            }
            case 13: {
                databaseTypeName = "DATABASE_SYBASE";
                break;
            }
            case 14: {
                databaseTypeName = "DATABASE_IMFORMIX";
                break;
            }
            case 15: {
                databaseTypeName = "DATABASE_MYSQL";
                break;
            }
            case 16: {
                databaseTypeName = "DATABASE_POSTGRESQL";
                break;
            }
            case 17: {
                databaseTypeName = "DATABASE_HSQLDB";
                break;
            }
            case 18: {
                databaseTypeName = "DATABASE_ACCESS";
                break;
            }
            case 19: {
                databaseTypeName = "DATABASE_SAPDB";
                break;
            }
            case 20: {
                databaseTypeName = "DATABASE_INTERBASE";
                break;
            }
            case 21: {
                databaseTypeName = "DATABASE_FIREBIRD";
            }
        }
        return databaseTypeName;
    }

    public static Connection getConnection() throws SQLException {
        boolean isBalance;
        long now;
        lastGetConnectionTime = now = System.currentTimeMillis();
        if (now - lastCloseAllConnectionsTime > 60000L * (long)minutesBetweenRefresh && !(isBalance = DBUtils.closeAllConnections())) {
            try {
                Thread.sleep(2000L);
                log.debug((Object)"DBUtils: sleep 2 seconds for checked-out connections to returned and closed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Connection conection = null;
        if (useDatasource) {
            if (dataSource != null) {
                conection = dataSource.getConnection();
            }
        } else if (connectionManager != null) {
            conection = connectionManager.getConnection(maxTimeToWait);
        } else {
            log.fatal((Object)"Assertion: DBUtils.connectionManager == null");
        }
        if (conection == null) {
            throw new SQLException("DBUtils: Cannot get connection from Connection Pool.");
        }
        return conection;
    }

    public static boolean closeAllConnections() {
        log.debug((Object)"DBUtils.closeAllConnections is called.");
        boolean retValue = true;
        lastCloseAllConnectionsTime = System.currentTimeMillis();
        if (useDatasource) {
            if (dataSource != null) {
                // empty if block
            }
        } else if (connectionManager != null) {
            retValue = connectionManager.release();
        } else {
            log.fatal((Object)"Assertion: DBUtils.connectionManager == null");
        }
        return retValue;
    }

    public static void closeConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        if (useDatasource) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)"DBUtils: Cannot close connection.", (Throwable)e);
            }
        } else {
            connectionManager.freeConnection(connection);
        }
    }

    public static void resetStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.setMaxRows(0);
            }
            catch (SQLException e) {
                log.error((Object)"DBUtils: Cannot reset statement MaxRows.", (Throwable)e);
            }
            try {
                statement.setFetchSize(0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)"DBUtils: Cannot close statement.", (Throwable)e);
        }
    }

    public static void closePrepareStatement(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.clearParameters();
                ps.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)"DBUtils: Cannot close PreparedStatement.", (Throwable)e);
        }
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)"DBUtils: Cannot close resultset.", (Throwable)e);
        }
    }

    static {
        databaseType = Sysconfig.getDatabaseType();
        if (databaseType != 0) {
            log.info((Object)("Set DATABASE_TYPE = " + databaseType));
        }
        if (useDatasource = Sysconfig.isUseDataSource()) {
            String dataSourceName = "";
            try {
                InitialContext context = new InitialContext();
                dataSourceName = Sysconfig.getDataSourceName();
                dataSource = (DataSource)context.lookup(dataSourceName);
                log.info((Object)("DBUtils : use datasource = " + dataSourceName));
            }
            catch (NamingException e) {
                log.error((Object)("Cannot get DataSource: datasource name = " + dataSourceName), (Throwable)e);
            }
        } else {
            maxTimeToWait = Sysconfig.getMaxTimeToWait();
            minutesBetweenRefresh = Sysconfig.getMinutesBetweenRefresh();
            connectionManager = DBConnectionManager.getInstance(true);
            log.info((Object)("DBUtils : use built-in DBConnectionManager (MAX_TIME_TO_WAIT = " + maxTimeToWait + ", MINUTES_BETWEEN_REFRESH = " + minutesBetweenRefresh + ")"));
        }
    }
}

