/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import tot.bean.DataField;
import tot.exception.SearchException;
import tot.global.Sysconfig;
import tot.search.AddUpdateIndexTask;
import tot.search.CreateEmptyIndexTask;
import tot.search.DeleteIndexTask;
import tot.search.RebuildIndexTask;
import tot.search.SearchService;
import tot.util.StringUtils;
import tot.util.TimerUtil;

public class ArticleIndex {
    private static Log log = LogFactory.getLog(ArticleIndex.class);
    private static Analyzer analyzer;
    private static String searchArticleIndexDir;
    private static long lastOptimizeTime;

    public static void scheduleAddTask(DataField df) {
        AddUpdateIndexTask task = new AddUpdateIndexTask(df, 0);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    public static void scheduleUpdateTask(DataField df) {
        AddUpdateIndexTask task = new AddUpdateIndexTask(df, 1);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    public static void scheduleDeleteTask(String objectID) {
        DeleteIndexTask task = new DeleteIndexTask(objectID);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    public static void scheduleRebuildIndexTask(String sql, String fields) {
        RebuildIndexTask task = new RebuildIndexTask(sql, fields);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    public static void scheduleCreateEmptyIndexTask() {
        int maxPostID = 0;
        CreateEmptyIndexTask task = new CreateEmptyIndexTask(maxPostID);
        TimerUtil.getInstance().schedule((TimerTask)task, 0L);
    }

    static Analyzer getAnalyzer() {
        return analyzer;
    }

    private static void initializeAnalyzer() {
        String analyzerClassName = Sysconfig.getLuceneAnalyzerClassName();
        analyzer = new StandardAnalyzer(Version.LUCENE_40);
        log.debug((Object)"Using StandardAnalyzer for indexing");
    }

    public static IndexWriter getIndexWriter(Directory directory, boolean create) {
        IndexWriter writer = null;
        IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_40, analyzer);
        if (create) {
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        try {
            writer = new IndexWriter(directory, iwc);
        }
        catch (IOException e) {
            log.warn((Object)"Cannot open existed index. New index will be created.", (Throwable)e);
        }
        return writer;
    }

    public static void doIndex(DataField df, IndexWriter writer, String table) throws SearchException {
        if (df == null) {
            return;
        }
        String id = df.getFieldValue("id");
        String classid = df.getFieldValue("classid");
        String title = df.getFieldValue("title");
        String datetime = df.getFieldValue("newstime");
        String linkurl = df.getFieldValue("linkurl");
        String content = df.getFieldValue("content");
        String demons = df.getFieldValue("demons");
        if (title == null || title.equals("") || content == null || content.equals("")) {
            return;
        }
        if (demons == null || demons.equals("")) {
            demons = StringUtils.removeHtml(content);
        }
        if (demons.length() > 100) {
            demons = demons.substring(0, 100);
        }
        Document dfDocument = new Document();
        dfDocument.add((IndexableField)new LongField("id", Long.parseLong(id), Field.Store.YES));
        dfDocument.add((IndexableField)new StringField("CategoryId", classid, Field.Store.YES));
        dfDocument.add((IndexableField)new TextField("Title", title, Field.Store.YES));
        dfDocument.add((IndexableField)new TextField("Content", content, Field.Store.NO));
        dfDocument.add((IndexableField)new StringField("Demons", demons, Field.Store.YES));
        dfDocument.add((IndexableField)new StringField("LinkUrl", linkurl, Field.Store.YES));
        dfDocument.add((IndexableField)new LongField("ModiTime", Timestamp.valueOf(datetime).getTime(), Field.Store.YES));
        try {
            writer.addDocument((Iterable)dfDocument);
        }
        catch (IOException e) {
            log.error((Object)"ArticleIndexer.doIndex failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizeIndex() throws SearchException, IOException {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = ArticleIndex.getIndexWriter(directory, false);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
            log.debug((Object)"writer.optimize() called in addToIndex");
        }
        catch (Exception ex) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    static void addToIndex(DataField df) throws SearchException, IOException {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = ArticleIndex.getIndexWriter(directory, false);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
            ArticleIndex.doIndex(df, writer, "");
        }
        catch (SearchException ex) {
            throw ex;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteFromIndex(String dfID) throws SearchException, IOException {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = ArticleIndex.getIndexWriter(directory, false);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
            Term term = new Term("id", dfID);
            writer.deleteDocuments(term);
        }
        catch (Exception ex) {
            log.error((Object)("Error while performing index delete operation by id:" + dfID), (Throwable)ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumDocs() {
        int numDocs = -1;
        Directory directory = null;
        DirectoryReader reader = null;
        try {
            directory = SearchService.getSearchIndexDir();
            reader = DirectoryReader.open((Directory)directory);
            if (reader == null) {
                log.warn((Object)"Cannot get the IndexReader");
                int n = -1;
                return n;
            }
            numDocs = reader.numDocs();
        }
        catch (IOException ioe) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexReader", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
        return numDocs;
    }

    static {
        lastOptimizeTime = 0L;
        searchArticleIndexDir = Sysconfig.getIndexDir();
        ArticleIndex.initializeAnalyzer();
    }
}

